/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.io;

import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.io.AStaticDataCollector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyFileStaticDataCollector
extends AStaticDataCollector {
    private InputStream m_source;

    public PropertyFileStaticDataCollector(ITrace2D trace, InputStream propertyFileStream) {
        super(trace);
        this.m_source = propertyFileStream;
    }

    @Override
    public void collectData() throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(this.m_source);
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        LinkedList<TracePoint2D> sortList = new LinkedList<TracePoint2D>();
        for (Map.Entry<Object, Object> entry : entries) {
            sortList.add(new TracePoint2D(Double.parseDouble((String)entry.getKey()), Double.parseDouble((String)entry.getValue())));
        }
        Collections.sort(sortList);
        for (ITracePoint2D iTracePoint2D : sortList) {
            this.m_trace.addPoint(iTracePoint2D);
        }
    }
}

