/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.events.AChart2DAction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public abstract class AAxisAction
extends AChart2DAction
implements PropertyChangeListener {
    private static final long serialVersionUID = 2602716712958711393L;
    private int m_axis;

    public AAxisAction(Chart2D chart, String description, int axis) {
        super(chart, description);
        this.m_axis = axis;
        IAxis<?> myAxis = this.getAxis();
        if (this.m_axis == 1) {
            myAxis.addPropertyChangeListener("Chart2D.PROPERTY_AXIS_X_BOTTOM_REPLACE", this);
        } else if (this.m_axis == 2) {
            myAxis.addPropertyChangeListener("Chart2D.PROPERTY_AXIS_Y_LEFT_REPLACE", this);
        }
    }

    protected IAxis<?> getAxis() {
        IAxis<?> axis = null;
        switch (this.m_axis) {
            case 1: {
                axis = this.m_chart.getAxisX();
                break;
            }
            case 2: {
                axis = this.m_chart.getAxisY();
                break;
            }
        }
        return axis;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (property.equals("Chart2D.PROPERTY_AXIS_X_BOTTOM_REPLACE") && this.m_axis == 1 || property.equals("Chart2D.PROPERTY_AXIS_Y_LEFT_REPLACE") && this.m_axis == 2) {
            IAxis oldAxis = (IAxis)evt.getOldValue();
            IAxis newAxis = (IAxis)evt.getNewValue();
            if (property.equals("Chart2D.PROPERTY_AXIS_X_BOTTOM_REPLACE")) {
                oldAxis.removePropertyChangeListener("Chart2D.PROPERTY_AXIS_X_BOTTOM_REPLACE", this);
                newAxis.addPropertyChangeListener("Chart2D.PROPERTY_AXIS_X_BOTTOM_REPLACE", this);
            } else if (property.equals("Chart2D.PROPERTY_AXIS_Y_LEFT_REPLACE")) {
                oldAxis.removePropertyChangeListener("Chart2D.PROPERTY_AXIS_Y_LEFT_REPLACE", this);
                newAxis.addPropertyChangeListener("Chart2D.PROPERTY_AXIS_Y_LEFT_REPLACE", this);
            }
        }
    }
}

