/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.axis.AxisLogE;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.painters.TracePainterDisc;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public final class LogAxisChart {
    public static void main(String[] args) {
        Chart2D chart = new Chart2D();
        chart.setAxisYLeft(new AxisLogE(), 0);
        Trace2DSimple trace = new Trace2DSimple("exponential");
        chart.addTrace(trace);
        trace.setTracePainter(new TracePainterDisc());
        trace.setColor(Color.DARK_GRAY);
        for (int i = 1; i < 50; ++i) {
            trace.addPoint(i, Math.exp(i));
        }
        Trace2DLtd trace2 = new Trace2DLtd("linear");
        trace2.setTracePainter(new TracePainterDisc());
        trace2.setColor(Color.BLUE);
        chart.addTrace(trace2);
        for (int i = 1; i < 50; ++i) {
            trace2.addPoint(i, i);
        }
        JFrame frame = new JFrame(LogAxisChart.class.getName());
        frame.getContentPane().add(new ChartPanel(chart));
        frame.setSize(400, 300);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    private LogAxisChart() {
    }
}

