/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls.errorbarwizard;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.controls.errorbarwizard.ErrorBarPolicyPanel;
import info.monitorenter.gui.chart.errorbars.ErrorBarPainter;
import info.monitorenter.gui.chart.errorbars.ErrorBarPolicyRelative;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.pointpainters.PointPainterLine;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.util.FileUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ErrorBarWizard
extends JPanel {
    private static final long serialVersionUID = 6973894101328190445L;

    public static void main(String[] args) {
        Chart2D chart = new Chart2D();
        Trace2DSimple trace = new Trace2DSimple();
        trace.setColor(Color.RED);
        ErrorBarPolicyRelative errorBarPolicy = new ErrorBarPolicyRelative(0.2, 0.2);
        errorBarPolicy.setShowNegativeYErrors(true);
        errorBarPolicy.setShowPositiveYErrors(true);
        trace.setErrorBarPolicy(errorBarPolicy);
        ErrorBarPainter errorBarPainter = new ErrorBarPainter();
        errorBarPainter.setEndPointPainter(new PointPainterDisc());
        errorBarPainter.setEndPointColor(Color.RED);
        errorBarPainter.setConnectionPainter(new PointPainterLine());
        errorBarPainter.setConnectionColor(Color.GREEN);
        errorBarPolicy.setErrorBarPainter(errorBarPainter);
        for (double i = 2.0; i < 40.0; i += 1.0) {
            trace.addPoint(i, Math.random() * i + i * 10.0);
        }
        chart.addTrace(trace);
        ErrorBarWizard wizard = new ErrorBarWizard(trace);
        JFrame frame = new JFrame(ErrorBarWizard.class.getName());
        frame.getContentPane().add(wizard);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    public ErrorBarWizard(ITrace2D trace) {
        JTabbedPane tabPolicies = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        for (IErrorBarPolicy<?> policy : trace.getErrorBarPolicies()) {
            String tabName = FileUtil.cutExtension(policy.getClass().getName()).getValue();
            tabPolicies.addTab(tabName, null, new ErrorBarPolicyPanel(policy), "Does nothing");
        }
        this.setLayout(new BorderLayout());
        this.add(tabPolicies);
    }
}

