/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis.scalepolicy;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisScalePolicy;
import info.monitorenter.gui.chart.LabeledValue;
import info.monitorenter.util.Range;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;

public class AxisScalePolicyManualTicks
implements IAxisScalePolicy {
    protected LabeledValue createLabeledValue(double value, double majorTickSpacing, IAxis<?> axis) {
        LabeledValue ret = new LabeledValue();
        ret.setValue(value);
        if (value % majorTickSpacing == 0.0) {
            ret.setMajorTick(true);
        } else {
            ret.setMajorTick(false);
        }
        ret.setLabel(axis.getFormatter().format(ret.getValue()));
        ret.setValue(axis.getFormatter().parse(ret.getLabel()).doubleValue());
        return ret;
    }

    protected List<LabeledValue> getLabels(IAxis<?> axis) {
        LinkedList<LabeledValue> collect = new LinkedList<LabeledValue>();
        double minorTickSpacing = axis.getMinorTickSpacing();
        double majorTickSpacing = axis.getMajorTickSpacing();
        if (minorTickSpacing > 0.0) {
            LabeledValue label;
            double value;
            Range domain = axis.getRange();
            double min = domain.getMin();
            double max = domain.getMax();
            String oldLabelName = "";
            double range = max - min;
            if (axis.isStartMajorTick()) {
                value = (double)((int)(min / majorTickSpacing)) * majorTickSpacing;
                if (value < min) {
                    value += majorTickSpacing;
                }
            } else {
                value = (double)((int)(min / minorTickSpacing)) * minorTickSpacing;
            }
            String labelName = "start";
            int loopStop = 0;
            while (value <= max && loopStop < 100) {
                if (loopStop == 99) {
                    // empty if block
                }
                if (oldLabelName.equals(labelName)) {
                    // empty if block
                }
                label = this.createLabeledValue(value, majorTickSpacing, axis);
                oldLabelName = labelName;
                labelName = label.getLabel();
                value = label.getValue();
                ++loopStop;
                if (value <= max && value >= min) {
                    collect.add(label);
                } else if (value > max || value < min) {
                    // empty if block
                }
                value += minorTickSpacing;
            }
            int stop = collect.size();
            for (int i = 0; i < stop; ++i) {
                label = (LabeledValue)collect.get(i);
                label.setValue((label.getValue() - min) / range);
            }
        }
        return collect;
    }

    @Override
    public List<LabeledValue> getScaleValues(Graphics g2d, IAxis<?> axis) {
        return this.getLabels(axis);
    }

    @Override
    public void initPaintIteration(IAxis<?> axis) {
    }
}

