/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis.scalepolicy;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisScalePolicy;
import info.monitorenter.gui.chart.LabeledValue;
import info.monitorenter.util.Range;
import info.monitorenter.util.math.MathUtil;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;

public class AxisScalePolicyAutomaticBestFit
implements IAxisScalePolicy {
    protected double m_power;

    @Override
    public List<LabeledValue> getScaleValues(Graphics g2d, IAxis<?> axis) {
        double labelspacepx = axis.getAccessor().getMinimumValueDistanceForLabels(g2d);
        double formattingspace = axis.getFormatter().getMinimumValueShiftForChange();
        double max = Math.max(labelspacepx, formattingspace);
        return this.getLabels(max, axis);
    }

    @Override
    public void initPaintIteration(IAxis<?> axis) {
        double range;
        double computeRange = range = axis.getMax() - axis.getMin();
        if (range == 0.0 || !MathUtil.isDouble(range)) {
            computeRange = 1.0;
        }
        double tmpPower = 0.0;
        if (computeRange > 1.0) {
            while (computeRange > 50.0) {
                computeRange /= 10.0;
                tmpPower += 1.0;
            }
            tmpPower = Math.pow(10.0, tmpPower - 1.0);
        } else {
            while (computeRange < 5.0) {
                computeRange *= 10.0;
                tmpPower += 1.0;
            }
            tmpPower = 1.0 / Math.pow(10.0, tmpPower);
        }
        this.m_power = tmpPower;
    }

    protected List<LabeledValue> getLabels(double resolution, IAxis<?> axis) {
        LinkedList<LabeledValue> collect = new LinkedList<LabeledValue>();
        if (resolution > 0.0) {
            LabeledValue label;
            Range domain = axis.getRange();
            double min = domain.getMin();
            double max = domain.getMax();
            String oldLabelName = "";
            double range = max - min;
            double tickResolution = this.roundToTicks(resolution, false, false, axis).getValue();
            String labelName = "start";
            int loopStop = 0;
            boolean firstMajorFound = false;
            for (double value = Math.ceil(min / tickResolution) * tickResolution; value <= max && loopStop < 100; value += resolution) {
                if (loopStop == 99) {
                    // empty if block
                }
                if (oldLabelName.equals(labelName)) {
                    // empty if block
                }
                label = this.roundToTicks(value, false, !firstMajorFound && axis.isStartMajorTick(), axis);
                oldLabelName = labelName;
                labelName = label.getLabel();
                value = label.getValue();
                ++loopStop;
                if (!firstMajorFound && axis.isStartMajorTick() && !label.isMajorTick()) continue;
                firstMajorFound = true;
                if (value <= max && value >= min) {
                    collect.add(label);
                    continue;
                }
                if (!(value > max) && !(value < min)) continue;
            }
            int stop = collect.size();
            for (int i = 0; i < stop; ++i) {
                label = (LabeledValue)collect.get(i);
                label.setValue((label.getValue() - min) / range);
            }
        }
        return collect;
    }

    protected LabeledValue roundToTicks(double value, boolean floor, boolean findMajorTick, IAxis<?> axis) {
        double majorDistance;
        double minorDistance;
        double majorMinorRelation;
        LabeledValue ret = new LabeledValue();
        double minorTick = axis.getMinorTickSpacing() * this.m_power;
        double majorTick = axis.getMajorTickSpacing() * this.m_power;
        double majorRound = floor ? Math.floor(value / majorTick) : Math.ceil(value / majorTick);
        boolean majorZeroHit = majorRound == 0.0 && value != 0.0;
        majorRound *= majorTick;
        double minorRound = floor ? Math.floor(value / minorTick) : Math.ceil(value / minorTick);
        boolean minorZeroHit = minorRound == 0.0 && value != 0.0;
        minorRound *= minorTick;
        if (majorZeroHit || minorZeroHit) {
            // empty if block
        }
        if (Double.isNaN(majorMinorRelation = (minorDistance = Math.abs(value - minorRound)) / (majorDistance = Math.abs(value - majorRound)))) {
            majorMinorRelation = 1.0;
        }
        if (majorDistance <= minorDistance || findMajorTick) {
            ret.setValue(majorRound);
            ret.setMajorTick(true);
        } else {
            ret.setValue(minorRound);
            ret.setMajorTick(false);
        }
        ret.setLabel(axis.getFormatter().format(ret.getValue()));
        ret.setValue(axis.getFormatter().parse(ret.getLabel()).doubleValue());
        return ret;
    }
}

