/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IAxisScalePolicy;
import info.monitorenter.gui.chart.IAxisTickPainter;
import info.monitorenter.gui.chart.IAxisTitlePainter;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.LabeledValue;
import info.monitorenter.gui.chart.axis.scalepolicy.AxisScalePolicyAutomaticBestFit;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterAutoUnits;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterSimple;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyUnbounded;
import info.monitorenter.util.Range;
import info.monitorenter.util.StringUtil;
import info.monitorenter.util.math.MathUtil;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class AAxis<T extends IAxisScalePolicy>
implements IAxis<T>,
PropertyChangeListener {
    private IAxisScalePolicy m_axisScalePolicy;
    public static final boolean DEBUG = false;
    private static SortedMap<String, IPropertyChangeReactor> propertyReactors = new TreeMap<String, IPropertyChangeReactor>();
    private static final long serialVersionUID = -3615740476406530580L;
    protected AChart2DDataAccessor m_accessor;
    private int m_axisPosition = -1;
    private IAxis.AxisTitle m_axisTitle;
    protected IAxisLabelFormatter m_formatter;
    protected double m_majorTickSpacing = 5.0;
    protected double m_max;
    protected double m_min;
    protected double m_minorTickSpacing = 1.0;
    protected boolean m_needsFullRescale = false;
    private boolean m_paintGrid = false;
    private boolean m_paintScale = true;
    private int m_pixelXLeft;
    private int m_pixelXRight;
    private int m_pixelYBottom;
    private int m_pixelYTop;
    private final PropertyChangeSupport m_propertyChangeSupport;
    protected IRangePolicy m_rangePolicy;
    private final Range m_rangePreviousScaling = new Range(0.0, 0.0);
    private final Range m_reusedRange = new Range(0.0, 0.0);
    private boolean m_startMajorTick = false;
    private final Set<ITrace2D> m_traces = new CopyOnWriteArraySet<ITrace2D>();
    private boolean m_visible = true;

    @Override
    public IAxisScalePolicy getAxisScalePolicy() {
        return this.m_axisScalePolicy;
    }

    @Override
    public IAxisScalePolicy setAxisScalePolicy(T axisScalePolicy) {
        IAxisScalePolicy result = this.m_axisScalePolicy;
        this.m_axisScalePolicy = axisScalePolicy;
        this.m_propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "IAxis.PROPERTY_AXIS_SCALE_POLICY_CHANGED", result, this.m_axisScalePolicy));
        return result;
    }

    @Override
    public String getDimensionString() {
        String result = null;
        if (this.m_accessor != null) {
            result = this.m_accessor.toString();
        }
        return result;
    }

    public AAxis() {
        this(new LabelFormatterAutoUnits(new LabelFormatterSimple()), new AxisScalePolicyAutomaticBestFit());
    }

    public AAxis(IAxisLabelFormatter formatter, T scalePolicy) {
        this.m_propertyChangeSupport = new PropertyChangeSupport(this);
        this.setAxisTitle(new IAxis.AxisTitle(null));
        this.m_rangePolicy = new RangePolicyUnbounded(Range.RANGE_UNBOUNDED);
        this.setFormatter(formatter);
        this.setAxisScalePolicy(scalePolicy);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addTrace(ITrace2D trace) {
        boolean result = false;
        Chart2D chart2D = this.getAccessor().getChart();
        synchronized (chart2D) {
            ITrace2D iTrace2D = trace;
            synchronized (iTrace2D) {
                if (this.m_traces.contains(trace)) {
                    throw new IllegalArgumentException("Trace " + trace.getName() + " is already contaied in this axis " + this.getAxisTitle() + ". Review your code. ");
                }
                result = this.m_traces.add(trace);
                if (result) {
                    double min;
                    this.listen2Trace(trace);
                    double max = this.getAccessor().getMaxValue(trace);
                    if (max > this.m_max) {
                        this.m_max = max;
                    }
                    if ((min = this.getAccessor().getMinValue(trace)) < this.m_min) {
                        this.m_min = min;
                    }
                    if (this.getTraces().size() == 1) {
                        this.m_min = min;
                        this.m_max = max;
                    }
                    trace.setRenderer(this.m_accessor.getChart());
                    this.scaleTrace(trace);
                }
            }
        }
        this.m_propertyChangeSupport.firePropertyChange("IAxis.PROPERTY_ADD_REMOVE_TRACE", null, trace);
        return result;
    }

    protected abstract AChart2DDataAccessor createAccessor(Chart2D var1, int var2, int var3);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AAxis other = (AAxis)obj;
        if (this.m_accessor == null ? other.m_accessor != null : !this.m_accessor.equals(other.m_accessor)) {
            return false;
        }
        if (this.m_axisPosition != other.m_axisPosition) {
            return false;
        }
        if (this.m_axisTitle == null ? other.m_axisTitle != null : !this.m_axisTitle.equals(other.m_axisTitle)) {
            return false;
        }
        if (this.m_formatter == null ? other.m_formatter != null : !this.m_formatter.equals(other.m_formatter)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_majorTickSpacing) != Double.doubleToLongBits(other.m_majorTickSpacing)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_max) != Double.doubleToLongBits(other.m_max)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_min) != Double.doubleToLongBits(other.m_min)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_minorTickSpacing) != Double.doubleToLongBits(other.m_minorTickSpacing)) {
            return false;
        }
        if (this.m_needsFullRescale != other.m_needsFullRescale) {
            return false;
        }
        if (this.m_paintGrid != other.m_paintGrid) {
            return false;
        }
        if (this.m_paintScale != other.m_paintScale) {
            return false;
        }
        if (this.m_pixelXLeft != other.m_pixelXLeft) {
            return false;
        }
        if (this.m_pixelXRight != other.m_pixelXRight) {
            return false;
        }
        if (this.m_pixelYBottom != other.m_pixelYBottom) {
            return false;
        }
        if (this.m_pixelYTop != other.m_pixelYTop) {
            return false;
        }
        if (this.m_propertyChangeSupport == null ? other.m_propertyChangeSupport != null : !this.m_propertyChangeSupport.equals(other.m_propertyChangeSupport)) {
            return false;
        }
        if (this.m_rangePolicy == null ? other.m_rangePolicy != null : !this.m_rangePolicy.equals(other.m_rangePolicy)) {
            return false;
        }
        if (this.m_rangePreviousScaling == null ? other.m_rangePreviousScaling != null : !this.m_rangePreviousScaling.equals(other.m_rangePreviousScaling)) {
            return false;
        }
        if (this.m_reusedRange == null ? other.m_reusedRange != null : !this.m_reusedRange.equals(other.m_reusedRange)) {
            return false;
        }
        if (this.m_startMajorTick != other.m_startMajorTick) {
            return false;
        }
        if (this.m_traces == null ? other.m_traces != null : !this.m_traces.equals(other.m_traces)) {
            return false;
        }
        return this.m_visible == other.m_visible;
    }

    protected final double findMax() {
        double max = -1.7976931348623157E308;
        for (ITrace2D trace : this.getTraces()) {
            double tmp;
            if (!trace.isVisible() || !((tmp = this.getAccessor().getMaxValue(trace)) > max)) continue;
            max = tmp;
        }
        if (max == -1.7976931348623157E308) {
            max = 10.0;
        }
        return max;
    }

    protected final double findMin() {
        double min = Double.MAX_VALUE;
        for (ITrace2D trace : this.getTraces()) {
            double tmp;
            if (!trace.isVisible() || !((tmp = this.getAccessor().getMinValue(trace)) < min)) continue;
            min = tmp;
        }
        if (min == Double.MAX_VALUE) {
            min = 0.0;
        }
        return min;
    }

    @Override
    public AChart2DDataAccessor getAccessor() {
        return this.m_accessor;
    }

    @Override
    public int getAxisPosition() {
        return this.m_axisPosition;
    }

    @Override
    public IAxis.AxisTitle getAxisTitle() {
        return this.m_axisTitle;
    }

    @Override
    public int getDimension() {
        int result = -1;
        if (this.m_accessor != null) {
            result = this.m_accessor.getDimension();
        }
        return result;
    }

    @Override
    public final IAxisLabelFormatter getFormatter() {
        return this.m_formatter;
    }

    @Override
    public final int getHeight(Graphics g2d) {
        return this.getAccessor().getHeight(g2d);
    }

    @Override
    public double getMajorTickSpacing() {
        return this.m_majorTickSpacing;
    }

    @Override
    public double getMax() {
        return this.getRangePolicy().getMax(this.m_min, this.m_max);
    }

    @Override
    public double getMaxValue() {
        return this.m_max;
    }

    @Override
    public double getMin() {
        return this.getRangePolicy().getMin(this.m_min, this.m_max);
    }

    @Override
    public double getMinorTickSpacing() {
        return this.m_minorTickSpacing;
    }

    @Override
    public double getMinValue() {
        return this.m_min;
    }

    @Override
    public final int getPixelXLeft() {
        return this.m_pixelXLeft;
    }

    @Override
    public final int getPixelXRight() {
        return this.m_pixelXRight;
    }

    @Override
    public final int getPixelYBottom() {
        return this.m_pixelYBottom;
    }

    @Override
    public final int getPixelYTop() {
        return this.m_pixelYTop;
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.m_propertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    @Override
    public final Range getRange() {
        double max;
        double min = this.getMin();
        if (min == (max = this.getMax())) {
            max += 10.0;
        }
        this.m_reusedRange.setMax(max);
        this.m_reusedRange.setMin(min);
        return this.m_reusedRange;
    }

    @Override
    public IRangePolicy getRangePolicy() {
        return this.m_rangePolicy;
    }

    @Override
    @Deprecated
    public final String getTitle() {
        return this.getAxisTitle().getTitle();
    }

    @Override
    @Deprecated
    public final IAxisTitlePainter getTitlePainter() {
        return this.getAxisTitle().getTitlePainter();
    }

    @Override
    public Set<ITrace2D> getTraces() {
        return this.m_traces;
    }

    protected final double getValueDistanceForPixel(int pixel) {
        return this.m_accessor.getValueDistanceForPixel(pixel);
    }

    @Override
    public final int getWidth(Graphics g2d) {
        return this.getAccessor().getWidth(g2d);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_accessor == null ? 0 : this.m_accessor.hashCode());
        result = 31 * result + this.m_axisPosition;
        result = 31 * result + (this.m_axisTitle == null ? 0 : this.m_axisTitle.hashCode());
        result = 31 * result + (this.m_formatter == null ? 0 : this.m_formatter.hashCode());
        long temp = Double.doubleToLongBits(this.m_majorTickSpacing);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m_max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m_min);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m_minorTickSpacing);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.m_needsFullRescale ? 1231 : 1237);
        result = 31 * result + (this.m_paintGrid ? 1231 : 1237);
        result = 31 * result + (this.m_paintScale ? 1231 : 1237);
        result = 31 * result + this.m_pixelXLeft;
        result = 31 * result + this.m_pixelXRight;
        result = 31 * result + this.m_pixelYBottom;
        result = 31 * result + this.m_pixelYTop;
        result = 31 * result + (this.m_propertyChangeSupport == null ? 0 : this.m_propertyChangeSupport.hashCode());
        result = 31 * result + (this.m_rangePolicy == null ? 0 : this.m_rangePolicy.hashCode());
        result = 31 * result + (this.m_rangePreviousScaling == null ? 0 : this.m_rangePreviousScaling.hashCode());
        result = 31 * result + (this.m_reusedRange == null ? 0 : this.m_reusedRange.hashCode());
        result = 31 * result + (this.m_startMajorTick ? 1231 : 1237);
        result = 31 * result + (this.m_traces == null ? 0 : this.m_traces.hashCode());
        result = 31 * result + (this.m_visible ? 1231 : 1237);
        return result;
    }

    @Override
    public final boolean hasTrace(ITrace2D trace) {
        boolean result = false;
        result = this.m_traces.contains(trace);
        return result;
    }

    @Override
    public void initPaintIteration() {
        this.m_formatter.initPaintIteration();
        this.m_axisScalePolicy.initPaintIteration(this);
    }

    @Override
    public final boolean isDirtyScaling() {
        boolean result = this.m_needsFullRescale;
        if (!result) {
            Range range = this.getRange();
            result |= !range.equals(this.m_rangePreviousScaling);
        }
        return result;
    }

    @Override
    public final boolean isPaintGrid() {
        return this.m_paintGrid;
    }

    @Override
    public final boolean isPaintScale() {
        return this.m_paintScale;
    }

    @Override
    public boolean isStartMajorTick() {
        return this.m_startMajorTick;
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    private void listen2Trace(ITrace2D trace) {
        if (this.getAccessor().getDimension() == 1) {
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_MAX_X", this);
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_MIN_X", this);
        } else {
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_MAX_Y", this);
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_MIN_Y", this);
        }
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_COLOR", this);
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_STROKE", this);
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_VISIBLE", this);
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_ZINDEX", this);
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_PAINTERS", this);
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_ERRORBARPOLICY", this);
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_ERRORBARPOLICY_CONFIGURATION", this);
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_ZINDEX", this);
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_NAME", this);
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_TRACEPOINT", this);
        trace.addPropertyChangeListener("ITrace2D.PROPERTY_POINT_CHANGED", this);
    }

    private void listenToAxisTitle(IAxis.AxisTitle axisTitle) {
        axisTitle.addPropertyChangeListener("IAxis.AxisTitle.PROPERTY_TITLE", this);
        axisTitle.addPropertyChangeListener("IAxis.AxisTitle.PROPERTY_TITLEFONT", this);
        axisTitle.addPropertyChangeListener("IAxis.AxisTitle.PROPERTY_TITLEPAINTER", this);
    }

    @Override
    public void paint(Graphics g2d) {
        if (!this.m_visible) {
            return;
        }
        switch (this.getDimension() | this.getAxisPosition()) {
            case 33: {
                this.paintAxisXBottom(g2d);
                break;
            }
            case 17: {
                this.paintAxisXTop(g2d);
                break;
            }
            case 6: {
                this.paintAxisYLeft(g2d);
                break;
            }
            case 10: {
                this.paintAxisYRight(g2d);
                break;
            }
            default: {
                throw new IllegalStateException("No valid Chart position found for this axis: " + this);
            }
        }
    }

    private void paintAxisXBottom(Graphics g2d) {
        Chart2D chart = this.getAccessor().getChart();
        int tmp = 0;
        FontMetrics fontdim = g2d.getFontMetrics();
        int fontheight = fontdim.getHeight();
        int xAxisStart = chart.getXChartStart();
        int xAxisEnd = chart.getXChartEnd();
        int yAxisEnd = chart.getYChartEnd();
        int rangexPx = xAxisEnd - xAxisStart;
        int yAxisLine = this.getPixelYTop();
        g2d.drawLine(xAxisStart, yAxisLine, xAxisEnd, yAxisLine);
        this.paintTitle(g2d);
        if (this.isPaintScale() || this.isPaintGrid()) {
            IAxisTickPainter tickPainter = chart.getAxisTickPainter();
            tmp = 0;
            List<LabeledValue> labels = this.m_axisScalePolicy.getScaleValues(g2d, this);
            for (LabeledValue label : labels) {
                tmp = xAxisStart + (int)(label.getValue() * (double)rangexPx);
                if (this.isPaintScale()) {
                    tickPainter.paintXTick(tmp, yAxisLine, label.isMajorTick(), true, g2d);
                    tickPainter.paintXLabel(tmp, yAxisLine + fontheight, label.getLabel(), g2d);
                }
                if (!this.isPaintGrid() || tmp == xAxisStart) continue;
                g2d.setColor(chart.getGridColor());
                g2d.drawLine(tmp, yAxisLine - 1, tmp, yAxisEnd);
                g2d.setColor(chart.getForeground());
            }
        }
        g2d.drawString(this.getFormatter().getUnit().getUnitName(), xAxisEnd, yAxisLine + 4 + fontdim.getHeight() * 2);
    }

    private void paintAxisXTop(Graphics g2d) {
        Chart2D chart = this.getAccessor().getChart();
        int tmp = 0;
        FontMetrics fontdim = g2d.getFontMetrics();
        int xAxisStart = chart.getXChartStart();
        int xAxisEnd = chart.getXChartEnd();
        int yAxisStart = chart.getYChartStart();
        int rangexPx = xAxisEnd - xAxisStart;
        int yAxisLine = this.getPixelYBottom();
        g2d.drawLine(xAxisStart, yAxisLine, xAxisEnd, yAxisLine);
        this.paintTitle(g2d);
        if (this.isPaintScale() || this.isPaintGrid()) {
            tmp = 0;
            IAxisTickPainter tickPainter = chart.getAxisTickPainter();
            int majorTickLength = tickPainter.getMajorTickLength();
            List<LabeledValue> labels = this.m_axisScalePolicy.getScaleValues(g2d, this);
            for (LabeledValue label : labels) {
                tmp = xAxisStart + (int)(label.getValue() * (double)rangexPx);
                if (this.isPaintScale()) {
                    tickPainter.paintXTick(tmp, yAxisLine, label.isMajorTick(), false, g2d);
                    tickPainter.paintXLabel(tmp, yAxisLine - majorTickLength, label.getLabel(), g2d);
                }
                if (!this.isPaintGrid() || tmp == xAxisStart) continue;
                g2d.setColor(chart.getGridColor());
                g2d.drawLine(tmp, yAxisLine + 1, tmp, yAxisStart);
                g2d.setColor(chart.getForeground());
            }
            g2d.drawString(this.getFormatter().getUnit().getUnitName(), xAxisEnd, yAxisLine - 4 - fontdim.getHeight());
        }
    }

    private void paintAxisYLeft(Graphics g2d) {
        Chart2D chart = this.getAccessor().getChart();
        int tmp = 0;
        FontMetrics fontdim = g2d.getFontMetrics();
        int xAxisStart = chart.getXChartStart();
        int xAxisEnd = chart.getXChartEnd();
        int yAxisStart = chart.getYChartStart();
        int yAxisEnd = chart.getYChartEnd();
        int rangeyPx = yAxisStart - yAxisEnd;
        int xAxisLine = this.getPixelXRight();
        g2d.drawLine(xAxisLine, yAxisStart, xAxisLine, yAxisEnd);
        this.paintTitle(g2d);
        if (this.isPaintScale() || this.isPaintGrid()) {
            IAxisTickPainter tickPainter = chart.getAxisTickPainter();
            int majorTickLength = tickPainter.getMajorTickLength();
            List<LabeledValue> labels = this.m_axisScalePolicy.getScaleValues(g2d, this);
            for (LabeledValue label : labels) {
                tmp = yAxisStart - (int)(label.getValue() * (double)rangeyPx);
                if (this.isPaintScale()) {
                    tickPainter.paintYTick(xAxisLine, tmp, label.isMajorTick(), true, g2d);
                    tickPainter.paintYLabel(xAxisLine - majorTickLength - fontdim.stringWidth(label.getLabel()), tmp, label.getLabel(), g2d);
                }
                if (!this.isPaintGrid() || tmp == yAxisStart) continue;
                g2d.setColor(chart.getGridColor());
                g2d.drawLine(xAxisStart + 1, tmp, xAxisEnd, tmp);
                g2d.setColor(chart.getForeground());
            }
            String unitName = this.getFormatter().getUnit().getUnitName();
            g2d.drawString(unitName, 4, yAxisEnd);
        }
    }

    private void paintAxisYRight(Graphics g2d) {
        Chart2D chart = this.getAccessor().getChart();
        int tmp = 0;
        FontMetrics fontdim = g2d.getFontMetrics();
        int xAxisStart = chart.getXChartStart();
        int xAxisEnd = chart.getXChartEnd();
        int yAxisStart = chart.getYChartStart();
        int yAxisEnd = chart.getYChartEnd();
        int rangeyPx = yAxisStart - yAxisEnd;
        int xAxisLine = this.getPixelXLeft();
        g2d.drawLine(xAxisLine, yAxisStart, xAxisLine, yAxisEnd);
        this.paintTitle(g2d);
        if (this.isPaintScale() || this.isPaintGrid()) {
            IAxisTickPainter tickPainter = chart.getAxisTickPainter();
            List<LabeledValue> labels = this.m_axisScalePolicy.getScaleValues(g2d, this);
            int tickWidth = tickPainter.getMajorTickLength() + 4;
            for (LabeledValue label : labels) {
                tmp = yAxisStart - (int)(label.getValue() * (double)rangeyPx);
                if (this.isPaintScale()) {
                    tickPainter.paintYTick(xAxisLine, tmp, label.isMajorTick(), false, g2d);
                    tickPainter.paintYLabel(xAxisLine + tickWidth, tmp, label.getLabel(), g2d);
                }
                if (!this.isPaintGrid() || tmp == yAxisStart) continue;
                g2d.setColor(chart.getGridColor());
                g2d.drawLine(xAxisStart + 1, tmp, xAxisEnd, tmp);
                g2d.setColor(chart.getForeground());
            }
            String unitName = this.getFormatter().getUnit().getUnitName();
            g2d.drawString(unitName, (int)chart.getSize().getWidth() - fontdim.charsWidth(unitName.toCharArray(), 0, unitName.length()) - 4, yAxisEnd);
        }
    }

    @Override
    public int paintTitle(Graphics g2d) {
        int result = 0;
        IAxis.AxisTitle axisTitle = this.getAxisTitle();
        String title = axisTitle.getTitle();
        if (!StringUtil.isEmpty(title)) {
            IAxisTitlePainter titlePainter = axisTitle.getTitlePainter();
            titlePainter.paintTitle(this, g2d);
            int dimension = this.getDimension();
            switch (dimension) {
                case 1: {
                    result = titlePainter.getHeight(this, g2d);
                    break;
                }
                case 2: {
                    result = titlePainter.getWidth(this, g2d);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Given axis.getDimension() is neither Chart2D.X nor Chart2D.Y!");
                }
            }
        }
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        IPropertyChangeReactor reactor = (IPropertyChangeReactor)propertyReactors.get(property);
        if (reactor != null) {
            reactor.propertyChange(evt, this);
        }
    }

    @Override
    public final Set<ITrace2D> removeAllTraces() {
        TreeSet<ITrace2D> result = new TreeSet<ITrace2D>();
        result.addAll(this.m_traces);
        for (ITrace2D trace : result) {
            this.removeTrace(trace);
        }
        return result;
    }

    @Override
    public IAxis.AxisTitle removeAxisTitle() {
        IAxis.AxisTitle result = this.m_axisTitle;
        this.unListenToAxisTitle(this.m_axisTitle);
        this.m_axisTitle = null;
        return result;
    }

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(property, listener);
    }

    @Override
    public boolean removeTrace(ITrace2D trace) {
        boolean result = this.m_traces.remove(trace);
        if (result) {
            this.unlisten2Trace(trace);
            this.m_max = this.findMax();
            this.m_min = this.findMin();
            this.m_propertyChangeSupport.firePropertyChange("IAxis.PROPERTY_ADD_REMOVE_TRACE", trace, null);
        }
        return result;
    }

    protected final void scalePoint(ITracePoint2D point) {
        int axis = this.getAccessor().getDimension();
        if (axis == 1) {
            point.setScaledX(this.getScaledValue(point.getX()));
        } else if (axis == 2) {
            point.setScaledY(this.getScaledValue(point.getY()));
        }
    }

    @Override
    public void scale() {
        for (ITrace2D trace : this.m_traces) {
            this.scaleTrace(trace);
        }
        this.m_rangePreviousScaling.mimic(this.getRange());
        this.m_needsFullRescale = false;
    }

    @Override
    public void scaleTrace(ITrace2D trace) {
        Range range = this.getRange();
        this.m_accessor.scaleTrace(trace, range);
    }

    protected final void setAccessor(AChart2DDataAccessor accessor) {
        this.m_accessor = accessor;
    }

    protected final synchronized void setAxisPosition(int axisPosition) {
        this.m_axisPosition = axisPosition;
    }

    @Override
    public void setAxisTitle(IAxis.AxisTitle axisTitle) {
        this.unListenToAxisTitle(this.m_axisTitle);
        this.m_axisTitle = axisTitle;
        this.listenToAxisTitle(this.m_axisTitle);
    }

    public void setChart(Chart2D chart, int dimension, int position) {
        this.m_accessor = this.createAccessor(chart, dimension, position);
        this.m_needsFullRescale = true;
    }

    @Override
    public void setFormatter(IAxisLabelFormatter formatter) {
        if (this.getAccessor() != null) {
            this.removePropertyChangeListener("IAxis.PROPERTY_LABELFORMATTER", this.getAccessor().getChart());
            this.addPropertyChangeListener("IAxis.PROPERTY_LABELFORMATTER", this.getAccessor().getChart());
            if (this.m_formatter != null) {
                this.m_formatter.removePropertyChangeListener("IAxisLabelFormatter.PROPERTY_FORMATCHANGE", this);
            }
            formatter.addPropertyChangeListener("IAxisLabelFormatter.PROPERTY_FORMATCHANGE", this);
        }
        IAxisLabelFormatter old = this.m_formatter;
        this.m_formatter = formatter;
        this.m_formatter.setAxis(this);
        this.m_propertyChangeSupport.firePropertyChange("IAxis.PROPERTY_LABELFORMATTER", old, this.m_formatter);
    }

    @Override
    public void setMajorTickSpacing(double majorTickSpacing) {
        this.m_majorTickSpacing = majorTickSpacing;
    }

    @Override
    public void setMinorTickSpacing(double minorTickSpacing) {
        this.m_minorTickSpacing = minorTickSpacing;
    }

    @Override
    public final void setPaintGrid(boolean grid) {
        boolean oldValue = this.m_paintGrid;
        this.m_paintGrid = grid;
        if (oldValue != grid) {
            this.m_propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "IAxis.PROPERTY_PAINTGRID", new Boolean(oldValue), this.m_paintGrid));
        }
    }

    @Override
    public final void setPaintScale(boolean show) {
        boolean oldValue = this.m_paintScale;
        this.m_paintScale = show;
        if (oldValue != this.m_paintScale) {
            this.m_propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "IAxis.PROPERTY_PAINTSCALE", new Boolean(oldValue), this.m_paintGrid));
        }
    }

    @Override
    public final void setPixelXLeft(int pixelXLeft) {
        this.m_pixelXLeft = pixelXLeft;
    }

    @Override
    public final void setPixelXRight(int pixelXRight) {
        this.m_pixelXRight = pixelXRight;
    }

    @Override
    public final void setPixelYBottom(int pixelYBottom) {
        this.m_pixelYBottom = pixelYBottom;
    }

    @Override
    public final void setPixelYTop(int pixelYTop) {
        this.m_pixelYTop = pixelYTop;
    }

    @Override
    public final void setRange(Range range) {
        this.getRangePolicy().setRange(range);
    }

    protected final void ensureInitialized() {
        if (this.m_accessor == null) {
            throw new IllegalStateException("Add this axis to a chart first before this operation (undebuggable deadlocks might occur else)");
        }
    }

    @Override
    public void setRangePolicy(IRangePolicy rangePolicy) {
        this.ensureInitialized();
        IRangePolicy old = this.getRangePolicy();
        double max = 0.0;
        double min = 0.0;
        if (old != null) {
            max = this.getMax();
            min = this.getMin();
            old.removePropertyChangeListener(this.m_accessor.m_chart, "IRangePolicy.PROPERTY_RANGE");
            old.removePropertyChangeListener(this.m_accessor.m_chart, "IRangePolicy.PROPERTY_RANGE");
            old.removePropertyChangeListener(this.m_accessor.m_chart, "IRangePolicy.PROPERTY_RANGE");
        }
        this.m_rangePolicy = rangePolicy;
        this.m_rangePolicy.addPropertyChangeListener("IRangePolicy.PROPERTY_RANGE", this.m_accessor.m_chart);
        this.m_rangePolicy.addPropertyChangeListener("IRangePolicy.PROPERTY_RANGE", this.m_accessor.m_chart);
        this.m_rangePolicy.addPropertyChangeListener("IRangePolicy.PROPERTY_RANGE", this.m_accessor.m_chart);
        if (max != 0.0 && min != 0.0 && (max != this.getMax() || min != this.getMin())) {
            this.m_accessor.m_chart.propertyChange(new PropertyChangeEvent(rangePolicy, "IRangePolicy.PROPERTY_RANGE", new Range(min, max), this.m_rangePolicy.getRange()));
        }
        this.m_propertyChangeSupport.firePropertyChange("IAxis.PROPERTY_RANGEPOLICY", old, rangePolicy);
    }

    @Override
    public void setStartMajorTick(boolean majorTick) {
        this.m_startMajorTick = majorTick;
    }

    @Override
    @Deprecated
    public final String setTitle(String title) {
        String result = this.getAxisTitle().setTitle(title);
        return result;
    }

    @Override
    @Deprecated
    public final IAxisTitlePainter setTitlePainter(IAxisTitlePainter painter) {
        IAxisTitlePainter result = this.getAxisTitle().setTitlePainter(painter);
        return result;
    }

    @Override
    public void setVisible(boolean visible) {
        this.m_visible = visible;
    }

    public double translateMousePosition(MouseEvent mouseEvent) throws IllegalArgumentException {
        return this.getAccessor().translateMousePosition(mouseEvent);
    }

    @Override
    public double translatePxToValue(int pixel) {
        return this.m_accessor.translatePxToValue(pixel);
    }

    @Override
    public final int translateValueToPx(double value) {
        return this.m_accessor.translateValueToPx(value);
    }

    private void unlisten2Trace(ITrace2D trace) {
        if (this.getAccessor().getDimension() == 1) {
            trace.removePropertyChangeListener("ITrace2D.PROPERTY_MAX_X", this);
            trace.removePropertyChangeListener("ITrace2D.PROPERTY_MIN_X", this);
        } else {
            trace.removePropertyChangeListener("ITrace2D.PROPERTY_MAX_Y", this);
            trace.removePropertyChangeListener("ITrace2D.PROPERTY_MIN_Y", this);
        }
        trace.removePropertyChangeListener("ITrace2D.PROPERTY_COLOR", this);
        trace.removePropertyChangeListener("ITrace2D.PROPERTY_STROKE", this);
        trace.removePropertyChangeListener("ITrace2D.PROPERTY_VISIBLE", this);
        trace.removePropertyChangeListener("ITrace2D.PROPERTY_ZINDEX", this);
        trace.removePropertyChangeListener("ITrace2D.PROPERTY_PAINTERS", this);
        trace.removePropertyChangeListener("ITrace2D.PROPERTY_ERRORBARPOLICY", this);
        trace.removePropertyChangeListener("ITrace2D.PROPERTY_ERRORBARPOLICY_CONFIGURATION", this);
        trace.removePropertyChangeListener("ITrace2D.PROPERTY_ZINDEX", this);
        trace.removePropertyChangeListener("ITrace2D.PROPERTY_NAME", this);
        trace.removePropertyChangeListener("ITrace2D.PROPERTY_TRACEPOINT", this);
        trace.removePropertyChangeListener("ITrace2D.PROPERTY_POINT_CHANGED", this);
    }

    private void unListenToAxisTitle(IAxis.AxisTitle axisTitle) {
        if (axisTitle != null) {
            axisTitle.removePropertyChangeListener("IAxis.AxisTitle.PROPERTY_TITLE", this);
            axisTitle.removePropertyChangeListener("IAxis.AxisTitle.PROPERTY_TITLEFONT", this);
            axisTitle.removePropertyChangeListener("IAxis.AxisTitle.PROPERTY_TITLEPAINTER", this);
        }
    }

    static {
        PropertyChangeRepainter repaintReactor = new PropertyChangeRepainter();
        propertyReactors.put("ITrace2D.PROPERTY_STROKE", repaintReactor);
        propertyReactors.put("ITrace2D.PROPERTY_STROKE", repaintReactor);
        propertyReactors.put("ITrace2D.PROPERTY_PAINTERS", repaintReactor);
        propertyReactors.put("ITrace2D.PROPERTY_COLOR", repaintReactor);
        propertyReactors.put("ITrace2D.PROPERTY_NAME", repaintReactor);
        propertyReactors.put("ITrace2D.PROPERTY_ERRORBARPOLICY", repaintReactor);
        propertyReactors.put("ITrace2D.PROPERTY_ERRORBARPOLICY_CONFIGURATION", repaintReactor);
        propertyReactors.put("ITrace2D.PROPERTY_ZINDEX", repaintReactor);
        propertyReactors.put("IAxis.PROPERTY_LABELFORMATTER", repaintReactor);
        propertyReactors.put("IAxisLabelFormatter.PROPERTY_FORMATCHANGE", repaintReactor);
        propertyReactors.put("IAxis.AxisTitle.PROPERTY_TITLEFONT", repaintReactor);
        propertyReactors.put("IAxis.AxisTitle.PROPERTY_TITLE", repaintReactor);
        propertyReactors.put("IAxis.AxisTitle.PROPERTY_TITLEPAINTER", repaintReactor);
        propertyReactors.put("ITrace2D.PROPERTY_MAX_X", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent changeEvent, AAxis<?> receiver) {
                boolean result = false;
                AChart2DDataAccessor accessor = receiver.getAccessor();
                if (accessor.getDimension() == 1) {
                    double value = (Double)changeEvent.getNewValue();
                    if (value > receiver.m_max) {
                        ITrace2D trace = (ITrace2D)changeEvent.getSource();
                        if (trace.isVisible()) {
                            receiver.m_max = value;
                            receiver.m_needsFullRescale = true;
                            result = true;
                        }
                    } else if (value < receiver.m_max) {
                        receiver.m_max = receiver.findMax();
                        receiver.m_needsFullRescale = true;
                        result = true;
                    }
                }
                return result;
            }
        });
        propertyReactors.put("ITrace2D.PROPERTY_MIN_X", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent changeEvent, AAxis<?> receiver) {
                boolean result = false;
                if (receiver.getAccessor().getDimension() == 1) {
                    double value = (Double)changeEvent.getNewValue();
                    if (value < receiver.m_min) {
                        ITrace2D trace = (ITrace2D)changeEvent.getSource();
                        if (trace.isVisible()) {
                            receiver.m_min = value;
                            receiver.m_needsFullRescale = true;
                            result = true;
                        }
                    } else if (value > receiver.m_min) {
                        receiver.m_min = receiver.findMin();
                        receiver.m_needsFullRescale = true;
                        result = true;
                    }
                }
                return result;
            }
        });
        propertyReactors.put("ITrace2D.PROPERTY_MAX_Y", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent changeEvent, AAxis<?> receiver) {
                boolean result = false;
                if (receiver.getAccessor().getDimension() == 2) {
                    double value = (Double)changeEvent.getNewValue();
                    if (value > receiver.m_max) {
                        ITrace2D trace = (ITrace2D)changeEvent.getSource();
                        if (trace.isVisible()) {
                            receiver.m_max = value;
                            receiver.m_needsFullRescale = true;
                            result = true;
                        }
                    } else if (value < receiver.m_max) {
                        receiver.m_max = receiver.findMax();
                        receiver.m_needsFullRescale = true;
                        result = true;
                    }
                }
                return result;
            }
        });
        propertyReactors.put("ITrace2D.PROPERTY_MIN_Y", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent changeEvent, AAxis<?> receiver) {
                boolean result = false;
                if (receiver.getAccessor().getDimension() == 2) {
                    double value = (Double)changeEvent.getNewValue();
                    if (value < receiver.m_min) {
                        ITrace2D trace = (ITrace2D)changeEvent.getSource();
                        if (trace.isVisible()) {
                            receiver.m_min = value;
                            receiver.m_needsFullRescale = true;
                            result = true;
                        }
                    } else if (value > receiver.m_min) {
                        receiver.m_min = receiver.findMin();
                        receiver.m_needsFullRescale = true;
                        result = true;
                    }
                }
                return result;
            }
        });
        propertyReactors.put("ITrace2D.PROPERTY_TRACEPOINT", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent changeEvent, AAxis<?> receiver) {
                boolean result = false;
                ITracePoint2D oldPt = (ITracePoint2D)changeEvent.getOldValue();
                ITracePoint2D newPt = (ITracePoint2D)changeEvent.getNewValue();
                if (oldPt == null) {
                    receiver.scalePoint(newPt);
                    result = true;
                }
                return result;
            }
        });
        propertyReactors.put("ITrace2D.PROPERTY_VISIBLE", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent changeEvent, AAxis<?> receiver) {
                boolean result = false;
                receiver.m_max = receiver.findMax();
                receiver.m_min = receiver.findMin();
                ITrace2D trace = (ITrace2D)changeEvent.getSource();
                receiver.scaleTrace(trace);
                result = true;
                return result;
            }
        });
        propertyReactors.put("ITrace2D.PROPERTY_POINT_CHANGED", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent changeEvent, AAxis<?> receiver) {
                boolean result = false;
                ITracePoint2D changed = (ITracePoint2D)changeEvent.getNewValue();
                receiver.scalePoint(changed);
                result = true;
                return result;
            }
        });
    }

    protected class YDataAccessor
    extends AChart2DDataAccessor {
        private static final long serialVersionUID = -3665759247443586028L;

        public YDataAccessor(Chart2D chart) {
            super(chart);
        }

        @Override
        public final int getDimension() {
            return 2;
        }

        @Override
        public final int getHeight(Graphics g2d) {
            FontMetrics fontdim = g2d.getFontMetrics();
            int fontHeight = fontdim.getHeight();
            return fontHeight += 4;
        }

        @Override
        protected final double getMaximumPixelForLabel(Graphics g2d) {
            FontMetrics fontdim = g2d.getFontMetrics();
            int fontheight = fontdim.getHeight();
            return fontheight + 10;
        }

        @Override
        protected double getMaxValue(ITrace2D trace) {
            return trace.getMaxY();
        }

        @Override
        public final double getMinimumValueDistanceForLabels(Graphics g2d) {
            double result;
            Dimension d = this.m_chart.getSize();
            int pxrange = (int)d.getHeight() - 40;
            if (pxrange <= 0) {
                result = 1.0;
            } else {
                double valuerange = AAxis.this.getMax() - AAxis.this.getMin();
                if (valuerange == 0.0) {
                    valuerange = 10.0;
                }
                double pxToValue = valuerange / (double)pxrange;
                result = pxToValue * this.getMaximumPixelForLabel(g2d);
            }
            return result;
        }

        @Override
        protected double getMinValue(ITrace2D trace) {
            return trace.getMinY();
        }

        @Override
        protected final int getPixelRange() {
            return this.m_chart.getYChartStart() - this.m_chart.getYChartEnd();
        }

        @Override
        protected double getValue(ITracePoint2D point) {
            return point.getY();
        }

        @Override
        protected final double getValueDistanceForPixel(int pixel) {
            double result;
            Dimension d = this.m_chart.getSize();
            int pxrangey = (int)d.getHeight() - 40;
            if (pxrangey <= 0) {
                result = -1.0;
            } else {
                double valuerangey = AAxis.this.getMaxValue() - AAxis.this.getMinValue();
                double pxToValue = valuerangey / (double)pxrangey;
                result = pxToValue * (double)pixel;
            }
            return result;
        }

        @Override
        public final int getWidth(Graphics g2d) {
            FontMetrics fontdim = g2d.getFontMetrics();
            int fontWidth = fontdim.charWidth('0');
            int height = fontWidth * AAxis.this.getFormatter().getMaxAmountChars();
            height += this.getChart().getAxisTickPainter().getMajorTickLength();
            return height += AAxis.this.getAxisTitle().getTitlePainter().getWidth(AAxis.this, g2d);
        }

        @Override
        protected void scaleTrace(ITrace2D trace, Range range) {
            if (trace.isVisible()) {
                double scaler = range.getExtent();
                Iterator<ITracePoint2D> itPoints = trace.iterator();
                while (itPoints.hasNext()) {
                    ITracePoint2D point = itPoints.next();
                    double absolute = point.getY();
                    double result = (absolute - range.getMin()) / scaler;
                    if (!MathUtil.isDouble(result)) {
                        result = 0.0;
                    }
                    point.setScaledY(result);
                }
            }
        }

        public String toString() {
            return "Y";
        }

        @Override
        public double translateMousePosition(MouseEvent mouseEvent) {
            return this.translatePxToValue(mouseEvent.getY());
        }

        @Override
        public double translatePxToValue(int pixel) {
            double result = 0.0;
            double px = this.m_chart.getYChartStart() - pixel;
            int rangeY = this.m_chart.getYChartStart() - this.m_chart.getYChartEnd();
            if (rangeY != 0) {
                double scaledY = px / (double)rangeY;
                Range valueRangeY = AAxis.this.getRange();
                result = scaledY * valueRangeY.getExtent() + valueRangeY.getMin();
            }
            return result;
        }

        @Override
        public int translateValueToPx(double value) {
            int result = 0;
            Range valueRange = AAxis.this.getRange();
            double valueNormalized = (value - valueRange.getMin()) / valueRange.getExtent();
            int rangeY = this.getPixelRange();
            if (rangeY != 0) {
                result = (int)Math.round((double)this.m_chart.getYChartStart() - valueNormalized * (double)rangeY);
            }
            return result;
        }
    }

    public class XDataAccessor
    extends AChart2DDataAccessor {
        private static final long serialVersionUID = 1185826702304621485L;

        public XDataAccessor(Chart2D chart) {
            super(chart);
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public int getHeight(Graphics g2d) {
            FontMetrics fontdim = g2d.getFontMetrics();
            int height = fontdim.getHeight();
            height += this.getChart().getAxisTickPainter().getMajorTickLength();
            return height += AAxis.this.getAxisTitle().getTitlePainter().getHeight(AAxis.this, g2d);
        }

        @Override
        protected final double getMaximumPixelForLabel(Graphics g2d) {
            FontMetrics fontdim = g2d.getFontMetrics();
            int fontwidth = fontdim.charWidth('0');
            int len = AAxis.this.getFormatter().getMaxAmountChars();
            return fontwidth * (len + 2);
        }

        @Override
        protected double getMaxValue(ITrace2D trace) {
            return trace.getMaxX();
        }

        @Override
        public final double getMinimumValueDistanceForLabels(Graphics g2d) {
            double result;
            Dimension d = this.m_chart.getSize();
            int pxrange = (int)d.getWidth() - 60;
            if (pxrange <= 0) {
                result = 1.0;
            } else {
                double valuerange = AAxis.this.getMax() - AAxis.this.getMin();
                if (valuerange == 0.0) {
                    valuerange = 10.0;
                }
                double pxToValue = valuerange / (double)pxrange;
                result = pxToValue * this.getMaximumPixelForLabel(g2d);
            }
            return result;
        }

        @Override
        protected double getMinValue(ITrace2D trace) {
            return trace.getMinX();
        }

        @Override
        protected int getPixelRange() {
            return this.m_chart.getXChartEnd() - this.m_chart.getXChartStart();
        }

        @Override
        protected double getValue(ITracePoint2D point) {
            return point.getX();
        }

        @Override
        protected final double getValueDistanceForPixel(int pixel) {
            double result;
            Dimension d = this.m_chart.getSize();
            int pxrangex = (int)d.getWidth() - 60;
            if (pxrangex <= 0) {
                result = -1.0;
            } else {
                double valuerangex = AAxis.this.getMax() - AAxis.this.getMin();
                double pxToValue = valuerangex / (double)pxrangex;
                result = pxToValue * (double)pixel;
            }
            return result;
        }

        @Override
        public int getWidth(Graphics g2d) {
            FontMetrics fontdim = g2d.getFontMetrics();
            int fontwidth = fontdim.charWidth('0');
            int rightSideOverhang = AAxis.this.getFormatter().getMaxAmountChars() * fontwidth;
            return rightSideOverhang;
        }

        @Override
        protected void scaleTrace(ITrace2D trace, Range range) {
            double scaler = range.getExtent();
            if (trace.isVisible()) {
                Iterator<ITracePoint2D> itPoints = trace.iterator();
                while (itPoints.hasNext()) {
                    ITracePoint2D point = itPoints.next();
                    double absolute = point.getX();
                    double result = (absolute - range.getMin()) / scaler;
                    if (!MathUtil.isDouble(result)) {
                        result = 0.0;
                    }
                    point.setScaledX(result);
                }
            }
        }

        public String toString() {
            return "X";
        }

        @Override
        public final double translateMousePosition(MouseEvent mouseEvent) {
            return this.translatePxToValue(mouseEvent.getX());
        }

        @Override
        public double translatePxToValue(int pixel) {
            double result = 0.0;
            double px = pixel - this.m_chart.getXChartStart();
            int rangeX = this.m_chart.getXChartEnd() - this.m_chart.getXChartStart();
            if (rangeX != 0) {
                double scaledX = px / (double)rangeX;
                Range valueRangeX = AAxis.this.getRange();
                result = scaledX * valueRangeX.getExtent() + valueRangeX.getMin();
            }
            return result;
        }

        @Override
        public int translateValueToPx(double value) {
            int result = 0;
            Range valueRange = AAxis.this.getRange();
            double valueNormalized = (value - valueRange.getMin()) / valueRange.getExtent();
            int rangeX = this.getPixelRange();
            if (rangeX != 0) {
                double tmpResult = valueNormalized * (double)rangeX + (double)this.m_chart.getXChartStart();
                result = (int)Math.round(tmpResult);
            }
            return result;
        }
    }

    private static final class PropertyChangeRepainter
    implements IPropertyChangeReactor {
        protected PropertyChangeRepainter() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent, AAxis<?> receiver) {
            Chart2D parent;
            AChart2DDataAccessor accessor = receiver.getAccessor();
            if (accessor != null && (parent = accessor.getChart()) != null) {
                parent.setRequestedRepaint(true);
            }
        }
    }

    private static interface IPropertyChangeReactor {
        public void propertyChange(PropertyChangeEvent var1, AAxis<?> var2);
    }

    private static abstract class APropertyChangeReactorSynced
    implements IPropertyChangeReactor {
        protected APropertyChangeReactorSynced() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void propertyChange(PropertyChangeEvent changeEvent, AAxis<?> receiver) {
            Chart2D chart;
            Chart2D chart2D = chart = receiver.getAccessor().getChart();
            synchronized (chart2D) {
                boolean repaint = this.propertyChangeSynced(changeEvent, receiver);
                if (repaint) {
                    chart.setRequestedRepaint(true);
                }
            }
        }

        protected abstract boolean propertyChangeSynced(PropertyChangeEvent var1, AAxis<?> var2);
    }

    public abstract class AChart2DDataAccessor
    implements Serializable {
        private static final long serialVersionUID = 5023422232812082122L;
        protected Chart2D m_chart;

        protected AChart2DDataAccessor(Chart2D chart) {
            AAxis.this.setAccessor(this);
            this.m_chart = chart;
        }

        public final Chart2D getChart() {
            return this.m_chart;
        }

        public abstract int getDimension();

        public abstract int getHeight(Graphics var1);

        protected abstract double getMaximumPixelForLabel(Graphics var1);

        protected abstract double getMaxValue(ITrace2D var1);

        public abstract double getMinimumValueDistanceForLabels(Graphics var1);

        protected abstract double getMinValue(ITrace2D var1);

        protected abstract int getPixelRange();

        protected abstract double getValue(ITracePoint2D var1);

        protected abstract double getValueDistanceForPixel(int var1);

        public abstract int getWidth(Graphics var1);

        protected abstract void scaleTrace(ITrace2D var1, Range var2);

        public abstract double translateMousePosition(MouseEvent var1);

        public abstract double translatePxToValue(int var1);

        public abstract int translateValueToPx(double var1);
    }
}

