/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoVertexT4OptionsPanel;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaObject;
import jhplot.jadraw.JaVertex;
import org.freehep.graphics2d.VectorGraphics;

public class JaVertexT4
extends JaVertex {
    private static final long serialVersionUID = 1L;

    @Override
    public final JaObject copy() {
        JaVertexT4 temp = (JaVertexT4)this.copy(new JaVertexT4());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaVertexT4) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        double length = Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        gp.moveTo(0.0f, -((float)length));
        gp.lineTo(0.0f, (float)length);
        gp.moveTo(-((float)length), 0.0f);
        gp.lineTo((float)length, 0.0f);
        gp = this.trans(gp, 1.0);
        g2.draw((Shape)gp);
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        String command = "";
        Point2D center = this.getLaTexCenter(scale, canvasHeight);
        float radius = this.getLaTexRadius(scale);
        if ((int)radius == 0) {
            command = "%";
        } else {
            Point2D.Float invec1 = new Point2D.Float((float)(center.getX() - (double)(radius * 0.707f)), (float)(center.getY() - (double)(radius * 0.707f)));
            Point2D.Float finvec1 = new Point2D.Float((float)(center.getX() + (double)(radius * 0.707f)), (float)(center.getY() + (double)(radius * 0.707f)));
            Point2D.Float invec2 = new Point2D.Float((float)(center.getX() - (double)(radius * 0.707f)), (float)(center.getY() + (double)(radius * 0.707f)));
            Point2D.Float finvec2 = new Point2D.Float((float)(center.getX() + (double)(radius * 0.707f)), (float)(center.getY() - (double)(radius * 0.707f)));
            double theta = 0.7853981633974483 - Math.atan2(this.getRelh(), this.getRelw());
            AffineTransform at = new AffineTransform();
            at.rotate(theta, center.getX(), center.getY());
            Point2D invect1 = new Point2D.Float();
            Point2D finvect1 = new Point2D.Float();
            Point2D invect2 = new Point2D.Float();
            Point2D finvect2 = new Point2D.Float();
            invect1 = at.transform(invec1, invect1);
            finvect1 = at.transform(finvec1, finvect1);
            invect2 = at.transform(invec2, invect2);
            finvect2 = at.transform(finvec2, finvect2);
            String command1 = "\\Line(" + D_FORMAT.format(invect1.getX()) + "," + D_FORMAT.format(invect1.getY()) + ")(" + D_FORMAT.format(finvect1.getX()) + "," + D_FORMAT.format(finvect1.getY()) + ")";
            String command2 = "\\Line(" + D_FORMAT.format(invect2.getX()) + "," + D_FORMAT.format(invect2.getY()) + ")(" + D_FORMAT.format(finvect2.getX()) + "," + D_FORMAT.format(finvect2.getY()) + ")";
            command = command1 + command2;
        }
        return command;
    }

    @Override
    public final boolean editPanel() {
        JaxoVertexT4OptionsPanel vert4op = new JaxoVertexT4OptionsPanel(this);
        return vert4op.hasChanged();
    }
}

