/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoVertexT3OptionsPanel;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaObject;
import jhplot.jadraw.JaVertex;
import org.freehep.graphics2d.VectorGraphics;

public class JaVertexT3
extends JaVertex {
    private static final long serialVersionUID = 1L;

    @Override
    public final JaObject copy() {
        JaVertexT3 temp = (JaVertexT3)this.copy(new JaVertexT3());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaVertexT3) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(0.0f));
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        double length = Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        Rectangle2D.Float square = new Rectangle2D.Float();
        square.setFrame(-length, -length, 2.0 * length, 2.0 * length);
        gp.append(square, false);
        gp = this.transv(gp, 1.0);
        g2.fill((Shape)gp);
        g2.draw((Shape)gp);
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D center = this.getLaTexCenter(scale, canvasHeight);
        float radius = this.getLaTexRadius(scale);
        String command = "";
        if ((int)radius == 0) {
            command = "%";
        } else {
            float xi = (float)center.getX() - radius;
            float yi = (float)center.getY() + radius;
            float xf = (float)center.getX() + radius;
            float yf = (float)center.getY() - radius;
            String tlc = JaxoColor.getColorName(this.getColor());
            command = "\\CBox(" + D_FORMAT.format(xf) + "," + D_FORMAT.format(yf) + ")(" + D_FORMAT.format(xi) + "," + D_FORMAT.format(yi) + "){" + tlc + "}{" + tlc + "}%%JaxoDrawID:Vertex";
        }
        return command;
    }

    @Override
    public final boolean editPanel() {
        JaxoVertexT3OptionsPanel vert3op = new JaxoVertexT3OptionsPanel(this);
        return vert3op.hasChanged();
    }
}

