/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoLineOptionsPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaLineObject;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaGlLine
extends JaLineObject {
    private static final long serialVersionUID = 1L;
    private int angamp;

    public JaGlLine() {
        this.setAmp(JaxoPrefs.getIntPref(104));
        this.setFreq(20.0f);
        this.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        this.setStroke(JaxoPrefs.getFloatPref(200));
        this.setSymm(false);
        this.setDoubleLine(false);
        this.setDLSeparation(JaxoPrefs.getFloatPref(201));
    }

    @Override
    public final JaObject copy() {
        JaGlLine temp = new JaGlLine();
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setAmp(this.getAmp());
        temp.setFreq(this.getFreq());
        temp.setColor(this.getColor());
        temp.setStroke(this.getStroke());
        temp.setSymm(this.isSymm());
        temp.setDoubleLine(this.getDoubleLine());
        temp.setDLSeparation(this.getDLSeparation());
        temp.setSize(this.getWidth(), this.getHeight(), this.getRelw(), this.getRelh());
        temp.setBoundingBox(this.getBoundingBox());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        JaGlLine line;
        boolean isCopy = false;
        if (comp instanceof JaGlLine && (line = (JaGlLine)comp).getX() == this.getX() && line.getY() == this.getY() && line.getAmp() == this.getAmp() && line.getFreq() == this.getFreq() && line.getColor().equals(this.getColor()) && line.getStroke() == this.getStroke() && line.isSymm() == this.isSymm() && line.getDoubleLine() == this.getDoubleLine() && line.getDLSeparation() == this.getDLSeparation() && line.getRelw() == this.getRelw() && line.getRelh() == this.getRelh()) {
            isCopy = true;
        }
        return isCopy;
    }

    public final int getAngamp() {
        return this.angamp;
    }

    public final void setAngamp(int amp) {
        this.angamp = amp;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        int i;
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        float boh = 0.6f;
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        this.angamp = -180;
        if (this.getAmp() > 0 && this.isBack() || this.getAmp() < 0 && !this.isBack()) {
            this.angamp = 180;
        }
        int a = Math.abs(this.getAmp());
        double length = Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        int n = (int)Math.round((length - (double)this.getFreq()) / (double)this.getFreq() / (double)boh);
        float ts = (float)(length / (double)(1.0f + boh * (float)n));
        Arc2D.Float arc = new Arc2D.Float();
        if (this.getDoubleLine()) {
            for (i = 0; i < n; ++i) {
                ((Arc2D)arc).setArc((float)i * ts * boh, (float)(-a / 2) + this.getDLSeparation(), ts, a, 180.0, this.angamp, 0);
                gp.append(arc, true);
                ((Arc2D)arc).setArc((float)i * ts * boh, (float)(-a / 2) - this.getDLSeparation(), ts, a, 180.0, this.angamp, 0);
                gp.append(arc, false);
                ((Arc2D)arc).setArc((float)(i + 1) * ts * boh, (float)(-a / 2) + this.getDLSeparation(), ts * (1.0f - boh), a, 0.0, this.angamp, 0);
                gp.append(arc, true);
                ((Arc2D)arc).setArc((float)(i + 1) * ts * boh, (float)(-a / 2) - this.getDLSeparation(), ts * (1.0f - boh), a, 0.0, this.angamp, 0);
                gp.append(arc, false);
            }
            ((Arc2D)arc).setArc((float)n * ts * boh, (float)(-a / 2) + this.getDLSeparation(), ts, a, 180.0, this.angamp, 0);
            gp.append(arc, true);
            ((Arc2D)arc).setArc((float)n * ts * boh, (float)(-a / 2) - this.getDLSeparation(), ts, a, 180.0, this.angamp, 0);
            gp.append(arc, false);
        } else {
            for (i = 0; i < n; ++i) {
                ((Arc2D)arc).setArc((float)i * ts * boh, -a / 2, ts, a, 180.0, this.angamp, 0);
                gp.append(arc, true);
                ((Arc2D)arc).setArc((float)(i + 1) * ts * boh, -a / 2, ts * (1.0f - boh), a, 0.0, this.angamp, 0);
                gp.append(arc, true);
            }
            ((Arc2D)arc).setArc((float)n * ts * boh, -a / 2, ts, a, 180.0, this.angamp, 0);
            gp.append(arc, true);
        }
        gp = this.trans(gp, 1.0);
        g2.draw((Shape)gp);
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D startPoint = this.getLaTexStartPoint(scale, canvasHeight);
        Point2D endPoint = this.getLaTexEndPoint(scale, canvasHeight);
        float amplitude = this.getLaTexAmplitude(2.0f * scale);
        float windings = this.getLaTexWindingNumber(1.0f);
        String command = "";
        String base = "\\Gluon";
        if ((int)endPoint.getX() == (int)startPoint.getX() && (int)endPoint.getY() == (int)startPoint.getY()) {
            command = "%";
        } else if (this.getDoubleLine()) {
            Point2D offSet = this.getOffSet(scale);
            String command1 = base + "(" + D_FORMAT.format(startPoint.getX() + offSet.getX()) + "," + D_FORMAT.format(startPoint.getY() + offSet.getY()) + ")(" + D_FORMAT.format(endPoint.getX() + offSet.getX()) + "," + D_FORMAT.format(endPoint.getY() + offSet.getY()) + "){" + D_FORMAT.format(amplitude) + "}{" + D_FORMAT.format(windings) + "}";
            String command2 = base + "(" + D_FORMAT.format(startPoint.getX() - offSet.getX()) + "," + D_FORMAT.format(startPoint.getY() - offSet.getY()) + ")(" + D_FORMAT.format(endPoint.getX() - offSet.getX()) + "," + D_FORMAT.format(endPoint.getY() - offSet.getY()) + "){" + D_FORMAT.format(amplitude) + "}{" + D_FORMAT.format(windings) + "}";
            command = command1.concat(command2.concat("%%JaxoDrawID:DoubleLine(" + D_FORMAT.format(this.getDLSeparation()) + ")"));
        } else {
            command = base + "(" + D_FORMAT.format(startPoint.getX()) + "," + D_FORMAT.format(startPoint.getY()) + ")(" + D_FORMAT.format(endPoint.getX()) + "," + D_FORMAT.format(endPoint.getY()) + "){" + D_FORMAT.format(amplitude) + "}{" + D_FORMAT.format(windings) + "}";
        }
        return command;
    }

    private Point2D getLaTexStartPoint(float scaleFactor, int canvasHeight) {
        Point2D.Float startVec = new Point2D.Float();
        float x1 = this.getRelw() <= 0 ? (float)(this.getX() - this.getRelw()) : (float)this.getX();
        float y1 = this.getRelh() >= 0 ? (float)this.getY() : (float)(this.getY() - this.getRelh());
        ((Point2D)startVec).setLocation(x1 / scaleFactor, ((float)canvasHeight - y1) / scaleFactor);
        return startVec;
    }

    private Point2D getLaTexEndPoint(float scaleFactor, int canvasHeight) {
        Point2D.Float endVec = new Point2D.Float();
        float x2 = this.getRelw() >= 0 ? (float)(this.getX() + this.getRelw()) : (float)this.getX();
        float y2 = this.getRelh() <= 0 ? (float)this.getY() : (float)(this.getY() + this.getRelh());
        ((Point2D)endVec).setLocation(x2 / scaleFactor, ((float)canvasHeight - y2) / scaleFactor);
        return endVec;
    }

    private float getLaTexAmplitude(float scaleFactor) {
        float a = (float)this.getAmp() / scaleFactor;
        return a;
    }

    private float getLaTexWindingNumber(float scaleFactor) {
        double length = Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        float n = (float)(length - (double)this.getFreq()) / this.getFreq() / 0.7f;
        return n /= scaleFactor;
    }

    private Point2D getOffSet(float scaleFactor) {
        Point2D.Float offSet = new Point2D.Float();
        float lSep = this.getDLSeparation() / scaleFactor;
        double theta = Math.atan2(this.getRelh(), this.getRelw());
        ((Point2D)offSet).setLocation((double)lSep * Math.sin(theta), (double)lSep * Math.cos(theta));
        return offSet;
    }

    @Override
    public final boolean editPanel() {
        JaxoLineOptionsPanel lineop = new JaxoLineOptionsPanel(15);
        lineop.initParams(this);
        lineop.setPanelIcon("japlot/jaxodraw/icons/gluon.gif");
        lineop.setPanelTitle("Gluon_line_parameters");
        this.baseEditPanel(lineop);
        lineop.addFinalAwSPanel(1, 0);
        lineop.addDlPanel(2, 0);
        boolean hasChanged = lineop.showPanel();
        return hasChanged;
    }
}

