/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoBoxOptionsPanel;
import japlot.jaxodraw.JaxoColor;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaFillObject;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaBox
extends JaFillObject {
    private static final long serialVersionUID = 1L;
    private float transp;
    private boolean fill;

    public JaBox() {
        this.setColor(Color.black);
        this.setFillColor(Color.white);
        this.setRelw(25);
        this.setRelh(25);
        this.transp = 1.0f;
        this.fill = true;
    }

    public JaBox(double x1, double y1, double x2, double y2, String what) {
        this.setColor(Color.black);
        this.setFillColor(Color.white);
        this.transp = 1.0f;
        this.fill = true;
        this.setLocation(x1, y1, what);
        this.setRelWH(x2, y2, what);
    }

    public int[] getXYCoord(int x, int y, int relw, int relh) {
        int[] co = new int[4];
        if (relw > 0 && relh >= 0 || relw < 0 && relh <= 0) {
            co[0] = x;
            co[1] = y;
            co[2] = x + Math.abs(relw);
            co[3] = y + Math.abs(relh);
        }
        if (relw >= 0 && relh < 0 || relw <= 0 && relh > 0) {
            co[0] = x;
            co[1] = y + Math.abs(relh);
            co[2] = x + Math.abs(relw);
            co[3] = y;
        }
        return co;
    }

    public void setLocationXY(int xin, int yin, int xfin, int yfin) {
        int newWidth = Math.abs(xfin - xin);
        int newHeight = Math.abs(yfin - yin);
        int newRelWidth = xfin - xin;
        int newRelHeight = yfin - yin;
        int newXin = xin;
        int newYin = yin;
        if (newRelWidth > 0 && newRelHeight >= 0) {
            newXin = xin;
            newYin = yin;
        }
        if (newRelWidth < 0 && newRelHeight <= 0) {
            newXin = xfin;
            newYin = yfin;
        }
        if (newRelWidth >= 0 && newRelHeight < 0) {
            newXin = xin;
            newYin = yin + newRelHeight;
        }
        if (newRelWidth <= 0 && newRelHeight > 0) {
            newXin = xin + newRelWidth;
            newYin = yin;
        }
        this.setRelWAndH(newWidth, newHeight);
        this.setLocation(newXin, newYin);
    }

    public void setFilled(boolean fill) {
        this.fill = fill;
    }

    public boolean isFilled() {
        return this.fill;
    }

    public void setTransparency(float transp) {
        this.transp = transp;
    }

    public float getTransparency() {
        return this.transp;
    }

    @Override
    public final JaObject copy() {
        JaBox temp = new JaBox();
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setColor(this.getColor());
        temp.setFilled(this.isFilled());
        temp.setTransparency(this.getTransparency());
        temp.setFillColor(this.getFillColor());
        temp.setStroke(this.getStroke());
        temp.setSize(this.getWidth(), this.getHeight(), this.getRelw(), this.getRelh());
        temp.setBoundingBox(this.getBoundingBox());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        JaBox temp;
        boolean isCopy = false;
        if (comp instanceof JaBox && (temp = (JaBox)comp).getX() == this.getX() && temp.getY() == this.getY() && temp.getColor().equals(this.getColor()) && temp.getFillColor().equals(this.getFillColor()) && temp.getStroke() == this.getStroke() && temp.getRelw() == this.getRelw() && temp.isFilled() == this.isFilled() && temp.getRelh() == this.getRelh()) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, int editmode) {
        if (editmode == 50 || editmode == 52) {
            if (clickX >= this.getX() + this.getWidth() && clickX <= this.getX() + this.getWidth() + 8 && clickY >= this.getY() + this.getHeight() && clickY <= this.getY() + this.getHeight() + 8) {
                return 11;
            }
            if (clickX >= this.getX() - 8 && clickX <= this.getX() && clickY >= this.getY() + this.getHeight() && clickY <= this.getY() + this.getHeight() + 8) {
                return 11;
            }
            if (clickX >= this.getX() + this.getWidth() && clickX <= this.getX() + this.getWidth() + 8 && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 11;
            }
            if (clickX >= this.getX() - 8 && clickX <= this.getX() && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 11;
            }
            return 0;
        }
        if (editmode == 51) {
            if (clickX >= this.getX() + this.getWidth() && clickX <= this.getX() + this.getWidth() + 8 && clickY >= this.getY() + this.getHeight() && clickY <= this.getY() + this.getHeight() + 8) {
                return 14;
            }
            if (clickX >= this.getX() - 8 && clickX <= this.getX() && clickY >= this.getY() + this.getHeight() && clickY <= this.getY() + this.getHeight() + 8) {
                return 15;
            }
            if (clickX >= this.getX() + this.getWidth() && clickX <= this.getX() + this.getWidth() + 8 && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 13;
            }
            if (clickX >= this.getX() - 8 && clickX <= this.getX() && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 12;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public final void drawHandles(VectorGraphics g2) {
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        g2.drawRect(x - 8, y - 8, 8, 8);
        g2.drawRect(x - 8, y + height, 8, 8);
        g2.drawRect(x + width, y - 8, 8, 8);
        g2.drawRect(x + width, y + height, 8, 8);
        if (this.isMarked()) {
            g2.setColor(JaxoColor.GRAYSCALE150);
            g2.fillRect(x - 8 + 1, y - 8 + 1, 7, 7);
            g2.fillRect(x - 8 + 1, y + height + 1, 7, 7);
            g2.fillRect(x + width + 1, y - 8 + 1, 7, 7);
            g2.fillRect(x + width + 1, y + height + 1, 7, 7);
        }
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        Rectangle2D.Float box = new Rectangle2D.Float();
        box.setFrame(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        gp.append(box, false);
        g2.setColor(this.getFillColor());
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        Composite cold = g2.getComposite();
        AlphaComposite c = AlphaComposite.getInstance(3, this.transp);
        g2.setComposite((Composite)c);
        if (this.isFilled()) {
            g2.fill((Shape)gp);
        }
        gp.reset();
        gp.append(box, false);
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        g2.draw((Shape)gp);
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
        g2.setComposite(cold);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D lowerCorner = this.getLaTexLowerCorner(scale, canvasHeight);
        Point2D upperCorner = this.getLaTexUpperCorner(scale, canvasHeight);
        String command = "";
        if ((int)lowerCorner.getX() == (int)upperCorner.getX() && (int)lowerCorner.getY() == (int)upperCorner.getY()) {
            command = "%";
        } else if (JaxoColor.isGrayScale(this.getFillColor())) {
            String grayScale = JaxoColor.getGreyScale(this.getFillColor());
            command = "\\GBox(" + D_FORMAT.format(lowerCorner.getX()) + "," + D_FORMAT.format(lowerCorner.getY()) + ")(" + D_FORMAT.format(upperCorner.getX()) + "," + D_FORMAT.format(upperCorner.getY()) + "){" + grayScale + "}";
        } else {
            String tlc = JaxoColor.getColorName(this.getColor());
            String tfc = JaxoColor.getColorName(this.getFillColor());
            command = "\\CBox(" + D_FORMAT.format(lowerCorner.getX()) + "," + D_FORMAT.format(lowerCorner.getY()) + ")(" + D_FORMAT.format(upperCorner.getX()) + "," + D_FORMAT.format(upperCorner.getY()) + "){" + tlc + "}{" + tfc + "}";
        }
        return command;
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        int newRelWidth = Math.round((float)this.getRelSize().width * scale);
        int newRelHeight = Math.round((float)this.getRelSize().height * scale);
        Point2D newP = this.scalePoint(orx, ory, scale, this.getX(), this.getY());
        this.setX((int)Math.round(newP.getX()));
        this.setY((int)Math.round(newP.getY()));
        this.setRelWAndH(newRelWidth, newRelHeight);
    }

    private Point2D getLaTexLowerCorner(float scaleFactor, int canvasHeight) {
        Point2D.Float lowerCornerVec = new Point2D.Float();
        float x1 = this.getX();
        float y1 = this.getY() + this.getHeight();
        ((Point2D)lowerCornerVec).setLocation(x1 / scaleFactor, ((float)canvasHeight - y1) / scaleFactor);
        return lowerCornerVec;
    }

    private Point2D getLaTexUpperCorner(float scaleFactor, int canvasHeight) {
        Point2D.Float upperCornerVec = new Point2D.Float();
        float x1 = this.getX() + this.getWidth();
        float y1 = this.getY();
        ((Point2D)upperCornerVec).setLocation(x1 / scaleFactor, ((float)canvasHeight - y1) / scaleFactor);
        return upperCornerVec;
    }

    @Override
    public final boolean editPanel() {
        JaxoBoxOptionsPanel boxop = new JaxoBoxOptionsPanel(this);
        return boxop.hasChanged();
    }
}

