/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoColorChooser;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jhplot.jadraw.JaVertexT5;

public class JaxoVertexT5OptionsPanel
extends JPanel
implements ActionListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaVertexT5 theVertexT5;
    private Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    private String sVertex;
    private Icon theIcon;
    private ImageIcon colorPreviewIcon;
    private ImageIcon colorFillPreviewIcon;
    private JButton colorbt;
    private JButton colorFillbt;
    private JPanel colorPanel;
    private JPanel colorFillPanel;
    private TitledBorder colorPanelTitle;
    private TitledBorder colorFillPanelTitle;
    private Color newColor;
    private Color newFillColor;
    private Image colorPreview;
    private Image colorFillPreview;
    private int nx1;
    private int nx2;
    private int nx3;
    private int ny1;
    private int ny2;
    private int ny3;
    private float newStroke;
    private boolean changed = false;

    public JaxoVertexT5OptionsPanel(JaVertexT5 vertexT5) {
        this.theVertexT5 = vertexT5;
        this.sVertex = this.language.getString("Vertex_parameters");
        this.theIcon = new ImageIcon(JaxoVertexT5OptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexT5.png"));
        this.newColor = this.theVertexT5.getColor();
        this.newFillColor = this.theVertexT5.getFillColor();
        this.colorPreview = this.getChooserImage(this.newColor);
        this.colorFillPreview = this.getChooserImage(this.newFillColor);
        this.colorPreviewIcon = new ImageIcon(this.colorPreview);
        this.colorFillPreviewIcon = new ImageIcon(this.colorFillPreview);
        this.nx1 = (int)Math.round(this.theVertexT5.getX1());
        this.ny1 = (int)Math.round(this.theVertexT5.getY1());
        this.nx2 = (int)Math.round(this.theVertexT5.getX2());
        this.ny2 = (int)Math.round(this.theVertexT5.getY2());
        this.nx3 = (int)Math.round(this.theVertexT5.getX3());
        this.ny3 = (int)Math.round(this.theVertexT5.getY3());
        this.newStroke = this.theVertexT5.getStroke();
        JPanel px1 = new JPanel();
        px1.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelX1 = new SpinnerNumberModel(this.nx1, 0, this.d.width, 1);
        JLabel lx1 = new JLabel("X1: ", 4);
        px1.add(lx1);
        JSpinner spx1 = new JSpinner(modelX1);
        px1.add(spx1);
        JPanel px2 = new JPanel();
        px2.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelX2 = new SpinnerNumberModel(this.nx2, 0, this.d.width, 1);
        JLabel lx2 = new JLabel("X2: ", 4);
        px2.add(lx2);
        JSpinner spx2 = new JSpinner(modelX2);
        px2.add(spx2);
        JPanel px3 = new JPanel();
        px3.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelX3 = new SpinnerNumberModel(this.nx3, 0, this.d.width, 1);
        JLabel lx3 = new JLabel("X3: ", 4);
        px3.add(lx3);
        JSpinner spx3 = new JSpinner(modelX3);
        px3.add(spx3);
        JPanel py1 = new JPanel();
        py1.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelY1 = new SpinnerNumberModel(this.ny1, 0, this.d.height, 1);
        JLabel ly1 = new JLabel("Y1: ", 4);
        py1.add(ly1);
        JSpinner spy1 = new JSpinner(modelY1);
        py1.add(spy1);
        JPanel py2 = new JPanel();
        py2.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelY2 = new SpinnerNumberModel(this.ny2, 0, this.d.height, 1);
        JLabel ly2 = new JLabel("Y2: ", 4);
        py2.add(ly2);
        JSpinner spy2 = new JSpinner(modelY2);
        py2.add(spy2);
        JPanel py3 = new JPanel();
        py3.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelY3 = new SpinnerNumberModel(this.ny3, 0, this.d.height, 1);
        JLabel ly3 = new JLabel("Y3: ", 4);
        py3.add(ly3);
        JSpinner spy3 = new JSpinner(modelY3);
        py3.add(spy3);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        px1.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(px1, sc);
        dimSPanel.add((Component)px1, sc);
        sc.gridx = 0;
        sc.gridy = 1;
        sc.insets = new Insets(3, 0, 3, 0);
        py1.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(py1, sc);
        dimSPanel.add((Component)py1, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        px2.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(px2, sc);
        dimSPanel.add((Component)px2, sc);
        sc.gridx = 1;
        sc.gridy = 1;
        sc.insets = new Insets(3, 0, 3, 0);
        py2.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(py2, sc);
        dimSPanel.add((Component)py2, sc);
        sc.gridx = 2;
        sc.gridy = 0;
        px3.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(px3, sc);
        dimSPanel.add((Component)px3, sc);
        sc.gridx = 2;
        sc.gridy = 1;
        sc.insets = new Insets(3, 0, 3, 0);
        py3.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(py3, sc);
        dimSPanel.add((Component)py3, sc);
        JPanel finalDimSPanel = new JPanel();
        finalDimSPanel.setLayout(new BoxLayout(finalDimSPanel, 0));
        TitledBorder dimSTitle = BorderFactory.createTitledBorder("Points coordinates");
        finalDimSPanel.setBorder(dimSTitle);
        finalDimSPanel.add(dimSPanel);
        JPanel pstin = new JPanel();
        GridBagLayout subgb = new GridBagLayout();
        GridBagConstraints subc = new GridBagConstraints();
        pstin.setLayout(subgb);
        SpinnerNumberModel modelstin = new SpinnerNumberModel(this.newStroke, 0.0, 100.0, 0.2);
        JLabel stin = new JLabel(this.language.getString("Line_Width"), 4);
        JSpinner spstin = new JSpinner(modelstin);
        subc.gridx = 0;
        subc.gridy = 0;
        subc.insets = new Insets(0, 5, 5, 5);
        subgb.setConstraints(stin, subc);
        pstin.add((Component)stin, subc);
        subc.gridx = 1;
        subc.gridy = 0;
        spstin.setPreferredSize(new Dimension(50, 20));
        subgb.setConstraints(spstin, subc);
        pstin.add((Component)spstin, subc);
        JPanel strSPanel = new JPanel();
        GridBagLayout gb1 = new GridBagLayout();
        GridBagConstraints sc1 = new GridBagConstraints();
        strSPanel.setLayout(gb1);
        sc1.gridx = 0;
        sc1.gridy = 0;
        gb1.setConstraints(pstin, sc1);
        strSPanel.add((Component)pstin, sc1);
        JPanel finalStrSPanel = new JPanel();
        finalStrSPanel.setLayout(new BoxLayout(finalStrSPanel, 0));
        TitledBorder strSTitle = BorderFactory.createTitledBorder(this.language.getString("Width"));
        finalStrSPanel.setBorder(strSTitle);
        finalStrSPanel.add(strSPanel);
        this.colorbt = new JButton(this.colorPreviewIcon);
        this.colorbt.addActionListener(this);
        this.colorPanel = new JPanel();
        this.colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Line_color"));
        this.colorPanel.add(this.colorbt);
        if (JaxoColor.isGrayScale(this.newFillColor)) {
            this.colorPanelTitle.setTitleColor(JaxoColor.GRAYSCALE165);
            this.colorbt.setEnabled(false);
        }
        this.colorPanel.setBorder(this.colorPanelTitle);
        this.colorFillbt = new JButton(this.colorFillPreviewIcon);
        this.colorFillbt.addActionListener(this);
        this.colorFillPanel = new JPanel();
        this.colorFillPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Fill_color"));
        this.colorFillPanel.setBorder(this.colorFillPanelTitle);
        this.colorFillPanel.add(this.colorFillbt);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 5);
        gridbag.setConstraints(finalDimSPanel, c);
        this.add((Component)finalDimSPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 0, 0, 5);
        gridbag.setConstraints(finalStrSPanel, c);
        this.add((Component)finalStrSPanel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 5, 0);
        this.colorPanel.setPreferredSize(new Dimension(100, 70));
        gridbag.setConstraints(this.colorPanel, c);
        this.add((Component)this.colorPanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 0, 0);
        this.colorFillPanel.setPreferredSize(new Dimension(100, 70));
        gridbag.setConstraints(this.colorFillPanel, c);
        this.add((Component)this.colorFillPanel, c);
        Object[] optionButtonNames = new String[]{this.language.getString("Accept"), this.language.getString("Cancel")};
        int n = JOptionPane.showOptionDialog(this, this, this.sVertex, 2, 1, this.theIcon, optionButtonNames, optionButtonNames[0]);
        if (n == 0) {
            if (this.newColor != null && this.newFillColor != null) {
                if (JaxoColor.isGrayScale(this.newFillColor)) {
                    this.newColor = JaxoColor.BLACK;
                }
                this.theVertexT5.setColor(this.newColor);
                this.theVertexT5.setFillColor(this.newFillColor);
            }
            this.newStroke = Math.abs(modelstin.getNumber().floatValue());
            this.theVertexT5.setStroke(this.newStroke);
            double x1 = modelX1.getNumber().doubleValue();
            double y1 = modelY1.getNumber().doubleValue();
            double x2 = modelX2.getNumber().doubleValue();
            double y2 = modelY2.getNumber().doubleValue();
            double x3 = modelX3.getNumber().doubleValue();
            double y3 = modelY3.getNumber().doubleValue();
            this.theVertexT5.setVertexPts(x1, y1, x2, y2, x3, y3);
            this.changed = true;
        }
    }

    public final boolean hasChanged() {
        return this.changed;
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        JaxoColorChooser colorChooser;
        if (evt.getSource() == this.colorbt) {
            colorChooser = new JaxoColorChooser();
            this.newColor = colorChooser.color(this.newColor, false);
            if (this.newColor != null) {
                this.colorPreviewIcon = new ImageIcon(this.getChooserImage(this.newColor));
                this.colorbt.setIcon(this.colorPreviewIcon);
            }
        }
        if (evt.getSource() == this.colorFillbt) {
            colorChooser = new JaxoColorChooser();
            this.newFillColor = colorChooser.color(this.newFillColor, true);
            if (this.newFillColor != null) {
                this.colorFillPreviewIcon = new ImageIcon(this.getChooserImage(this.newFillColor));
                this.colorFillbt.setIcon(this.colorFillPreviewIcon);
                this.colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Line_color"));
                this.colorbt.setEnabled(true);
                if (JaxoColor.isGrayScale(this.newFillColor)) {
                    this.colorPanelTitle.setTitleColor(JaxoColor.GRAYSCALE165);
                    this.colorbt.setEnabled(false);
                }
                this.colorPanel.setBorder(this.colorPanelTitle);
            }
        }
    }

    private Image getChooserImage(Color iconColor) {
        int width = 40;
        int height = 15;
        int size = width * height;
        int[] pixels = new int[size];
        for (int i = 0; i < size; ++i) {
            pixels[i] = iconColor.getRGB();
        }
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image jaxColorBox = this.createImage(source);
        return jaxColorBox;
    }
}

