/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.Plot;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ResourceBundle;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JOptionPane;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaxoPrint
implements Printable {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaxoGraph graph;
    private double transX;
    private double transY;
    private double scale = 1.0;
    private Dimension canvasD;
    private String currentTab = "";

    @Override
    public final int print(Graphics g, PageFormat pf, int pageIndex) {
        this.transX = pf.getImageableX();
        this.transY = pf.getImageableY();
        double scaleX = pf.getImageableWidth() / (double)this.canvasD.width;
        double scaleY = pf.getImageableHeight() / (double)this.canvasD.height;
        if (pageIndex == 0) {
            JaObject ob;
            int i;
            VectorGraphics g2 = VectorGraphics.create((Graphics)g);
            this.scale = scaleX;
            if (scaleY < scaleX) {
                this.scale = scaleY;
            }
            if (this.scale > 1.0) {
                this.scale = 1.0;
            }
            g2.translate(this.transX, this.transY);
            g2.scale(this.scale, this.scale);
            int length = this.graph.listSize();
            for (i = 0; i < length; ++i) {
                ob = this.graph.listElementAt(i);
                if (!Plot.drawFirst(ob)) continue;
                ob.jaxoDraw(g2, false);
            }
            for (i = 0; i < length; ++i) {
                ob = this.graph.listElementAt(i);
                Plot.drawRest(ob, g2, false);
            }
            return 0;
        }
        return 1;
    }

    public final void print(JaxoGraph newGraph, Dimension d) {
        this.graph = newGraph;
        this.canvasD = d;
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(OrientationRequested.LANDSCAPE);
        aset.add(new Copies(1));
        aset.add(new JobName(this.currentTab, null));
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        PrintService[] services = PrinterJob.lookupPrintServices();
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        if (services.length > 0) {
            try {
                pj.setPrintService(services[0]);
                if (pj.printDialog(aset)) {
                    pj.print(aset);
                }
            }
            catch (PrinterException pe) {
                if (JaxoPrefs.verbose()) {
                    System.err.println(pe);
                }
                JOptionPane.showMessageDialog(null, this.language.getString("PrinterException:_Cannot_print_document!"));
            }
        } else if (defaultService != null) {
            try {
                pj.setPrintService(defaultService);
                if (pj.printDialog(aset)) {
                    pj.print(aset);
                }
            }
            catch (PrinterException pe) {
                if (JaxoPrefs.verbose()) {
                    System.err.println(pe);
                }
                JOptionPane.showMessageDialog(null, this.language.getString("PrinterException:_Cannot_print_document!"));
            }
        } else {
            JOptionPane.showMessageDialog(null, this.language.getString("No_printers_found!"));
        }
    }

    public final void setCurrentTab(String newTab) {
        this.currentTab = newTab;
    }
}

