/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.Plot;
import japlot.jaxodraw.JaxoCanvas;
import japlot.jaxodraw.JaxoExportLatex;
import japlot.jaxodraw.JaxoExportLatexPS;
import japlot.jaxodraw.JaxoExportPS;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaxoPreview {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaxoGraph graph;
    private JFrame frame;
    private String userDIR = System.getProperty("user.dir");

    public final void previewPS(JaxoGraph newGraph, Dimension d, int mode) {
        block6: {
            this.graph = newGraph;
            this.checkforLatexText();
            String previewFileName = "Jaxo_tmp.ps";
            String prefPSVIEWER = JaxoPrefs.getStringPref(2);
            if (prefPSVIEWER.length() == 0) {
                JOptionPane.showMessageDialog(null, this.language.getString("Please_choose_a_Postscript_viewer_\n") + this.language.getString("from_the_Preferences_dialog!"));
            } else {
                String command = prefPSVIEWER + " " + this.userDIR + File.separator + previewFileName;
                File previewFile = new File(previewFileName);
                new FilePermission(previewFileName, "read, write, delete");
                previewFile.deleteOnExit();
                JaxoExportPS p = new JaxoExportPS();
                p.exportPS(this.graph, d, previewFileName, mode);
                try {
                    Runtime.getRuntime().exec(command);
                }
                catch (IOException anIOException) {
                    JOptionPane.showMessageDialog(null, this.language.getString("IOException:_Cannot_find_ps_viewer!"));
                    if (JaxoPrefs.verbose()) {
                        System.err.println(anIOException);
                    }
                }
                catch (SecurityException aSecurityException) {
                    JOptionPane.showMessageDialog(null, this.language.getString("SecurityException:_Cannot_run_external_command!"));
                    if (!JaxoPrefs.verbose()) break block6;
                    System.err.println(aSecurityException);
                }
            }
        }
    }

    public final void previewEPS(JaxoGraph newGraph, Dimension d) {
        block6: {
            this.graph = newGraph;
            this.checkforLatexText();
            String previewFileName = "Jaxo_tmp.eps";
            String prefPSVIEWER = JaxoPrefs.getStringPref(2);
            if (prefPSVIEWER.length() == 0) {
                JOptionPane.showMessageDialog(null, this.language.getString("Please_choose_a_Postscript_viewer_\n") + this.language.getString("from_the_Preferences_dialog!"));
            } else {
                String command = prefPSVIEWER + " " + this.userDIR + File.separator + previewFileName;
                File previewFile = new File(previewFileName);
                new FilePermission(previewFileName, "read, write, delete");
                previewFile.deleteOnExit();
                JaxoExportPS eps = new JaxoExportPS();
                eps.setCanvasD(d);
                eps.exportEPS(this.graph, previewFileName);
                try {
                    Runtime.getRuntime().exec(command);
                }
                catch (IOException anIOException) {
                    JOptionPane.showMessageDialog(null, this.language.getString("IOException:_Cannot_find_ps_viewer!"));
                    if (JaxoPrefs.verbose()) {
                        System.err.println(anIOException);
                    }
                }
                catch (SecurityException aSecurityException) {
                    JOptionPane.showMessageDialog(null, this.language.getString("SecurityException:_Cannot_run_external_command!"));
                    if (!JaxoPrefs.verbose()) break block6;
                    System.err.println(aSecurityException);
                }
            }
        }
    }

    public final void previewLatex(JaxoGraph newGraph) {
        block9: {
            this.graph = newGraph;
            this.checkforPSText();
            String fs = File.separator;
            String previewFileName = "Jaxo_tmp.tex";
            File previewFile = new File(previewFileName);
            new FilePermission(previewFileName, "read, write, delete");
            previewFile.deleteOnExit();
            JaxoExportLatex lat = new JaxoExportLatex();
            lat.exportLatex(this.graph, previewFileName);
            String prefEDITOR = JaxoPrefs.getStringPref(1);
            if (prefEDITOR.length() == 0) {
                JOptionPane.showMessageDialog(null, this.language.getString("You_may_choose_a_custom_text_editor_\n") + this.language.getString("from_the_Preferences_dialog!"));
                String url = "file:" + this.userDIR + fs + previewFileName;
                JEditorPane editorPane = new JEditorPane();
                editorPane.setEditable(false);
                editorPane.setContentType("text/plain");
                try {
                    editorPane.setPage(url);
                }
                catch (Exception e) {
                    if (JaxoPrefs.verbose()) {
                        System.err.println(e);
                    }
                    JOptionPane.showMessageDialog(null, this.language.getString("Could_not_open:_") + url + "!");
                }
                JScrollPane scroller = new JScrollPane(editorPane);
                scroller.setVerticalScrollBarPolicy(20);
                scroller.setPreferredSize(new Dimension(250, 145));
                scroller.setMinimumSize(new Dimension(10, 10));
                scroller.setBorder(BorderFactory.createEtchedBorder());
                scroller.setVisible(true);
                JButton closeButton = new JButton(this.language.getString("Close"));
                closeButton.setBorder(BorderFactory.createRaisedBevelBorder());
                closeButton.addMouseListener(new JaxoCloseMouseAdapter());
                JPanel buttonPanel = new JPanel();
                buttonPanel.add((Component)closeButton, "Center");
                this.frame = new JFrame();
                this.frame.getContentPane().add((Component)scroller, "Center");
                this.frame.getContentPane().add((Component)buttonPanel, "South");
                this.frame.setDefaultCloseOperation(2);
                this.frame.setSize(700, 600);
                this.frame.setTitle(this.language.getString("Latex_Preview"));
                this.frame.setLocationRelativeTo(null);
                this.frame.setVisible(true);
            } else {
                String command = prefEDITOR + " " + this.userDIR + File.separator + previewFileName;
                try {
                    Runtime.getRuntime().exec(command);
                }
                catch (IOException anIOException) {
                    JOptionPane.showMessageDialog(null, this.language.getString("IOException:_Cannot_find_text_editor!"));
                    if (JaxoPrefs.verbose()) {
                        System.err.println(anIOException);
                    }
                }
                catch (SecurityException aSecurityException) {
                    JOptionPane.showMessageDialog(null, this.language.getString("SecurityException:_Cannot_run_external_command!"));
                    if (!JaxoPrefs.verbose()) break block9;
                    System.err.println(aSecurityException);
                }
            }
        }
    }

    public final void previewLatexPS(JaxoGraph newGraph, Dimension d, boolean wMode) {
        this.graph = newGraph;
        this.checkforPSText();
        String previewFileName = "Jaxo_tmp.eps";
        String prefPSVIEWER = JaxoPrefs.getStringPref(2);
        if (prefPSVIEWER.length() == 0) {
            JOptionPane.showMessageDialog(null, this.language.getString("Please_choose_a_Postscript_viewer_\n") + this.language.getString("from_the_Preferences_dialog!"));
        } else {
            this.previewLatexPS(prefPSVIEWER, previewFileName, wMode);
        }
    }

    private void previewLatexPS(String prefPSVIEWER, String previewFileName, boolean wMode) {
        block5: {
            boolean newWindow;
            String command = prefPSVIEWER + " " + this.userDIR + File.separator + previewFileName;
            File previewFile = new File(previewFileName);
            boolean previewFileExists = previewFile.exists();
            new FilePermission(previewFileName, "read, write, delete");
            previewFile.deleteOnExit();
            JaxoExportLatexPS eps = new JaxoExportLatexPS();
            int status = eps.exportLatexPS(this.graph, previewFileName);
            boolean bl = newWindow = !wMode || wMode && !previewFileExists;
            if (status == 0 && newWindow) {
                try {
                    Runtime.getRuntime().exec(command);
                }
                catch (IOException anIOException) {
                    JOptionPane.showMessageDialog(null, this.language.getString("IOException:_Cannot_find_ps_viewer!"));
                    if (JaxoPrefs.verbose()) {
                        System.err.println(anIOException);
                    }
                }
                catch (SecurityException aSecurityException) {
                    JOptionPane.showMessageDialog(null, this.language.getString("SecurityException:_Cannot_run_external_command!"));
                    if (!JaxoPrefs.verbose()) break block5;
                    System.err.println(aSecurityException);
                }
            }
        }
    }

    public final void previewIMG(JaxoGraph previewGraph, Dimension d) {
        this.graph = previewGraph;
        this.checkforLatexText();
        Image image = (Image)((Object)this.createImage(d));
        this.frame = new JFrame();
        JLabel label = new JLabel(new ImageIcon(image));
        this.frame.getContentPane().add((Component)label, "Center");
        this.frame.setDefaultCloseOperation(2);
        this.frame.setTitle(this.language.getString("Image_Preview"));
        this.frame.setLocationRelativeTo(null);
        this.frame.addKeyListener(new JaxoCloseKeyAdapter());
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private RenderedImage createImage(Dimension d) {
        JaObject ob;
        int i;
        int width = d.width;
        int height = d.height;
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        VectorGraphics g2d = (VectorGraphics)bufferedImage.createGraphics();
        g2d.setColor(JaxoCanvas.BCKG_COLOR);
        g2d.fillRect(0, 0, width, height);
        int length = this.graph.listSize();
        for (i = 0; i < length; ++i) {
            ob = this.graph.listElementAt(i);
            if (!Plot.drawFirst(ob)) continue;
            ob.jaxoDraw(g2d, false);
        }
        for (i = 0; i < length; ++i) {
            ob = this.graph.listElementAt(i);
            Plot.drawRest(ob, g2d, false);
        }
        g2d.dispose();
        double[] bb = this.graph.getBoundingBox();
        int x = (int)Math.round(bb[0]);
        int y = (int)Math.round(bb[1]);
        int w = (int)Math.round(bb[2] - bb[0]) + 1;
        int h = (int)Math.round(bb[3] - bb[1]) + 1;
        return bufferedImage.getSubimage(x, y, w, h);
    }

    private void checkforLatexText() {
        if (this.graph.containsLatexText()) {
            Object[] message = new Object[]{this.language.getString("There_are_LaTeX_text_objects_in_this_graph."), this.language.getString("They_will_not_be_exported_to_this_format!")};
            JOptionPane.showMessageDialog(null, message, this.language.getString("Warning"), 2);
        }
    }

    private void checkforPSText() {
        if (this.graph.containsPSText()) {
            Object[] message = new Object[]{this.language.getString("There_are_Postscript_text_objects_in_this_graph."), this.language.getString("They_will_not_be_exported_to_LaTeX!")};
            JOptionPane.showMessageDialog(null, message, this.language.getString("Warning"), 2);
        }
    }

    class JaxoCloseMouseAdapter
    extends MouseAdapter {
        JaxoCloseMouseAdapter() {
        }

        @Override
        public final void mouseClicked(MouseEvent evt) {
            JaxoPreview.this.frame.dispose();
        }
    }

    class JaxoCloseKeyAdapter
    extends KeyAdapter {
        JaxoCloseKeyAdapter() {
        }

        @Override
        public final void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                JaxoPreview.this.frame.dispose();
            }
        }
    }
}

