/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JaxoParticleButtons
extends JPanel
implements ActionListener {
    private static final String[] PARTICLE_BUTTON_ICONS = new String[]{"japlot/jaxodraw/icons/fline.gif", "japlot/jaxodraw/icons/floop.gif", "japlot/jaxodraw/icons/farc.gif", "japlot/jaxodraw/icons/sline.gif", "japlot/jaxodraw/icons/sloop.gif", "japlot/jaxodraw/icons/sarc.gif", "japlot/jaxodraw/icons/gline.gif", "japlot/jaxodraw/icons/gloop.gif", "japlot/jaxodraw/icons/garc.gif", "japlot/jaxodraw/icons/photon.gif", "japlot/jaxodraw/icons/photonloop.gif", "japlot/jaxodraw/icons/photonarc.gif", "japlot/jaxodraw/icons/gluon.gif", "japlot/jaxodraw/icons/gluonloop.gif", "japlot/jaxodraw/icons/gluonarc.gif"};
    private static final int[] PARTICLE_MODES = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    private JaxoMainPanel thePanel;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private int pnbts = 15;
    private JButton[] particleButtons = new JButton[this.pnbts];
    private String[] particleFlagModes = new String[]{this.language.getString("Fermion_Line"), this.language.getString("Fermion_Loop"), this.language.getString("Fermion_Arc"), this.language.getString("Scalar_Line"), this.language.getString("Scalar_Loop"), this.language.getString("Scalar_Arc"), this.language.getString("Ghost_Line"), this.language.getString("Ghost_Loop"), this.language.getString("Ghost_Arc"), this.language.getString("Photon_Line"), this.language.getString("Photon_Loop"), this.language.getString("Photon_Arc"), this.language.getString("Gluon_Line"), this.language.getString("Gluon_Loop"), this.language.getString("Gluon_Arc")};
    private String[] particleTips = new String[]{this.language.getString("Draw_a_fermion_line"), this.language.getString("Draw_a_fermion_loop"), this.language.getString("Draw_a_fermion_arc"), this.language.getString("Draw_a_scalar_line"), this.language.getString("Draw_a_scalar_loop"), this.language.getString("Draw_a_scalar_arc"), this.language.getString("Draw_a_ghost_line"), this.language.getString("Draw_a_ghost_loop"), this.language.getString("Draw_a_ghost_arc"), this.language.getString("Draw_a_photon_line"), this.language.getString("Draw_a_photon_loop"), this.language.getString("Draw_a_photon_arc"), this.language.getString("Draw_a_gluon_line"), this.language.getString("Draw_a_gluon_loop"), this.language.getString("Draw_a_gluon_arc")};
    private Border raisedetched = BorderFactory.createEtchedBorder(0);
    private Border raisedbevel = BorderFactory.createRaisedBevelBorder();
    private Border loweredbevel = BorderFactory.createLoweredBevelBorder();

    public JaxoParticleButtons(JaxoMainPanel mainPanel) {
        this.thePanel = mainPanel;
        JPanel particleButtonPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        particleButtonPanel.setLayout(gridbag);
        for (int i = 0; i < this.pnbts; ++i) {
            this.particleButtons[i] = new JButton();
            this.particleButtons[i].setIcon(new ImageIcon(JaxoParticleButtons.class.getClassLoader().getResource(PARTICLE_BUTTON_ICONS[i])));
            this.particleButtons[i].setToolTipText(this.particleTips[i]);
            this.particleButtons[i].addActionListener(this);
            this.particleButtons[i].setMinimumSize(new Dimension(40, 40));
            this.particleButtons[i].setPreferredSize(new Dimension(40, 40));
            this.particleButtons[i].setBorder(this.raisedbevel);
            this.particleButtons[i].setFocusPainted(false);
        }
        for (int j = 0; j < 5; ++j) {
            for (int i = 0; i < 3; ++i) {
                c.gridx = i;
                c.gridy = j;
                gridbag.setConstraints(this.particleButtons[i + 3 * j], c);
                particleButtonPanel.add(this.particleButtons[i + 3 * j]);
            }
        }
        JPanel finalParticleButtonPanel = new JPanel();
        finalParticleButtonPanel.setLayout(new BorderLayout());
        finalParticleButtonPanel.setBorder(this.raisedetched);
        finalParticleButtonPanel.add((Component)particleButtonPanel, "Center");
        this.setLayout(new GridLayout(0, 1));
        this.add(finalParticleButtonPanel);
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.pnbts; ++i) {
            if (evt.getSource() != this.particleButtons[i]) continue;
            this.thePanel.particleEvent(PARTICLE_MODES[i]);
            this.thePanel.getCanvas().resetNOfClicks();
        }
    }

    public final void reset() {
        for (int i = 0; i < this.pnbts; ++i) {
            this.setButtonBorder(i, this.raisedbevel);
            this.setButtonBackground(i, null);
            this.particleButtons[i].setFocusPainted(false);
        }
    }

    public final int getIndex(int i) {
        int j = this.pnbts + 1;
        for (int jj = 0; jj < this.pnbts; ++jj) {
            if (i != PARTICLE_MODES[jj]) continue;
            j = jj;
        }
        return j;
    }

    public final void pressButton(int j) {
        this.setButtonBackground(j, new Color(170, 170, 180));
        this.setButtonBorder(j, this.loweredbevel);
        this.particleButtons[j].setFocusPainted(false);
        this.particleButtons[j].setSelected(true);
    }

    public final String getParticleFlagModes(int i) {
        return this.particleFlagModes[i];
    }

    public final int getpnbts() {
        return this.pnbts;
    }

    public final void setButtonBackground(int i, Color bgColor) {
        this.particleButtons[i].setBackground(bgColor);
    }

    public final void setButtonBorder(int i, Border border) {
        this.particleButtons[i].setBorder(border);
    }

    public final void clickButton(int i) {
        this.particleButtons[i].doClick();
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        this.particleFlagModes[0] = this.language.getString("Fermion_Line");
        this.particleFlagModes[1] = this.language.getString("Fermion_Loop");
        this.particleFlagModes[2] = this.language.getString("Fermion_Arc");
        this.particleFlagModes[3] = this.language.getString("Scalar_Line");
        this.particleFlagModes[4] = this.language.getString("Scalar_Loop");
        this.particleFlagModes[5] = this.language.getString("Scalar_Arc");
        this.particleFlagModes[6] = this.language.getString("Ghost_Line");
        this.particleFlagModes[7] = this.language.getString("Ghost_Loop");
        this.particleFlagModes[8] = this.language.getString("Ghost_Arc");
        this.particleFlagModes[9] = this.language.getString("Photon_Line");
        this.particleFlagModes[10] = this.language.getString("Photon_Loop");
        this.particleFlagModes[11] = this.language.getString("Photon_Arc");
        this.particleFlagModes[12] = this.language.getString("Gluon_Line");
        this.particleFlagModes[13] = this.language.getString("Gluon_Loop");
        this.particleFlagModes[14] = this.language.getString("Gluon_Arc");
        this.particleTips[0] = this.language.getString("Draw_a_fermion_line");
        this.particleTips[1] = this.language.getString("Draw_a_fermion_loop");
        this.particleTips[2] = this.language.getString("Draw_a_fermion_arc");
        this.particleTips[3] = this.language.getString("Draw_a_scalar_line");
        this.particleTips[4] = this.language.getString("Draw_a_scalar_loop");
        this.particleTips[5] = this.language.getString("Draw_a_scalar_arc");
        this.particleTips[6] = this.language.getString("Draw_a_ghost_line");
        this.particleTips[7] = this.language.getString("Draw_a_ghost_loop");
        this.particleTips[8] = this.language.getString("Draw_a_ghost_arc");
        this.particleTips[9] = this.language.getString("Draw_a_photon_line");
        this.particleTips[10] = this.language.getString("Draw_a_photon_loop");
        this.particleTips[11] = this.language.getString("Draw_a_photon_arc");
        this.particleTips[12] = this.language.getString("Draw_a_gluon_line");
        this.particleTips[13] = this.language.getString("Draw_a_gluon_loop");
        this.particleTips[14] = this.language.getString("Draw_a_gluon_arc");
        for (int i = 0; i < this.pnbts; ++i) {
            this.particleButtons[i].setToolTipText(this.particleTips[i]);
        }
    }
}

