/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColorChooser;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jhplot.jadraw.JaText;

public class JaxoPSTextOptionsPanel
extends JPanel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    private JaText thePSText;
    private String sText;
    private Icon theIcon;
    private ImageIcon colorPreviewIcon;
    private JLabel textStringLabels = new JLabel();
    private JTextField textStringFields = new JTextField();
    private JPanel textStringNamesPanel;
    private JPanel textStringFieldsPanel;
    private JPanel textFinalStringPanel;
    private TitledBorder textStringTitle;
    private JPanel textFinalFontPanel;
    private TitledBorder textFontTitle;
    private JPanel textFamilyPanel;
    private JPanel textSizePanel;
    private JPanel textStylePanel;
    private JButton colorbt;
    private JPanel colorPanel;
    private TitledBorder colorPanelTitle;
    private JComboBox famcomb;
    private JComboBox sizecomb;
    private JComboBox stycomb;
    private Color newColor;
    private Image colorPreview;
    private int newX;
    private int newY;
    private int newRot;
    private String newTextString;
    private boolean changed = false;
    private JLabel textFamilyLabel;
    private JLabel textSizeLabel;
    private JLabel textStyleLabel;
    private String[] envFonts;
    private String fontChoice;
    private String sizeChoice;
    private String family;
    private Integer sizeCInt;
    private int sizeChoiceInt;
    private int styleC;
    private int styleChoice;
    private Font newFont;

    public JaxoPSTextOptionsPanel(JaText psText, String[] fonts) {
        this.thePSText = psText;
        this.envFonts = fonts;
        this.sText = this.language.getString("Text_parameters");
        this.theIcon = new ImageIcon(JaxoPSTextOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/font_truetype.png"));
        this.newTextString = this.thePSText.getText();
        this.newX = this.thePSText.getX();
        this.newY = this.thePSText.getY();
        this.newColor = this.thePSText.getColor();
        this.newRot = -this.thePSText.getRotAngle();
        this.newFont = this.thePSText.getFont();
        this.family = this.newFont.getFamily();
        this.sizeCInt = new Integer(this.newFont.getSize());
        this.styleC = this.newFont.getStyle();
        this.colorPreview = this.getChooserImage(this.newColor);
        this.colorPreviewIcon = new ImageIcon(this.colorPreview);
        this.textStringNamesPanel = new JPanel();
        this.textStringNamesPanel.setLayout(new GridLayout(0, 2));
        this.textStringFieldsPanel = new JPanel();
        this.textStringFieldsPanel.setLayout(new GridLayout(1, 0));
        String textStringPar = this.newTextString;
        this.textStringLabels = new JLabel(this.language.getString("Text_string") + ": ", 4);
        this.textStringNamesPanel.add(this.textStringLabels);
        this.textStringFields = new JTextField(textStringPar);
        this.textStringNamesPanel.add(this.textStringFields);
        this.textFinalStringPanel = new JPanel();
        this.textFinalStringPanel.setLayout(new BorderLayout());
        this.textStringTitle = BorderFactory.createTitledBorder(this.language.getString("Text"));
        this.textFinalStringPanel.setBorder(this.textStringTitle);
        this.textFinalStringPanel.add((Component)this.textStringNamesPanel, "North");
        this.textFinalStringPanel.add((Component)this.textStringFieldsPanel, "South");
        this.textFamilyPanel = new JPanel();
        this.textFamilyLabel = new JLabel();
        this.textFamilyLabel.setText(this.language.getString("Font"));
        this.textFamilyLabel.setHorizontalAlignment(0);
        this.textSizePanel = new JPanel();
        this.textSizeLabel = new JLabel();
        this.textSizeLabel.setText(this.language.getString("Size"));
        this.textSizeLabel.setHorizontalAlignment(0);
        this.textStylePanel = new JPanel();
        this.textStyleLabel = new JLabel();
        this.textStyleLabel.setText(this.language.getString("Style"));
        this.textStyleLabel.setHorizontalAlignment(0);
        this.famcomb = new JComboBox<String>(this.envFonts);
        this.famcomb.addItemListener(this);
        this.famcomb.setSelectedIndex(this.getFamilyIndex(this.family));
        this.textFamilyPanel.add(this.famcomb);
        String[] sizes = new String[]{"4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "32", "34", "36", "38", "40", "42", "44", "46", "48", "50", "52", "54", "56", "58", "60", "62", "64"};
        this.sizecomb = new JComboBox<String>(sizes);
        this.sizecomb.addItemListener(this);
        this.sizecomb.setSize(new Dimension(80, 24));
        this.sizecomb.setSelectedIndex(JaxoPSTextOptionsPanel.getSizeIndex(this.sizeCInt.toString()));
        this.textSizePanel.add(this.sizecomb);
        String[] styles = new String[]{"Plain", "Bold", "Italic", "B&Italic"};
        this.stycomb = new JComboBox<String>(styles);
        this.stycomb.addItemListener(this);
        this.stycomb.setSelectedIndex(this.styleC);
        this.textStylePanel.add(this.stycomb);
        this.textFinalFontPanel = new JPanel();
        this.textFinalFontPanel.setLayout(new BorderLayout());
        this.textFontTitle = BorderFactory.createTitledBorder(this.language.getString("Font_properties"));
        this.textFinalFontPanel.setBorder(this.textFontTitle);
        this.textFinalFontPanel.add("West", this.textFamilyPanel);
        this.textFinalFontPanel.add("Center", this.textSizePanel);
        this.textFinalFontPanel.add("East", this.textStylePanel);
        JPanel pxin = new JPanel();
        pxin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelXin = new SpinnerNumberModel(this.newX, 0, this.d.width, 1);
        JLabel xin = new JLabel("X: ", 4);
        pxin.add(xin);
        JSpinner spxin = new JSpinner(modelXin);
        pxin.add(spxin);
        JPanel pyin = new JPanel();
        pyin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelYin = new SpinnerNumberModel(this.newY, 0, this.d.height, 1);
        JLabel yin = new JLabel("Y: ", 4);
        pyin.add(yin);
        JSpinner spyin = new JSpinner(modelYin);
        pyin.add(spyin);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 5, 0);
        pxin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pxin, sc);
        dimSPanel.add((Component)pxin, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 5, 5);
        pyin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pyin, sc);
        dimSPanel.add((Component)pyin, sc);
        JPanel finalDimSPanel = new JPanel();
        finalDimSPanel.setLayout(new BoxLayout(finalDimSPanel, 0));
        TitledBorder dimSTitle = BorderFactory.createTitledBorder(this.language.getString("Position"));
        finalDimSPanel.setBorder(dimSTitle);
        finalDimSPanel.add(dimSPanel);
        JPanel protin = new JPanel();
        GridBagLayout subgb1 = new GridBagLayout();
        GridBagConstraints subc1 = new GridBagConstraints();
        protin.setLayout(subgb1);
        SpinnerNumberModel modelrotin = new SpinnerNumberModel(this.newRot, -360, 360, 1);
        JLabel rotin = new JLabel(this.language.getString("Rot._Angle") + ": ", 4);
        JSpinner sprotin = new JSpinner(modelrotin);
        subc1.gridx = 0;
        subc1.gridy = 0;
        subc1.insets = new Insets(0, 5, 5, 5);
        subgb1.setConstraints(rotin, subc1);
        protin.add((Component)rotin, subc1);
        subc1.gridx = 1;
        subc1.gridy = 0;
        sprotin.setPreferredSize(new Dimension(50, 20));
        subgb1.setConstraints(sprotin, subc1);
        protin.add((Component)sprotin, subc1);
        JPanel rotrSPanel = new JPanel();
        GridBagLayout gb2 = new GridBagLayout();
        GridBagConstraints sc2 = new GridBagConstraints();
        rotrSPanel.setLayout(gb2);
        sc2.gridx = 0;
        sc2.gridy = 0;
        gb2.setConstraints(protin, sc2);
        rotrSPanel.add((Component)protin, sc2);
        JPanel finalRotrSPanel = new JPanel();
        finalRotrSPanel.setLayout(new BoxLayout(finalRotrSPanel, 0));
        TitledBorder rotrSTitle = BorderFactory.createTitledBorder(this.language.getString("Rotate"));
        finalRotrSPanel.setBorder(rotrSTitle);
        finalRotrSPanel.add(rotrSPanel);
        this.colorbt = new JButton(this.colorPreviewIcon);
        this.colorbt.addActionListener(this);
        this.colorPanel = new JPanel();
        this.colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Text_color"));
        this.colorPanel.setBorder(this.colorPanelTitle);
        this.colorPanel.add(this.colorbt);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 5);
        gridbag.setConstraints(finalDimSPanel, c);
        this.add((Component)finalDimSPanel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 5, 5);
        this.colorPanel.setPreferredSize(new Dimension(100, 70));
        gridbag.setConstraints(this.colorPanel, c);
        this.add((Component)this.colorPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        gridbag.setConstraints(finalRotrSPanel, c);
        this.add((Component)finalRotrSPanel, c);
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(5, 0, 0, 5);
        this.textFinalFontPanel.setPreferredSize(new Dimension(350, 60));
        gridbag.setConstraints(this.textFinalFontPanel, c);
        this.add((Component)this.textFinalFontPanel, c);
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 3;
        c.insets = new Insets(5, 0, 0, 5);
        this.textFinalStringPanel.setPreferredSize(new Dimension(260, 50));
        gridbag.setConstraints(this.textFinalStringPanel, c);
        this.add((Component)this.textFinalStringPanel, c);
        Object[] optionButtonNames = new String[]{this.language.getString("Accept"), this.language.getString("Cancel")};
        int n = JOptionPane.showOptionDialog(this, this, this.sText, 2, 1, this.theIcon, optionButtonNames, optionButtonNames[0]);
        if (n == 0) {
            if (this.newColor != null) {
                this.thePSText.setColor(this.newColor);
            }
            this.newTextString = this.textStringFields.getText();
            this.thePSText.setText(this.newTextString);
            this.newX = modelXin.getNumber().intValue();
            this.newY = modelYin.getNumber().intValue();
            this.thePSText.setX(this.newX);
            this.thePSText.setY(this.newY);
            this.newRot = modelrotin.getNumber().intValue();
            this.thePSText.setRotAngle(-this.newRot);
            this.newFont = new Font(this.fontChoice, this.styleChoice, this.sizeChoiceInt);
            this.thePSText.setFont(this.newFont);
            this.changed = true;
        }
    }

    public final boolean hasChanged() {
        return this.changed;
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.colorbt) {
            JaxoColorChooser colorChooser = new JaxoColorChooser();
            this.newColor = colorChooser.color(this.newColor, true);
            if (this.newColor != null) {
                this.colorPreviewIcon = new ImageIcon(this.getChooserImage(this.newColor));
                this.colorbt.setIcon(this.colorPreviewIcon);
            }
        }
    }

    @Override
    public final void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        Object list = e.getSource();
        if (list == this.famcomb) {
            this.fontChoice = (String)this.famcomb.getSelectedItem();
        } else if (list == this.stycomb) {
            this.styleChoice = this.stycomb.getSelectedIndex();
        } else {
            this.sizeChoice = (String)this.sizecomb.getSelectedItem();
            Integer newSize = new Integer(this.sizeChoice);
            this.sizeChoiceInt = newSize;
        }
    }

    private Image getChooserImage(Color iconColor) {
        int width = 40;
        int height = 15;
        int size = width * height;
        int[] pixels = new int[size];
        for (int i = 0; i < size; ++i) {
            pixels[i] = iconColor.getRGB();
        }
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image jaxColorBox = this.createImage(source);
        return jaxColorBox;
    }

    private static int getSizeIndex(String s) {
        String[] sizes = new String[]{"4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "32", "34", "36", "38", "40", "42", "44", "46", "48", "50", "52", "54", "56", "58", "60", "62", "64"};
        int i = 0;
        while (sizes[i].compareTo(s) != 0) {
            ++i;
        }
        if (sizes[i].compareTo(s) == 0) {
            return i;
        }
        return -1;
    }

    private int getFamilyIndex(String s) {
        int i = this.envFonts.length;
        for (int j = 0; j < i; ++j) {
            if (this.envFonts[j].compareTo(s) != 0) continue;
            i = j;
            break;
        }
        if (i < this.envFonts.length) {
            return i;
        }
        return 0;
    }
}

