/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColorChooser;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jhplot.jadraw.JaFLoop;
import jhplot.jadraw.JaGLoop;
import jhplot.jadraw.JaGlLoop;
import jhplot.jadraw.JaLoopObject;
import jhplot.jadraw.JaPLoop;
import jhplot.jadraw.JaSLoop;

public class JaxoLoopOptionsPanel
extends JPanel
implements ItemListener,
ActionListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    private SpinnerNumberModel modelampin;
    private SpinnerNumberModel modelwigin;
    private JaLoopObject theLoop;
    private String theParticle;
    private Icon theIcon;
    private ImageIcon colorPreviewIcon;
    private JButton colorbt;
    private JPanel colorPanel;
    private TitledBorder colorPanelTitle;
    private JCheckBox arrowcb;
    private JCheckBox flipcb;
    private JPanel loopArrowPanel;
    private TitledBorder loopArrowTitle;
    private Color newColor;
    private Image colorPreview;
    private boolean newFlip;
    private boolean newArrow;
    private int newWidth;
    private int newHeight;
    private int newRelWidth;
    private int newRelHeight;
    private int newXin;
    private int newYin;
    private int newAmp;
    private float newFreq;
    private int newWiggles;
    private float newStroke;
    private float newDash;
    private double newLength;
    private double realNewLength;
    private boolean changed = false;
    private boolean newDLine;
    private float newDLSep;
    private JCheckBox dlcb;
    private JLabel stsep;
    private JSpinner spsep;

    public JaxoLoopOptionsPanel(JaLoopObject loop) {
        this.theLoop = loop;
        this.newColor = this.theLoop.getColor();
        this.colorPreview = this.getChooserImage(this.newColor);
        this.colorPreviewIcon = new ImageIcon(this.colorPreview);
        this.newArrow = this.theLoop.getArrow();
        this.newFlip = this.theLoop.getFlip();
        this.newWidth = this.theLoop.getSize().width;
        this.newHeight = this.theLoop.getSize().height;
        this.newRelWidth = this.theLoop.getRelSize().width;
        this.newRelHeight = this.theLoop.getRelSize().height;
        this.getCenter(this.theLoop.getX(), this.theLoop.getY(), this.newRelWidth, this.newRelHeight);
        this.newAmp = this.theLoop.getAmp();
        this.newStroke = this.theLoop.getStroke();
        this.newDash = this.theLoop.getDash();
        this.newLength = Math.sqrt(this.newWidth * this.newWidth + this.newHeight * this.newHeight);
        this.newFreq = this.theLoop.getFreq();
        this.newDLine = this.theLoop.getDoubleLine();
        this.newDLSep = this.theLoop.getDLSeparation();
        if ((double)this.newDLSep < 0.5) {
            this.newDLSep = JaxoPrefs.getFloatPref(201);
        }
        if (this.theLoop instanceof JaFLoop) {
            this.theParticle = this.language.getString("Fermion_loop_parameters");
            this.theIcon = new ImageIcon(JaxoLoopOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/floop.gif"));
        } else if (this.theLoop instanceof JaSLoop) {
            this.theParticle = this.language.getString("Scalar_loop_parameters");
            this.theIcon = new ImageIcon(JaxoLoopOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/sloop.gif"));
        } else if (this.theLoop instanceof JaGLoop) {
            this.theParticle = this.language.getString("Ghost_loop_parameters");
            this.theIcon = new ImageIcon(JaxoLoopOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/gloop.gif"));
        } else if (this.theLoop instanceof JaPLoop) {
            this.theParticle = this.language.getString("Photon_loop_parameters");
            this.theIcon = new ImageIcon(JaxoLoopOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/photonloop.gif"));
            this.newWiggles = (int)(this.newLength * 2.0 * Math.PI / (double)this.newFreq);
        } else if (this.theLoop instanceof JaGlLoop) {
            this.theParticle = this.language.getString("Gluon_loop_parameters");
            this.theIcon = new ImageIcon(JaxoLoopOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/gluonloop.gif"));
            this.newWiggles = (int)(this.newLength * 2.0 * Math.PI / (double)this.newFreq / (double)0.6f);
        }
        JPanel pxin = new JPanel();
        pxin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelXin = new SpinnerNumberModel(this.newXin, 0, this.d.width, 1);
        JLabel xin = new JLabel("X: ", 4);
        pxin.add(xin);
        JSpinner spxin = new JSpinner(modelXin);
        pxin.add(spxin);
        JPanel pyin = new JPanel();
        pyin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelYin = new SpinnerNumberModel(this.newYin, 0, this.d.height, 1);
        JLabel yin = new JLabel("Y: ", 4);
        pyin.add(yin);
        JSpinner spyin = new JSpinner(modelYin);
        pyin.add(spyin);
        JPanel prad = new JPanel();
        prad.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelrad = new SpinnerNumberModel((int)this.newLength, 0, (int)Math.round(Math.sqrt(this.d.width * this.d.width + this.d.height * this.d.height)), 1);
        JLabel rad = new JLabel(this.language.getString("Radius") + ": ", 4);
        prad.add(rad);
        JSpinner sprad = new JSpinner(modelrad);
        prad.add(sprad);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        pxin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pxin, sc);
        dimSPanel.add((Component)pxin, sc);
        sc.gridx = 0;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 0);
        pyin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pyin, sc);
        dimSPanel.add((Component)pyin, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        sc.gridheight = 2;
        sc.insets = new Insets(0, 0, 5, 5);
        prad.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(prad, sc);
        dimSPanel.add((Component)prad, sc);
        JPanel finalDimSPanel = new JPanel();
        finalDimSPanel.setLayout(new BoxLayout(finalDimSPanel, 0));
        TitledBorder dimSTitle = BorderFactory.createTitledBorder(this.language.getString("Center/Radius"));
        finalDimSPanel.setBorder(dimSTitle);
        finalDimSPanel.add(dimSPanel);
        JPanel pstin = new JPanel();
        GridBagLayout subgb = new GridBagLayout();
        GridBagConstraints subc = new GridBagConstraints();
        pstin.setLayout(subgb);
        SpinnerNumberModel modelstin = new SpinnerNumberModel(this.newStroke, 0.0, 100.0, 0.2);
        JLabel stin = new JLabel(this.language.getString("Line_Width"), 4);
        JSpinner spstin = new JSpinner(modelstin);
        subc.gridx = 0;
        subc.gridy = 0;
        subc.insets = new Insets(0, 5, 0, 5);
        subgb.setConstraints(stin, subc);
        pstin.add((Component)stin, subc);
        subc.gridx = 1;
        subc.gridy = 0;
        spstin.setPreferredSize(new Dimension(50, 20));
        subgb.setConstraints(spstin, subc);
        pstin.add((Component)spstin, subc);
        JPanel pdsin = new JPanel();
        GridBagLayout subgb1 = new GridBagLayout();
        GridBagConstraints subc1 = new GridBagConstraints();
        pdsin.setLayout(subgb);
        SpinnerNumberModel modeldsin = new SpinnerNumberModel(this.newDash, 0.0, 50.0, 0.2);
        JLabel dsin = new JLabel(" " + this.language.getString("Dash_Size"), 4);
        pdsin.add(dsin);
        JSpinner spdsin = new JSpinner(modeldsin);
        subc1.gridx = 0;
        subc1.gridy = 0;
        subc1.insets = new Insets(0, 5, 5, 5);
        subgb1.setConstraints(dsin, subc1);
        pdsin.add((Component)dsin, subc1);
        subc1.gridx = 1;
        subc1.gridy = 0;
        spdsin.setPreferredSize(new Dimension(50, 20));
        subgb1.setConstraints(spdsin, subc1);
        pdsin.add((Component)spdsin, subc1);
        if (this.theLoop instanceof JaFLoop || this.theLoop instanceof JaPLoop || this.theLoop instanceof JaGlLoop) {
            dsin.setEnabled(false);
            spdsin.setEnabled(false);
        }
        JPanel strSPanel = new JPanel();
        GridBagLayout gb1 = new GridBagLayout();
        GridBagConstraints sc1 = new GridBagConstraints();
        strSPanel.setLayout(gb1);
        sc1.gridx = 0;
        sc1.gridy = 0;
        gb1.setConstraints(pstin, sc1);
        strSPanel.add((Component)pstin, sc1);
        sc1.gridx = 0;
        sc1.gridy = 1;
        sc1.insets = new Insets(5, 0, 0, 0);
        gb1.setConstraints(pdsin, sc1);
        strSPanel.add((Component)pdsin, sc1);
        JPanel finalStrSPanel = new JPanel();
        finalStrSPanel.setLayout(new BoxLayout(finalStrSPanel, 0));
        TitledBorder strSTitle = BorderFactory.createTitledBorder(this.language.getString("Width/Dashing"));
        finalStrSPanel.setBorder(strSTitle);
        finalStrSPanel.add(strSPanel);
        this.colorbt = new JButton(this.colorPreviewIcon);
        this.colorbt.addActionListener(this);
        this.colorPanel = new JPanel();
        this.colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Color"));
        this.colorPanel.setBorder(this.colorPanelTitle);
        this.colorPanel.add(this.colorbt);
        JPanel finalAwSPanel = new JPanel();
        if (this.theLoop instanceof JaPLoop || this.theLoop instanceof JaGlLoop) {
            JPanel pampin = new JPanel();
            GridBagLayout subgb2 = new GridBagLayout();
            GridBagConstraints subc2 = new GridBagConstraints();
            pampin.setLayout(subgb2);
            this.modelampin = new SpinnerNumberModel((double)this.newAmp, -500.0, 500.0, 1.0);
            JLabel ampin = new JLabel(this.language.getString("Amplitude"), 4);
            JSpinner spampin = new JSpinner(this.modelampin);
            subc2.gridx = 0;
            subc2.gridy = 0;
            subgb2.setConstraints(ampin, subc2);
            pampin.add((Component)ampin, subc2);
            subc2.gridx = 1;
            subc2.gridy = 0;
            spampin.setPreferredSize(new Dimension(60, 20));
            subgb2.setConstraints(spampin, subc2);
            pampin.add((Component)spampin, subc2);
            JPanel pwigin = new JPanel();
            GridBagLayout subgb3 = new GridBagLayout();
            GridBagConstraints subc3 = new GridBagConstraints();
            pampin.setLayout(subgb3);
            this.modelwigin = new SpinnerNumberModel((double)this.newWiggles, 0.0, 1000.0, 1.0);
            JLabel wigin = new JLabel("  " + this.language.getString("Wiggles"), 4);
            JSpinner spwigin = new JSpinner(this.modelwigin);
            subc3.gridx = 0;
            subc3.gridy = 0;
            subgb3.setConstraints(wigin, subc3);
            pwigin.add((Component)wigin, subc3);
            subc3.gridx = 1;
            subc3.gridy = 0;
            spwigin.setPreferredSize(new Dimension(60, 20));
            subgb3.setConstraints(spwigin, subc3);
            pwigin.add((Component)spwigin, subc3);
            JPanel awSPanel = new JPanel();
            GridBagLayout gb2 = new GridBagLayout();
            GridBagConstraints sc2 = new GridBagConstraints();
            awSPanel.setLayout(gb2);
            sc2.gridx = 0;
            sc2.gridy = 0;
            gb2.setConstraints(pampin, sc2);
            awSPanel.add((Component)pampin, sc2);
            sc2.gridx = 0;
            sc2.gridy = 1;
            sc2.insets = new Insets(0, 0, 0, 0);
            gb2.setConstraints(pwigin, sc2);
            awSPanel.add((Component)pwigin, sc2);
            finalAwSPanel.setLayout(new BoxLayout(finalAwSPanel, 0));
            TitledBorder awSTitle = BorderFactory.createTitledBorder(this.language.getString("Amplitude/Wiggles"));
            finalAwSPanel.setBorder(awSTitle);
            finalAwSPanel.add(awSPanel);
        }
        if (this.theLoop instanceof JaFLoop || this.theLoop instanceof JaSLoop || this.theLoop instanceof JaGLoop) {
            this.arrowcb = new JCheckBox(this.language.getString("Arrow"));
            this.arrowcb.setSelected(this.theLoop.getArrow());
            this.arrowcb.addItemListener(this);
            this.flipcb = new JCheckBox(this.language.getString("Flip"));
            this.flipcb.setSelected(this.theLoop.getFlip());
            this.flipcb.addItemListener(this);
            this.loopArrowPanel = new JPanel();
            this.loopArrowPanel.setLayout(new GridLayout(0, 1));
            this.loopArrowTitle = BorderFactory.createTitledBorder(this.language.getString("Arrow"));
            this.loopArrowPanel.setBorder(this.loopArrowTitle);
            this.loopArrowPanel.add(this.arrowcb);
            this.loopArrowPanel.add(this.flipcb);
        }
        this.dlcb = new JCheckBox(this.language.getString("Double_line"));
        this.dlcb.setSelected(this.newDLine);
        this.dlcb.addItemListener(this);
        SpinnerNumberModel modelsep = new SpinnerNumberModel(this.newDLSep, 0.5, 5.0, 0.5);
        this.stsep = new JLabel(this.language.getString("Separation") + ": ");
        this.spsep = new JSpinner(modelsep);
        this.stsep.setEnabled(this.newDLine);
        this.spsep.setEnabled(this.newDLine);
        JPanel dlP = new JPanel();
        GridBagLayout subdl = new GridBagLayout();
        GridBagConstraints subcdl = new GridBagConstraints();
        dlP.setLayout(subdl);
        subcdl.gridx = 0;
        subcdl.gridy = 0;
        subdl.setConstraints(this.dlcb, subcdl);
        dlP.add((Component)this.dlcb, subcdl);
        subcdl.gridx = 0;
        subcdl.gridy = 1;
        subcdl.insets = new Insets(5, 0, 5, 0);
        subdl.setConstraints(this.stsep, subcdl);
        dlP.add((Component)this.stsep, subcdl);
        subcdl.gridx = 1;
        subcdl.gridy = 1;
        subcdl.insets = new Insets(5, 0, 5, 5);
        this.spsep.setPreferredSize(new Dimension(50, 20));
        subdl.setConstraints(this.spsep, subcdl);
        dlP.add((Component)this.spsep, subcdl);
        JPanel dlPanel = new JPanel();
        dlPanel.setLayout(new BoxLayout(dlPanel, 0));
        TitledBorder dlTitle = BorderFactory.createTitledBorder(this.language.getString("Double_line"));
        dlPanel.setBorder(dlTitle);
        dlPanel.add(dlP);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 5);
        gridbag.setConstraints(finalDimSPanel, c);
        this.add((Component)finalDimSPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 0, 0, 5);
        gridbag.setConstraints(finalStrSPanel, c);
        this.add((Component)finalStrSPanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 0, 0);
        this.colorPanel.setPreferredSize(new Dimension(100, 70));
        gridbag.setConstraints(this.colorPanel, c);
        this.add((Component)this.colorPanel, c);
        if (this.theLoop instanceof JaFLoop || this.theLoop instanceof JaSLoop || this.theLoop instanceof JaGLoop) {
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(0, 5, 5, 0);
            this.loopArrowPanel.setPreferredSize(new Dimension(100, 70));
            gridbag.setConstraints(this.loopArrowPanel, c);
            this.add((Component)this.loopArrowPanel, c);
        } else if (this.theLoop instanceof JaPLoop || this.theLoop instanceof JaGlLoop) {
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(0, 5, 5, 5);
            gridbag.setConstraints(finalAwSPanel, c);
            this.add((Component)finalAwSPanel, c);
        }
        c.gridx = 2;
        c.gridy = 0;
        gridbag.setConstraints(dlPanel, c);
        this.add((Component)dlPanel, c);
        Object[] optionButtonNames = new String[]{this.language.getString("Accept"), this.language.getString("Cancel")};
        int n = JOptionPane.showOptionDialog(this, this, this.theParticle, 2, 1, this.theIcon, optionButtonNames, optionButtonNames[0]);
        if (n == 0) {
            this.theLoop.setArrow(this.newArrow);
            this.theLoop.setFlip(this.newFlip);
            if (this.newColor != null) {
                this.theLoop.setColor(this.newColor);
            }
            this.newXin = modelXin.getNumber().intValue();
            this.newYin = modelYin.getNumber().intValue();
            this.realNewLength = modelrad.getNumber().floatValue();
            this.newStroke = Math.abs(modelstin.getNumber().floatValue());
            this.newDash = Math.abs(modeldsin.getNumber().floatValue());
            if (this.theLoop instanceof JaPLoop || this.theLoop instanceof JaGlLoop) {
                this.newAmp = (int)this.modelampin.getNumber().floatValue();
                this.newWiggles = (int)this.modelwigin.getNumber().floatValue();
            }
            if (this.theLoop instanceof JaPLoop) {
                this.newFreq = (float)(this.realNewLength * 2.0 * Math.PI / (double)this.newWiggles);
            }
            if (this.theLoop instanceof JaGlLoop) {
                this.newFreq = (float)(this.realNewLength * 2.0 * Math.PI / (double)this.newWiggles / (double)0.6f);
            }
            this.theLoop.setDash(this.newDash);
            this.theLoop.setStroke(this.newStroke);
            this.theLoop.setDoubleLine(this.newDLine);
            this.newDLSep = modelsep.getNumber().floatValue();
            this.theLoop.setDLSeparation(this.newDLSep);
            if (this.realNewLength - this.newLength != 0.0) {
                this.setBox(this.realNewLength, this.newRelWidth, this.newRelHeight);
                this.newWidth = Math.abs(this.newRelWidth);
                this.newHeight = Math.abs(this.newRelHeight);
                this.theLoop.setRelWAndH(this.newRelWidth, this.newRelHeight);
            }
            this.setNewCenter(this.newXin, this.newYin, this.newRelWidth, this.newRelHeight);
            this.theLoop.setX(this.newXin);
            this.theLoop.setY(this.newYin);
            this.theLoop.setAmp(this.newAmp);
            this.theLoop.setFreq(this.newFreq);
            this.changed = true;
        }
    }

    public final boolean hasChanged() {
        return this.changed;
    }

    @Override
    public final void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.arrowcb) {
            this.newArrow = !this.newArrow;
            this.flipcb.setEnabled(this.newArrow);
        } else if (source == this.flipcb) {
            this.newFlip = !this.newFlip;
        } else if (source == this.dlcb) {
            this.newDLine = !this.newDLine;
            this.stsep.setEnabled(this.newDLine);
            this.spsep.setEnabled(this.newDLine);
        }
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.colorbt) {
            JaxoColorChooser colorChooser = new JaxoColorChooser();
            this.newColor = colorChooser.color(this.newColor, false);
            if (this.newColor != null) {
                this.colorPreviewIcon = new ImageIcon(this.getChooserImage(this.newColor));
                this.colorbt.setIcon(this.colorPreviewIcon);
            }
        }
    }

    private void getCenter(int x, int y, int relw, int relh) {
        if (relw > 0 && relh >= 0) {
            this.newXin = x;
            this.newYin = y;
        }
        if (relw < 0 && relh <= 0) {
            this.newXin = x + Math.abs(relw);
            this.newYin = y + Math.abs(relh);
        }
        if (relw >= 0 && relh < 0) {
            this.newXin = x;
            this.newYin = y + Math.abs(relh);
        }
        if (relw <= 0 && relh > 0) {
            this.newXin = x + Math.abs(relw);
            this.newYin = y;
        }
    }

    private Image getChooserImage(Color iconColor) {
        int width = 40;
        int height = 15;
        int size = width * height;
        int[] pixels = new int[size];
        for (int i = 0; i < size; ++i) {
            pixels[i] = iconColor.getRGB();
        }
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image jaxColorBox = this.createImage(source);
        return jaxColorBox;
    }

    private void setNewCenter(int xin, int yin, int relw, int relh) {
        if (this.newRelWidth > 0 && this.newRelHeight >= 0) {
            this.newXin = xin;
            this.newYin = yin;
        }
        if (this.newRelWidth < 0 && this.newRelHeight <= 0) {
            this.newXin = xin + relw;
            this.newYin = yin + relh;
        }
        if (this.newRelWidth >= 0 && this.newRelHeight < 0) {
            this.newXin = xin;
            this.newYin = yin + relh;
        }
        if (this.newRelWidth <= 0 && this.newRelHeight > 0) {
            this.newXin = xin + relw;
            this.newYin = yin;
        }
    }

    private void setBox(double length, int relw, int relh) {
        double theta = Math.atan2(relh, relw);
        if (relw > 0 && relh >= 0) {
            this.newRelHeight = (int)(length * Math.sin(theta)) + 1;
            this.newRelWidth = (int)(length * Math.cos(theta)) + 1;
        }
        if (relw >= 0 && relh < 0) {
            this.newRelHeight = (int)(length * Math.sin(theta)) - 1;
            this.newRelWidth = (int)(length * Math.cos(theta)) + 1;
        }
        if (relw < 0 && relh <= 0) {
            this.newRelHeight = (int)(length * Math.sin(theta)) - 1;
            this.newRelWidth = (int)(length * Math.cos(theta)) - 1;
        }
        if (relw <= 0 && relh > 0) {
            this.newRelHeight = (int)(length * Math.sin(theta)) + 1;
            this.newRelWidth = (int)(length * Math.cos(theta)) - 1;
        }
    }
}

