/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoPrefs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JaxoLatexPackage
implements ListSelectionListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private ArrayList listVector;
    private JList list;
    private DefaultListModel listModel;
    private JButton removeButton;
    private JTextField packageName;
    private JDialog dialog;

    public JaxoLatexPackage(ArrayList vector) {
        this.listVector = vector;
        this.listModel = new DefaultListModel();
        for (int i = 0; i < this.listVector.size(); ++i) {
            this.listModel.add(i, this.listVector.get(i));
        }
        this.initComponents();
    }

    private void initComponents() {
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(this);
        JScrollPane listScrollPane = new JScrollPane(this.list);
        JButton addButton = new JButton(this.language.getString("Add"));
        addButton.addActionListener(new AddPackageListener());
        this.removeButton = new JButton(this.language.getString("Remove"));
        this.removeButton.addMouseListener(new MouseAdapter(){

            @Override
            public final void mouseClicked(MouseEvent evt) {
                JaxoLatexPackage.this.removeButtonClicked();
            }
        });
        this.removeButton.setEnabled(false);
        JButton okButton = new JButton(this.language.getString("OK"));
        okButton.addMouseListener(new MouseAdapter(){

            @Override
            public final void mouseClicked(MouseEvent evt) {
                JaxoLatexPackage.this.okButtonClicked();
            }
        });
        JButton cancelButton = new JButton(this.language.getString("Cancel"));
        cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public final void mouseClicked(MouseEvent evt) {
                JaxoLatexPackage.this.cancelButtonClicked();
            }
        });
        this.packageName = new JTextField(10);
        this.packageName.addActionListener(new AddPackageListener());
        this.packageName.setText("");
        JPanel buttonPane = new JPanel();
        buttonPane.add(this.packageName);
        buttonPane.add(addButton);
        buttonPane.add(this.removeButton);
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog = new JDialog();
        this.dialog.getContentPane().add((Component)listScrollPane, "Center");
        this.dialog.getContentPane().add((Component)buttonPane, "South");
        this.dialog.setTitle(this.language.getString("Add_Latex_package"));
        this.dialog.pack();
        Dimension dialogSize = this.dialog.getSize();
        this.dialog.setLocation(d.width / 2 - dialogSize.width / 2, d.height / 2 - dialogSize.height / 2);
        this.dialog.setVisible(true);
    }

    private void removeButtonClicked() {
        int index = this.list.getSelectedIndex();
        if (index == 0 || index == 1 || index == 2) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.listModel.remove(index);
        int size = this.listModel.getSize();
        if (size == 3) {
            this.removeButton.setEnabled(false);
        } else {
            if (index == size) {
                --index;
            }
            this.list.setSelectedIndex(index);
        }
    }

    @Override
    public final void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int index = this.list.getSelectedIndex();
            if (index == -1) {
                this.removeButton.setEnabled(false);
                this.packageName.setText("");
            } else if (index == 0 || index == 1 || index == 2) {
                this.removeButton.setEnabled(false);
                this.packageName.setText("");
            } else {
                this.removeButton.setEnabled(true);
                String name = this.list.getSelectedValue().toString();
                this.packageName.setText(name);
            }
        }
    }

    public final ArrayList getPackageList() {
        return this.listVector;
    }

    private void okButtonClicked() {
        this.listVector.clear();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            this.listVector.add(this.listModel.getElementAt(i));
        }
        this.dialog.dispose();
    }

    private void cancelButtonClicked() {
        this.dialog.dispose();
    }

    class AddPackageListener
    implements ActionListener {
        AddPackageListener() {
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            if (JaxoLatexPackage.this.packageName.getText().equals("")) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            int size = JaxoLatexPackage.this.listModel.getSize();
            JaxoLatexPackage.this.listModel.addElement(JaxoLatexPackage.this.packageName.getText());
            JaxoLatexPackage.this.list.setSelectedIndex(size);
        }
    }
}

