/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColorChooser;
import japlot.jaxodraw.JaxoGroup;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class JaxoGroupOptionsPanel
extends JPanel
implements ActionListener,
ItemListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    private SpinnerNumberModel modelampin;
    private JaxoGroup theGroup;
    private String sGroup;
    private Icon theIcon;
    private ImageIcon colorPreviewIcon;
    private JButton colorbt;
    private JPanel colorPanel;
    private TitledBorder colorPanelTitle;
    private Color newColor;
    private Image colorPreview;
    private JComboBox fscomb;
    private JPanel fsPanel;
    private TitledBorder fsPanelTitle;
    private JPanel textFinalFontPanel;
    private TitledBorder textFontTitle;
    private JPanel textFamilyPanel;
    private JPanel textSizePanel;
    private JPanel textStylePanel;
    private JComboBox famcomb;
    private JComboBox sizecomb;
    private JComboBox stycomb;
    private JLabel textFamilyLabel;
    private JLabel textSizeLabel;
    private JLabel textStyleLabel;
    private double[] bbox;
    private int oldXin;
    private int oldYin;
    private int newXin;
    private int newYin;
    private float newSFactor;
    private float oldStroke;
    private float newStroke;
    private int oldAmp;
    private int newAmp;
    private int oldSize;
    private int newSize;
    private String fontChoice;
    private String sizeChoice;
    private String family;
    private Integer sizeCInt;
    private int sizeChoiceInt;
    private int styleC;
    private int styleChoice;
    private Font oldFont;
    private Font newFont;
    private String[] envFonts;
    private boolean changed = false;

    public JaxoGroupOptionsPanel(JaxoGroup group, String[] fonts) {
        Object[] optionButtonNames;
        int n;
        this.theGroup = group;
        this.envFonts = fonts;
        boolean ampOb = this.theGroup.areAmpObject();
        boolean texOb = this.theGroup.areTeXLabels();
        boolean psOb = this.theGroup.arePSLabels();
        this.sGroup = this.language.getString("Group_parameters");
        this.theIcon = new ImageIcon(JaxoGroupOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/groupobject.png"));
        this.bbox = this.theGroup.getBoundingBox();
        this.oldXin = (int)Math.round(this.bbox[0]);
        this.oldYin = (int)Math.round(this.bbox[1]);
        this.newColor = this.theGroup.getColor();
        if (this.newColor != null) {
            this.colorPreview = this.getChooserImage(this.newColor);
            this.colorPreviewIcon = new ImageIcon(this.colorPreview);
        }
        this.oldStroke = this.theGroup.getStroke();
        this.oldAmp = this.theGroup.getAmp();
        this.oldSize = this.theGroup.getTeXSize();
        this.newSize = this.theGroup.getTeXSize();
        this.oldFont = this.theGroup.getTextFont();
        this.family = this.oldFont.getFamily();
        this.sizeCInt = new Integer(this.oldFont.getSize());
        this.styleC = this.oldFont.getStyle();
        JPanel pxin = new JPanel();
        pxin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelXin = new SpinnerNumberModel(this.oldXin, 0, this.d.width, 1);
        JLabel xin = new JLabel("X: ", 4);
        pxin.add(xin);
        JSpinner spxin = new JSpinner(modelXin);
        pxin.add(spxin);
        JPanel pyin = new JPanel();
        pyin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelYin = new SpinnerNumberModel(this.oldYin, 0, this.d.height, 1);
        JLabel yin = new JLabel("Y: ", 4);
        pyin.add(yin);
        JSpinner spyin = new JSpinner(modelYin);
        pyin.add(spyin);
        JPanel prad = new JPanel();
        prad.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelrad = new SpinnerNumberModel(1.0, 0.0, 50.0, 0.05);
        JLabel rad = new JLabel(this.language.getString("Scale") + ": ", 4);
        prad.add(rad);
        JSpinner sprad = new JSpinner(modelrad);
        prad.add(sprad);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        pxin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pxin, sc);
        dimSPanel.add((Component)pxin, sc);
        sc.gridx = 0;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 0);
        pyin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pyin, sc);
        dimSPanel.add((Component)pyin, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        sc.gridheight = 2;
        sc.insets = new Insets(0, 0, 5, 5);
        prad.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(prad, sc);
        dimSPanel.add((Component)prad, sc);
        JPanel finalDimSPanel = new JPanel();
        finalDimSPanel.setLayout(new BoxLayout(finalDimSPanel, 0));
        TitledBorder dimSTitle = BorderFactory.createTitledBorder(this.language.getString("Position/Scale_factor"));
        finalDimSPanel.setBorder(dimSTitle);
        finalDimSPanel.add(dimSPanel);
        JPanel pstin = new JPanel();
        GridBagLayout subgb = new GridBagLayout();
        GridBagConstraints subc = new GridBagConstraints();
        pstin.setLayout(subgb);
        SpinnerNumberModel modelstin = new SpinnerNumberModel(this.oldStroke, 0.0, 100.0, 0.2);
        JLabel stin = new JLabel(this.language.getString("Line_Width"), 4);
        JSpinner spstin = new JSpinner(modelstin);
        subc.gridx = 0;
        subc.gridy = 0;
        subc.insets = new Insets(0, 5, 5, 5);
        subgb.setConstraints(stin, subc);
        pstin.add((Component)stin, subc);
        subc.gridx = 1;
        subc.gridy = 0;
        spstin.setPreferredSize(new Dimension(50, 20));
        subgb.setConstraints(spstin, subc);
        pstin.add((Component)spstin, subc);
        JPanel strSPanel = new JPanel();
        GridBagLayout gb1 = new GridBagLayout();
        GridBagConstraints sc1 = new GridBagConstraints();
        strSPanel.setLayout(gb1);
        sc1.gridx = 0;
        sc1.gridy = 0;
        gb1.setConstraints(pstin, sc1);
        strSPanel.add((Component)pstin, sc1);
        JPanel finalStrSPanel = new JPanel();
        finalStrSPanel.setLayout(new BoxLayout(finalStrSPanel, 0));
        TitledBorder strSTitle = BorderFactory.createTitledBorder(this.language.getString("Width"));
        finalStrSPanel.setBorder(strSTitle);
        finalStrSPanel.add(strSPanel);
        JPanel finalAwSPanel = new JPanel();
        if (ampOb) {
            JPanel pampin = new JPanel();
            GridBagLayout subgb2 = new GridBagLayout();
            GridBagConstraints subc2 = new GridBagConstraints();
            pampin.setLayout(subgb2);
            this.modelampin = new SpinnerNumberModel((double)this.oldAmp, -200.0, 200.0, 1.0);
            JLabel ampin = new JLabel(this.language.getString("Amplitude") + ": ", 4);
            JSpinner spampin = new JSpinner(this.modelampin);
            subc2.gridx = 0;
            subc2.gridy = 0;
            subc2.insets = new Insets(0, 5, 5, 5);
            subgb2.setConstraints(ampin, subc2);
            pampin.add((Component)ampin, subc2);
            subc2.gridx = 1;
            subc2.gridy = 0;
            spampin.setPreferredSize(new Dimension(60, 20));
            subgb2.setConstraints(spampin, subc2);
            pampin.add((Component)spampin, subc2);
            JPanel awSPanel = new JPanel();
            GridBagLayout gb2 = new GridBagLayout();
            GridBagConstraints sc2 = new GridBagConstraints();
            awSPanel.setLayout(gb2);
            sc2.gridx = 0;
            sc2.gridy = 0;
            gb2.setConstraints(pampin, sc2);
            awSPanel.add((Component)pampin, sc2);
            finalAwSPanel.setLayout(new BoxLayout(finalAwSPanel, 0));
            TitledBorder awSTitle = BorderFactory.createTitledBorder(this.language.getString("Amplitude"));
            finalAwSPanel.setBorder(awSTitle);
            finalAwSPanel.add(awSPanel);
        }
        if (texOb) {
            String[] allowed = new String[]{"tiny", "scriptsize", "footnotesize", "small", "normalsize", "large", "Large", "LARGE", "huge", "Huge"};
            this.fscomb = new JComboBox<String>(allowed);
            this.fscomb.setSelectedIndex(this.oldSize);
            this.fscomb.addActionListener(this);
            this.fsPanel = new JPanel();
            this.fsPanelTitle = BorderFactory.createTitledBorder("TeX" + this.language.getString("Font_size"));
            this.fsPanel.setBorder(this.fsPanelTitle);
            this.fsPanel.add(this.fscomb);
        }
        if (psOb) {
            this.textFamilyPanel = new JPanel();
            this.textFamilyLabel = new JLabel();
            this.textFamilyLabel.setText(this.language.getString("Font"));
            this.textFamilyLabel.setHorizontalAlignment(0);
            this.textSizePanel = new JPanel();
            this.textSizeLabel = new JLabel();
            this.textSizeLabel.setText(this.language.getString("Size"));
            this.textSizeLabel.setHorizontalAlignment(0);
            this.textStylePanel = new JPanel();
            this.textStyleLabel = new JLabel();
            this.textStyleLabel.setText(this.language.getString("Style"));
            this.textStyleLabel.setHorizontalAlignment(0);
            this.famcomb = new JComboBox<String>(this.envFonts);
            this.famcomb.addItemListener(this);
            this.famcomb.setSelectedIndex(this.getFamilyIndex(this.family));
            this.textFamilyPanel.add(this.famcomb);
            String[] sizes = new String[]{"4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "32", "34", "36", "38", "40", "42", "44", "46", "48", "50", "52", "54", "56", "58", "60", "62", "64"};
            this.sizecomb = new JComboBox<String>(sizes);
            this.sizecomb.addItemListener(this);
            this.sizecomb.setSelectedIndex(JaxoGroupOptionsPanel.getSizeIndex(this.sizeCInt.toString()));
            this.textSizePanel.add(this.sizecomb);
            String[] styles = new String[]{"Plain", "Bold", "Italic", "Bold & Italic"};
            this.stycomb = new JComboBox<String>(styles);
            this.stycomb.addItemListener(this);
            this.stycomb.setSelectedIndex(this.styleC);
            this.textStylePanel.add(this.stycomb);
            this.textFinalFontPanel = new JPanel();
            this.textFinalFontPanel.setLayout(new BorderLayout());
            this.textFontTitle = BorderFactory.createTitledBorder(this.language.getString("Font_properties"));
            this.textFinalFontPanel.setBorder(this.textFontTitle);
            this.textFinalFontPanel.add("West", this.textFamilyPanel);
            this.textFinalFontPanel.add("Center", this.textSizePanel);
            this.textFinalFontPanel.add("East", this.textStylePanel);
        }
        this.colorbt = new JButton(this.colorPreviewIcon);
        this.colorbt.addActionListener(this);
        this.colorbt.setPreferredSize(new Dimension(70, 25));
        this.colorPanel = new JPanel();
        this.colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Color"));
        this.colorPanel.setBorder(this.colorPanelTitle);
        this.colorPanel.add(this.colorbt);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 5);
        gridbag.setConstraints(finalDimSPanel, c);
        this.add((Component)finalDimSPanel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 5, 0);
        this.colorPanel.setPreferredSize(new Dimension(100, 70));
        gridbag.setConstraints(this.colorPanel, c);
        this.add((Component)this.colorPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 0, 0, 5);
        gridbag.setConstraints(finalStrSPanel, c);
        this.add((Component)finalStrSPanel, c);
        if (ampOb) {
            c.gridx = 1;
            c.gridy = 1;
            gridbag.setConstraints(finalAwSPanel, c);
            this.add((Component)finalAwSPanel, c);
        }
        if (psOb) {
            c.gridwidth = 2;
            c.gridx = 0;
            c.gridy = 2;
            c.insets = new Insets(5, 0, 0, 5);
            this.textFinalFontPanel.setPreferredSize(new Dimension(350, 60));
            gridbag.setConstraints(this.textFinalFontPanel, c);
            this.add((Component)this.textFinalFontPanel, c);
        }
        if (texOb) {
            if (ampOb && !psOb) {
                c.gridx = 2;
                c.gridy = 0;
                c.insets = new Insets(0, 5, 5, 0);
                gridbag.setConstraints(this.fsPanel, c);
                this.add((Component)this.fsPanel, c);
            } else if (ampOb && psOb) {
                c.gridx = 2;
                c.gridy = 0;
                gridbag.setConstraints(this.fsPanel, c);
                this.add((Component)this.fsPanel, c);
            } else {
                c.gridx = 1;
                c.gridy = 1;
                gridbag.setConstraints(this.fsPanel, c);
                this.add((Component)this.fsPanel, c);
            }
        }
        if ((n = JOptionPane.showOptionDialog(this, this, this.sGroup, 2, 1, this.theIcon, optionButtonNames = new String[]{this.language.getString("Accept"), this.language.getString("Cancel")}, optionButtonNames[0])) == 0) {
            this.newXin = modelXin.getNumber().intValue();
            this.newYin = modelYin.getNumber().intValue();
            this.newSFactor = Math.abs(modelrad.getNumber().floatValue());
            this.newStroke = Math.abs(modelstin.getNumber().floatValue());
            if (ampOb) {
                this.newAmp = (int)this.modelampin.getNumber().floatValue();
            }
            if (this.newColor != null) {
                this.theGroup.setGroupColor(this.newColor);
                this.changed = true;
            }
            if (this.newXin - this.oldXin != 0 || this.newYin - this.oldYin != 0) {
                this.theGroup.setX(this.newXin);
                this.theGroup.setY(this.newYin);
                this.theGroup.moveBy(this.newXin - this.oldXin, this.newYin - this.oldYin);
                this.changed = true;
            }
            if ((double)Math.abs(this.newSFactor - 1.0f) > 1.0E-4) {
                this.theGroup.rescaleObject(this.newXin, this.newYin, this.newSFactor);
                this.changed = true;
            }
            if ((double)Math.abs(this.newStroke - this.oldStroke) > 1.0E-4) {
                this.theGroup.setGroupStroke(this.newStroke);
                this.changed = true;
            }
            if (ampOb && this.newAmp - this.oldAmp != 0) {
                this.theGroup.setGroupAmp(this.newAmp);
                this.changed = true;
            }
            if (texOb && this.oldSize - this.newSize != 0) {
                this.theGroup.setGroupTeXSize(this.newSize);
                this.changed = true;
            }
            if (psOb && (this.sizeChoiceInt - this.sizeCInt != 0 || this.styleChoice - this.styleC != 0 || this.fontChoice != null)) {
                this.newFont = new Font(this.fontChoice, this.styleChoice, this.sizeChoiceInt);
                this.theGroup.setGroupTextFont(this.newFont);
            }
        }
    }

    public final boolean hasChanged() {
        return this.changed;
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.colorbt) {
            JaxoColorChooser colorChooser = new JaxoColorChooser();
            this.newColor = colorChooser.color(this.newColor, false);
            if (this.newColor != null) {
                this.colorPreviewIcon = new ImageIcon(this.getChooserImage(this.newColor));
                this.colorbt.setIcon(this.colorPreviewIcon);
            }
        } else if (evt.getSource() == this.fscomb) {
            this.newSize = this.fscomb.getSelectedIndex();
        }
    }

    @Override
    public final void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        Object list = e.getSource();
        if (list == this.famcomb) {
            this.fontChoice = (String)this.famcomb.getSelectedItem();
        } else if (list == this.stycomb) {
            this.styleChoice = this.stycomb.getSelectedIndex();
        } else {
            this.sizeChoice = (String)this.sizecomb.getSelectedItem();
            Integer thisSize = new Integer(this.sizeChoice);
            this.sizeChoiceInt = thisSize;
        }
    }

    private Image getChooserImage(Color iconColor) {
        int width = 40;
        int height = 15;
        int size = width * height;
        int[] pixels = new int[size];
        for (int i = 0; i < size; ++i) {
            pixels[i] = iconColor.getRGB();
        }
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image jaxColorBox = this.createImage(source);
        return jaxColorBox;
    }

    private static int getSizeIndex(String s) {
        String[] sizes = new String[]{"4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "32", "34", "36", "38", "40", "42", "44", "46", "48", "50", "52", "54", "56", "58", "60", "62", "64"};
        int i = 0;
        while (sizes[i].compareTo(s) != 0) {
            ++i;
        }
        if (sizes[i].compareTo(s) == 0) {
            return i;
        }
        return -1;
    }

    private int getFamilyIndex(String s) {
        int i = this.envFonts.length;
        for (int j = 0; j < i; ++j) {
            if (this.envFonts[j].compareTo(s) != 0) continue;
            i = j;
            break;
        }
        if (i < this.envFonts.length) {
            return i;
        }
        return 0;
    }
}

