/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoGroup;
import japlot.jaxodraw.JaxoSaveGraph;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import jhplot.jadraw.JaLatexText;
import jhplot.jadraw.JaObject;
import jhplot.jadraw.JaText;
import org.freehep.graphics2d.VectorGraphics;

public class JaxoGraph
implements Serializable {
    private JaxoSaveGraph saveGraph;
    private ArrayList backupList;
    private String saveFileName;
    private boolean graphIsSaved = true;
    private JaObject selectedObject;
    private JaObject backupSelectedObject;

    public JaxoGraph() {
        this.saveGraph = new JaxoSaveGraph();
        this.backupList = new ArrayList(5);
        this.saveFileName = "";
    }

    public JaxoGraph(ArrayList list) {
        this.saveGraph = new JaxoSaveGraph(list);
        this.backupList = list;
        this.saveFileName = "";
    }

    public JaxoGraph(ArrayList list, String describe) {
        this.saveGraph = new JaxoSaveGraph(list, describe);
        this.backupList = list;
        this.saveFileName = "";
    }

    public JaxoGraph(ArrayList list, String describe, String saveFile) {
        this.saveGraph = new JaxoSaveGraph(list, describe);
        this.backupList = list;
        this.saveFileName = saveFile;
    }

    public final JaxoSaveGraph getSaveGraph() {
        return this.saveGraph;
    }

    public final void setSaveGraph(JaxoSaveGraph newSaveGraph) {
        this.saveGraph = newSaveGraph;
    }

    public final ArrayList getObjectList() {
        return this.saveGraph.getObjectList();
    }

    public final void reverse() {
        this.saveGraph.reverse();
    }

    public final void setObjectList(ArrayList list) {
        this.saveGraph.setObjectList(list);
        this.setSaved(false);
    }

    public final ArrayList getPackageList() {
        return this.saveGraph.getPackageList();
    }

    public final void setPackageList(ArrayList list) {
        this.saveGraph.setPackageList(list);
        this.setSaved(false);
    }

    public final void setBackupList(ArrayList v) {
        this.backupList = v;
    }

    public final ArrayList getBackupList() {
        return this.backupList;
    }

    public final void setDescription(String describe) {
        this.saveGraph.setDescription(describe);
        this.setSaved(false);
    }

    public final String getDescription() {
        return this.saveGraph.getDescription();
    }

    public final boolean isSaved() {
        return this.graphIsSaved;
    }

    public final void setSaved(boolean isSaved) {
        this.graphIsSaved = isSaved;
    }

    public final void setSaveFileName(String fileName) {
        this.saveFileName = fileName;
    }

    public final String getSaveFileName() {
        return this.saveFileName;
    }

    public final String getShortName() {
        File sname = new File(this.saveFileName);
        return sname.getName();
    }

    public final JaObject getSelectedObject() {
        return this.selectedObject;
    }

    public final void setSelectedObject(JaObject newOb) {
        this.selectedObject = newOb;
    }

    public final JaObject getBackupSelectedObject() {
        return this.backupSelectedObject;
    }

    public final void setBackupSelectedObject(JaObject newOb) {
        if (newOb != null) {
            this.backupSelectedObject = newOb.copy();
        }
    }

    public final JaObject listElementAt(int i) {
        return this.saveGraph.listElementAt(i);
    }

    public final int listSize() {
        return this.saveGraph.listSize();
    }

    public final void foreground(JaObject object) {
        boolean isLastElement = this.saveGraph.foreground(object);
        if (!isLastElement) {
            this.setSaved(false);
        }
    }

    public final void background(JaObject object) {
        boolean isFirstElement = this.saveGraph.background(object);
        if (!isFirstElement) {
            this.setSaved(false);
        }
    }

    public final void delete(JaObject object) {
        this.saveGraph.delete(object);
        this.setSaved(false);
    }

    public final void addFirst(JaObject object) {
        this.saveGraph.addFirst(object);
        this.setSaved(false);
    }

    public final void addObject(JaObject object) {
        this.saveGraph.addObject(object);
        this.setSaved(false);
    }

    public final void clear() {
        boolean listIsEmpty = this.saveGraph.clear();
        if (listIsEmpty) {
            this.setSaved(true);
        } else {
            this.setSaved(false);
        }
    }

    public final void clearAll() {
        boolean graphIsEmpty = this.saveGraph.clearAll();
        if (graphIsEmpty && this.saveFileName.length() == 0) {
            this.setSaved(true);
        } else {
            this.setSaveFileName("");
            this.setSaved(false);
        }
    }

    public final void undo() {
        ArrayList temp = this.copyFrom(this.backupList);
        this.setBackupList(this.copyFrom(this.getObjectList()));
        this.setObjectList(temp);
        JaObject ob = this.getBackupSelectedObject();
        this.setBackupSelectedObject(this.selectedObject);
        this.setSelectedObject(ob);
    }

    public final double[] getBoundingBox() {
        return this.saveGraph.getBoundingBox();
    }

    public final void backup() {
        if (this.copyFrom(this.getObjectList()).size() != 0) {
            this.setBackupList(this.copyFrom(this.getObjectList()));
            this.setBackupSelectedObject(this.getSelectedObject());
        }
    }

    public final ArrayList copyFrom(ArrayList v) {
        ArrayList<JaObject> temp = new ArrayList<JaObject>(v.size());
        for (int i = 0; i < v.size(); ++i) {
            JaObject cur = (JaObject)v.get(i);
            temp.add(cur.copy());
        }
        return temp;
    }

    public final boolean containsPSText() {
        boolean contains = false;
        ArrayList templist = this.getObjectList();
        for (int j = 0; j < templist.size(); ++j) {
            JaObject ob = (JaObject)templist.get(j);
            if (ob instanceof JaText) {
                contains = true;
                break;
            }
            if (ob instanceof JaxoGroup && (contains = ((JaxoGroup)ob).arePSLabels())) break;
        }
        return contains;
    }

    public final boolean containsLatexText() {
        boolean contains = false;
        ArrayList templist = this.getObjectList();
        for (int j = 0; j < templist.size(); ++j) {
            JaObject ob = (JaObject)templist.get(j);
            if (ob instanceof JaLatexText) {
                contains = true;
                break;
            }
            if (ob instanceof JaxoGroup && (contains = ((JaxoGroup)ob).areTeXLabels())) break;
        }
        return contains;
    }

    public final void drawHandles(VectorGraphics g2) {
        for (int j = 0; j < this.listSize(); ++j) {
            JaObject jaxoOb = this.listElementAt(j);
            jaxoOb.drawHandles(g2);
        }
    }

    public final void drawGroupHandles(VectorGraphics g2) {
        for (int j = 0; j < this.listSize(); ++j) {
            JaObject jaxoOb = this.listElementAt(j);
            if (!(jaxoOb instanceof JaxoGroup)) continue;
            jaxoOb.drawHandles(g2);
        }
    }

    public final void setAsMarked(boolean marked) {
        for (int i = 0; i < this.listSize(); ++i) {
            JaObject ob = this.listElementAt(i);
            ob.setAsMarked(marked);
        }
    }
}

