/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoCanvas;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoIO;
import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import japlot.jaxodraw.JaxoPrint;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import jhplot.gui.CommonGUI;
import jhplot.io.BrowserData;
import jhplot.jadraw.JaLatexText;
import jhplot.jadraw.JaObject;

public class JaxoFileMenu
extends JMenu
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JaxoMainPanel thePanel;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JMenu newM;
    private JMenuItem openMI;
    private JMenuItem opendataMI;
    private JMenuItem closeMI;
    private JMenuItem saveMI;
    private JMenuItem saveasMI;
    private JMenuItem exportMI;
    private JMenuItem printMI;
    private JMenuItem quitMI;
    private JMenuItem importMI;
    private ArrayList recentList;
    private int[] keyList = new int[]{49, 50, 51, 52};
    private JMenuItem newGraphMI;
    private JMenuItem newGraphTabMI;
    private int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public JaxoFileMenu(JaxoMainPanel mainPanel) {
        super(ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("File"));
        this.thePanel = mainPanel;
        this.recentList = new ArrayList(4);
        this.newM = new JMenu(this.language.getString("New"));
        this.newM.addActionListener(this);
        this.newGraphMI = new JMenuItem(this.language.getString("New_graph"));
        this.newGraphMI.setAccelerator(KeyStroke.getKeyStroke(78, this.keyMask));
        this.newGraphMI.addActionListener(this);
        this.newGraphMI.setActionCommand("NewG");
        this.newGraphTabMI = new JMenuItem(this.language.getString("New_tab"));
        this.newGraphTabMI.setAccelerator(KeyStroke.getKeyStroke(84, this.keyMask));
        this.newGraphTabMI.addActionListener(this);
        this.newGraphTabMI.setActionCommand("NewT");
        this.newM.add(this.newGraphMI);
        this.newM.add(this.newGraphTabMI);
        this.add(this.newM);
        this.opendataMI = new JMenuItem(this.language.getString("Opendata"));
        this.add(this.opendataMI);
        this.opendataMI.addActionListener(this);
        this.opendataMI.setActionCommand("Opendata");
        this.closeMI = new JMenuItem(this.language.getString("Close"));
        this.add(this.closeMI);
        this.closeMI.addActionListener(this);
        this.closeMI.setAccelerator(KeyStroke.getKeyStroke(88, this.keyMask));
        this.closeMI.setActionCommand("Close");
        this.exportMI = new JMenuItem(this.language.getString("Export"));
        this.add(this.exportMI);
        this.exportMI.addActionListener(this);
        this.exportMI.setAccelerator(KeyStroke.getKeyStroke(69, this.keyMask));
        this.exportMI.setActionCommand("Export");
        this.addSeparator();
        this.addRecentFiles();
        this.addSeparator();
        this.quitMI = new JMenuItem(this.language.getString("Quit"));
        this.add(this.quitMI);
        this.quitMI.addActionListener(this);
        this.quitMI.setAccelerator(KeyStroke.getKeyStroke(81, this.keyMask));
        this.quitMI.setActionCommand("Quit");
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        AbstractButton source = (AbstractButton)evt.getSource();
        if (source.getActionCommand().equals("NewG")) {
            this.thePanel.fileEvent(70);
        } else if (source.getActionCommand().equals("NewT")) {
            this.thePanel.fileEvent(80);
        } else if (source.getActionCommand().equals("Open")) {
            this.thePanel.fileEvent(71);
        } else if (source.getActionCommand().equals("Opendata")) {
            this.thePanel.fileEvent(82);
        } else if (source.getActionCommand().equals("Import")) {
            this.thePanel.fileEvent(81);
        } else if (source.getActionCommand().equals("Close")) {
            this.thePanel.fileEvent(78);
        } else if (source.getActionCommand().equals("Save")) {
            this.thePanel.fileEvent(72);
        } else if (source.getActionCommand().equals("Save_as")) {
            this.thePanel.fileEvent(73);
        } else if (source.getActionCommand().equals("Export")) {
            this.thePanel.fileEvent(75);
        } else if (source.getActionCommand().equals("Print")) {
            this.thePanel.fileEvent(76);
        } else if (source.getActionCommand().equals("Quit")) {
            this.thePanel.fileEvent(44);
        } else {
            boolean xml = this.checkFileExtension(source.getName());
            if (xml) {
                JaxoGraph ng = JaxoIO.open(source.getName());
                if (ng != null) {
                    this.reorderRFPanel(source.getName(), true);
                    this.open(ng);
                } else {
                    this.reorderRFPanel(source.getName(), false);
                }
            } else {
                JaxoGraph ng = JaxoIO.importLatex(source.getName());
                if (ng != null) {
                    this.reorderRFPanel(source.getName(), true);
                    this.open(ng);
                } else {
                    this.reorderRFPanel(source.getName(), false);
                }
            }
        }
    }

    public final void aNewG() {
        JaxoGraph graph = this.thePanel.getCanvas().getCanvasGraph();
        boolean listIsEmpty = graph.getObjectList().isEmpty();
        if (!listIsEmpty) {
            String s1 = this.language.getString("Continue");
            String s2 = this.language.getString("Cancel");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(null, this.language.getString("All_drawn_objects_will_be_destroyed!_Continue?"), this.language.getString("Warning"), 0, 3, null, options, s1);
            if (n == 0) {
                this.thePanel.getCanvas().saveBackupImage();
                graph.setBackupSelectedObject(graph.getSelectedObject());
                graph.setBackupList(graph.copyFrom(graph.getObjectList()));
                graph.clearAll();
                this.thePanel.getCanvas().clearOffScreenImage();
                graph.setSelectedObject(null);
                this.thePanel.setFlagPanelFileName("");
                this.thePanel.repaintCanvas();
            }
        } else {
            this.thePanel.getCanvas().saveBackupImage();
            graph.setBackupSelectedObject(graph.getSelectedObject());
            graph.setBackupList(graph.copyFrom(graph.getObjectList()));
            graph.clearAll();
            this.thePanel.getCanvas().clearOffScreenImage();
            graph.setSelectedObject(null);
            this.thePanel.setFlagPanelFileName("");
            this.thePanel.repaintCanvas();
        }
    }

    public final void aNewT() {
        JaxoGraph newGraph = new JaxoGraph();
        newGraph.setBackupSelectedObject(null);
        newGraph.setSelectedObject(null);
        JaxoCanvas newCanvas = new JaxoCanvas(this.thePanel);
        newCanvas.setCanvasGraph(newGraph);
        newCanvas.addMouseMotionListener(newCanvas);
        newCanvas.addMouseListener(newCanvas);
        this.thePanel.getCanvasPanel().registerTitle(newCanvas.getCanvasTick());
        newCanvas.setCanvasTick(this.thePanel.getCanvasPanel().getIndexedTitle(newCanvas.getCanvasTick()));
        this.thePanel.getCanvasPanel().add(newCanvas.getCanvasTick(), newCanvas).setName(this.language.getString("Untitled"));
        this.thePanel.getCanvasPanel().setSelectedComponent(newCanvas);
        if (this.thePanel.isMiscMode()) {
            if (this.thePanel.getMode() > 33) {
                newCanvas.setCursor(Cursor.getPredefinedCursor(2));
            }
        } else if (this.thePanel.isEditMode()) {
            if (this.thePanel.getMode() < 53) {
                newCanvas.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                newCanvas.setCursor(Cursor.getPredefinedCursor(12));
            }
        }
        newCanvas.clearOffScreenImage();
        this.thePanel.updateZoom();
    }

    public final void open() {
        JaxoGraph newGraph = JaxoIO.open();
        this.open(newGraph);
    }

    public final void opendata() {
        JFileChooser fileChooser = CommonGUI.openDataFileChooser(this);
        int ret = fileChooser.showDialog(this, "Open Data file");
        if (ret == 0) {
            BrowserData br = new BrowserData(fileChooser.getSelectedFile().getAbsolutePath(), null);
            this.thePanel.fillBrowser(br.getMap());
        }
    }

    public final void importLatex() {
        JaxoGraph newGraph = JaxoIO.importLatex();
        this.open(newGraph);
    }

    public final void close() {
        JaxoCanvas theCanvas = this.thePanel.getCanvas();
        int index = this.thePanel.getCanvasPanel().indexOfComponent(theCanvas);
        if (this.thePanel.getCanvasPanel().getTabCount() > 1) {
            if (theCanvas.getCanvasGraph().isSaved()) {
                this.thePanel.getCanvasPanel().removeTitle(index, this.thePanel.getCanvasPanel().getComponentAt(index).getName());
                this.thePanel.getCanvasPanel().remove(theCanvas);
            } else {
                String s1 = this.language.getString("Yes");
                String s2 = this.language.getString("No");
                String s3 = this.language.getString("Save_and_close");
                Object[] options = new Object[]{s1, s2, s3};
                int n = JOptionPane.showOptionDialog(null, this.language.getString("Graph").concat(theCanvas.getCanvasTick().concat(this.language.getString("_has_been_modified!"))) + this.language.getString("_Close_anyway?"), this.language.getString("Close_Confirmation"), -1, 3, null, options, null);
                switch (n) {
                    case 0: {
                        this.thePanel.getCanvasPanel().removeTitle(index, this.thePanel.getCanvasPanel().getComponentAt(index).getName());
                        this.thePanel.getCanvasPanel().remove(theCanvas);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.save();
                        this.thePanel.getCanvasPanel().removeTitle(index, this.thePanel.getCanvasPanel().getComponentAt(index).getName());
                        this.thePanel.getCanvasPanel().remove(theCanvas);
                        break;
                    }
                }
            }
        } else if (theCanvas.getCanvasGraph().isSaved()) {
            this.thePanel.getCanvasPanel().removeTitle(index, this.thePanel.getCanvasPanel().getComponentAt(index).getName());
            this.thePanel.fileEvent(80);
            this.thePanel.getCanvasPanel().remove(theCanvas);
        } else {
            String s1 = this.language.getString("Yes");
            String s2 = this.language.getString("No");
            String s3 = this.language.getString("Save_and_close");
            Object[] options = new Object[]{s1, s2, s3};
            int n = JOptionPane.showOptionDialog(null, this.language.getString("Graph").concat(theCanvas.getCanvasTick().concat(this.language.getString("_has_been_modified!"))) + this.language.getString("_Close_anyway?"), this.language.getString("Close_Confirmation"), -1, 3, null, options, null);
            switch (n) {
                case 0: {
                    this.thePanel.getCanvasPanel().removeTitle(index, this.thePanel.getCanvasPanel().getComponentAt(index).getName());
                    this.thePanel.fileEvent(80);
                    this.thePanel.getCanvasPanel().remove(theCanvas);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.save();
                    this.thePanel.getCanvasPanel().removeTitle(index, this.thePanel.getCanvasPanel().getComponentAt(index).getName());
                    this.thePanel.fileEvent(80);
                    this.thePanel.getCanvasPanel().remove(theCanvas);
                    break;
                }
            }
        }
        if (!theCanvas.getCanvasGraph().getSaveFileName().equals("")) {
            this.thePanel.setFlagPanelFileName(this.thePanel.getCanvas().getCanvasGraph().getSaveFileName());
        }
    }

    public final void save() {
        JaxoCanvas theCanvas = this.thePanel.getCanvas();
        String currentTab = this.thePanel.getCanvasPanel().getSelectedComponent().getName();
        JaxoIO.save(theCanvas.getCanvasGraph(), currentTab);
        if (theCanvas.getCanvasGraph().getSaveFileName().length() != 0) {
            this.addRecentFile(theCanvas.getCanvasGraph());
            this.thePanel.getCanvasPanel().removeTitle(this.thePanel.getCanvasPanel().indexOfComponent(theCanvas), this.thePanel.getCanvasPanel().getComponentAt(this.thePanel.getCanvasPanel().indexOfComponent(theCanvas)).getName());
            this.thePanel.getCanvasPanel().getComponentAt(this.thePanel.getCanvasPanel().indexOfComponent(theCanvas)).setName(this.removeExtension(theCanvas.getCanvasGraph().getShortName()));
            this.thePanel.getCanvasPanel().registerTitle(this.removeExtension(theCanvas.getCanvasGraph().getShortName()));
            theCanvas.setCanvasTick(this.thePanel.getCanvasPanel().getIndexedTitle(this.removeExtension(theCanvas.getCanvasGraph().getShortName())));
            this.thePanel.getCanvasPanel().setTitleAt(this.thePanel.getCanvasPanel().indexOfComponent(theCanvas), theCanvas.getCanvasTick());
            this.thePanel.getCanvasPanel().removeModifiedIcon(this.thePanel.getCanvasPanel().indexOfComponent(theCanvas));
        } else {
            this.thePanel.getCanvasPanel().setTitleAt(this.thePanel.getCanvasPanel().indexOfComponent(theCanvas), theCanvas.getCanvasTick());
        }
        this.thePanel.setFlagPanelFileName(theCanvas.getCanvasGraph().getSaveFileName());
    }

    public final void saveAs() {
        JaxoCanvas theCanvas = this.thePanel.getCanvas();
        String currentTab = this.thePanel.getCanvasPanel().getSelectedComponent().getName();
        JaxoIO.saveAs(theCanvas.getCanvasGraph(), currentTab);
        this.thePanel.setFlagPanelFileName(theCanvas.getCanvasGraph().getSaveFileName());
        if (theCanvas.getCanvasGraph().getSaveFileName().length() != 0) {
            this.addRecentFile(theCanvas.getCanvasGraph());
            this.thePanel.getCanvasPanel().removeTitle(this.thePanel.getCanvasPanel().indexOfComponent(theCanvas), this.thePanel.getCanvasPanel().getComponentAt(this.thePanel.getCanvasPanel().indexOfComponent(theCanvas)).getName());
            this.thePanel.getCanvasPanel().getComponentAt(this.thePanel.getCanvasPanel().indexOfComponent(theCanvas)).setName(this.removeExtension(theCanvas.getCanvasGraph().getShortName()));
            this.thePanel.getCanvasPanel().registerTitle(this.removeExtension(theCanvas.getCanvasGraph().getShortName()));
            theCanvas.setCanvasTick(this.thePanel.getCanvasPanel().getIndexedTitle(this.removeExtension(theCanvas.getCanvasGraph().getShortName())));
            this.thePanel.getCanvasPanel().setTitleAt(this.thePanel.getCanvasPanel().indexOfComponent(theCanvas), theCanvas.getCanvasTick());
            this.thePanel.getCanvasPanel().removeModifiedIcon(this.thePanel.getCanvasPanel().indexOfComponent(theCanvas));
        }
    }

    public final void export() {
        this.thePanel.exportImage();
    }

    public final void print() {
        Dimension d = new Dimension(this.thePanel.getCanvas().getWidth(), this.thePanel.getCanvas().getHeight());
        JaxoPrint p = new JaxoPrint();
        p.print(this.thePanel.getCanvas().getCanvasGraph(), d);
    }

    public final void quit() {
        boolean allSaved = true;
        for (int i = 0; i < this.thePanel.getCanvasPanel().getTabCount(); ++i) {
            if (((JaxoCanvas)this.thePanel.getCanvasPanel().getComponentAt(i)).getCanvasGraph().isSaved()) continue;
            allSaved = false;
            break;
        }
        if (allSaved) {
            JaxoPrefs.saveRecentFiles();
            this.thePanel.shutdown();
        } else {
            String s1 = this.language.getString("Quit");
            String s2 = this.language.getString("Cancel");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(null, this.language.getString("Do_you_really_want_to_quit?"), this.language.getString("Quit_Confirmation"), 0, 3, null, options, null);
            switch (n) {
                case 0: {
                    JaxoPrefs.saveRecentFiles();
                    this.thePanel.shutdown();
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    private String removeExtension(String fileName) {
        int lp = fileName.lastIndexOf(".");
        if (lp != -1) {
            return fileName.substring(0, lp);
        }
        return fileName;
    }

    private boolean checkFileExtension(String fileName) {
        boolean xml = true;
        int lp = fileName.lastIndexOf(".");
        if (fileName.substring(lp + 1, fileName.length()).equals("tex")) {
            xml = false;
        }
        return xml;
    }

    public void open(JaxoGraph graph) {
        if (graph != null) {
            if (this.thePanel.getCanvas().hasBeenUsed() || this.thePanel.getCanvas().getCanvasGraph().getShortName().length() > 0) {
                JaxoCanvas newCanvasTab = new JaxoCanvas(this.thePanel);
                newCanvasTab.setCanvasGraph(graph);
                newCanvasTab.addMouseMotionListener(newCanvasTab);
                newCanvasTab.addMouseListener(newCanvasTab);
                for (int i = 0; i < graph.listSize(); ++i) {
                    JaObject jaxoOb = graph.listElementAt(i);
                    if (!(jaxoOb instanceof JaLatexText)) continue;
                    ((JaLatexText)jaxoOb).createLatexPanel();
                    newCanvasTab.add(((JaLatexText)jaxoOb).getLatexPanel());
                    ((JaLatexText)jaxoOb).getLatexPanel().setVisible(false);
                }
                this.thePanel.getCanvasPanel().add(this.removeExtension(graph.getShortName()), newCanvasTab).setName(this.removeExtension(graph.getShortName()));
                this.thePanel.getCanvasPanel().registerTitle(this.removeExtension(newCanvasTab.getCanvasGraph().getShortName()));
                newCanvasTab.setCanvasTick(this.thePanel.getCanvasPanel().getIndexedTitle(this.removeExtension(newCanvasTab.getCanvasGraph().getShortName())));
                this.thePanel.getCanvasPanel().setTitleAt(this.thePanel.getCanvasPanel().indexOfComponent(newCanvasTab), newCanvasTab.getCanvasTick());
                this.thePanel.getCanvasPanel().setSelectedComponent(newCanvasTab);
                this.thePanel.setFlagPanelFileName(graph.getSaveFileName());
            } else {
                JaxoCanvas oldCanvasTab = (JaxoCanvas)this.thePanel.getCanvasPanel().getSelectedComponent();
                this.thePanel.getCanvasPanel().removeTitle(this.thePanel.getCanvasPanel().indexOfComponent(oldCanvasTab), this.thePanel.getCanvasPanel().getComponentAt(this.thePanel.getCanvasPanel().indexOfComponent(oldCanvasTab)).getName());
                JaxoCanvas newCanvasTab = new JaxoCanvas(this.thePanel);
                newCanvasTab.setCanvasGraph(graph);
                newCanvasTab.addMouseMotionListener(newCanvasTab);
                newCanvasTab.addMouseListener(newCanvasTab);
                this.thePanel.getCanvasPanel().add(this.removeExtension(graph.getShortName()), newCanvasTab).setName(this.removeExtension(graph.getShortName()));
                for (int i = 0; i < graph.listSize(); ++i) {
                    JaObject jaxoOb = graph.listElementAt(i);
                    if (!(jaxoOb instanceof JaLatexText)) continue;
                    ((JaLatexText)jaxoOb).createLatexPanel();
                    newCanvasTab.add(((JaLatexText)jaxoOb).getLatexPanel());
                    ((JaLatexText)jaxoOb).getLatexPanel().setVisible(false);
                }
                this.thePanel.getCanvasPanel().registerTitle(this.removeExtension(newCanvasTab.getCanvasGraph().getShortName()));
                newCanvasTab.setCanvasTick(this.thePanel.getCanvasPanel().getIndexedTitle(this.removeExtension(newCanvasTab.getCanvasGraph().getShortName())));
                this.thePanel.getCanvasPanel().setTitleAt(this.thePanel.getCanvasPanel().indexOfComponent(newCanvasTab), newCanvasTab.getCanvasTick());
                this.thePanel.getCanvasPanel().remove(oldCanvasTab);
                this.thePanel.setFlagPanelFileName(graph.getSaveFileName());
            }
            JaxoCanvas newCanvas = this.thePanel.getCanvas();
            if (this.thePanel.isEditMode()) {
                if (this.thePanel.getMode() < 53) {
                    newCanvas.setCursor(Cursor.getPredefinedCursor(1));
                } else {
                    newCanvas.setCursor(Cursor.getPredefinedCursor(12));
                }
                newCanvas.drawWithHandles(true);
                newCanvas.drawVisualAid(false);
                this.thePanel.getEbtPanel().pressButton(this.thePanel.getEbtPanel().getIndex(this.thePanel.getMode()));
            } else if (this.thePanel.isParticleMode()) {
                this.thePanel.getPbtPanel().pressButton(this.thePanel.getPbtPanel().getIndex(this.thePanel.getMode()));
                newCanvas.drawWithHandles(false);
                newCanvas.drawVisualAid(false);
            } else if (this.thePanel.isMiscMode()) {
                if (this.thePanel.getMode() > 33) {
                    newCanvas.setCursor(Cursor.getPredefinedCursor(2));
                }
                this.thePanel.getMbtPanel().pressButton(this.thePanel.getMbtPanel().getIndex(this.thePanel.getMode()));
                newCanvas.drawWithHandles(false);
                newCanvas.drawVisualAid(false);
            }
            this.thePanel.reset();
        }
    }

    private void addRecentFile(JaxoGraph newGraph) {
        int i;
        JMenuItem mi = new JMenuItem(newGraph.getShortName());
        mi.setName(newGraph.getSaveFileName());
        boolean maxReached = false;
        boolean notthere = true;
        for (i = 0; i < this.recentList.size(); ++i) {
            String name = ((JMenuItem)this.recentList.get(i)).getText();
            int p = name.indexOf(". ");
            if (p != -1) {
                name = name.substring(p + 2, name.length());
            }
            if (!mi.getText().equals(name)) continue;
            notthere = false;
            break;
        }
        if (notthere) {
            this.recentList.add(0, mi);
            this.copyRecentArray();
            if (this.recentList.size() > 4) {
                maxReached = true;
                for (i = 4; i < this.recentList.size(); ++i) {
                    this.recentList.remove(i);
                }
            }
            for (i = 0; i < this.recentList.size(); ++i) {
                Integer in = new Integer(i + 1);
                String name = ((JMenuItem)this.recentList.get(i)).getText();
                int p = name.indexOf(". ");
                if (p != -1) {
                    name = name.substring(p + 2, name.length());
                }
                ((JMenuItem)this.recentList.get(i)).setText((in.toString() + ". ").concat(name));
                ((JMenuItem)this.recentList.get(i)).removeActionListener(this);
                ((JMenuItem)this.recentList.get(i)).addActionListener(this);
                ((JMenuItem)this.recentList.get(i)).setAccelerator(KeyStroke.getKeyStroke(this.keyList[i], this.keyMask));
                this.add((Component)((JMenuItem)this.recentList.get(i)), 10 + i);
            }
            if (maxReached) {
                this.remove(this.getItemCount() - 3);
            }
        }
    }

    private void copyRecentArray() {
        for (int j = 0; j < 4; ++j) {
            if (j < this.recentList.size()) {
                JaxoPrefs.setRecentFile(j, ((JMenuItem)this.recentList.get(j)).getName());
                continue;
            }
            JaxoPrefs.setRecentFile(j, "");
        }
    }

    private String getBaseName(String absPath) {
        int last = absPath.lastIndexOf(File.separator);
        return absPath.substring(last + 1);
    }

    private void addRecentFiles() {
        String recentFile = "";
        for (int j = 3; j >= 0; --j) {
            recentFile = JaxoPrefs.getRecentFile(j);
            if (recentFile.length() <= 0) continue;
            JMenuItem mi = new JMenuItem(this.getBaseName(recentFile));
            mi.setName(recentFile);
            this.recentList.add(0, mi);
            for (int i = 0; i < this.recentList.size(); ++i) {
                Integer in = new Integer(i + 1);
                String name = ((JMenuItem)this.recentList.get(i)).getText();
                int p = name.indexOf(". ");
                if (p != -1) {
                    name = name.substring(p + 2, name.length());
                }
                ((JMenuItem)this.recentList.get(i)).setText((in.toString() + ". ").concat(name));
                ((JMenuItem)this.recentList.get(i)).removeActionListener(this);
                ((JMenuItem)this.recentList.get(i)).addActionListener(this);
                ((JMenuItem)this.recentList.get(i)).setAccelerator(KeyStroke.getKeyStroke(this.keyList[i], this.keyMask));
                this.add((Component)((JMenuItem)this.recentList.get(i)), 10 + i);
            }
        }
    }

    private void reorderRFPanel(String file, boolean found) {
        int i;
        String sName = this.getBaseName(file);
        int index = 10;
        for (i = 0; i < this.recentList.size(); ++i) {
            String name = ((JMenuItem)this.recentList.get(i)).getText();
            int p = name.indexOf(". ");
            if (p != -1) {
                name = name.substring(p + 2, name.length());
            }
            if (!name.equals(sName)) continue;
            this.recentList.remove(i);
            index += i;
            break;
        }
        this.remove(index);
        if (found) {
            JMenuItem mi = new JMenuItem(sName);
            mi.setName(file);
            this.recentList.add(0, mi);
        }
        for (i = 0; i < this.recentList.size(); ++i) {
            Integer in = new Integer(i + 1);
            String name = ((JMenuItem)this.recentList.get(i)).getText();
            int p = name.indexOf(". ");
            if (p != -1) {
                name = name.substring(p + 2, name.length());
            }
            ((JMenuItem)this.recentList.get(i)).setText((in.toString() + ". ").concat(name));
            ((JMenuItem)this.recentList.get(i)).removeActionListener(this);
            ((JMenuItem)this.recentList.get(i)).addActionListener(this);
            ((JMenuItem)this.recentList.get(i)).setAccelerator(KeyStroke.getKeyStroke(this.keyList[i], this.keyMask));
            this.add((Component)((JMenuItem)this.recentList.get(i)), 10 + i);
        }
        this.copyRecentArray();
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        super.setText(this.language.getString("File"));
        this.newM.setText(this.language.getString("New"));
        this.newGraphMI.setText(this.language.getString("New_graph"));
        this.newGraphTabMI.setText(this.language.getString("New_tab"));
        this.opendataMI.setText(this.language.getString("Opendata"));
        this.closeMI.setText(this.language.getString("Close"));
        this.exportMI.setText(this.language.getString("Export"));
        this.quitMI.setText(this.language.getString("Quit"));
    }
}

