/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JaxoEditButtons
extends JPanel
implements ActionListener {
    private static final String[] EDIT_BUTTON_ICONS = new String[]{"japlot/jaxodraw/icons/move.png", "japlot/jaxodraw/icons/resize.png", "japlot/jaxodraw/icons/copy.png", "japlot/jaxodraw/icons/color.png", "japlot/jaxodraw/icons/edit.png", "japlot/jaxodraw/icons/delete.png", "japlot/jaxodraw/icons/back.png", "japlot/jaxodraw/icons/fore.png", "japlot/jaxodraw/icons/group.png", "japlot/jaxodraw/icons/ungroup.png", "japlot/jaxodraw/icons/empty.png", "japlot/jaxodraw/icons/empty.png"};
    private static final int[] EDIT_MODES = new int[]{50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 10000, 10001};
    private JaxoMainPanel thePanel;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private int enbts = 12;
    private JButton[] editButtons = new JButton[this.enbts];
    private String[] editFlagModes = new String[]{this.language.getString("Move"), this.language.getString("Resize"), this.language.getString("Copy"), this.language.getString("Color"), this.language.getString("Edit"), this.language.getString("Delete"), this.language.getString("Background"), this.language.getString("Foreground"), this.language.getString("group"), this.language.getString("Ungroup"), "?1", "?2"};
    private String[] editTips = new String[]{this.language.getString("Move_an_object"), this.language.getString("Resize_an_object"), this.language.getString("Copy_an_object"), this.language.getString("Color_an_object"), this.language.getString("Edit_an_object"), this.language.getString("Delete_an_object"), this.language.getString("Put_an_object_in_the_background"), this.language.getString("Put_an_object_in_the_foreground"), this.language.getString("Group_objects"), this.language.getString("Ungroup_objects"), "", ""};
    private Border raisedetched = BorderFactory.createEtchedBorder(0);
    private Border raisedbevel = BorderFactory.createRaisedBevelBorder();
    private Border loweredbevel = BorderFactory.createLoweredBevelBorder();

    public JaxoEditButtons(JaxoMainPanel mainPanel) {
        this.thePanel = mainPanel;
        JPanel editButtonPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        editButtonPanel.setLayout(gridbag);
        for (int i = 0; i < this.enbts; ++i) {
            this.editButtons[i] = new JButton();
            this.editButtons[i].setIcon(new ImageIcon(JaxoEditButtons.class.getClassLoader().getResource(EDIT_BUTTON_ICONS[i])));
            this.editButtons[i].setToolTipText(this.editTips[i]);
            this.editButtons[i].addActionListener(this);
            this.editButtons[i].setMinimumSize(new Dimension(40, 40));
            this.editButtons[i].setPreferredSize(new Dimension(40, 40));
            this.editButtons[i].setBorder(this.raisedbevel);
            this.editButtons[i].setFocusPainted(false);
        }
        for (int j = 0; j < this.enbts / 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                c.gridx = i;
                c.gridy = j;
                gridbag.setConstraints(this.editButtons[i + 3 * j], c);
                editButtonPanel.add(this.editButtons[i + 3 * j]);
            }
        }
        this.editButtons[10].setEnabled(false);
        this.editButtons[11].setEnabled(false);
        JPanel finalEditButtonPanel = new JPanel();
        finalEditButtonPanel.setLayout(new BorderLayout());
        finalEditButtonPanel.setBorder(this.raisedetched);
        finalEditButtonPanel.add((Component)editButtonPanel, "Center");
        this.setLayout(new GridLayout(0, 1));
        this.add(finalEditButtonPanel);
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.enbts; ++i) {
            if (evt.getSource() != this.editButtons[i]) continue;
            this.thePanel.editEvent(EDIT_MODES[i]);
        }
    }

    public final void reset() {
        for (int i = 0; i < this.enbts; ++i) {
            this.setButtonBorder(i, this.raisedbevel);
            this.setButtonBackground(i, null);
            this.editButtons[i].setFocusPainted(false);
        }
    }

    public final int getIndex(int i) {
        int j = this.enbts + 1;
        for (int jj = 0; jj < this.enbts; ++jj) {
            if (i != EDIT_MODES[jj]) continue;
            j = jj;
        }
        return j;
    }

    public final void pressButton(int j) {
        this.setButtonBackground(j, new Color(170, 170, 180));
        this.setButtonBorder(j, this.loweredbevel);
        this.editButtons[j].setFocusPainted(false);
    }

    public final String getEditFlagModes(int i) {
        return this.editFlagModes[i];
    }

    public final int getenbts() {
        return this.enbts;
    }

    public final void setButtonBackground(int i, Color bgColor) {
        this.editButtons[i].setBackground(bgColor);
    }

    public final void setButtonBorder(int i, Border border) {
        this.editButtons[i].setBorder(border);
    }

    public final void clickButton(int i) {
        this.editButtons[i].doClick();
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        this.editFlagModes[0] = this.language.getString("Move");
        this.editFlagModes[1] = this.language.getString("Resize");
        this.editFlagModes[2] = this.language.getString("Copy");
        this.editFlagModes[3] = this.language.getString("Color");
        this.editFlagModes[4] = this.language.getString("Edit");
        this.editFlagModes[5] = this.language.getString("Delete");
        this.editFlagModes[6] = this.language.getString("Background");
        this.editFlagModes[7] = this.language.getString("Foreground");
        this.editFlagModes[8] = this.language.getString("group");
        this.editFlagModes[9] = this.language.getString("Ungroup");
        this.editTips[0] = this.language.getString("Move_an_object");
        this.editTips[1] = this.language.getString("Resize_an_object");
        this.editTips[2] = this.language.getString("Copy_an_object");
        this.editTips[3] = this.language.getString("Color_an_object");
        this.editTips[4] = this.language.getString("Edit_an_object");
        this.editTips[5] = this.language.getString("Delete_an_object");
        this.editTips[6] = this.language.getString("Put_an_object_in_the_background");
        this.editTips[7] = this.language.getString("Put_an_object_in_the_foreground");
        this.editTips[8] = this.language.getString("Group_objects");
        this.editTips[9] = this.language.getString("Ungroup_objects");
        for (int i = 0; i < this.enbts - 1; ++i) {
            this.editButtons[i].setToolTipText(this.editTips[i]);
        }
    }
}

