/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoCanvas;
import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;

public class JaxoCanvasPopupMenu
extends JPopupMenu
implements ActionListener,
MouseListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaxoMainPanel thePanel;
    private JMenuItem newTabMI;
    private JMenuItem renameMI;
    private JMenuItem refreshMI;
    private JMenuItem clearMI;
    private JMenuItem closeTabMI;
    private JMenuItem pasteMI;
    private JMenuItem gridSizeMI;
    private JMenu gridM;
    private JRadioButtonMenuItem gridBType1;
    private JRadioButtonMenuItem gridBType2;
    private ButtonGroup gridGroup;
    private int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private int xPos = 0;
    private int yPos = 0;

    public JaxoCanvasPopupMenu(JaxoMainPanel mainPanel) {
        this.thePanel = mainPanel;
        this.newTabMI = new JMenuItem(this.language.getString("New_tab"));
        this.newTabMI.addActionListener(this);
        this.newTabMI.setActionCommand("New");
        this.newTabMI.setAccelerator(KeyStroke.getKeyStroke(84, this.keyMask));
        this.renameMI = new JMenuItem(this.language.getString("Rename_tab"));
        this.renameMI.addActionListener(this);
        this.renameMI.addMouseListener(this);
        this.renameMI.setActionCommand("Rename");
        this.refreshMI = new JMenuItem(this.language.getString("Refresh"));
        this.refreshMI.addActionListener(this);
        this.refreshMI.setActionCommand("Refresh");
        this.refreshMI.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.clearMI = new JMenuItem(this.language.getString("Clear"));
        this.clearMI.addActionListener(this);
        this.clearMI.setActionCommand("Clear");
        this.clearMI.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.pasteMI = new JMenuItem(this.language.getString("Paste"));
        this.pasteMI.addActionListener(this);
        this.pasteMI.setActionCommand("Paste");
        this.pasteMI.setAccelerator(KeyStroke.getKeyStroke(86, 8));
        this.gridSizeMI = new JMenuItem(this.language.getString("Grid_size"));
        this.gridSizeMI.addActionListener(this);
        this.gridSizeMI.addMouseListener(this);
        this.gridSizeMI.setActionCommand("Grid size");
        this.gridM = new JMenu(this.language.getString("Grid_type"));
        this.gridGroup = new ButtonGroup();
        this.gridBType1 = new JRadioButtonMenuItem(this.language.getString("Rectangular"));
        this.gridBType1.addActionListener(this);
        this.gridBType1.setActionCommand("Rectangular");
        this.gridBType2 = new JRadioButtonMenuItem(this.language.getString("Hexagonal"));
        this.gridBType2.addActionListener(this);
        this.gridBType2.setActionCommand("Hexagonal");
        this.gridGroup.add(this.gridBType1);
        this.gridGroup.add(this.gridBType2);
        this.gridM.add(this.gridBType1);
        this.gridM.add(this.gridBType2);
        this.closeTabMI = new JMenuItem(this.language.getString("Close"));
        this.closeTabMI.addActionListener(this);
        this.closeTabMI.setActionCommand("Close");
        this.closeTabMI.setAccelerator(KeyStroke.getKeyStroke(88, this.keyMask));
        this.add(this.newTabMI);
        this.add(this.renameMI);
        this.addSeparator();
        this.add(this.gridSizeMI);
        this.add(this.gridM);
        this.addSeparator();
        this.add(this.refreshMI);
        this.add(this.clearMI);
        this.add(this.pasteMI);
        this.addSeparator();
        this.add(this.closeTabMI);
    }

    public final void setGridType() {
        if (this.thePanel.getCanvas().getGridType()) {
            this.gridBType2.setSelected(true);
        } else {
            this.gridBType1.setSelected(true);
        }
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        AbstractButton source = (AbstractButton)evt.getSource();
        JaxoCanvas theCanvas = this.thePanel.getCanvas();
        if (source.getActionCommand().equals("New")) {
            this.thePanel.fileEvent(80);
        } else if (source.getActionCommand().equals("Rename")) {
            this.renameTab(theCanvas);
        } else if (source.getActionCommand().equals("Grid size")) {
            this.setGridSize(theCanvas);
        } else if (source.getActionCommand().equals("Rectangular")) {
            theCanvas.setGridType(false);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            double[] newbb = new double[]{5.0, 5.0, d.width, d.height};
            theCanvas.setOldbb(newbb);
            theCanvas.updateOffScreenImage();
        } else if (source.getActionCommand().equals("Hexagonal")) {
            this.thePanel.getCanvas().setGridType(true);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            double[] newbb = new double[]{5.0, 5.0, d.width, d.height};
            theCanvas.setOldbb(newbb);
            theCanvas.updateOffScreenImage();
        } else if (source.getActionCommand().equals("Refresh")) {
            this.thePanel.actionEvent(45);
        } else if (source.getActionCommand().equals("Clear")) {
            this.thePanel.actionEvent(43);
        } else if (source.getActionCommand().equals("Paste")) {
            this.thePanel.actionEvent(46);
        } else if (source.getActionCommand().equals("Close")) {
            this.thePanel.fileEvent(78);
        }
    }

    private void renameTab(JaxoCanvas canvas) {
        String newTabName = this.getNewTabName(canvas.getCanvasTick());
        if (newTabName.length() != 0 && !newTabName.equals(canvas.getCanvasTick())) {
            this.thePanel.getCanvasPanel().removeTitle(this.thePanel.getCanvasPanel().indexOfComponent(canvas), this.thePanel.getCanvasPanel().getComponentAt(this.thePanel.getCanvasPanel().indexOfComponent(canvas)).getName());
            this.thePanel.getCanvasPanel().getComponentAt(this.thePanel.getCanvasPanel().indexOfComponent(canvas)).setName(newTabName);
            this.thePanel.getCanvasPanel().registerTitle(newTabName);
            canvas.setCanvasTick(this.thePanel.getCanvasPanel().getIndexedTitle(newTabName));
            this.thePanel.getCanvasPanel().setTitleAt(this.thePanel.getCanvasPanel().indexOfComponent(canvas), canvas.getCanvasTick());
        }
    }

    private String getNewTabName(String oldName) {
        String text = "";
        String msg1 = this.language.getString("Please_enter_the_new_tab_name");
        JTextField textField = new JTextField(oldName, 20);
        Object[] array = new Object[]{msg1, textField};
        String btn1 = this.language.getString("OK");
        String btn2 = this.language.getString("Cancel");
        Object[] options = new Object[]{btn1, btn2};
        JOptionPane jPane = new JOptionPane(array, -1, 2, null, options, btn1);
        JDialog dialog = jPane.createDialog(this, this.language.getString("Grid_size"));
        Dimension dialogSize = dialog.getSize();
        dialog.setLocation(this.xPos + dialogSize.width / 4, this.yPos + dialogSize.height / 2);
        dialog.setVisible(true);
        Object selectedValue = jPane.getValue();
        int n = 0;
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            n = counter;
        }
        if (n == 0) {
            text = textField.getText();
        }
        return text;
    }

    private void setGridSize(JaxoCanvas canvas) {
        int oldSize = canvas.getGridSize();
        int newSize = this.getNewGridSize(oldSize);
        if (newSize != oldSize) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            double[] newbb = new double[]{5.0, 5.0, d.width, d.height};
            canvas.setGridSize(newSize);
            canvas.setOldbb(newbb);
            canvas.updateOffScreenImage();
        }
    }

    private int getNewGridSize(int os) {
        int newSize = os;
        JPanel pgrid = new JPanel();
        pgrid.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelgrid = new SpinnerNumberModel(os, 1, 75, 1);
        JLabel lgrid = new JLabel(this.language.getString("Size_:") + " ", 4);
        pgrid.add(lgrid);
        JSpinner spgrid = new JSpinner(modelgrid);
        pgrid.add(spgrid);
        JPanel gridSizePanel = new JPanel();
        gridSizePanel.add(pgrid);
        String btn1 = this.language.getString("OK");
        String btn2 = this.language.getString("Cancel");
        Object[] options = new Object[]{btn1, btn2};
        JOptionPane jPane = new JOptionPane(gridSizePanel, -1, 2, null, options, btn1);
        JDialog dialog = jPane.createDialog(this, this.language.getString("Grid_size"));
        dialog.setLocation(this.xPos, this.yPos);
        dialog.setVisible(true);
        Object selectedValue = jPane.getValue();
        int n = 0;
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            n = counter;
        }
        if (n == 0) {
            newSize = modelgrid.getNumber().intValue();
        }
        return newSize;
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        this.newTabMI.setText(this.language.getString("New_tab"));
        this.clearMI.setText(this.language.getString("Clear"));
        this.refreshMI.setText(this.language.getString("Refresh"));
        this.renameMI.setText(this.language.getString("Rename_tab"));
        this.pasteMI.setText(this.language.getString("Paste"));
        this.closeTabMI.setText(this.language.getString("Close"));
        this.gridSizeMI.setText(this.language.getString("Grid_size"));
        this.gridM.setText(this.language.getString("Grid_type"));
        this.gridBType1.setText(this.language.getString("Rectangular"));
        this.gridBType2.setText(this.language.getString("Hexagonal"));
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        Point tapLocation = this.getLocationOnScreen();
        this.xPos = tapLocation.x;
        this.yPos = tapLocation.y;
    }

    @Override
    public final void mouseExited(MouseEvent e) {
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
    }
}

