/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColor;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;
import jhplot.jadraw.JaBlob;
import jhplot.jadraw.JaBox;
import jhplot.jadraw.JaFArc;
import jhplot.jadraw.JaFLine;
import jhplot.jadraw.JaFLoop;
import jhplot.jadraw.JaGArc;
import jhplot.jadraw.JaGLine;
import jhplot.jadraw.JaGLoop;
import jhplot.jadraw.JaGlArc;
import jhplot.jadraw.JaGlLine;
import jhplot.jadraw.JaGlLoop;
import jhplot.jadraw.JaLatexText;
import jhplot.jadraw.JaLineObject;
import jhplot.jadraw.JaObject;
import jhplot.jadraw.JaPArc;
import jhplot.jadraw.JaPLine;
import jhplot.jadraw.JaPLoop;
import jhplot.jadraw.JaSArc;
import jhplot.jadraw.JaSLine;
import jhplot.jadraw.JaSLoop;
import jhplot.jadraw.JaVertexT1;
import jhplot.jadraw.JaVertexT2;
import jhplot.jadraw.JaVertexT3;
import jhplot.jadraw.JaVertexT4;
import jhplot.jadraw.JaVertexT5;
import jhplot.jadraw.JaVertexT6;
import jhplot.jadraw.JaZigZagLine;

public class JaxoAxodraw {
    private static final String[] KNOWN_COMMANDS = new String[]{"\\ArrowArcn", "\\ArrowArc", "\\ArrowLine", "\\CArc", "\\CBox", "\\CCirc", "\\COval", "\\CTri", "\\DashArrowArcn", "\\DashArrowArc", "\\DashArrowLine", "\\DashCArc", "\\DashLine", "\\GBox", "\\GCirc", "\\GlueArc", "\\Gluon", "\\GOval", "\\GTri", "\\Line", "\\PhotonArc", "\\Photon", "\\SetColor", "\\SetWidth", "\\Text", "\\Vertex", "\\ZigZag"};
    private static final int N_OF_COMMANDS = KNOWN_COMMANDS.length;
    private static final String[] REQUIRED_COMMANDS = new String[]{"\\documentclass", "\\begin{document}", "\\begin{picture}"};
    private static final int N_OF_REQUIRED = REQUIRED_COMMANDS.length;
    private final boolean[] isValid = new boolean[3];
    private String string = "";
    private int index = 0;
    private Color color = JaxoColor.BLACK;
    private float stroke = 1.0f;
    private float scaleFactor = 1.0f;
    private String comment = "";
    private float bBoxHeight = 0.0f;
    private ArrayList packageList = new ArrayList(3);

    public JaxoAxodraw() {
        this.packageList.add("axodraw");
        this.packageList.add("color");
    }

    public final JaObject getJaxoObject(String newString) {
        this.string = newString;
        JaObject newob = null;
        boolean valid = this.isValidJaxoCommand(this.string);
        if (!valid) {
            newob = null;
        } else if (this.index == -3) {
            newob = this.newVertexT6();
        } else if (this.index == -2) {
            newob = this.newVertexT4();
        } else if (this.index == -1) {
            newob = this.newVertexT2();
        } else if (this.index == this.getIndex("\\ArrowArcn")) {
            newob = this.newFLoop(true, true);
        } else if (this.index == this.getIndex("\\ArrowArc")) {
            newob = this.newFLoop(false, true);
        } else if (this.index == this.getIndex("\\ArrowLine")) {
            newob = this.newLine(true);
        } else if (this.index == this.getIndex("\\CArc")) {
            newob = this.newFLoop(false, false);
        } else if (this.index == this.getIndex("\\CBox")) {
            newob = this.newCBox();
        } else if (this.index == this.getIndex("\\CCirc")) {
            newob = this.newCCirc();
        } else if (this.index == this.getIndex("\\COval")) {
            newob = this.newCOval();
        } else if (this.index == this.getIndex("\\CTri")) {
            newob = this.newCTri();
        } else if (this.index == this.getIndex("\\DashArrowArcn")) {
            newob = this.newDashArc(true, true);
        } else if (this.index == this.getIndex("\\DashArrowArc")) {
            newob = this.newDashArc(false, true);
        } else if (this.index == this.getIndex("\\DashArrowLine")) {
            newob = this.newDashLine(true);
        } else if (this.index == this.getIndex("\\DashCArc")) {
            newob = this.newDashArc(true, false);
        } else if (this.index == this.getIndex("\\DashLine")) {
            newob = this.newDashLine(false);
        } else if (this.index == this.getIndex("\\GBox")) {
            newob = this.newGBox();
        } else if (this.index == this.getIndex("\\GCirc")) {
            newob = this.newGCirc();
        } else if (this.index == this.getIndex("\\GlueArc")) {
            newob = this.newGlArc();
        } else if (this.index == this.getIndex("\\Gluon")) {
            newob = this.newGlLine();
        } else if (this.index == this.getIndex("\\GOval")) {
            newob = this.newGOval();
        } else if (this.index == this.getIndex("\\GTri")) {
            newob = this.newGTri();
        } else if (this.index == this.getIndex("\\Line")) {
            newob = this.newLine(false);
        } else if (this.index == this.getIndex("\\PhotonArc")) {
            newob = this.newPArc();
        } else if (this.index == this.getIndex("\\Photon")) {
            newob = this.newPLine();
        } else if (this.index == this.getIndex("\\SetColor")) {
            this.color = JaxoColor.getColor(this.getOneCurl(this.string));
        } else if (this.index == this.getIndex("\\SetWidth")) {
            this.stroke = Float.parseFloat(this.getOneCurl(this.string)) * 2.0f;
        } else if (this.index == this.getIndex("\\Text")) {
            newob = this.newText();
        } else if (this.index == this.getIndex("\\Vertex")) {
            newob = this.newVertexT1();
        } else if (this.index == this.getIndex("\\ZigZag")) {
            newob = this.newZigZagLine();
        }
        return newob;
    }

    public final void checkRequired(String newString) {
        this.string = newString;
        if (this.string.startsWith("\\usepackage")) {
            String pack = this.getOneCurl(this.string);
            if (!pack.equals("axodraw") && !pack.equals("color")) {
                this.packageList.add(pack);
            }
        } else if (this.string.startsWith("%%JaxoComment:")) {
            this.comment = this.string.replaceFirst("%%JaxoComment:", "").trim();
        } else if (this.string.startsWith("%%JaxoScale")) {
            this.scaleFactor = Float.parseFloat(this.getOneCurl(this.string));
        } else {
            int i;
            boolean isRequiredCommand = false;
            for (i = 0; !this.string.startsWith(REQUIRED_COMMANDS[i]) && i < N_OF_REQUIRED - 1; ++i) {
            }
            if (i == N_OF_REQUIRED - 1 && !this.string.startsWith(REQUIRED_COMMANDS[i])) {
                ++i;
            }
            boolean bl = isRequiredCommand = i < N_OF_REQUIRED;
            if (isRequiredCommand) {
                this.isValid[i] = true;
                if (i == 2) {
                    int[] pic = this.getFourInts(this.string);
                    this.bBoxHeight = (float)pic[1] * this.scaleFactor;
                }
            }
        }
    }

    public final boolean[] getValid() {
        int length = this.isValid.length;
        boolean[] newArray = new boolean[length];
        System.arraycopy(this.isValid, 0, newArray, 0, length);
        return newArray;
    }

    public final ArrayList getPackages() {
        return this.packageList;
    }

    public final String getComment() {
        return this.comment;
    }

    private boolean isValidJaxoCommand(String s) {
        int i;
        for (i = 0; !s.startsWith(KNOWN_COMMANDS[i]) && i < N_OF_COMMANDS - 1; ++i) {
        }
        if (i == N_OF_COMMANDS - 1 && !s.startsWith(KNOWN_COMMANDS[i])) {
            ++i;
        }
        this.index = i;
        if (i == this.getIndex("\\COval")) {
            if (s.indexOf("\\Line", 6) > 0) {
                this.index = -1;
            }
        } else if (i == this.getIndex("\\Line")) {
            if (s.indexOf("\\Line", 6) > 0 && s.indexOf("%") == -1) {
                this.index = -2;
            }
        } else if (i == this.getIndex("\\CTri") && s.indexOf("\\CTri", 6) > 0) {
            this.index = -3;
        }
        return i < N_OF_COMMANDS;
    }

    private int getIndex(String s) {
        int i;
        for (i = 0; KNOWN_COMMANDS[i].compareTo(s) != 0 && i < N_OF_COMMANDS - 1; ++i) {
        }
        if (KNOWN_COMMANDS[i].compareTo(s) == 0) {
            return i;
        }
        return N_OF_COMMANDS;
    }

    private int[] getLineParams(int[] in, String st) {
        int[] out = new int[4];
        out[2] = Math.round((float)(in[2] - in[0]) * this.scaleFactor);
        out[3] = Math.round((float)(in[1] - in[3]) * this.scaleFactor);
        if (out[2] > 0 && out[3] >= 0) {
            out[0] = Math.round((float)in[0] * this.scaleFactor);
            out[1] = Math.round(this.bBoxHeight - (float)in[1] * this.scaleFactor);
        } else if (out[2] >= 0 && out[3] < 0) {
            out[0] = Math.round((float)in[0] * this.scaleFactor);
            out[1] = Math.round(this.bBoxHeight - (float)in[3] * this.scaleFactor);
        } else if (out[2] <= 0 && out[3] > 0) {
            out[0] = Math.round((float)in[2] * this.scaleFactor);
            out[1] = Math.round(this.bBoxHeight - (float)in[1] * this.scaleFactor);
        } else if (out[2] < 0 && out[3] <= 0) {
            out[0] = Math.round((float)in[2] * this.scaleFactor);
            out[1] = Math.round(this.bBoxHeight - (float)in[3] * this.scaleFactor);
        }
        if (st.indexOf("%") != -1) {
            double theta = Math.atan2((float)(in[1] - in[3]) * this.scaleFactor, (float)(in[2] - in[0]) * this.scaleFactor);
            float dlSep = this.theDLSeparation(st);
            out[0] = (int)Math.round((double)out[0] - (double)dlSep * Math.sin(theta));
            out[1] = (int)Math.round((double)out[1] + (double)dlSep * Math.cos(theta));
        }
        return out;
    }

    private int[] getBoxParams(int[] in) {
        int[] out = new int[4];
        out[2] = Math.round((float)(in[2] - in[0]) * this.scaleFactor);
        out[3] = Math.round((float)(in[3] - in[1]) * this.scaleFactor);
        out[0] = Math.round((float)in[0] * this.scaleFactor);
        out[1] = Math.round(this.bBoxHeight - (float)in[3] * this.scaleFactor);
        return out;
    }

    private int[] getCircParams(int[] in, String rad) {
        int[] out = new int[]{Math.round((float)in[0] * this.scaleFactor), Math.round(this.bBoxHeight - (float)in[1] * this.scaleFactor), Math.round(Float.parseFloat(rad) * this.scaleFactor)};
        return out;
    }

    private int[] getBlobParams(String[] in) {
        int[] out = new int[5];
        out[2] = Math.round(Float.parseFloat(in[2]) * this.scaleFactor);
        out[3] = Math.round(Float.parseFloat(in[3]) * this.scaleFactor);
        out[0] = Math.round(Float.parseFloat(in[0]) * this.scaleFactor);
        out[1] = Math.round(this.bBoxHeight - Float.parseFloat(in[1]) * this.scaleFactor);
        out[4] = Math.round(Float.parseFloat(in[4]));
        return out;
    }

    private int[] getT1Params(String[] st) {
        int[] out = new int[2];
        float x = Float.parseFloat(st[0]);
        float y = Float.parseFloat(st[1]);
        out[0] = Math.round(x * this.scaleFactor);
        out[1] = Math.round(this.bBoxHeight - y * this.scaleFactor);
        return out;
    }

    private int[] getT2Params(String[] st) {
        int[] out = new int[4];
        float radius = Float.parseFloat(st[2]) * this.scaleFactor;
        float angle = (float)Math.toRadians(Float.parseFloat(st[4]));
        float cx = Float.parseFloat(st[0]) * this.scaleFactor;
        float cy = Float.parseFloat(st[1]) * this.scaleFactor;
        out[2] = (int)Math.round((double)radius * Math.sin(angle));
        out[3] = (int)Math.round((double)radius * Math.cos(angle));
        if (out[2] > 0 && out[3] >= 0) {
            out[0] = Math.round(cx);
            out[1] = Math.round(this.bBoxHeight - cy);
        } else if (out[2] >= 0 && out[3] < 0) {
            out[0] = Math.round(cx + (float)out[3]);
            out[1] = Math.round(this.bBoxHeight - cy);
        } else if (out[2] <= 0 && out[3] > 0) {
            out[0] = Math.round(cx);
            out[1] = Math.round(this.bBoxHeight + (float)out[2] - cy);
        } else if (out[2] < 0 && out[3] <= 0) {
            out[0] = Math.round(cx + (float)out[3]);
            out[1] = Math.round(this.bBoxHeight + (float)out[2] - cy);
        }
        return out;
    }

    private int[] getT3Params(int[] in) {
        int[] out = new int[]{Math.round((in[2] + in[0]) / 2), Math.round(this.bBoxHeight - (float)((in[3] + in[1]) / 2)), (int)Math.round((double)Math.abs(in[2] - in[0]) * Math.sin(Math.toRadians(45.0)) / 2.0), (int)Math.round((double)Math.abs(in[2] - in[0]) * Math.cos(Math.toRadians(45.0)) / 2.0)};
        return out;
    }

    private int[] getT4Params(int[] firstl, int[] secondl) {
        int[] out = new int[4];
        out[2] = Math.round((float)(secondl[2] - secondl[0]) * this.scaleFactor / 2.0f);
        out[3] = Math.round((float)(secondl[1] - secondl[3]) * this.scaleFactor / 2.0f);
        if (secondl[2] - secondl[0] > 0 && firstl[2] - firstl[0] > 0) {
            out[0] = Math.round((float)secondl[0] * this.scaleFactor + (float)out[2]);
            out[1] = Math.round(this.bBoxHeight - (float)secondl[1] * this.scaleFactor + (float)out[3]);
        } else if (secondl[2] - secondl[0] > 0 && firstl[2] - firstl[0] < 0) {
            out[0] = Math.round((float)secondl[0] * this.scaleFactor + (float)out[2]);
            out[1] = Math.round(this.bBoxHeight - (float)secondl[1] * this.scaleFactor + (float)(2 * out[3]));
        } else if (secondl[2] - secondl[0] < 0 && firstl[2] - firstl[0] < 0) {
            out[0] = Math.round((float)secondl[0] * this.scaleFactor + (float)(2 * out[2]));
            out[1] = Math.round(this.bBoxHeight - (float)secondl[1] * this.scaleFactor + (float)(2 * out[3]));
        } else if (secondl[2] - secondl[0] < 0 && firstl[2] - firstl[0] > 0) {
            out[0] = Math.round((float)secondl[0] * this.scaleFactor + (float)(2 * out[2]));
            out[1] = Math.round(this.bBoxHeight - (float)secondl[1] * this.scaleFactor + (float)out[3]);
        }
        return out;
    }

    private Vector getPoints(String[] st, boolean cntrclk) {
        double cx = Double.parseDouble(st[0]) * (double)this.scaleFactor;
        double cy = (double)this.bBoxHeight - Double.parseDouble(st[1]) * (double)this.scaleFactor;
        double radius = Double.parseDouble(st[2]) * (double)this.scaleFactor;
        double phi1 = 0.0;
        double phi2 = 0.0;
        if (cntrclk) {
            phi1 = Double.parseDouble(st[4]);
            phi2 = Double.parseDouble(st[3]);
        } else {
            phi1 = Double.parseDouble(st[3]);
            phi2 = Double.parseDouble(st[4]);
        }
        Point2D.Double fpt = new Point2D.Double(cx + radius * Math.cos(Math.toRadians(-phi1)), cy + radius * Math.sin(Math.toRadians(-phi1)));
        Point2D.Double spt = new Point2D.Double(0.0, 0.0);
        AffineTransform at = new AffineTransform();
        at.rotate(Math.toRadians(-phi2 + phi1) / 2.0, cx, cy);
        at.transform(fpt, spt);
        Point2D.Double tpt = new Point2D.Double(0.0, 0.0);
        AffineTransform at1 = new AffineTransform();
        at1.rotate(Math.toRadians(-phi2 + phi1), cx, cy);
        at1.transform(fpt, tpt);
        Vector<Point2D.Double> pts = new Vector<Point2D.Double>(3, 1);
        pts.add(fpt);
        pts.add(spt);
        pts.add(tpt);
        return pts;
    }

    private int[] getLoopPars(String[] st, String st1, boolean cntrclk) {
        int[] out = new int[4];
        float x = Float.parseFloat(st[0]);
        float y = Float.parseFloat(st[1]);
        float r = Float.parseFloat(st[2]);
        int phi1 = Math.round(Float.parseFloat(st[3]));
        int phi2 = Math.round(Float.parseFloat(st[4]));
        if (st1.indexOf("%") != -1) {
            r -= this.theDLSeparation(st1);
        }
        double alpha = 0.0;
        alpha = cntrclk ? (phi1 > phi2 ? Math.toRadians(-phi1 + 180) : Math.toRadians(-phi2 + 180)) : (phi1 > phi2 ? Math.toRadians(-phi2 + 180) : Math.toRadians(-phi1 + 180));
        out[2] = (int)Math.round((double)(r * this.scaleFactor) * Math.cos(alpha));
        out[3] = (int)Math.round((double)(r * this.scaleFactor) * Math.sin(alpha));
        if (out[2] > 0 && out[3] >= 0) {
            out[0] = (int)(x * this.scaleFactor);
            out[1] = (int)(this.bBoxHeight - y * this.scaleFactor);
        } else if (out[2] >= 0 && out[3] < 0) {
            out[0] = (int)(x * this.scaleFactor);
            out[1] = (int)(this.bBoxHeight - (float)Math.abs(out[3]) - y * this.scaleFactor);
        } else if (out[2] <= 0 && out[3] > 0) {
            out[0] = (int)(x * this.scaleFactor - (float)Math.abs(out[2]));
            out[1] = (int)(this.bBoxHeight - y * this.scaleFactor);
        } else if (out[2] < 0 && out[3] <= 0) {
            out[0] = (int)(x * this.scaleFactor - (float)Math.abs(out[2]));
            out[1] = (int)(this.bBoxHeight - (float)Math.abs(out[3]) - y * this.scaleFactor);
        }
        return out;
    }

    private float getPhotonFreq(int[] looppars, float nOfWiggles) {
        float offset = 0.1f;
        float freq = (float)(Math.sqrt(looppars[2] * looppars[2] + looppars[3] * looppars[3]) * 2.0 * Math.PI / (double)nOfWiggles);
        return freq -= offset;
    }

    private String[] getOvalBrackets(String str) {
        String[] st = new String[5];
        int start = str.indexOf("(");
        int comma = str.indexOf(",");
        int stop = str.indexOf(")");
        st[0] = str.substring(start + 1, comma);
        st[1] = str.substring(comma + 1, stop);
        int offset = stop + 1;
        start = str.indexOf("(", offset);
        comma = str.indexOf(",", offset);
        stop = str.indexOf(")", offset);
        st[2] = str.substring(start + 1, comma);
        st[3] = str.substring(comma + 1, stop);
        offset = stop + 1;
        start = str.indexOf("(", offset);
        stop = str.indexOf(")", offset);
        st[4] = str.substring(start + 1, stop);
        return st;
    }

    private int[] getFourInts(String str) {
        int[] ints = new int[4];
        int start = str.indexOf("(");
        int comma = str.indexOf(",");
        int stop = str.indexOf(")");
        ints[0] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[1] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        int offset = stop + 1;
        start = str.indexOf("(", offset);
        comma = str.indexOf(",", offset);
        stop = str.indexOf(")", offset);
        ints[2] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[3] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        return ints;
    }

    private int[] getTwoInts(String str) {
        int[] ints = new int[2];
        int start = str.indexOf("(");
        int comma = str.indexOf(",");
        int stop = str.indexOf(")");
        ints[0] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[1] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        return ints;
    }

    private int[] getFourInts(String str, int fromIndex) {
        int[] ints = new int[4];
        int start = str.indexOf("(", fromIndex);
        int comma = str.indexOf(",", fromIndex);
        int stop = str.indexOf(")", fromIndex);
        ints[0] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[1] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        int offset = stop + 1;
        start = str.indexOf("(", offset);
        comma = str.indexOf(",", offset);
        stop = str.indexOf(")", offset);
        ints[2] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[3] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        return ints;
    }

    private int[] getSixInts(String str) {
        int[] ints = new int[6];
        int start = str.indexOf("(");
        int comma = str.indexOf(",");
        int stop = str.indexOf(")");
        ints[0] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[1] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        int offset = stop + 1;
        start = str.indexOf("(", offset);
        comma = str.indexOf(",", offset);
        stop = str.indexOf(")", offset);
        ints[2] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[3] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        offset = stop + 1;
        start = str.indexOf("(", offset);
        comma = str.indexOf(",", offset);
        stop = str.indexOf(")", offset);
        ints[4] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[5] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        return ints;
    }

    private int[] getTriangleParameters(int[] coords) {
        int[] out = new int[]{0, 0, 0, 0, 0, 0};
        out[0] = Math.round((float)coords[0] * this.scaleFactor);
        out[1] = Math.round(this.bBoxHeight - (float)coords[1] * this.scaleFactor);
        out[2] = Math.round((float)coords[2] * this.scaleFactor);
        out[3] = Math.round(this.bBoxHeight - (float)coords[3] * this.scaleFactor);
        out[4] = Math.round((float)coords[4] * this.scaleFactor);
        out[5] = Math.round(this.bBoxHeight - (float)coords[5] * this.scaleFactor);
        return out;
    }

    private int getTeXAllign(String str) {
        Vector<String> possible = new Vector<String>(10, 1);
        possible.add("lt");
        possible.add("l");
        possible.add("lb");
        possible.add("t");
        possible.add("");
        possible.add("b");
        possible.add("rt");
        possible.add("r");
        possible.add("rb");
        return possible.indexOf(str);
    }

    private Color getTeXColor(String str) {
        int offset = str.indexOf("{\\");
        int start = str.indexOf("\\", offset);
        int stop = str.indexOf("$");
        if (stop > start && start != -1) {
            return JaxoColor.getColor(str.substring(start + 1, stop - 1));
        }
        return JaxoColor.BLACK;
    }

    private int getTeXSize(String str) {
        int start = str.indexOf("\\");
        int stop = str.indexOf("{", start);
        if (stop > start && start != -1) {
            String st = str.substring(start + 1, stop);
            Vector<String> possible = new Vector<String>(10, 1);
            possible.add("tiny");
            possible.add("scriptsize");
            possible.add("footnotesize");
            possible.add("small");
            possible.add("normalsize");
            possible.add("large");
            possible.add("Large");
            possible.add("LARGE");
            possible.add("huge");
            possible.add("Huge");
            if (possible.indexOf(st) != -1) {
                return possible.indexOf(st);
            }
            return 4;
        }
        return 4;
    }

    private String getTeXText(String str) {
        int start = str.indexOf("$");
        int stop = str.indexOf("$", start + 1);
        String st = str.substring(start + 1, stop);
        return st;
    }

    private String[] getOneBracket(String str) {
        String[] st = new String[2];
        int start = str.indexOf("(");
        int comma = str.indexOf(",");
        int stop = str.indexOf(")");
        st[0] = str.substring(start + 1, comma);
        st[1] = str.substring(comma + 1, stop);
        return st;
    }

    private String getOneBrace(String str) {
        String st = "";
        int start = str.indexOf("[");
        int stop = str.indexOf("]");
        st = str.substring(start + 1, stop);
        return st;
    }

    private String getOneCurl(String str) {
        int start = str.indexOf("{");
        int stop = str.indexOf("}");
        String st = str.substring(start + 1, stop);
        return st;
    }

    private String[] getTwoCurls(String str) {
        String[] st = new String[2];
        int start = str.indexOf("{");
        int stop = str.indexOf("}");
        st[0] = str.substring(start + 1, stop);
        int offset = stop + 1;
        start = str.indexOf("{", offset);
        stop = str.indexOf("}", offset);
        st[1] = str.substring(start + 1, stop);
        return st;
    }

    private String[] getThreeCurls(String str) {
        String[] st = new String[2];
        int start = str.indexOf("{");
        int stop = str.indexOf("}");
        st[0] = str.substring(start + 1, stop);
        int offset = stop + 1;
        start = str.indexOf("{", offset);
        stop = str.indexOf("}", offset);
        st[1] = str.substring(start + 1, stop);
        offset = stop + 1;
        start = str.indexOf("{", offset);
        stop = str.indexOf("}", offset);
        st[2] = str.substring(start + 1, stop);
        return st;
    }

    private String[] getArcBrackets(String str) {
        String[] st = new String[5];
        int start = str.indexOf("(");
        int comma = str.indexOf(",");
        int stop = str.indexOf(")");
        st[0] = str.substring(start + 1, comma);
        st[1] = str.substring(comma + 1, stop);
        int offset = stop + 1;
        start = str.indexOf("(", offset);
        int comma1 = str.indexOf(",", offset);
        int comma2 = str.indexOf(",", comma1 + 1);
        stop = str.indexOf(")", offset);
        st[2] = str.substring(start + 1, comma1);
        st[3] = str.substring(comma1 + 1, comma2);
        st[4] = str.substring(comma2 + 1, stop);
        return st;
    }

    private float theDLSeparation(String str) {
        int offset = str.indexOf("%") + 1;
        int start = str.indexOf("(", offset);
        int stop = str.indexOf(")", offset);
        float sep = Float.parseFloat(str.substring(start + 1, stop));
        return sep;
    }

    private JaObject newVertexT4() {
        int[] firstl = this.getFourInts(this.string);
        int[] secondl = this.getFourInts(this.string, this.string.lastIndexOf("\\Line"));
        int[] vertexpars = this.getT4Params(firstl, secondl);
        JaVertexT4 newVertexT4 = new JaVertexT4();
        newVertexT4.setLocation(vertexpars[0], vertexpars[1]);
        newVertexT4.setRelWAndH(vertexpars[2], vertexpars[3]);
        newVertexT4.setStroke(this.stroke);
        newVertexT4.setColor(this.color);
        return newVertexT4;
    }

    private JaObject newVertexT2() {
        int[] vertexpars = this.getT2Params(this.getOvalBrackets(this.string));
        String[] colors = this.getTwoCurls(this.string);
        JaVertexT2 newVertexT2 = new JaVertexT2();
        newVertexT2.setLocation(vertexpars[0], vertexpars[1]);
        newVertexT2.setRelWAndH(vertexpars[3], vertexpars[2]);
        newVertexT2.setStroke(this.stroke);
        newVertexT2.setColor(JaxoColor.getColor(colors[0]));
        newVertexT2.setFillColor(JaxoColor.getColor(colors[1]));
        return newVertexT2;
    }

    private JaObject newFLoop(boolean arcn, boolean arrow) {
        int phi2;
        JaObject newob = null;
        String[] st = this.getArcBrackets(this.string);
        int phi1 = Math.round(Float.parseFloat(st[3]));
        if (Math.abs(phi1 - (phi2 = Math.round(Float.parseFloat(st[4])))) >= 360) {
            int[] looppars = this.getLoopPars(st, this.string, arcn);
            JaFLoop newFLoop = new JaFLoop();
            newFLoop.setLocation(looppars[0], looppars[1]);
            newFLoop.setRelWAndH(looppars[2], looppars[3]);
            newFLoop.setColor(this.color);
            newFLoop.setStroke(this.stroke);
            newFLoop.setArrow(arrow);
            newFLoop.setFlip(arcn);
            if (this.string.indexOf("%") == -1) {
                newFLoop.setDoubleLine(false);
                newFLoop.setDLSeparation(2.0f);
            } else {
                newFLoop.setDoubleLine(true);
                newFLoop.setDLSeparation(this.theDLSeparation(this.string));
            }
            newob = newFLoop;
        } else {
            Vector pts = this.getPoints(st, arcn);
            Point2D p0 = (Point2D)pts.elementAt(0);
            Point2D p1 = (Point2D)pts.elementAt(1);
            Point2D p2 = (Point2D)pts.elementAt(2);
            JaFArc newFArc = new JaFArc();
            newFArc.setArcPts((int)Math.round(p0.getX()), (int)Math.round(p0.getY()), (int)Math.round(p1.getX()), (int)Math.round(p1.getY()), (int)Math.round(p2.getX()), (int)Math.round(p2.getY()));
            newFArc.setColor(this.color);
            newFArc.setStroke(this.stroke);
            newFArc.setArrow(arrow);
            newFArc.setFlip(arcn);
            if (this.string.indexOf("%") == -1) {
                newFArc.setDoubleLine(false);
                newFArc.setDLSeparation(2.0f);
            } else {
                newFArc.setDoubleLine(true);
                newFArc.setDLSeparation(this.theDLSeparation(this.string));
            }
            newob = newFArc;
        }
        return newob;
    }

    private JaObject newLine(boolean arrow) {
        int[] linepars = this.getLineParams(this.getFourInts(this.string), this.string);
        JaFLine newFLine = new JaFLine();
        newFLine.setLocation(linepars[0], linepars[1]);
        newFLine.setRelWAndH(linepars[2], linepars[3]);
        newFLine.setColor(this.color);
        newFLine.setStroke(this.stroke);
        newFLine.setArrow(arrow);
        newFLine.setFlip(false);
        if (this.string.indexOf("%") == -1) {
            newFLine.setDoubleLine(false);
            newFLine.setDLSeparation(2.0f);
        } else {
            newFLine.setDoubleLine(true);
            newFLine.setDLSeparation(Math.abs(this.theDLSeparation(this.string)));
        }
        return newFLine;
    }

    private JaObject newCBox() {
        JaObject newob = null;
        if (this.string.indexOf("%") == -1) {
            int[] boxpars = this.getBoxParams(this.getFourInts(this.string));
            String[] colors = this.getTwoCurls(this.string);
            JaBox newBox = new JaBox();
            newBox.setLocation(boxpars[0], boxpars[1]);
            newBox.setRelWAndH(boxpars[2], boxpars[3]);
            newBox.setStroke(this.stroke);
            newBox.setColor(JaxoColor.getColor(colors[0]));
            newBox.setFillColor(JaxoColor.getColor(colors[1]));
            newob = newBox;
        } else {
            int[] vertexT3pars = this.getT3Params(this.getFourInts(this.string));
            String[] colors = this.getTwoCurls(this.string);
            JaVertexT3 newVertexT3 = new JaVertexT3();
            newVertexT3.setLocation(vertexT3pars[0], vertexT3pars[1]);
            newVertexT3.setRelWAndH(vertexT3pars[2], vertexT3pars[3]);
            newVertexT3.setColor(JaxoColor.getColor(colors[0]));
            newob = newVertexT3;
        }
        return newob;
    }

    private JaObject newCCirc() {
        String[] radcol = this.getThreeCurls(this.string);
        int[] circpars = this.getCircParams(this.getTwoInts(this.string), radcol[0]);
        JaBlob newBlob = new JaBlob();
        newBlob.setLocation(circpars[0], circpars[1]);
        newBlob.setRelWAndH(circpars[2], circpars[2]);
        newBlob.setStroke(this.stroke);
        newBlob.setRotAngle(0);
        newBlob.setColor(JaxoColor.getColor(radcol[1]));
        newBlob.setFillColor(JaxoColor.getColor(radcol[2]));
        return newBlob;
    }

    private JaObject newCOval() {
        int[] blobpars = this.getBlobParams(this.getOvalBrackets(this.string));
        String[] colors = this.getTwoCurls(this.string);
        JaBlob newBlob = new JaBlob();
        newBlob.setLocation(blobpars[0], blobpars[1]);
        newBlob.setRelWAndH(blobpars[3], blobpars[2]);
        newBlob.setStroke(this.stroke);
        newBlob.setRotAngle(-blobpars[4]);
        newBlob.setColor(JaxoColor.getColor(colors[0]));
        newBlob.setFillColor(JaxoColor.getColor(colors[1]));
        return newBlob;
    }

    private JaObject newCTri() {
        String[] colors = this.getTwoCurls(this.string);
        int[] tripars = this.getTriangleParameters(this.getSixInts(this.string));
        JaVertexT5 newVertexT5 = new JaVertexT5();
        newVertexT5.setVertexPts(tripars[0], tripars[1], tripars[2], tripars[3], tripars[4], tripars[5]);
        newVertexT5.setStroke(this.stroke);
        newVertexT5.setColor(JaxoColor.getColor(colors[0]));
        newVertexT5.setFillColor(JaxoColor.getColor(colors[1]));
        return newVertexT5;
    }

    private JaObject newDashArc(boolean arcn, boolean arrow) {
        int phi2;
        int phi1;
        String[] st = this.getArcBrackets(this.string);
        float dash = Float.parseFloat(this.getOneCurl(this.string)) * this.scaleFactor;
        JaObject newob = null;
        if (!arrow && this.string.indexOf("%") != -1) {
            float r = Float.parseFloat(st[2]);
            dash = Math.round(dash * r / (r + this.theDLSeparation(this.string)));
        }
        if (Math.abs((phi1 = Math.round(Float.parseFloat(st[3]))) - (phi2 = Math.round(Float.parseFloat(st[4])))) >= 360) {
            int[] looppars = this.getLoopPars(st, this.string, arcn);
            if (dash > 5.0f) {
                JaSLoop newSLoop = new JaSLoop();
                newSLoop.setLocation(looppars[0], looppars[1]);
                newSLoop.setRelWAndH(looppars[2], looppars[3]);
                newSLoop.setColor(this.color);
                newSLoop.setStroke(this.stroke);
                newSLoop.setArrow(arrow);
                newSLoop.setFlip(arcn);
                newSLoop.setDash(dash);
                if (this.string.indexOf("%") == -1) {
                    newSLoop.setDoubleLine(false);
                    newSLoop.setDLSeparation(2.0f);
                } else {
                    newSLoop.setDoubleLine(true);
                    newSLoop.setDLSeparation(this.theDLSeparation(this.string));
                }
                newob = newSLoop;
            } else {
                JaGLoop newGLoop = new JaGLoop();
                newGLoop.setLocation(looppars[0], looppars[1]);
                newGLoop.setRelWAndH(looppars[2], looppars[3]);
                newGLoop.setColor(this.color);
                newGLoop.setStroke(this.stroke);
                newGLoop.setArrow(arrow);
                newGLoop.setFlip(arcn);
                newGLoop.setDash(dash);
                if (this.string.indexOf("%") == -1) {
                    newGLoop.setDoubleLine(false);
                    newGLoop.setDLSeparation(2.0f);
                } else {
                    newGLoop.setDoubleLine(true);
                    newGLoop.setDLSeparation(this.theDLSeparation(this.string));
                }
                newob = newGLoop;
            }
        } else {
            Vector pts = this.getPoints(st, arcn);
            if (dash > 5.0f) {
                JaSArc newSArc = new JaSArc();
                Point2D p0 = (Point2D)pts.elementAt(0);
                Point2D p1 = (Point2D)pts.elementAt(1);
                Point2D p2 = (Point2D)pts.elementAt(2);
                newSArc.setArcPts((int)Math.round(p0.getX()), (int)Math.round(p0.getY()), (int)Math.round(p1.getX()), (int)Math.round(p1.getY()), (int)Math.round(p2.getX()), (int)Math.round(p2.getY()));
                newSArc.setColor(this.color);
                newSArc.setStroke(this.stroke);
                newSArc.setArrow(arrow);
                newSArc.setFlip(arcn);
                newSArc.setDash(dash);
                if (this.string.indexOf("%") == -1) {
                    newSArc.setDoubleLine(false);
                    newSArc.setDLSeparation(2.0f);
                } else {
                    newSArc.setDoubleLine(true);
                    newSArc.setDLSeparation(this.theDLSeparation(this.string));
                }
                newob = newSArc;
            } else {
                JaGArc newGArc = new JaGArc();
                Point2D p0 = (Point2D)pts.elementAt(0);
                Point2D p1 = (Point2D)pts.elementAt(1);
                Point2D p2 = (Point2D)pts.elementAt(2);
                newGArc.setArcPts((int)Math.round(p0.getX()), (int)Math.round(p0.getY()), (int)Math.round(p1.getX()), (int)Math.round(p1.getY()), (int)Math.round(p2.getX()), (int)Math.round(p2.getY()));
                newGArc.setColor(this.color);
                newGArc.setStroke(this.stroke);
                newGArc.setArrow(arrow);
                newGArc.setFlip(arcn);
                newGArc.setDash(dash);
                if (this.string.indexOf("%") == -1) {
                    newGArc.setDoubleLine(false);
                    newGArc.setDLSeparation(2.0f);
                } else {
                    newGArc.setDoubleLine(true);
                    newGArc.setDLSeparation(this.theDLSeparation(this.string));
                }
                newob = newGArc;
            }
        }
        return newob;
    }

    private JaObject newDashLine(boolean arrow) {
        int[] linepars = this.getLineParams(this.getFourInts(this.string), this.string);
        float dash = Float.parseFloat(this.getOneCurl(this.string)) * this.scaleFactor;
        JaLineObject newob = null;
        if (dash > 5.0f) {
            JaSLine newSLine = new JaSLine();
            newSLine.setLocation(linepars[0], linepars[1]);
            newSLine.setRelWAndH(linepars[2], linepars[3]);
            newSLine.setColor(this.color);
            newSLine.setStroke(this.stroke);
            newSLine.setArrow(arrow);
            newSLine.setFlip(false);
            newSLine.setDash(dash);
            if (this.string.indexOf("%") == -1) {
                newSLine.setDoubleLine(false);
                newSLine.setDLSeparation(2.0f);
            } else {
                newSLine.setDoubleLine(true);
                newSLine.setDLSeparation(Math.abs(this.theDLSeparation(this.string)));
            }
            newob = newSLine;
        } else {
            JaGLine newGLine = new JaGLine();
            newGLine.setLocation(linepars[0], linepars[1]);
            newGLine.setRelWAndH(linepars[2], linepars[3]);
            newGLine.setColor(this.color);
            newGLine.setStroke(this.stroke);
            newGLine.setArrow(arrow);
            newGLine.setFlip(false);
            newGLine.setDash(dash);
            if (this.string.indexOf("%") == -1) {
                newGLine.setDoubleLine(false);
                newGLine.setDLSeparation(2.0f);
            } else {
                newGLine.setDoubleLine(true);
                newGLine.setDLSeparation(Math.abs(this.theDLSeparation(this.string)));
            }
            newob = newGLine;
        }
        return newob;
    }

    private JaObject newGBox() {
        int[] boxpars = this.getBoxParams(this.getFourInts(this.string));
        JaBox newBox = new JaBox();
        newBox.setLocation(boxpars[0], boxpars[1]);
        newBox.setRelWAndH(boxpars[2], boxpars[3]);
        newBox.setStroke(this.stroke);
        newBox.setColor(this.color);
        newBox.setFillColor(JaxoColor.getGrayScale(Float.parseFloat(this.getOneCurl(this.string))));
        return newBox;
    }

    private JaObject newGCirc() {
        String[] radcol = this.getTwoCurls(this.string);
        int[] circpars = this.getCircParams(this.getTwoInts(this.string), radcol[0]);
        JaBlob newBlob = new JaBlob();
        newBlob.setLocation(circpars[0], circpars[1]);
        newBlob.setRelWAndH(circpars[2], circpars[2]);
        newBlob.setStroke(this.stroke);
        newBlob.setRotAngle(0);
        newBlob.setColor(this.color);
        newBlob.setFillColor(JaxoColor.getGrayScale(Float.parseFloat(radcol[1])));
        return newBlob;
    }

    private JaObject newGlArc() {
        int phi2;
        JaObject newob = null;
        String[] st = this.getArcBrackets(this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        int phi1 = Math.round(Float.parseFloat(st[3]));
        if (Math.abs(phi1 - (phi2 = Math.round(Float.parseFloat(st[4])))) >= 360) {
            int[] looppars = this.getLoopPars(st, this.string, false);
            JaGlLoop newGlLoop = new JaGlLoop();
            newGlLoop.setLocation(looppars[0] - looppars[2], looppars[1] - looppars[3]);
            newGlLoop.setRelWAndH(-looppars[2], -looppars[3]);
            newGlLoop.setColor(this.color);
            newGlLoop.setStroke(this.stroke);
            newGlLoop.setAmp(Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.scaleFactor));
            float nOfWiggles = Float.parseFloat(ampwig[1]) * this.scaleFactor;
            newGlLoop.setFreq((float)(Math.sqrt(looppars[2] * looppars[2] + looppars[3] * looppars[3]) * 2.0 * Math.PI / (double)nOfWiggles / (double)0.7f));
            if (this.string.indexOf("%") == -1) {
                newGlLoop.setDoubleLine(false);
                newGlLoop.setDLSeparation(2.0f);
            } else {
                newGlLoop.setDoubleLine(true);
                newGlLoop.setDLSeparation(this.theDLSeparation(this.string));
            }
            newob = newGlLoop;
        } else {
            Vector pts = this.getPoints(st, false);
            float r = Float.parseFloat(st[2]) * this.scaleFactor;
            JaGlArc newGlArc = new JaGlArc();
            Point2D p0 = (Point2D)pts.elementAt(0);
            Point2D p1 = (Point2D)pts.elementAt(1);
            Point2D p2 = (Point2D)pts.elementAt(2);
            newGlArc.setArcPts((int)Math.round(p0.getX()), (int)Math.round(p0.getY()), (int)Math.round(p1.getX()), (int)Math.round(p1.getY()), (int)Math.round(p2.getX()), (int)Math.round(p2.getY()));
            newGlArc.setColor(this.color);
            newGlArc.setStroke(this.stroke);
            newGlArc.setAmp(Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.scaleFactor));
            float nOfWiggles = Float.parseFloat(ampwig[1]) * this.scaleFactor;
            newGlArc.setFreq((float)((double)(r * 2.0f) * Math.toRadians(Math.abs((phi2 - phi1) / 2)) / (double)(nOfWiggles * 0.7f + 1.0f)));
            if (this.string.indexOf("%") == -1) {
                newGlArc.setDoubleLine(false);
                newGlArc.setDLSeparation(2.0f);
            } else {
                newGlArc.setDoubleLine(true);
                newGlArc.setDLSeparation(this.theDLSeparation(this.string));
            }
            newob = newGlArc;
        }
        return newob;
    }

    private JaObject newGlLine() {
        int[] linepars = this.getLineParams(this.getFourInts(this.string), this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        JaGlLine newGlLine = new JaGlLine();
        newGlLine.setLocation(linepars[0], linepars[1]);
        newGlLine.setRelWAndH(linepars[2], linepars[3]);
        newGlLine.setColor(this.color);
        newGlLine.setStroke(this.stroke);
        newGlLine.setAmp(Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.scaleFactor));
        float nOfWiggles = Float.parseFloat(ampwig[1]) * this.scaleFactor;
        newGlLine.setFreq((float)(Math.sqrt(linepars[2] * linepars[2] + linepars[3] * linepars[3]) / (double)(nOfWiggles * 0.7f + 1.0f)));
        if (this.string.indexOf("%") == -1) {
            newGlLine.setDoubleLine(false);
            newGlLine.setDLSeparation(2.0f);
        } else {
            newGlLine.setDoubleLine(true);
            newGlLine.setDLSeparation(this.theDLSeparation(this.string));
        }
        return newGlLine;
    }

    private JaObject newGOval() {
        int[] blobpars = this.getBlobParams(this.getOvalBrackets(this.string));
        JaBlob newBlob = new JaBlob();
        newBlob.setLocation(blobpars[0], blobpars[1]);
        newBlob.setRelWAndH(blobpars[3], blobpars[2]);
        newBlob.setStroke(this.stroke);
        newBlob.setRotAngle(-blobpars[4]);
        newBlob.setColor(this.color);
        newBlob.setFillColor(JaxoColor.getGrayScale(Float.parseFloat(this.getOneCurl(this.string))));
        return newBlob;
    }

    private JaObject newGTri() {
        int[] tripars = this.getTriangleParameters(this.getSixInts(this.string));
        JaVertexT5 newVertexT5 = new JaVertexT5();
        newVertexT5.setVertexPts(tripars[0], tripars[1], tripars[2], tripars[3], tripars[4], tripars[5]);
        newVertexT5.setStroke(this.stroke);
        newVertexT5.setColor(this.color);
        newVertexT5.setFillColor(JaxoColor.getGrayScale(Float.parseFloat(this.getOneCurl(this.string))));
        return newVertexT5;
    }

    private JaObject newPArc() {
        int phi2;
        JaObject newob = null;
        String[] st = this.getArcBrackets(this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        int phi1 = Math.round(Float.parseFloat(st[3]));
        if (Math.abs(phi1 - (phi2 = Math.round(Float.parseFloat(st[4])))) >= 360) {
            int[] looppars = this.getLoopPars(st, this.string, false);
            JaPLoop newPLoop = new JaPLoop();
            newPLoop.setLocation(looppars[0] - looppars[2], looppars[1] - looppars[3]);
            newPLoop.setRelWAndH(-looppars[2], -looppars[3]);
            newPLoop.setColor(this.color);
            newPLoop.setStroke(this.stroke);
            newPLoop.setAmp(Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.scaleFactor));
            float nOfWiggles = Float.parseFloat(ampwig[1]);
            newPLoop.setFreq(this.getPhotonFreq(looppars, nOfWiggles));
            if (this.string.indexOf("%") == -1) {
                newPLoop.setDoubleLine(false);
                newPLoop.setDLSeparation(2.0f);
            } else {
                newPLoop.setDoubleLine(true);
                newPLoop.setDLSeparation(this.theDLSeparation(this.string));
            }
            newob = newPLoop;
        } else {
            Vector pts = this.getPoints(st, false);
            float r = Float.parseFloat(st[2]) * this.scaleFactor;
            JaPArc newPArc = new JaPArc();
            Point2D p0 = (Point2D)pts.elementAt(0);
            Point2D p1 = (Point2D)pts.elementAt(1);
            Point2D p2 = (Point2D)pts.elementAt(2);
            newPArc.setArcPts((int)Math.round(p0.getX()), (int)Math.round(p0.getY()), (int)Math.round(p1.getX()), (int)Math.round(p1.getY()), (int)Math.round(p2.getX()), (int)Math.round(p2.getY()));
            newPArc.setColor(this.color);
            newPArc.setStroke(this.stroke);
            newPArc.setAmp(Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.scaleFactor));
            float nOfWiggles = Float.parseFloat(ampwig[1]) - 0.5f;
            newPArc.setFreq((float)((double)(r * 2.0f) * Math.toRadians(Math.abs((phi2 - phi1) / 2)) / (double)nOfWiggles));
            if (this.string.indexOf("%") == -1) {
                newPArc.setDoubleLine(false);
                newPArc.setDLSeparation(2.0f);
            } else {
                newPArc.setDoubleLine(true);
                newPArc.setDLSeparation(this.theDLSeparation(this.string));
            }
            newob = newPArc;
        }
        return newob;
    }

    private JaObject newPLine() {
        int[] linepars = this.getLineParams(this.getFourInts(this.string), this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        JaPLine newPLine = new JaPLine();
        newPLine.setLocation(linepars[0], linepars[1]);
        newPLine.setRelWAndH(linepars[2], linepars[3]);
        newPLine.setColor(this.color);
        newPLine.setStroke(this.stroke);
        newPLine.setAmp(Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.scaleFactor));
        float nOfWiggles = Float.parseFloat(ampwig[1]);
        int symm = Math.round(nOfWiggles);
        if ((double)((float)symm - nOfWiggles) > 0.001) {
            newPLine.setSymm(true);
            newPLine.setFreq((float)(Math.sqrt(linepars[2] * linepars[2] + linepars[3] * linepars[3]) / ((double)nOfWiggles - 0.5)));
        } else {
            newPLine.setSymm(false);
            newPLine.setFreq((float)(Math.sqrt(linepars[2] * linepars[2] + linepars[3] * linepars[3]) / (double)nOfWiggles));
        }
        if (this.string.indexOf("%") == -1) {
            newPLine.setDoubleLine(false);
            newPLine.setDLSeparation(2.0f);
        } else {
            newPLine.setDoubleLine(true);
            newPLine.setDLSeparation(this.theDLSeparation(this.string));
        }
        return newPLine;
    }

    private JaObject newText() {
        int[] pos = this.getT1Params(this.getOneBracket(this.string));
        int allign = this.getTeXAllign(this.getOneBrace(this.string));
        int size = this.getTeXSize(this.getOneCurl(this.string));
        String text = this.getTeXText(this.string);
        Color txtcolor = this.getTeXColor(this.getOneCurl(this.string));
        JaLatexText newText = new JaLatexText();
        newText.setX(pos[0]);
        newText.setY(pos[1]);
        newText.setColor(txtcolor);
        newText.setTextString(text);
        newText.setAllign(allign);
        newText.setLatexFS(size);
        newText.createLatexPanel();
        return newText;
    }

    private JaObject newVertexT1() {
        int[] center = this.getT1Params(this.getOneBracket(this.string));
        String radius = this.getOneCurl(this.string);
        JaVertexT1 newVertexT1 = new JaVertexT1();
        newVertexT1.setLocation(center[0], center[1]);
        newVertexT1.setRelWAndH((int)Math.round((double)(Float.parseFloat(radius) * this.scaleFactor) / Math.sqrt(2.0)), (int)Math.round((double)(Float.parseFloat(radius) * this.scaleFactor) / Math.sqrt(2.0)));
        newVertexT1.setColor(JaxoColor.BLACK);
        return newVertexT1;
    }

    private JaObject newVertexT6() {
        int[] tripars = this.getTriangleParameters(this.getSixInts(this.string));
        String[] colors = this.getTwoCurls(this.string);
        JaVertexT6 newVertexT6 = new JaVertexT6();
        double length = (double)(tripars[4] - tripars[0]) / 2.0;
        newVertexT6.setLocation((int)Math.round((double)tripars[0] + length), tripars[1]);
        newVertexT6.setRelWAndH((int)Math.round(length * 0.5 * Math.sqrt(2.0)), (int)Math.round(length * 0.5 * Math.sqrt(2.0)));
        newVertexT6.setStroke(this.stroke);
        newVertexT6.setColor(JaxoColor.getColor(colors[0]));
        return newVertexT6;
    }

    private JaObject newZigZagLine() {
        int[] linepars = this.getLineParams(this.getFourInts(this.string), this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        JaZigZagLine newZigZagLine = new JaZigZagLine();
        newZigZagLine.setLocation(linepars[0], linepars[1]);
        newZigZagLine.setRelWAndH(linepars[2], linepars[3]);
        newZigZagLine.setColor(this.color);
        newZigZagLine.setStroke(this.stroke);
        newZigZagLine.setAmp(Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.scaleFactor));
        float nOfWiggles = Float.parseFloat(ampwig[1]) * this.scaleFactor;
        int symm = Math.round(nOfWiggles);
        if ((double)((float)symm - nOfWiggles) > 0.001) {
            newZigZagLine.setSymm(true);
            newZigZagLine.setFreq((float)(Math.sqrt(linepars[2] * linepars[2] + linepars[3] * linepars[3]) / ((double)nOfWiggles - 0.5)));
        } else {
            newZigZagLine.setSymm(false);
            newZigZagLine.setFreq((float)(Math.sqrt(linepars[2] * linepars[2] + linepars[3] * linepars[3]) / (double)nOfWiggles));
        }
        if (this.string.indexOf("%") == -1) {
            newZigZagLine.setDoubleLine(false);
            newZigZagLine.setDLSeparation(2.0f);
        } else {
            newZigZagLine.setDoubleLine(true);
            newZigZagLine.setDLSeparation(this.theDLSeparation(this.string));
        }
        return newZigZagLine;
    }
}

