/*
 * Decompiled with CFR 0.152.
 */
package japlot;

import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class ComboBoxRenderer
extends JLabel
implements ListCellRenderer {
    private Font uhOhFont;
    private Icon[] images;
    private String[] petStrings;

    public ComboBoxRenderer(Icon[] images, String[] petStrings) {
        this.setOpaque(true);
        this.setVerticalAlignment(0);
        this.setHorizontalTextPosition(2);
        this.setVerticalTextPosition(3);
        this.images = images;
        this.petStrings = petStrings;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int selectedIndex = (Integer)value;
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        Icon icon = this.images[selectedIndex];
        String pet = this.petStrings[selectedIndex];
        this.setIcon(icon);
        if (icon != null) {
            this.setIconTextGap(2);
            this.setText(pet);
            this.setFont(list.getFont());
        } else {
            this.setUhOhText(pet + " (no image available)", list.getFont());
        }
        return this;
    }

    protected void setUhOhText(String uhOhText, Font normalFont) {
        if (this.uhOhFont == null) {
            this.uhOhFont = normalFont.deriveFont(2);
        }
        this.setFont(this.uhOhFont);
        this.setText(uhOhText);
    }
}

