/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.web.example;

import java.util.Calendar;
import java.util.List;
import org.jfin.common.Iso4217Currency;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.Frequency;
import org.jfin.date.Period;
import org.jfin.date.ScheduleException;
import org.jfin.date.ScheduleGenerator;
import org.jfin.date.StubType;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.web.example.FixedPeriod;
import org.jfin.date.web.example.FloatPeriod;

public class PlainSwap {
    private double notional;
    private Iso4217Currency currency;
    private Calendar tradeDate;
    private Calendar effectiveDate;
    private Calendar maturityDate;
    private StubType stubType;
    private DaycountCalculator fixedDaycountCalculator;
    private DaycountCalculator floatDaycountCalculator;
    private Frequency fixedFrequency;
    private Frequency floatFrequency;
    private BusinessDayConvention fixedConvention;
    private BusinessDayConvention floatConvention;
    private boolean payFixed;
    private double fixedRate;
    private String floatIndex;
    private double floatMargin;
    private int fixingOffset;
    private HolidayCalendar fixingBusinessDays;
    private HolidayCalendar paymentBusinessDays;
    private static int MAX_PERIODS = 200;

    public Iso4217Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Iso4217Currency currency) {
        this.currency = currency;
    }

    public Calendar getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Calendar effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public BusinessDayConvention getFixedConvention() {
        return this.fixedConvention;
    }

    public void setFixedConvention(BusinessDayConvention fixedConvention) {
        this.fixedConvention = fixedConvention;
    }

    public DaycountCalculator getFixedDaycountCalculator() {
        return this.fixedDaycountCalculator;
    }

    public void setFixedDaycountCalculator(DaycountCalculator fixedDaycountCalculator) {
        this.fixedDaycountCalculator = fixedDaycountCalculator;
    }

    public Frequency getFixedFrequency() {
        return this.fixedFrequency;
    }

    public void setFixedFrequency(Frequency fixedFrequency) {
        this.fixedFrequency = fixedFrequency;
    }

    public BusinessDayConvention getFloatConvention() {
        return this.floatConvention;
    }

    public void setFloatConvention(BusinessDayConvention floatConvention) {
        this.floatConvention = floatConvention;
    }

    public DaycountCalculator getFloatDaycountCalculator() {
        return this.floatDaycountCalculator;
    }

    public void setFloatDaycountCalculator(DaycountCalculator floatDaycountCalculator) {
        this.floatDaycountCalculator = floatDaycountCalculator;
    }

    public Frequency getFloatFrequency() {
        return this.floatFrequency;
    }

    public void setFloatFrequency(Frequency floatFrequency) {
        this.floatFrequency = floatFrequency;
    }

    public Calendar getMaturityDate() {
        return this.maturityDate;
    }

    public void setMaturityDate(Calendar maturityDate) {
        this.maturityDate = maturityDate;
    }

    public double getNotional() {
        return this.notional;
    }

    public void setNotional(double notional) {
        this.notional = notional;
    }

    public StubType getStubType() {
        return this.stubType;
    }

    public void setStubType(StubType stubType) {
        this.stubType = stubType;
    }

    public Calendar getTradeDate() {
        return this.tradeDate;
    }

    public void setTradeDate(Calendar tradeDate) {
        this.tradeDate = tradeDate;
    }

    public double getFixedRate() {
        return this.fixedRate;
    }

    public void setFixedRate(double fixedRate) {
        this.fixedRate = fixedRate;
    }

    public HolidayCalendar getFixingBusinessDays() {
        return this.fixingBusinessDays;
    }

    public void setFixingBusinessDays(HolidayCalendar fixingBusinessDays) {
        this.fixingBusinessDays = fixingBusinessDays;
    }

    public int getFixingOffset() {
        return this.fixingOffset;
    }

    public void setFixingOffset(int fixingOffset) {
        this.fixingOffset = fixingOffset;
    }

    public String getFloatIndex() {
        return this.floatIndex;
    }

    public void setFloatIndex(String floatIndex) {
        this.floatIndex = floatIndex;
    }

    public double getFloatMargin() {
        return this.floatMargin;
    }

    public void setFloatMargin(double floatMargin) {
        this.floatMargin = floatMargin;
    }

    public boolean isPayFixed() {
        return this.payFixed;
    }

    public void setPayFixed(boolean payFixed) {
        this.payFixed = payFixed;
    }

    public HolidayCalendar getPaymentBusinessDays() {
        return this.paymentBusinessDays;
    }

    public void setPaymentBusinessDays(HolidayCalendar paymentBusinessDays) {
        this.paymentBusinessDays = paymentBusinessDays;
    }

    public List getFixedSchedule() throws ScheduleException {
        FixedPeriod prototype = new FixedPeriod();
        prototype.setNotional(this.payFixed ? -1.0 * this.getNotional() : this.getNotional());
        prototype.setCurrency(this.getCurrency());
        prototype.setFixedRate(this.getFixedRate());
        prototype.setBusinessDayConvention(this.getFixedConvention());
        prototype.setDaycountCalculator(this.getFixedDaycountCalculator());
        prototype.setPaymentHolidayCalendar(this.getPaymentBusinessDays());
        List<Period> periods = ScheduleGenerator.generateSchedule(this.getEffectiveDate(), this.getMaturityDate(), this.getFixedFrequency(), this.getStubType(), (Period)prototype, MAX_PERIODS);
        return periods;
    }

    public List getFloatSchedule() throws ScheduleException {
        FloatPeriod prototype = new FloatPeriod();
        prototype.setNotional(this.payFixed ? this.getNotional() : -1.0 * this.getNotional());
        prototype.setCurrency(this.getCurrency());
        prototype.setBusinessDayConvention(this.getFloatConvention());
        prototype.setDaycountCalculator(this.getFloatDaycountCalculator());
        prototype.setPaymentHolidayCalendar(this.getPaymentBusinessDays());
        prototype.setFixingHolidayCalendar(this.getFixingBusinessDays());
        prototype.setIndex(this.getFloatIndex());
        prototype.setFrequency(this.getFloatFrequency());
        prototype.setFixingOffset(this.getFixingOffset());
        List<Period> periods = ScheduleGenerator.generateSchedule(this.getEffectiveDate(), this.getMaturityDate(), this.getFloatFrequency(), this.getStubType(), (Period)prototype, MAX_PERIODS);
        return periods;
    }
}

