/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.holiday.financialcalendarimpl;

import java.io.File;
import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarException;
import org.jfin.date.holiday.HolidayCalendarFactory;
import org.jfin.date.holiday.financialcalendarimpl.HolidayCalendarFactoryFinancialCalendarImpl;

public class FinancialCalendarHolidayCalendarTest
extends TestCase {
    private String rootPath = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.rootPath = "src/test/data/financialcalendar/";
        File f = new File(this.rootPath);
        if (!f.exists()) {
            this.rootPath = "../src/test/data/financialcalendar/";
        }
    }

    public void testGetHolidayCalendar() {
        System.setProperty("jfin.HolidayCalendarFactory", "org.jfin.date.holiday.financialcalendarimpl.HolidayCalendarFactoryFinancialCalendarImpl");
        System.setProperty("jfin.FinancialCalendar.HolidayFilePath", this.rootPath + "jfin.csv");
        System.setProperty("jfin.FinancialCalendar.InfoFilePath", this.rootPath + "info.csv");
        HolidayCalendarFactory holidayCalendarFactory = HolidayCalendarFactory.newInstance();
        FinancialCalendarHolidayCalendarTest.assertTrue((boolean)(holidayCalendarFactory instanceof HolidayCalendarFactoryFinancialCalendarImpl));
        System.clearProperty("jfin.HolidayCalendarFactory");
        System.clearProperty("jfin.FinancialCalendar.HolidayFilePath");
        System.clearProperty("jfin.FinancialCalendar.InfoFilePath");
    }

    public void testLondonHolidayCalendar() {
        System.setProperty("jfin.HolidayCalendarFactory", "org.jfin.date.holiday.financialcalendarimpl.HolidayCalendarFactoryFinancialCalendarImpl");
        System.setProperty("jfin.FinancialCalendar.HolidayFilePath", this.rootPath + "jfin.csv");
        System.setProperty("jfin.FinancialCalendar.InfoFilePath", this.rootPath + "info.csv");
        HolidayCalendarFactory holidayCalendarFactory = HolidayCalendarFactory.newInstance();
        HolidayCalendar LnB = holidayCalendarFactory.getHolidayCalendar("LnB");
        FinancialCalendarHolidayCalendarTest.assertTrue((boolean)LnB.isHoliday(new GregorianCalendar(2006, 0, 30)));
        FinancialCalendarHolidayCalendarTest.assertTrue((!LnB.isWeekend(new GregorianCalendar(2006, 0, 30)) ? 1 : 0) != 0);
        FinancialCalendarHolidayCalendarTest.assertTrue((boolean)LnB.isHoliday(new GregorianCalendar(2006, 0, 15)));
        FinancialCalendarHolidayCalendarTest.assertTrue((boolean)LnB.isWeekend(new GregorianCalendar(2006, 0, 15)));
        FinancialCalendarHolidayCalendarTest.assertTrue((!LnB.isHoliday(new GregorianCalendar(2006, 1, 21)) ? 1 : 0) != 0);
        System.clearProperty("jfin.HolidayCalendarFactory");
        System.clearProperty("jfin.FinancialCalendar.HolidayFilePath");
        System.clearProperty("jfin.FinancialCalendar.InfoFilePath");
    }

    public void testBadHolidayCalendar() {
        System.setProperty("jfin.HolidayCalendarFactory", "org.jfin.date.holiday.financialcalendarimpl.HolidayCalendarFactoryFinancialCalendarImpl");
        System.setProperty("jfin.FinancialCalendar.HolidayFilePath", this.rootPath + "jfin.csv");
        System.setProperty("jfin.FinancialCalendar.InfoFilePath", this.rootPath + "info.csv");
        HolidayCalendarFactory holidayCalendarFactory = HolidayCalendarFactory.newInstance();
        try {
            holidayCalendarFactory.getHolidayCalendar("TEST");
        }
        catch (HolidayCalendarException e) {
            System.clearProperty("jfin.HolidayCalendarFactory");
            System.clearProperty("jfin.FinancialCalendar.HolidayFilePath");
            System.clearProperty("jfin.FinancialCalendar.InfoFilePath");
            return;
        }
        FinancialCalendarHolidayCalendarTest.fail((String)"Failed to throw an exception finding HolidayCalendar TEST");
    }

    public void testCombinedHolidayCalendar() {
        System.setProperty("jfin.HolidayCalendarFactory", "org.jfin.date.holiday.financialcalendarimpl.HolidayCalendarFactoryFinancialCalendarImpl");
        System.setProperty("jfin.FinancialCalendar.HolidayFilePath", this.rootPath + "jfin.csv");
        System.setProperty("jfin.FinancialCalendar.InfoFilePath", this.rootPath + "info.csv");
        HolidayCalendarFactory holidayCalendarFactory = HolidayCalendarFactory.newInstance();
        HolidayCalendar holidayCalendar = holidayCalendarFactory.getHolidayCalendar(new String[]{"LnB", "TkB"});
        FinancialCalendarHolidayCalendarTest.assertTrue((boolean)holidayCalendar.isHoliday(new GregorianCalendar(2006, 0, 30)));
        FinancialCalendarHolidayCalendarTest.assertTrue((!holidayCalendar.isWeekend(new GregorianCalendar(2006, 0, 30)) ? 1 : 0) != 0);
        FinancialCalendarHolidayCalendarTest.assertTrue((boolean)holidayCalendar.isHoliday(new GregorianCalendar(2006, 0, 15)));
        FinancialCalendarHolidayCalendarTest.assertTrue((boolean)holidayCalendar.isWeekend(new GregorianCalendar(2006, 0, 15)));
        FinancialCalendarHolidayCalendarTest.assertTrue((boolean)holidayCalendar.isHoliday(new GregorianCalendar(2006, 1, 21)));
        System.clearProperty("jfin.HolidayCalendarFactory");
        System.clearProperty("jfin.FinancialCalendar.HolidayFilePath");
        System.clearProperty("jfin.FinancialCalendar.InfoFilePath");
    }

    public void testAvailableLocales() {
        System.setProperty("jfin.HolidayCalendarFactory", "org.jfin.date.holiday.financialcalendarimpl.HolidayCalendarFactoryFinancialCalendarImpl");
        System.setProperty("jfin.FinancialCalendar.HolidayFilePath", this.rootPath + "jfin.csv");
        System.setProperty("jfin.FinancialCalendar.InfoFilePath", this.rootPath + "info.csv");
        HolidayCalendarFactory holidayCalendarFactory = HolidayCalendarFactory.newInstance();
        String[] availableLocales = holidayCalendarFactory.getAvailableLocales();
        FinancialCalendarHolidayCalendarTest.assertEquals((int)3, (int)availableLocales.length);
        FinancialCalendarHolidayCalendarTest.assertEquals((String)"LnB", (String)availableLocales[0]);
        FinancialCalendarHolidayCalendarTest.assertEquals((String)"NYB", (String)availableLocales[1]);
        FinancialCalendarHolidayCalendarTest.assertEquals((String)"TkB", (String)availableLocales[2]);
        System.clearProperty("jfin.HolidayCalendarFactory");
        System.clearProperty("jfin.FinancialCalendar.HolidayFilePath");
        System.clearProperty("jfin.FinancialCalendar.InfoFilePath");
    }
}

