/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.holiday;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import junit.framework.TestCase;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.Period;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarFactory;
import org.jfin.date.util.ISDADateFormat;

public class HolidayCalendarTest
extends TestCase {
    public void testAdjustPeriodList() throws ParseException {
        HolidayCalendar<Period> holidayCalendar = HolidayCalendarFactory.newInstance().getHolidayCalendar("WE", Period.class);
        ArrayList<Period> periods = new ArrayList<Period>();
        Period period1 = new Period();
        period1.setStartCalendar(ISDADateFormat.parse("2007/11/10"));
        period1.setEndCalendar(ISDADateFormat.parse("2007/11/16"));
        Period period2 = new Period();
        period2.setStartCalendar(ISDADateFormat.parse("2007/11/16"));
        period2.setEndCalendar(ISDADateFormat.parse("2007/11/25"));
        periods.add(period1);
        periods.add(period2);
        ArrayList adjustedPeriods = holidayCalendar.adjust((Period)((Object)periods), BusinessDayConvention.FOLLOWING);
        HolidayCalendarTest.assertEquals((int)2, (int)adjustedPeriods.size());
        Period adjustedPeriod1 = (Period)adjustedPeriods.get(0);
        Period adjustedPeriod2 = (Period)adjustedPeriods.get(1);
        HolidayCalendarTest.assertEquals((String)"2007/11/12", (String)ISDADateFormat.format(adjustedPeriod1.getStartCalendar()));
        HolidayCalendarTest.assertEquals((String)"2007/11/16", (String)ISDADateFormat.format(adjustedPeriod1.getEndCalendar()));
        HolidayCalendarTest.assertEquals((String)"2007/11/16", (String)ISDADateFormat.format(adjustedPeriod2.getStartCalendar()));
        HolidayCalendarTest.assertEquals((String)"2007/11/26", (String)ISDADateFormat.format(adjustedPeriod2.getEndCalendar()));
    }

    public void testIsLastDayOfMonth() throws ParseException {
        Calendar lastDay = ISDADateFormat.parse("2007/10/31");
        Calendar notLastDay = ISDADateFormat.parse("2008/2/28");
        HolidayCalendarTest.assertTrue((boolean)HolidayCalendar.isLastDayOfMonth(lastDay));
        HolidayCalendarTest.assertFalse((boolean)HolidayCalendar.isLastDayOfMonth(notLastDay));
    }
}

