/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.accrual.impl;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import junit.framework.TestCase;
import org.jfin.common.Iso4217Currency;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.Frequency;
import org.jfin.date.ScheduleException;
import org.jfin.date.StubType;
import org.jfin.date.TypedScheduleGenerator;
import org.jfin.date.accrual.AccrualSchedule;
import org.jfin.date.accrual.NotionalSchedule;
import org.jfin.date.accrual.PaymentType;
import org.jfin.date.accrual.impl.FixedAccrualPeriod;
import org.jfin.date.accrual.impl.FixingAdjustmentType;
import org.jfin.date.accrual.impl.FlatNotionalSchedule;
import org.jfin.date.accrual.impl.FloatAccrualPeriod;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountCalculatorFactory;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarFactory;
import org.jfin.date.test.accrual.impl.MockPayment;
import org.jfin.date.util.ISDADateFormat;

public class PlainSwapTest
extends TestCase {
    private List<FixedAccrualPeriod> fixedAccrualPeriods;
    private List<FloatAccrualPeriod> floatAccrualPeriods;
    NotionalSchedule notionalSchedule;
    private AccrualSchedule<FixedAccrualPeriod, MockPayment> fixedSchedule;
    private AccrualSchedule<FloatAccrualPeriod, MockPayment> floatSchedule;
    private int significantDigits = 2;
    double[] expectedFixedAmounts = new double[]{20.11, 20.44, 20.22, 20.44, 20.11, 20.67, 19.89, 20.56, 20.22, 20.22, 20.22, 20.44, 20.11, 20.44, 20.11, 20.44, 20.11, 20.67, 20.22, 20.22};
    private String[] paymentDates = new String[]{""};

    public void setUp() throws ParseException, ScheduleException {
        BusinessDayConvention paymentBusinessDayConvention = BusinessDayConvention.MODIFIED_FOLLOWING;
        BusinessDayConvention accrualBusinessDayConvention = BusinessDayConvention.MODIFIED_FOLLOWING;
        BusinessDayConvention fixingBusinessDayConvention = BusinessDayConvention.PRECEDING;
        HolidayCalendar holidayCalendar = HolidayCalendarFactory.newInstance().getHolidayCalendar("WE");
        DaycountCalculator fixedDaycountCalculator = DaycountCalculatorFactory.newInstance().getActual360();
        DaycountCalculator floatDaycountCalculator = DaycountCalculatorFactory.newInstance().getActual360();
        int fixingOffset = -2;
        FixingAdjustmentType fixingAdjustmentType = FixingAdjustmentType.BUSINESS_DAYS;
        Iso4217Currency currency = Iso4217Currency.EUR;
        double notional = 1000.0;
        double fixedRate = 0.04;
        double floatRate = 0.02;
        Calendar startDate = ISDADateFormat.parse("2007/1/16");
        String maturity = "10Y";
        StubType stubType = StubType.NONE;
        Frequency fixedFrequency = Frequency.SEMI_ANNUALLY;
        Frequency floatFrequency = Frequency.QUARTERLY;
        MockPayment paymentPrototype = new MockPayment();
        paymentPrototype.setTestField("TEST");
        this.fixedSchedule = new AccrualSchedule(paymentPrototype);
        this.floatSchedule = new AccrualSchedule(paymentPrototype);
        FixedAccrualPeriod fixedPeriodPrototype = new FixedAccrualPeriod();
        fixedPeriodPrototype.setDaycountCalculator(fixedDaycountCalculator);
        fixedPeriodPrototype.setFixedRate(fixedRate);
        fixedPeriodPrototype.setPaymentBusinessDayConvention(paymentBusinessDayConvention);
        fixedPeriodPrototype.setPaymentHolidayCalendar(holidayCalendar);
        fixedPeriodPrototype.setPaymentType(PaymentType.IN_ARREARS);
        fixedPeriodPrototype.setAccrualHolidayCalendar(holidayCalendar);
        fixedPeriodPrototype.setAccrualBusinessDayConvention(accrualBusinessDayConvention);
        FloatAccrualPeriod floatPeriodPrototype = new FloatAccrualPeriod();
        floatPeriodPrototype.setDaycountCalculator(floatDaycountCalculator);
        floatPeriodPrototype.setFixingBusinessDayConvention(fixingBusinessDayConvention);
        floatPeriodPrototype.setFixingCalendarOffsetAmount(fixingOffset);
        floatPeriodPrototype.setFixingAdjustmentType(fixingAdjustmentType);
        floatPeriodPrototype.setFixingHolidayCalendar(holidayCalendar);
        floatPeriodPrototype.setPaymentBusinessDayConvention(paymentBusinessDayConvention);
        floatPeriodPrototype.setPaymentHolidayCalendar(holidayCalendar);
        floatPeriodPrototype.setPaymentType(PaymentType.IN_ARREARS);
        floatPeriodPrototype.setAccrualHolidayCalendar(holidayCalendar);
        floatPeriodPrototype.setAccrualBusinessDayConvention(accrualBusinessDayConvention);
        floatPeriodPrototype.setFixingRate(floatRate);
        TypedScheduleGenerator<FixedAccrualPeriod> fixedScheduleGenerator = new TypedScheduleGenerator<FixedAccrualPeriod>(fixedPeriodPrototype);
        TypedScheduleGenerator<FloatAccrualPeriod> floatScheduleGenerator = new TypedScheduleGenerator<FloatAccrualPeriod>(floatPeriodPrototype);
        this.fixedAccrualPeriods = fixedScheduleGenerator.generateSchedule(startDate, maturity, fixedFrequency, stubType);
        this.floatAccrualPeriods = floatScheduleGenerator.generateSchedule(startDate, maturity, floatFrequency, stubType);
        this.fixedSchedule.setAccrualPeriods(this.fixedAccrualPeriods);
        this.floatSchedule.setAccrualPeriods(this.floatAccrualPeriods);
        this.notionalSchedule = new FlatNotionalSchedule(notional, currency);
    }

    public void testScheduleLengths() {
        PlainSwapTest.assertEquals((int)20, (int)this.fixedAccrualPeriods.size());
        PlainSwapTest.assertEquals((int)40, (int)this.floatAccrualPeriods.size());
    }

    public void testMockPaymentsInitialised() throws Exception {
        List<MockPayment> payments = this.fixedSchedule.getPayments(this.notionalSchedule);
        payments.addAll(this.floatSchedule.getPayments(this.notionalSchedule));
        for (MockPayment payment : payments) {
            PlainSwapTest.assertEquals((String)"TEST", (String)payment.getTestField());
        }
    }

    public void testFixedSchedulePayment() throws Exception {
        List<MockPayment> payments = this.fixedSchedule.getNettedPayments(this.notionalSchedule);
        for (int i = 0; i < payments.size(); ++i) {
            MockPayment payment = payments.get(i);
            double expectedAmount = this.expectedFixedAmounts[i];
            double actualAmount = payment.getAmount();
            PlainSwapTest.assertEquals((String)("Payment for date " + ISDADateFormat.format(payment.getPaymentCalendar())), (String)this.formatDouble(expectedAmount), (String)this.formatDouble(actualAmount));
        }
    }

    public void testFormatDouble() {
        PlainSwapTest.assertEquals((String)"1.23", (String)this.formatDouble(1.23));
        PlainSwapTest.assertEquals((String)"1.23", (String)this.formatDouble(1.234));
        PlainSwapTest.assertEquals((String)"1.24", (String)this.formatDouble(1.235));
    }

    private String formatDouble(double d1) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(this.significantDigits);
        return nf.format(d1);
    }
}

