/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.accrual.impl;

import java.text.ParseException;
import java.util.Calendar;
import junit.framework.TestCase;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.accrual.AccrualException;
import org.jfin.date.accrual.PaymentType;
import org.jfin.date.accrual.impl.FixedAccrualPeriod;
import org.jfin.date.daycount.DaycountCalculatorFactory;
import org.jfin.date.holiday.HolidayCalendarFactory;
import org.jfin.date.util.ISDADateFormat;

public class FixedAccrualPeriodTest
extends TestCase {
    public void testClone() throws ParseException {
        FixedAccrualPeriod toCopy = new FixedAccrualPeriod();
        toCopy.setDaycountCalculator(DaycountCalculatorFactory.newInstance().getEU30360());
        toCopy.setEndCalendar(ISDADateFormat.parse("2006/06/01"));
        toCopy.setFixedRate(100.0);
        toCopy.setPaymentBusinessDayConvention(BusinessDayConvention.FOLLOWING);
        toCopy.setPaymentHolidayCalendar(HolidayCalendarFactory.newInstance().getHolidayCalendar("WE"));
        toCopy.setPaymentType(PaymentType.IN_ADVANCE);
        toCopy.setReferenceEndCalendar(ISDADateFormat.parse("2006/06/01"));
        toCopy.setReferenceStartCalendar(ISDADateFormat.parse("2006/03/01"));
        toCopy.setStartCalendar(ISDADateFormat.parse("2006/03/01"));
        toCopy.initialise();
        FixedAccrualPeriod copy = toCopy.clone();
        FixedAccrualPeriodTest.assertEquals((Object)toCopy.getDaycountCalculator(), (Object)copy.getDaycountCalculator());
        FixedAccrualPeriodTest.assertEquals((Object)toCopy.getEndCalendar(), (Object)copy.getEndCalendar());
        FixedAccrualPeriodTest.assertEquals((Object)toCopy.getFixedRate(), (Object)copy.getFixedRate());
        FixedAccrualPeriodTest.assertEquals((Object)((Object)toCopy.getPaymentBusinessDayConvention()), (Object)((Object)copy.getPaymentBusinessDayConvention()));
        FixedAccrualPeriodTest.assertEquals((Object)toCopy.getPaymentHolidayCalendar(), (Object)copy.getPaymentHolidayCalendar());
        FixedAccrualPeriodTest.assertEquals((Object)((Object)toCopy.getPaymentType()), (Object)((Object)copy.getPaymentType()));
        FixedAccrualPeriodTest.assertEquals((Object)toCopy.getReferenceEndCalendar(), (Object)copy.getReferenceEndCalendar());
        FixedAccrualPeriodTest.assertEquals((Object)toCopy.getReferenceStartCalendar(), (Object)copy.getReferenceStartCalendar());
        FixedAccrualPeriodTest.assertEquals((Object)toCopy.getStartCalendar(), (Object)copy.getStartCalendar());
        FixedAccrualPeriodTest.assertEquals((Object)toCopy.getPaymentCalendar(), (Object)copy.getPaymentCalendar());
    }

    public void testInitialiseInAdvance() throws ParseException {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setDaycountCalculator(DaycountCalculatorFactory.newInstance().getEU30360());
        accrualPeriod.setStartCalendar(ISDADateFormat.parse("2006/03/01"));
        accrualPeriod.setEndCalendar(ISDADateFormat.parse("2006/06/01"));
        accrualPeriod.setFixedRate(100.0);
        accrualPeriod.setPaymentBusinessDayConvention(BusinessDayConvention.UNADJUSTED);
        accrualPeriod.setPaymentType(PaymentType.IN_ADVANCE);
        accrualPeriod.initialise();
        FixedAccrualPeriodTest.assertEquals((Object)((Object)PaymentType.IN_ADVANCE), (Object)((Object)accrualPeriod.getPaymentType()));
        FixedAccrualPeriodTest.assertEquals((String)"2006/03/01", (String)ISDADateFormat.formatFixedLength(accrualPeriod.getPaymentCalendar()));
    }

    public void testInitialiseInArrears() throws ParseException {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setDaycountCalculator(DaycountCalculatorFactory.newInstance().getEU30360());
        accrualPeriod.setStartCalendar(ISDADateFormat.parse("2006/03/01"));
        accrualPeriod.setEndCalendar(ISDADateFormat.parse("2006/06/01"));
        accrualPeriod.setFixedRate(100.0);
        accrualPeriod.setPaymentBusinessDayConvention(BusinessDayConvention.UNADJUSTED);
        accrualPeriod.setPaymentType(PaymentType.IN_ARREARS);
        accrualPeriod.initialise();
        FixedAccrualPeriodTest.assertEquals((Object)((Object)PaymentType.IN_ARREARS), (Object)((Object)accrualPeriod.getPaymentType()));
        FixedAccrualPeriodTest.assertEquals((String)"2006/06/01", (String)ISDADateFormat.formatFixedLength(accrualPeriod.getPaymentCalendar()));
    }

    public void testImproperBusinessDayConvention1() {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setPaymentBusinessDayConvention(BusinessDayConvention.FOLLOWING);
        try {
            accrualPeriod.getAdjustedStartCalendar();
        }
        catch (AccrualException e) {
            return;
        }
        FixedAccrualPeriodTest.fail((String)"Did not throw exception when expected");
    }

    public void testImproperBusinessDayConvention2() {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setPaymentBusinessDayConvention(BusinessDayConvention.FOLLOWING);
        try {
            accrualPeriod.getAdjustedEndCalendar();
        }
        catch (AccrualException e) {
            return;
        }
        FixedAccrualPeriodTest.fail((String)"Did not throw exception when expected");
    }

    public void testImproperBusinessDayConvention3() throws ParseException {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setPaymentBusinessDayConvention(BusinessDayConvention.FOLLOWING);
        accrualPeriod.setStartCalendar(ISDADateFormat.parse("2006/01/01"));
        accrualPeriod.setEndCalendar(ISDADateFormat.parse("2006/04/01"));
        try {
            accrualPeriod.getAdjustedStartCalendar();
        }
        catch (AccrualException e) {
            return;
        }
        FixedAccrualPeriodTest.fail((String)"Did not throw exception when expected");
    }

    public void testImproperBusinessDayConvention4() throws ParseException {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setPaymentBusinessDayConvention(BusinessDayConvention.FOLLOWING);
        accrualPeriod.setStartCalendar(ISDADateFormat.parse("2006/01/01"));
        accrualPeriod.setEndCalendar(ISDADateFormat.parse("2006/04/01"));
        try {
            accrualPeriod.getAdjustedEndCalendar();
        }
        catch (AccrualException e) {
            return;
        }
        FixedAccrualPeriodTest.fail((String)"Did not throw exception when expected");
    }

    public void testImproperBusinessDayConvention5() throws ParseException {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setPaymentBusinessDayConvention(null);
        accrualPeriod.setStartCalendar(ISDADateFormat.parse("2006/01/01"));
        accrualPeriod.setEndCalendar(ISDADateFormat.parse("2006/04/01"));
        try {
            accrualPeriod.getAdjustedStartCalendar();
        }
        catch (AccrualException e) {
            return;
        }
        FixedAccrualPeriodTest.fail((String)"Did not throw exception when expected");
    }

    public void testImproperBusinessDayConvention6() throws ParseException {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setPaymentBusinessDayConvention(null);
        accrualPeriod.setStartCalendar(ISDADateFormat.parse("2007/01/01"));
        accrualPeriod.setEndCalendar(ISDADateFormat.parse("2007/04/01"));
        try {
            accrualPeriod.getAdjustedEndCalendar();
        }
        catch (AccrualException e) {
            return;
        }
        FixedAccrualPeriodTest.fail((String)"Did not throw exception when expected");
    }

    public void testProperBusinessDayConvention1() throws ParseException {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setAccrualBusinessDayConvention(BusinessDayConvention.FOLLOWING);
        accrualPeriod.setStartCalendar(ISDADateFormat.parse("2007/01/13"));
        accrualPeriod.setEndCalendar(ISDADateFormat.parse("2007/01/28"));
        accrualPeriod.setAccrualHolidayCalendar(HolidayCalendarFactory.newInstance().getHolidayCalendar("WE"));
        try {
            Calendar adjustedStartCalendar = accrualPeriod.getAdjustedStartCalendar();
            FixedAccrualPeriodTest.assertEquals((String)"2007/01/15", (String)ISDADateFormat.formatFixedLength(adjustedStartCalendar));
        }
        catch (AccrualException e) {
            FixedAccrualPeriodTest.fail();
        }
    }

    public void testProperBusinessDayConvention2() throws ParseException {
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setAccrualBusinessDayConvention(BusinessDayConvention.FOLLOWING);
        accrualPeriod.setStartCalendar(ISDADateFormat.parse("2007/01/13"));
        accrualPeriod.setEndCalendar(ISDADateFormat.parse("2007/01/28"));
        accrualPeriod.setAccrualHolidayCalendar(HolidayCalendarFactory.newInstance().getHolidayCalendar("WE"));
        try {
            Calendar adjustedEndCalendar = accrualPeriod.getAdjustedEndCalendar();
            FixedAccrualPeriodTest.assertEquals((String)"2007/01/29", (String)ISDADateFormat.formatFixedLength(adjustedEndCalendar));
        }
        catch (AccrualException e) {
            FixedAccrualPeriodTest.fail();
        }
    }
}

