/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.holiday;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfin.date.Period;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarException;
import org.jfin.date.holiday.HolidayCalendarSet;

public abstract class HolidayCalendarFactory {
    private static Logger logger = Logger.getLogger("org.jfin.date.holiday.HolidayCalendarFactory");
    public static String defaultHolidayCalendarFactoryClassName = "org.jfin.date.holiday.defaultimpl.HolidayCalendarFactoryImpl";
    public static String defaultHolidayCalendarFactoryClassNameParameter = "jfin.HolidayCalendarFactory";

    public static HolidayCalendarFactory newInstance() {
        logger.info("Constructing new default holiday calendar provider.");
        String holidayCalendarFactoryClassName = System.getProperty(defaultHolidayCalendarFactoryClassNameParameter);
        if (holidayCalendarFactoryClassName == null) {
            logger.info("No system property " + defaultHolidayCalendarFactoryClassNameParameter + " provided, using " + defaultHolidayCalendarFactoryClassName);
            holidayCalendarFactoryClassName = defaultHolidayCalendarFactoryClassName;
        } else {
            logger.info("Found system property " + defaultHolidayCalendarFactoryClassNameParameter + ": " + holidayCalendarFactoryClassName);
        }
        return HolidayCalendarFactory.newInstance(holidayCalendarFactoryClassName);
    }

    public static HolidayCalendarFactory newInstance(String holidayCalendarFactoryClassName) {
        try {
            logger.info("Attempting to instantiate " + holidayCalendarFactoryClassName);
            Class<?> holidayCalendarProviderClass = Class.forName(holidayCalendarFactoryClassName);
            HolidayCalendarFactory holidayCalendarFactory = (HolidayCalendarFactory)holidayCalendarProviderClass.newInstance();
            return holidayCalendarFactory;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Cannot create a holidayCalendarProvider with class " + holidayCalendarFactoryClassName + ". Check that this class exists within the classpath.", e);
            throw new HolidayCalendarException(e);
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "Cannot create a holidayCalendarProvider with class " + holidayCalendarFactoryClassName + ". Check that this class implements a default constructor.", e);
            throw new HolidayCalendarException(e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "Cannot create a holidayCalendarProvider with class " + holidayCalendarFactoryClassName + ". Check that this class implements a public default constructor.", e);
            throw new HolidayCalendarException(e);
        }
        catch (ClassCastException e) {
            logger.log(Level.SEVERE, "Cannot create a holidayCalendarProvider with class " + holidayCalendarFactoryClassName + ". Check that this class extends HolidayCalendarFactory.", e);
            throw new HolidayCalendarException(e);
        }
    }

    public abstract HolidayCalendar getHolidayCalendar(String var1);

    public abstract <T extends Period> HolidayCalendar<T> getHolidayCalendar(String var1, Class<T> var2);

    public <T extends Period> HolidayCalendar<T> getHolidayCalendar(String[] locales, Class<T> c) {
        if (locales.length == 1) {
            return this.getHolidayCalendar(locales[0]);
        }
        HolidayCalendarSet holidayCalendarSet = new HolidayCalendarSet();
        for (int i = 0; i < locales.length; ++i) {
            HolidayCalendar holidayCalendar = this.getHolidayCalendar(locales[i]);
            holidayCalendarSet.addHolidayCalendar(holidayCalendar);
        }
        return holidayCalendarSet;
    }

    public HolidayCalendar getHolidayCalendar(String[] locales) {
        return this.getHolidayCalendar(locales, Period.class);
    }

    public abstract String[] getAvailableLocales();
}

