/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.daycount.defaultimpl;

import java.util.Calendar;
import java.util.logging.Logger;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountException;
import org.jfin.date.util.ISDADateFormat;

public class ISMAActualActual
extends DaycountCalculator {
    private static Logger logger = Logger.getLogger("org.jfin.date.daycount.defaultimpl.ISMAActualActual");

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar) throws DaycountException {
        return this.calculateDaycountFraction(startCalendar, endCalendar, null, null);
    }

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar, Calendar periodStartCalendar, Calendar periodEndCalendar) throws DaycountException {
        Calendar newRefEnd;
        Calendar newRefStart;
        logger.finer("Calculating daycount fraction for " + ISDADateFormat.format(startCalendar) + " - " + ISDADateFormat.format(endCalendar));
        if (periodStartCalendar != null && periodEndCalendar != null) {
            logger.finer("Provided with reference period " + ISDADateFormat.format(periodStartCalendar) + " - " + ISDADateFormat.format(periodEndCalendar));
        }
        if (startCalendar.after(endCalendar)) {
            logger.fine("Dates are wrong way round so swap over");
            Calendar holdCalendar = startCalendar;
            startCalendar = endCalendar;
            endCalendar = holdCalendar;
        }
        if (startCalendar.equals(endCalendar)) {
            logger.fine("Dates are the same so return zero");
            return 0.0;
        }
        Calendar refPeriodStart = periodStartCalendar != null ? periodStartCalendar : startCalendar;
        Calendar refPeriodEnd = periodEndCalendar != null ? periodEndCalendar : endCalendar;
        logger.finer("Using reference period " + ISDADateFormat.format(refPeriodStart) + " - " + ISDADateFormat.format(refPeriodEnd));
        if (!refPeriodEnd.after(refPeriodStart) || !refPeriodEnd.after(startCalendar)) {
            throw new DaycountException("invalid reference period: date 1: " + ISDADateFormat.format(startCalendar) + ", date 2: " + ISDADateFormat.format(endCalendar) + ", reference period start: " + ISDADateFormat.format(refPeriodStart) + ", reference period end: " + ISDADateFormat.format(refPeriodEnd));
        }
        double monthsEstimate = (double)this.daysBetween(refPeriodStart, refPeriodEnd) * 0.03287671232876712;
        int months = (int)Math.round(monthsEstimate);
        logger.finer("Estimated months as " + months + " (" + monthsEstimate + ")");
        if (months == 0) {
            logger.fine("Short period (Estimated months is 0), taking reference period as 1 year from d1.");
            refPeriodStart = startCalendar;
            refPeriodEnd = (Calendar)startCalendar.clone();
            refPeriodEnd.add(1, 1);
            months = 12;
        }
        double period = (double)months / 12.0;
        logger.finer("Period calculated as " + period);
        if (endCalendar.before(refPeriodEnd) || endCalendar.equals(refPeriodEnd)) {
            logger.finer("refPeriodEnd is a future (maybe notional) payment date");
            if (startCalendar.after(refPeriodStart) || startCalendar.equals(refPeriodStart)) {
                logger.finer("refPeriodStart is the last (maybe notional) payment date. refPeriodStart <= d1 <= d2 <= refPeriodEnd [maybe the equality should be enforced, since refPeriodStart < d1 <= d2 < refPeriodEnd could give wrong results] ???");
                long numerator = this.daysBetween(startCalendar, endCalendar);
                long denominator = this.daysBetween(refPeriodStart, refPeriodEnd);
                logger.fine("Calculating portion between date 1: " + ISDADateFormat.format(startCalendar) + ", date 2: " + ISDADateFormat.format(endCalendar) + " as " + period + " * " + numerator + "/" + denominator);
                return period * (double)numerator / (double)denominator;
            }
            logger.finer("refPeriodStart is the next (maybe notional) payment date and refPeriodEnd is the second next (maybe notional) payment date. d1 < refPeriodStart < refPeriodEnd AND d2 <= refPeriodEnd this case is long first coupon ");
            Calendar previousRef = (Calendar)startCalendar.clone();
            logger.finer("The last notional payment date is " + ISDADateFormat.format(previousRef));
            if (endCalendar.after(refPeriodStart)) {
                return this.calculateDaycountFraction(startCalendar, refPeriodStart, previousRef, refPeriodStart) + this.calculateDaycountFraction(refPeriodStart, endCalendar, refPeriodStart, refPeriodEnd);
            }
            return this.calculateDaycountFraction(startCalendar, endCalendar, previousRef, refPeriodStart);
        }
        logger.finer("refPeriodEnd is the last (notional?) payment date d1 < refPeriodEnd < d2 AND refPeriodStart < refPeriodEnd");
        if (!refPeriodStart.before(startCalendar) && !refPeriodStart.equals(startCalendar)) {
            throw new DaycountException("invalid dates: d1 < refPeriodStart < refPeriodEnd < d2");
        }
        logger.finer("refPeriodStart <= d1 < refPeriodEnd < d2");
        double sum = this.calculateDaycountFraction(startCalendar, refPeriodEnd, refPeriodStart, refPeriodEnd);
        logger.finer("The part from d1 to refPeriodEnd is " + sum);
        int i = 0;
        while (true) {
            newRefStart = (Calendar)refPeriodEnd.clone();
            newRefStart.add(2, months * i);
            newRefEnd = (Calendar)refPeriodEnd.clone();
            newRefEnd.add(2, months * (i + 1));
            if (endCalendar.before(newRefEnd)) break;
            sum += period;
            ++i;
        }
        double secondSum = this.calculateDaycountFraction(newRefStart, endCalendar, newRefStart, newRefEnd);
        logger.finer("The part from refPeriodEnd to d2 is " + sum);
        return sum += secondSum;
    }
}

