/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.daycount.defaultimpl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import org.jfin.date.Period;
import org.jfin.date.ScheduleGenerator;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountException;
import org.jfin.date.util.ISDADateFormat;

public class ISDAActualActual
extends DaycountCalculator {
    private static Logger logger = Logger.getLogger("org.jfin.date.daycount.defaultimpl.ISDAActualActual");

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar) throws DaycountException {
        logger.finer("Calculating daycount fraction for " + ISDADateFormat.format(startCalendar) + " - " + ISDADateFormat.format(endCalendar));
        if (startCalendar.after(endCalendar)) {
            logger.fine("Dates are wrong way round so swap over");
            Calendar holdCalendar = startCalendar;
            startCalendar = endCalendar;
            endCalendar = holdCalendar;
        }
        if (startCalendar.equals(endCalendar)) {
            logger.fine("Dates are the same so return zero");
            return 0.0;
        }
        double fraction = 0.0;
        List<Period> subPeriods = this.getPeriods(startCalendar, endCalendar);
        int[] numerators = this.getNumerators(subPeriods);
        int[] denominators = this.getDenominators(subPeriods);
        for (int i = 0; i < numerators.length; ++i) {
            fraction += (double)numerators[i] / (double)denominators[i];
        }
        return fraction;
    }

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar, Calendar periodStartCalendar, Calendar periodEndCalendar) throws DaycountException {
        return this.calculateDaycountFraction(startCalendar, endCalendar);
    }

    public List<Period> getPeriods(Calendar startCalendar, Calendar endCalendar) {
        Calendar hold = ScheduleGenerator.copyAndReset(startCalendar);
        Calendar end = ScheduleGenerator.copyAndReset(endCalendar);
        ArrayList<Period> periods = new ArrayList<Period>();
        while (hold.get(1) < end.get(1)) {
            Calendar holdEnd = ScheduleGenerator.copyAndReset(hold);
            holdEnd.set(1, hold.get(1) + 1);
            holdEnd.set(2, 0);
            holdEnd.set(5, 1);
            periods.add(new Period(ScheduleGenerator.copyAndReset(hold), holdEnd));
            hold = ScheduleGenerator.copyAndReset(holdEnd);
        }
        periods.add(new Period(hold, end));
        return periods;
    }

    public int[] getNumerators(List<Period> subPeriods) {
        int[] numerators = new int[subPeriods.size()];
        for (int i = 0; i < subPeriods.size(); ++i) {
            Period period = subPeriods.get(i);
            numerators[i] = (int)this.daysBetween(period.getStartCalendar(), period.getEndCalendar());
        }
        return numerators;
    }

    public int[] getDenominators(List<Period> subPeriods) {
        int[] denominators = new int[subPeriods.size()];
        for (int i = 0; i < subPeriods.size(); ++i) {
            Period period = subPeriods.get(i);
            denominators[i] = period.getStartCalendar().getActualMaximum(6);
        }
        return denominators;
    }
}

