/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.daycount.defaultimpl;

import java.util.Calendar;
import java.util.logging.Logger;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountException;

public class AFBActualActual
extends DaycountCalculator {
    private static Logger logger = Logger.getLogger("org.jfin.date.daycount.defaultimpl.AFBActualActual");

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar) throws DaycountException {
        if (startCalendar.after(endCalendar)) {
            logger.fine("Dates are wrong way round so swap over");
            Calendar holdCalendar = startCalendar;
            startCalendar = endCalendar;
            endCalendar = holdCalendar;
        }
        if (startCalendar.equals(endCalendar)) {
            logger.fine("Dates are the same so return zero");
            return 0.0;
        }
        Calendar newD2 = endCalendar;
        Calendar temp = (Calendar)endCalendar.clone();
        double sum = 0.0;
        while (temp.after(startCalendar)) {
            temp = (Calendar)newD2.clone();
            temp.add(1, -1);
            if (temp.get(5) == 28 && temp.get(2) == 1 && temp.getActualMaximum(6) == 366) {
                temp.add(6, 1);
            }
            if (!temp.after(startCalendar) && !temp.equals(startCalendar)) continue;
            sum += 1.0;
            newD2 = temp;
        }
        double den = 365.0;
        if (newD2.getActualMaximum(6) == 366) {
            temp = (Calendar)newD2.clone();
            temp.set(2, 1);
            temp.set(5, 29);
            if (newD2.after(temp) && (startCalendar.before(temp) || startCalendar.equals(temp))) {
                den += 1.0;
            }
        } else if (startCalendar.getActualMaximum(6) == 366) {
            temp = (Calendar)startCalendar.clone();
            temp.set(2, 1);
            temp.set(5, 29);
            if (newD2.after(temp) && (startCalendar.before(temp) || startCalendar.equals(temp))) {
                den += 1.0;
            }
        }
        return sum + (double)this.daysBetween(startCalendar, newD2) / den;
    }

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar, Calendar periodStartCalendar, Calendar periodEndCalendar) throws DaycountException {
        return this.calculateDaycountFraction(startCalendar, endCalendar);
    }
}

