/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.accrual;

import java.util.Calendar;
import org.jfin.common.Iso4217Currency;
import org.jfin.date.Period;
import org.jfin.date.accrual.Notional;

public class NotionalPeriod
extends Period {
    Notional notional;

    public NotionalPeriod() {
    }

    public NotionalPeriod(NotionalPeriod toCopy) {
        super(toCopy);
        this.notional = toCopy.notional;
    }

    public NotionalPeriod(Notional notional) {
        this.notional = notional;
    }

    public NotionalPeriod(double amount, Iso4217Currency currency) {
        this.notional = new Notional(amount, currency);
    }

    public NotionalPeriod(Calendar startCalendar, Calendar endCalendar, Notional notional) {
        super(startCalendar, endCalendar);
        this.notional = notional;
    }

    public NotionalPeriod(Calendar startCalendar, Calendar endCalendar, double amount, Iso4217Currency currency) {
        super(startCalendar, endCalendar);
        this.notional = new Notional(amount, currency);
    }

    @Override
    public NotionalPeriod clone() {
        return new NotionalPeriod(this);
    }

    public Notional getNotional() {
        return this.notional;
    }

    public void setNotional(Notional notional) {
        this.notional = notional;
    }

    public double getAmount() {
        return this.notional.getAmount();
    }

    public void setAmount(double amount) {
        this.notional.setAmount(amount);
    }

    public Iso4217Currency getCurrency() {
        return this.notional.getCurrency();
    }

    public void setCurrency(Iso4217Currency currency) {
        this.notional.setCurrency(currency);
    }
}

