/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.sax;

import java.io.IOException;
import javolution.lang.Reusable;
import javolution.text.CharArray;
import javolution.text.Text;
import javolution.xml.sax.Attributes;
import javolution.xml.sax.ContentHandler;
import javolution.xml.sax.XMLReaderImpl;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class SAX2ReaderImpl
implements XMLReader,
Reusable {
    private static Sax2DefaultHandler DEFAULT_HANDLER = new Sax2DefaultHandler();
    private final XMLReaderImpl _parser = new XMLReaderImpl();
    private final Proxy _proxy = new Proxy();

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this._parser.getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this._parser.setFeature(string, bl);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this._parser.getProperty(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this._parser.setProperty(string, object);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._parser.setEntityResolver(entityResolver);
    }

    public EntityResolver getEntityResolver() {
        return this._parser.getEntityResolver();
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this._parser.setDTDHandler(dTDHandler);
    }

    public DTDHandler getDTDHandler() {
        return this._parser.getDTDHandler();
    }

    public void setContentHandler(org.xml.sax.ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException();
        }
        this._proxy._sax2Handler = contentHandler;
        this._parser.setContentHandler(this._proxy);
    }

    public org.xml.sax.ContentHandler getContentHandler() {
        return this._proxy._sax2Handler == DEFAULT_HANDLER ? null : this._proxy._sax2Handler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._parser.setErrorHandler(errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this._parser.getErrorHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource) throws IOException, SAXException {
        try {
            this._parser.parse(inputSource);
        }
        finally {
            this._parser.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String string) throws IOException, SAXException {
        try {
            this._parser.parse(string);
        }
        finally {
            this._parser.reset();
        }
    }

    public void reset() {
        this._parser.reset();
    }

    private static CharSequence toCharSequence(Object object) {
        return object instanceof CharSequence ? (CharSequence)object : Text.valueOf(object);
    }

    private static final class Sax2DefaultHandler
    implements EntityResolver,
    DTDHandler,
    org.xml.sax.ContentHandler,
    ErrorHandler {
        private Sax2DefaultHandler() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            return null;
        }

        public void notationDecl(String string, String string2, String string3) throws SAXException {
        }

        public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }

    private static final class Proxy
    implements ContentHandler,
    org.xml.sax.Attributes {
        private org.xml.sax.ContentHandler _sax2Handler = SAX2ReaderImpl.access$200();
        private Attributes _attributes;

        public void setDocumentLocator(Locator locator) {
            this._sax2Handler.setDocumentLocator(locator);
        }

        public void startDocument() throws SAXException {
            this._sax2Handler.startDocument();
        }

        public void endDocument() throws SAXException {
            this._sax2Handler.endDocument();
            this._sax2Handler = DEFAULT_HANDLER;
        }

        public void startPrefixMapping(CharArray charArray, CharArray charArray2) throws SAXException {
            this._sax2Handler.startPrefixMapping(charArray.toString(), charArray2.toString());
        }

        public void endPrefixMapping(CharArray charArray) throws SAXException {
            this._sax2Handler.endPrefixMapping(charArray.toString());
        }

        public void startElement(CharArray charArray, CharArray charArray2, CharArray charArray3, Attributes attributes) throws SAXException {
            this._attributes = attributes;
            this._sax2Handler.startElement(charArray.toString(), charArray2.toString(), charArray3.toString(), this);
        }

        public void endElement(CharArray charArray, CharArray charArray2, CharArray charArray3) throws SAXException {
            this._sax2Handler.endElement(charArray.toString(), charArray2.toString(), charArray3.toString());
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this._sax2Handler.characters(cArray, n, n2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this._sax2Handler.ignorableWhitespace(cArray, n, n2);
        }

        public void processingInstruction(CharArray charArray, CharArray charArray2) throws SAXException {
            this._sax2Handler.processingInstruction(charArray.toString(), charArray2.toString());
        }

        public void skippedEntity(CharArray charArray) throws SAXException {
            this._sax2Handler.skippedEntity(charArray.toString());
        }

        public int getLength() {
            return this._attributes != null ? this._attributes.getLength() : 0;
        }

        public String getURI(int n) {
            CharArray charArray = this._attributes != null ? this._attributes.getURI(n) : null;
            return charArray != null ? ((Object)charArray).toString() : "";
        }

        public String getLocalName(int n) {
            CharArray charArray = this._attributes != null ? this._attributes.getLocalName(n) : null;
            return charArray != null ? ((Object)charArray).toString() : "";
        }

        public String getQName(int n) {
            CharArray charArray = this._attributes != null ? this._attributes.getQName(n) : null;
            return charArray != null ? ((Object)charArray).toString() : "";
        }

        public String getType(int n) {
            return this._attributes != null ? this._attributes.getType(n).toString() : null;
        }

        public String getValue(int n) {
            CharArray charArray = this._attributes != null ? this._attributes.getValue(n) : null;
            return charArray != null ? ((Object)charArray).toString() : null;
        }

        public int getIndex(String string, String string2) {
            return string != null && string2 != null && this._attributes != null ? this._attributes.getIndex(SAX2ReaderImpl.toCharSequence(string), SAX2ReaderImpl.toCharSequence(string2)) : -1;
        }

        public int getIndex(String string) {
            return string != null && this._attributes != null ? this._attributes.getIndex(SAX2ReaderImpl.toCharSequence(string)) : -1;
        }

        public String getType(String string, String string2) {
            return string != null && string2 != null && this._attributes != null ? this._attributes.getType(SAX2ReaderImpl.toCharSequence(string), SAX2ReaderImpl.toCharSequence(string2)).toString() : null;
        }

        public String getType(String string) {
            return string != null && this._attributes != null ? this._attributes.getType(SAX2ReaderImpl.toCharSequence(string)).toString() : null;
        }

        public String getValue(String string, String string2) {
            return string != null && string2 != null && this._attributes != null && this._attributes.getValue(SAX2ReaderImpl.toCharSequence(string), SAX2ReaderImpl.toCharSequence(string2)) != null ? this._attributes.getValue(SAX2ReaderImpl.toCharSequence(string), SAX2ReaderImpl.toCharSequence(string2)).toString() : null;
        }

        public String getValue(String string) {
            return string != null && this._attributes != null ? this._attributes.getValue(SAX2ReaderImpl.toCharSequence(string)).toString() : null;
        }
    }
}

