/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javolution.Javolution;
import javolution.JavolutionError;
import javolution.context.PersistentContext;
import javolution.lang.ClassInitializer;
import javolution.lang.Reflection;
import javolution.lang.Reusable;
import javolution.text.CharArray;
import javolution.text.Text;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.util.Index;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReaderImpl;
import javolution.xml.stream.XMLStreamWriterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBinding
implements Reusable,
XMLSerializable {
    private static FastMap STATIC_MAPPING = new FastMap().setShared(true);
    static final XMLBinding DEFAULT = new XMLBinding();
    static final XMLFormat XML = new XMLFormat(Javolution.j2meGetClass("javolution.xml.XMLBinding")){

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            XMLBinding xMLBinding = (XMLBinding)object;
            xMLBinding._classAttributeName = inputElement.getAttribute("classAttributeName", (String)null);
            xMLBinding._classAttributeURI = inputElement.getAttribute("classAttributeURI", (String)null);
            FastMap fastMap = xMLBinding._aliasToClass = inputElement.get("AliasToClass", FastMap.class);
            FastCollection.Record record = fastMap.head();
            FastMap.Entry entry = fastMap.tail();
            while ((record = ((FastMap.Entry)record).getNext()) != entry) {
                xMLBinding._classToAlias.put(((FastMap.Entry)record).getValue(), ((FastMap.Entry)record).getKey());
            }
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            XMLBinding xMLBinding = (XMLBinding)object;
            outputElement.setAttribute("classAttributeName", xMLBinding._classAttributeName);
            outputElement.setAttribute("classAttributeURI", xMLBinding._classAttributeURI);
            outputElement.add(xMLBinding._aliasToClass, "AliasToClass", FastMap.class);
        }
    };
    private String _classAttributeName = "class";
    private String _classAttributeURI = null;
    private FastMap _classToAlias = new FastMap();
    private FastMap _aliasToClass = new FastMap();
    static final XMLFormat<Object> OBJECT_XML = new XMLFormat((Class)new Object().getClass()){

        public void read(XMLFormat.InputElement inputElement, Object object) {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) {
        }
    };
    static final XMLFormat<Class> CLASS_XML = new XMLFormat((Class)"".getClass().getClass()){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            Class clazz2;
            CharArray charArray = inputElement.getAttribute("name");
            if (charArray == null) {
                throw new XMLStreamException("Attribute 'name' missing");
            }
            try {
                clazz2 = Reflection.getClass(charArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new XMLStreamException(classNotFoundException);
            }
            return clazz2;
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("name", ((Class)object).getName());
        }
    };
    static final XMLFormat<String> STRING_XML = new XMLFormat((Class)"".getClass()){

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            return inputElement.getAttribute("value", "");
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("value", (String)object);
        }
    };
    static final XMLFormat<Appendable> APPENDABLE_XML = new XMLFormat(Javolution.j2meGetClass("java.lang.Appendable")){

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            CharArray charArray = inputElement.getAttribute("value");
            if (charArray != null) {
                try {
                    ((Appendable)object).append(charArray);
                }
                catch (IOException iOException) {
                    throw new XMLStreamException(iOException);
                }
            }
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            if (object instanceof CharSequence) {
                outputElement.setAttribute("value", (CharSequence)object);
            } else {
                outputElement.setAttribute("value", object.toString());
            }
        }
    };
    static final XMLFormat<Collection> COLLECTION_XML = new XMLFormat(Javolution.j2meGetClass("java.util.Collection")){

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            Collection collection = (Collection)object;
            while (inputElement.hasNext()) {
                collection.add(inputElement.getNext());
            }
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                outputElement.add(iterator.next());
            }
        }
    };
    static final XMLFormat<Map> MAP_XML = new XMLFormat(Javolution.j2meGetClass("java.util.Map")){

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            Map map = (Map)object;
            while (inputElement.hasNext()) {
                Object t = inputElement.get("Key");
                Object t2 = inputElement.get("Value");
                map.put(t, t2);
            }
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                outputElement.add(entry.getKey(), "Key");
                outputElement.add(entry.getValue(), "Value");
            }
        }
    };
    static final XMLFormat<Object[]> OBJECT_ARRAY_XML = new XMLFormat((Class)new Object[0].getClass()){

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            Class clazz2;
            try {
                clazz2 = Reflection.getClass(inputElement.getAttribute("componentType"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new XMLStreamException(classNotFoundException);
            }
            int n = inputElement.getAttribute("length", 0);
            return Array.newInstance(clazz2, n);
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = inputElement.getNext();
            }
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            Object[] objectArray = (Object[])object;
            outputElement.setAttribute("componentType", objectArray.getClass().getComponentType().getName());
            outputElement.setAttribute("length", objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                outputElement.add(objectArray[i]);
            }
        }
    };
    static final XMLFormat<Boolean> BOOLEAN_XML = new XMLFormat((Class)new Boolean(true).getClass()){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            return new Boolean(inputElement.getAttribute("value", false));
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("value", (Boolean)object);
        }
    };
    static final XMLFormat<Byte> BYTE_XML = new XMLFormat((Class)new Byte(0).getClass()){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            return new Byte((byte)inputElement.getAttribute("value", 0));
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("value", ((Byte)object).byteValue());
        }
    };
    static final XMLFormat<Character> CHARACTER_XML = new XMLFormat((Class)new Character(' ').getClass()){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            CharArray charArray = inputElement.getAttribute("value");
            if (charArray == null || charArray.length() != 1) {
                throw new XMLStreamException("Missing or invalid value attribute");
            }
            return new Character(charArray.charAt(0));
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("value", Text.valueOf(((Character)object).charValue()));
        }
    };
    static final XMLFormat<Short> SHORT_XML = new XMLFormat((Class)new Short(0).getClass()){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            return new Short((short)inputElement.getAttribute("value", 0));
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("value", ((Short)object).shortValue());
        }
    };
    static final XMLFormat<Integer> INTEGER_XML = new XMLFormat((Class)new Integer(0).getClass()){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            return new Integer(inputElement.getAttribute("value", 0));
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("value", (Integer)object);
        }
    };
    static final XMLFormat<Long> LONG_XML = new XMLFormat((Class)new Long(0L).getClass()){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            return new Long(inputElement.getAttribute("value", 0L));
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("value", (Long)object);
        }
    };
    static final XMLFormat<Float> FLOAT_XML = new XMLFormat((Class)new Float(0.0f).getClass()){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            return new Float(inputElement.getAttribute("value", 0.0f));
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("value", ((Float)object).floatValue());
        }
    };
    static final XMLFormat<Double> DOUBLE_XML = new XMLFormat((Class)new Double(0.0).getClass()){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            return new Double(inputElement.getAttribute("value", 0.0));
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("value", (Double)object);
        }
    };
    static final XMLFormat<Text> TEXT_XML = new XMLFormat(Javolution.j2meGetClass("javolution.text.Text")){

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            CharArray charArray = inputElement.getAttribute("value");
            return charArray != null ? Text.valueOf(charArray) : Text.EMPTY;
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("value", (Text)object);
        }
    };
    static final XMLFormat<FastMap> FASTMAP_XML = new XMLFormat((Class)new FastMap().getClass()){

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            FastComparator fastComparator;
            FastMap fastMap = (FastMap)object;
            fastMap.setShared(inputElement.getAttribute("shared", false));
            FastComparator fastComparator2 = (FastComparator)inputElement.get("KeyComparator");
            if (fastComparator2 != null) {
                fastMap.setKeyComparator(fastComparator2);
            }
            if ((fastComparator = (FastComparator)inputElement.get("ValueComparator")) != null) {
                fastMap.setValueComparator(fastComparator);
            }
            while (inputElement.hasNext()) {
                Object t = inputElement.get("Key");
                Object t2 = inputElement.get("Value");
                fastMap.put(t, t2);
            }
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            FastMap fastMap = (FastMap)object;
            if (fastMap.isShared()) {
                outputElement.setAttribute("shared", true);
            }
            if (fastMap.getKeyComparator() != FastComparator.DEFAULT) {
                outputElement.add(fastMap.getKeyComparator(), "KeyComparator");
            }
            if (fastMap.getValueComparator() != FastComparator.DEFAULT) {
                outputElement.add(fastMap.getValueComparator(), "ValueComparator");
            }
            FastCollection.Record record = fastMap.head();
            FastMap.Entry entry = fastMap.tail();
            while ((record = ((FastMap.Entry)record).getNext()) != entry) {
                outputElement.add(((FastMap.Entry)record).getKey(), "Key");
                outputElement.add(((FastMap.Entry)record).getValue(), "Value");
            }
        }
    };
    static final XMLFormat<FastCollection> FASTCOLLECTION_XML = new XMLFormat(Javolution.j2meGetClass("javolution.util.FastCollection")){

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            FastCollection fastCollection = (FastCollection)object;
            while (inputElement.hasNext()) {
                fastCollection.add(inputElement.getNext());
            }
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            FastCollection fastCollection = (FastCollection)object;
            FastCollection.Record record = fastCollection.head();
            FastCollection.Record record2 = fastCollection.tail();
            while ((record = record.getNext()) != record2) {
                outputElement.add(fastCollection.valueOf(record));
            }
        }
    };
    static final XMLFormat<FastComparator> FASTCOMPARATOR_XML = new XMLFormat(Javolution.j2meGetClass("javolution.util.FastComparator")){

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            if (clazz == FastComparator.DEFAULT.getClass()) {
                return FastComparator.DEFAULT;
            }
            if (clazz == FastComparator.DIRECT.getClass()) {
                return FastComparator.DIRECT;
            }
            if (clazz == FastComparator.IDENTITY.getClass()) {
                return FastComparator.IDENTITY;
            }
            if (clazz == FastComparator.LEXICAL.getClass()) {
                return FastComparator.LEXICAL;
            }
            if (clazz == FastComparator.REHASH.getClass()) {
                return FastComparator.REHASH;
            }
            return super.newInstance(clazz, inputElement);
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
        }
    };
    static final XMLFormat<Index> INDEX_XML = new XMLFormat((Class)Index.ZERO.getClass()){

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            return Index.valueOf(inputElement.getAttribute("value", 0));
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("value", ((Index)object).intValue());
        }
    };
    static final XMLFormat<PersistentContext> PERSISTENT_CONTEXT_XML = new XMLFormat((Class)new PersistentContext().getClass()){

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            PersistentContext persistentContext = (PersistentContext)object;
            persistentContext.getIdToValue().putAll((FastMap)inputElement.get("References"));
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            PersistentContext persistentContext = (PersistentContext)object;
            outputElement.add(persistentContext.getIdToValue(), "References");
        }
    };

    public void setAlias(Class clazz, String string) {
        Class clazz2 = this._aliasToClass.put(string, clazz);
        if (clazz2 != null) {
            this._classToAlias.put(clazz2, null);
        }
        this._classToAlias.put(clazz, string);
    }

    public void setClassAttribute(String string) {
        this._classAttributeName = string;
        this._classAttributeURI = null;
    }

    public void setClassAttribute(String string, String string2) {
        this._classAttributeName = string;
        this._classAttributeURI = string2;
    }

    public <T> XMLFormat<T> getFormat(Class<T> clazz) {
        Object v = STATIC_MAPPING.get(clazz);
        return v != null ? (XMLFormat)v : this.searchFormat(clazz);
    }

    private XMLFormat searchFormat(Class clazz) {
        ClassInitializer.initialize(clazz);
        XMLFormat xMLFormat = null;
        int n = XMLFormat._ClassInstancesLength;
        for (int i = 0; i < n; ++i) {
            XMLFormat xMLFormat2 = XMLFormat._ClassInstances[i];
            if (!xMLFormat2._class.isAssignableFrom(clazz) || xMLFormat != null && !xMLFormat._class.isAssignableFrom(xMLFormat2._class)) continue;
            xMLFormat = xMLFormat2;
        }
        if (xMLFormat == null) {
            throw new JavolutionError("Cannot find format for " + clazz);
        }
        STATIC_MAPPING.put(clazz, xMLFormat);
        return xMLFormat;
    }

    protected String getName(Class clazz) {
        String string = (String)this._classToAlias.get(clazz);
        return string != null ? string : clazz.getName();
    }

    protected Class getClass(CharArray charArray) throws ClassNotFoundException {
        Class clazz = (Class)this._aliasToClass.get(charArray);
        return clazz != null ? clazz : Reflection.getClass(charArray);
    }

    protected String getLocalName(Class clazz) {
        return this.getName(clazz);
    }

    protected String getURI(Class clazz) {
        return null;
    }

    protected Class getClass(CharArray charArray, CharArray charArray2) throws ClassNotFoundException {
        return this.getClass(charArray);
    }

    @Override
    public void reset() {
        this._aliasToClass.reset();
        this._classToAlias.reset();
    }

    final Class readClassAttribute(XMLStreamReaderImpl xMLStreamReaderImpl) throws XMLStreamException {
        if (this._classAttributeName == null) {
            throw new XMLStreamException("Binding has no class attribute defined, cannot retrieve class");
        }
        CharArray charArray = xMLStreamReaderImpl.getAttributeValue(this._classAttributeURI, this._classAttributeName);
        if (charArray == null) {
            throw new XMLStreamException("Cannot retrieve class (class attribute not found)");
        }
        try {
            return this.getClass(charArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XMLStreamException(classNotFoundException);
        }
    }

    final void writeClassAttribute(XMLStreamWriterImpl xMLStreamWriterImpl, Class clazz) throws XMLStreamException {
        if (this._classAttributeName != null) {
            String string = this.getName(clazz);
            if (this._classAttributeURI == null) {
                xMLStreamWriterImpl.writeAttribute(this._classAttributeName, string);
            } else {
                xMLStreamWriterImpl.writeAttribute(this._classAttributeURI, this._classAttributeName, string);
            }
        }
    }

    private static CharSequence toCsq(Object object) {
        return Javolution.j2meToCharSeq(object);
    }
}

