/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayFactory<T> {
    public static final ArrayFactory<boolean[]> BOOLEANS_FACTORY = new ArrayFactory(){

        protected Object create(int n) {
            return new boolean[n];
        }

        public void recycle(Object object) {
            this.recycle(object, ((boolean[])object).length);
        }
    };
    public static final ArrayFactory<byte[]> BYTES_FACTORY = new ArrayFactory(){

        protected Object create(int n) {
            return new byte[n];
        }

        public void recycle(Object object) {
            this.recycle(object, ((byte[])object).length);
        }
    };
    public static final ArrayFactory<char[]> CHARS_FACTORY = new ArrayFactory(){

        protected Object create(int n) {
            return new char[n];
        }

        public void recycle(Object object) {
            this.recycle(object, ((char[])object).length);
        }
    };
    public static final ArrayFactory<short[]> SHORTS_FACTORY = new ArrayFactory(){

        protected Object create(int n) {
            return new short[n];
        }

        public void recycle(Object object) {
            this.recycle(object, ((short[])object).length);
        }
    };
    public static final ArrayFactory<int[]> INTS_FACTORY = new ArrayFactory(){

        protected Object create(int n) {
            return new int[n];
        }

        public void recycle(Object object) {
            this.recycle(object, ((int[])object).length);
        }
    };
    public static final ArrayFactory<long[]> LONGS_FACTORY = new ArrayFactory(){

        protected Object create(int n) {
            return new long[n];
        }

        public void recycle(Object object) {
            this.recycle(object, ((long[])object).length);
        }
    };
    public static final ArrayFactory<float[]> FLOATS_FACTORY = new ArrayFactory(){

        protected Object create(int n) {
            return new float[n];
        }

        public void recycle(Object object) {
            this.recycle(object, ((float[])object).length);
        }
    };
    public static final ArrayFactory<double[]> DOUBLES_FACTORY = new ArrayFactory(){

        protected Object create(int n) {
            return new double[n];
        }

        public void recycle(Object object) {
            this.recycle(object, ((double[])object).length);
        }
    };
    public static final ArrayFactory<Object[]> OBJECTS_FACTORY = new ArrayFactory(){

        protected Object create(int n) {
            return new Object[n];
        }

        public void recycle(Object object) {
            this.recycle(object, ((Object[])object).length);
        }
    };
    private final ObjectFactory _factory4 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(4);
        }
    };
    private final ObjectFactory _factory8 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(8);
        }
    };
    private final ObjectFactory _factory16 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(16);
        }
    };
    private final ObjectFactory _factory32 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(32);
        }
    };
    private final ObjectFactory _factory64 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(64);
        }
    };
    private final ObjectFactory _factory128 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(128);
        }
    };
    private final ObjectFactory _factory256 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(256);
        }
    };
    private final ObjectFactory _factory512 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(512);
        }
    };
    private final ObjectFactory _factory1024 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(1024);
        }
    };
    private final ObjectFactory _factory2048 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(2048);
        }
    };
    private final ObjectFactory _factory4096 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(4096);
        }
    };
    private final ObjectFactory _factory8192 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(8192);
        }
    };
    private final ObjectFactory _factory16384 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(16384);
        }
    };
    private final ObjectFactory _factory32768 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(32768);
        }
    };
    private final ObjectFactory _factory65536 = new ObjectFactory(){

        protected Object create() {
            return ArrayFactory.this.create(65536);
        }
    };

    public final T array(int n) {
        return n <= 4 ? this._factory4.object() : this.largeArray(n);
    }

    private final T largeArray(int n) {
        if (n <= 8) {
            return this._factory8.object();
        }
        if (n <= 16) {
            return this._factory16.object();
        }
        if (n <= 32) {
            return this._factory32.object();
        }
        if (n <= 64) {
            return this._factory64.object();
        }
        if (n <= 128) {
            return this._factory128.object();
        }
        if (n <= 256) {
            return this._factory256.object();
        }
        if (n <= 512) {
            return this._factory512.object();
        }
        if (n <= 1024) {
            return this._factory1024.object();
        }
        if (n <= 2048) {
            return this._factory2048.object();
        }
        if (n <= 4096) {
            return this._factory4096.object();
        }
        if (n <= 8192) {
            return this._factory8192.object();
        }
        if (n <= 16384) {
            return this._factory16384.object();
        }
        if (n <= 32768) {
            return this._factory32768.object();
        }
        if (n <= 65536) {
            return this._factory65536.object();
        }
        return this.create(n);
    }

    public void recycle(T t) {
        this.recycle(t, ((Object[])t).length);
    }

    final void recycle(Object object, int n) {
        if (n <= 4) {
            this._factory4.recycle(object);
        } else if (n <= 8) {
            this._factory8.recycle(object);
        } else if (n <= 16) {
            this._factory16.recycle(object);
        } else if (n <= 32) {
            this._factory32.recycle(object);
        } else if (n <= 64) {
            this._factory64.recycle(object);
        } else if (n <= 128) {
            this._factory128.recycle(object);
        } else if (n <= 256) {
            this._factory256.recycle(object);
        } else if (n <= 512) {
            this._factory512.recycle(object);
        } else if (n <= 1024) {
            this._factory1024.recycle(object);
        } else if (n <= 2048) {
            this._factory2048.recycle(object);
        } else if (n <= 4096) {
            this._factory4096.recycle(object);
        } else if (n <= 8192) {
            this._factory8192.recycle(object);
        } else if (n <= 16384) {
            this._factory16384.recycle(object);
        } else if (n <= 32768) {
            this._factory32768.recycle(object);
        } else if (n <= 65536) {
            this._factory65536.recycle(object);
        }
    }

    protected abstract T create(int var1);
}

