/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javolution.JavolutionError;
import javolution.lang.Configurable;
import javolution.testing.TestCase;
import javolution.testing.TestContext;
import javolution.testing.TestSuite;
import javolution.text.TextBuilder;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;
import javolution.util.FastTable;
import javolution.util.Index;

public final class UtilTestSuite
extends TestSuite {
    public static final Configurable<Integer> SIZE = new Configurable<Integer>(new Integer(256));
    private static final int PADDING = 60;

    public void run() {
        int n = SIZE.get();
        Index.setMinimumRange(0, n);
        TestContext.info("----------------------------------------------");
        TestContext.info("-- Test Suite for javolution.util.* classes --");
        TestContext.info("----------------------------------------------");
        TestContext.info("Collections/Maps of " + n + " elements (configurable \"javolution.UtilTestSuite#SIZE\")");
        TestContext.info("");
        TestContext.info(" - Add elements to collection -");
        boolean bl = false;
        TestContext.test(new CollectionAdd(FastTable.class, n, bl));
        TestContext.test(new CollectionAdd(ArrayList.class, n, bl));
        TestContext.test(new CollectionAdd(FastList.class, n, bl));
        TestContext.test(new CollectionAdd(LinkedList.class, n, bl));
        TestContext.test(new CollectionAdd(FastSet.class, n, bl));
        TestContext.test(new CollectionAdd(HashSet.class, n, bl));
        bl = true;
        TestContext.test(new CollectionAdd(FastTable.class, n, bl));
        TestContext.test(new CollectionAdd(ArrayList.class, n, bl));
        TestContext.test(new CollectionAdd(FastList.class, n, bl));
        TestContext.test(new CollectionAdd(LinkedList.class, n, bl));
        TestContext.test(new CollectionAdd(FastSet.class, n, bl));
        TestContext.test(new CollectionAdd(HashSet.class, n, bl));
        TestContext.info("");
        TestContext.info(" - Iterate over collections -");
        TestContext.test(new CollectionIteration(FastTable.class, n));
        TestContext.test(new CollectionIteration(ArrayList.class, n));
        TestContext.test(new CollectionIteration(FastList.class, n));
        TestContext.test(new CollectionIteration(LinkedList.class, n));
        TestContext.test(new CollectionIteration(FastSet.class, n));
        TestContext.test(new CollectionIteration(HashSet.class, n));
        TestContext.info("");
        TestContext.info(" - Put new key/value pairs to map instance -");
        bl = false;
        TestContext.test(new MapPut(FastMap.class, n, bl));
        TestContext.test(new MapPut(HashMap.class, n, bl));
        TestContext.test(new MapPut(LinkedHashMap.class, n, bl));
        TestContext.test(new MapPut(SharedFastMap.class, n, bl));
        TestContext.test(new MapPut(ConcurrentHashMap.class, n, bl));
        bl = true;
        TestContext.test(new MapPut(FastMap.class, n, bl));
        TestContext.test(new MapPut(HashMap.class, n, bl));
        TestContext.test(new MapPut(LinkedHashMap.class, n, bl));
        TestContext.info("");
        TestContext.info(" - Retrieves map value from key - ");
        TestContext.test(new MapGet(FastMap.class, n));
        TestContext.test(new MapGet(HashMap.class, n));
        TestContext.test(new MapGet(LinkedHashMap.class, n));
        TestContext.test(new MapGet(SharedFastMap.class, n));
        TestContext.test(new MapGet(ConcurrentHashMap.class, n));
        TestContext.info("");
        TestContext.info(" - Removes keys from map - ");
        TestContext.test(new MapRemove(FastMap.class, n));
        TestContext.test(new MapRemove(HashMap.class, n));
        TestContext.test(new MapRemove(LinkedHashMap.class, n));
        TestContext.test(new MapRemove(SharedFastMap.class, n));
        TestContext.test(new MapRemove(ConcurrentHashMap.class, n));
        TestContext.info("");
        TestContext.info(" - Iterates over map entries - ");
        TestContext.test(new MapIteration(FastMap.class, n));
        TestContext.test(new MapIteration(HashMap.class, n));
        TestContext.test(new MapIteration(LinkedHashMap.class, n));
        TestContext.test(new MapIteration(SharedFastMap.class, n));
        TestContext.test(new MapIteration(ConcurrentHashMap.class, n));
        TestContext.info("");
        TestContext.info(" - Direct collection/map iterations (no iterator) - ");
        TestContext.test(new FastTableDirectIteration(n));
        TestContext.test(new ArrayListDirectIteration(n));
        TestContext.test(new FastListDirectIteration(n));
        TestContext.test(new FastMapDirectIteration(n));
        TestContext.info("");
    }

    private static Object newInstanceOf(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JavolutionError(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JavolutionError(illegalAccessException);
        }
    }

    private static final class SharedFastMap
    extends FastMap {
        SharedFastMap() {
            this.setShared(true);
        }
    }

    public static class FastMapDirectIteration
    extends TestCase {
        private final int _size;
        private final FastMap _map;

        public FastMapDirectIteration(int n) {
            this._size = n;
            this._map = new FastMap();
            for (int i = 0; i < this._size; ++i) {
                this._map.put(Index.valueOf(i), Index.valueOf(i));
            }
        }

        public CharSequence getDescription() {
            return TextBuilder.newInstance().append("javolution.util.FastMap.Entry.getNext()").toText().padRight(60);
        }

        public void execute() {
            Index index = Index.valueOf(this._size - 1);
            FastCollection.Record record = this._map.head();
            FastMap.Entry entry = this._map.tail();
            while ((record = ((FastMap.Entry)record).getNext()) != entry) {
                if (((FastMap.Entry)record).getKey() != index) continue;
                return;
            }
            throw new Error();
        }

        public int count() {
            return this._size;
        }

        public void validate() {
            int n = 0;
            FastCollection.Record record = this._map.head();
            FastMap.Entry entry = this._map.tail();
            while ((record = ((FastMap.Entry)record).getNext()) != entry && TestContext.assertEquals(Index.valueOf(n), ((FastMap.Entry)record).getValue())) {
                ++n;
            }
            TestContext.assertTrue(n == this._size);
        }
    }

    public static class FastListDirectIteration
    extends TestCase {
        private final int _size;
        private final FastList _list;

        public FastListDirectIteration(int n) {
            this._size = n;
            this._list = new FastList();
            for (int i = 0; i < this._size; ++i) {
                this._list.add(Index.valueOf(i));
            }
        }

        public CharSequence getDescription() {
            return TextBuilder.newInstance().append("javolution.util.FastList.Node.getNext()").toText().padRight(60);
        }

        public void execute() {
            Index index = Index.valueOf(this._size - 1);
            FastCollection.Record record = this._list.head();
            FastCollection.Record record2 = this._list.tail();
            while ((record = ((FastList.Node)record).getNext()) != record2) {
                if (((FastList.Node)record).getValue() != index) continue;
                return;
            }
            throw new Error();
        }

        public int count() {
            return this._size;
        }

        public void validate() {
            int n = 0;
            FastCollection.Record record = this._list.head();
            FastCollection.Record record2 = this._list.tail();
            while ((record = ((FastList.Node)record).getNext()) != record2 && TestContext.assertEquals(Index.valueOf(n), ((FastList.Node)record).getValue())) {
                ++n;
            }
            TestContext.assertTrue(n == this._size);
        }
    }

    public static class FastTableDirectIteration
    extends TestCase {
        private final int _size;
        private final FastTable _list;

        public FastTableDirectIteration(int n) {
            this._size = n;
            this._list = new FastTable();
            for (int i = 0; i < this._size; ++i) {
                this._list.add(Index.valueOf(i));
            }
        }

        public CharSequence getDescription() {
            return TextBuilder.newInstance().append("javolution.util.FastTable.get(i)").toText().padRight(60);
        }

        public void execute() {
            Index index = Index.valueOf(this._size - 1);
            for (int i = 0; i < this._size; ++i) {
                if (this._list.get(i) != index) continue;
                return;
            }
            throw new Error();
        }

        public int count() {
            return this._size;
        }

        public void validate() {
            for (int i = 0; i < this._size && TestContext.assertEquals(Index.valueOf(i), this._list.get(i)); ++i) {
            }
        }
    }

    public static class ArrayListDirectIteration
    extends TestCase {
        private final int _size;
        private final ArrayList _list;

        public ArrayListDirectIteration(int n) {
            this._size = n;
            this._list = new ArrayList();
            for (int i = 0; i < this._size; ++i) {
                this._list.add(Index.valueOf(i));
            }
        }

        public CharSequence getDescription() {
            return TextBuilder.newInstance().append("java.util.ArrayList.get(i)").toText().padRight(60);
        }

        public void execute() {
            Index index = Index.valueOf(this._size - 1);
            for (int i = 0; i < this._size; ++i) {
                if (this._list.get(i) != index) continue;
                return;
            }
            throw new Error();
        }

        public int count() {
            return this._size;
        }

        public void validate() {
            for (int i = 0; i < this._size && TestContext.assertEquals(Index.valueOf(i), this._list.get(i)); ++i) {
            }
        }
    }

    public static class MapIteration
    extends TestCase {
        private final Class _class;
        private final int _size;
        private final Map _map;
        private Object _last;

        public MapIteration(Class clazz, int n) {
            this._class = clazz;
            this._size = n;
            this._map = (Map)UtilTestSuite.newInstanceOf(clazz);
            int n2 = 0;
            while (n2 < this._size) {
                this._map.put(Index.valueOf(n2), Index.valueOf(n2++));
            }
        }

        public CharSequence getDescription() {
            return TextBuilder.newInstance().append("Iterates over ").append(this._class.getName()).toText().padRight(60);
        }

        public void execute() {
            for (Map.Entry this._last : this._map.entrySet()) {
            }
        }

        public int count() {
            return this._size;
        }

        public void validate() {
            Map.Entry entry = (Map.Entry)this._last;
            TestContext.assertTrue(entry.getKey() == entry.getValue());
        }
    }

    public static class MapRemove
    extends TestCase {
        private final Class _class;
        private final int _size;
        private Map _map;
        private Object _last;

        public MapRemove(Class clazz, int n) {
            this._class = clazz;
            this._size = n;
            this._map = (Map)UtilTestSuite.newInstanceOf(clazz);
        }

        public CharSequence getDescription() {
            return TextBuilder.newInstance().append(this._class.getName()).append(".remove(key):").toText().padRight(60);
        }

        public void prepare() {
            int n = 0;
            while (n < this._size) {
                this._map.put(Index.valueOf(n), Index.valueOf(++n));
            }
        }

        public void execute() {
            int n = 0;
            while (n < this._size) {
                this._last = this._map.remove(Index.valueOf(n++));
            }
        }

        public int count() {
            return this._size;
        }

        public void validate() {
            TestContext.assertEquals(Index.valueOf(this._size), this._last);
            TestContext.assertTrue(this._map.size() == 0);
        }
    }

    public static class MapGet
    extends TestCase {
        private final Class _class;
        private final int _size;
        private Map _map;
        private Object _last;

        public MapGet(Class clazz, int n) {
            this._class = clazz;
            this._size = n;
            this._map = (Map)UtilTestSuite.newInstanceOf(clazz);
            int n2 = 0;
            while (n2 < this._size) {
                this._map.put(Index.valueOf(n2), Index.valueOf(++n2));
            }
        }

        public CharSequence getDescription() {
            return TextBuilder.newInstance().append(this._class.getName()).append(".get(key):").toText().padRight(60);
        }

        public void execute() {
            int n = 0;
            while (n < this._size) {
                this._last = this._map.get(Index.valueOf(n++));
            }
        }

        public int count() {
            return this._size;
        }

        public void validate() {
            for (int i = 0; i < this._size && TestContext.assertEquals(Index.valueOf(i + 1), this._map.get(Index.valueOf(i))); ++i) {
            }
            TestContext.assertEquals(Index.valueOf(this._size), this._last);
        }
    }

    public static class MapPut
    extends TestCase {
        private final Class _class;
        private final int _size;
        private final boolean _reuse;
        private Map _map;

        public MapPut(Class clazz, int n, boolean bl) {
            this._class = clazz;
            this._size = n;
            this._reuse = bl;
        }

        public CharSequence getDescription() {
            return TextBuilder.newInstance().append(this._reuse ? "Recycled " : "New ").append(this._class.getName()).append(".put(key, value)").toText().padRight(60);
        }

        public void prepare() {
            if (this._reuse && this._map != null) {
                this._map.clear();
            } else {
                this._map = (Map)UtilTestSuite.newInstanceOf(this._class);
            }
        }

        public void execute() {
            int n = 0;
            while (n < this._size) {
                this._map.put(Index.valueOf(n++), "");
            }
        }

        public int count() {
            return this._size;
        }

        public void validate() {
            TestContext.assertTrue(this._map.size() == this._size);
            int n = 0;
            while (n < this._size && TestContext.assertTrue(this._map.containsKey(Index.valueOf(n++)))) {
            }
        }
    }

    public static class CollectionIteration
    extends TestCase {
        private final Class _class;
        private final int _size;
        private final Collection _collection;
        private int _count;

        public CollectionIteration(Class clazz, int n) {
            this._class = clazz;
            this._size = n;
            this._collection = (Collection)UtilTestSuite.newInstanceOf(clazz);
            int n2 = 0;
            while (n2 < this._size) {
                this._collection.add(Index.valueOf(n2++));
            }
        }

        public CharSequence getDescription() {
            return TextBuilder.newInstance().append("Iterates over ").append(this._class.getName()).toText().padRight(60);
        }

        public void execute() {
            this._count = 0;
            Iterator iterator = this._collection.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++this._count;
            }
        }

        public int count() {
            return this._count;
        }

        public void validate() {
            TestContext.assertTrue(this._count == this._size);
        }
    }

    public static class CollectionAdd
    extends TestCase {
        private final Class _class;
        private final int _size;
        private final boolean _reuse;
        private Collection _collection;

        public CollectionAdd(Class clazz, int n, boolean bl) {
            this._class = clazz;
            this._size = n;
            this._reuse = bl;
        }

        public CharSequence getDescription() {
            return TextBuilder.newInstance().append(this._reuse ? "Recycled " : "New ").append(this._class.getName()).append(".add(element)").toText().padRight(60);
        }

        public void prepare() {
            if (this._reuse && this._collection != null) {
                this._collection.clear();
            } else {
                this._collection = (Collection)UtilTestSuite.newInstanceOf(this._class);
            }
        }

        public void execute() {
            int n = 0;
            while (n < this._size) {
                this._collection.add(Index.valueOf(n++));
            }
        }

        public int count() {
            return this._size;
        }

        public void validate() {
            TestContext.assertTrue(this._collection.size() == this._size);
            int n = 0;
            while (n < this._size && TestContext.assertTrue(this._collection.contains(Index.valueOf(n++)))) {
            }
        }
    }
}

