/*
 * Decompiled with CFR 0.152.
 */
package jyplot;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class CustomSymbolAxis
extends SymbolAxis {
    private HashMap<Double, String> locationToSymbolMap;
    private Double[] symbolLocations;
    private List symbols;
    private transient Paint gridBandPaint;
    private boolean gridBandsVisible;

    public CustomSymbolAxis(String label, String[] sv, double[] symbolLocations) {
        super(label, sv);
        int i;
        this.symbols = Arrays.asList(sv);
        this.gridBandsVisible = true;
        this.gridBandPaint = DEFAULT_GRID_BAND_PAINT;
        this.locationToSymbolMap = new HashMap();
        this.symbolLocations = new Double[symbolLocations.length];
        for (i = 0; i < symbolLocations.length && i < sv.length; ++i) {
            this.locationToSymbolMap.put(new Double(symbolLocations[i]), sv[i]);
        }
        Arrays.sort(symbolLocations);
        for (i = 0; i < symbolLocations.length; ++i) {
            this.symbolLocations[i] = new Double(symbolLocations[i]);
        }
        this.setAutoTickUnitSelection(false, false);
        this.setAutoRangeStickyZero(false);
    }

    public List refreshTicks(Graphics2D g2, AxisState state, Rectangle2D dataArea, RectangleEdge edge) {
        List ticks = null;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            ticks = this.refreshTicksHorizontal(g2, dataArea, edge);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            ticks = this.refreshTicksVertical(g2, dataArea, edge);
        }
        return ticks;
    }

    protected List refreshTicksHorizontal(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        Font tickLabelFont = this.getTickLabelFont();
        g2.setFont(tickLabelFont);
        double size = this.getTickUnit().getSize();
        int count = this.calculateVisibleTickCount();
        double lowestTickValue = this.calculateLowestVisibleTickValue();
        double previousDrawnTickLabelPos = 0.0;
        double previousDrawnTickLabelLength = 0.0;
        if (count <= 500) {
            for (int i = 0; i < this.symbolLocations.length; ++i) {
                double currentTickValue = this.symbolLocations[i];
                double xx = this.valueToJava2D(currentTickValue, dataArea, edge);
                NumberFormat formatter = this.getNumberFormatOverride();
                String tickLabel = this.locationToSymbolMap.containsKey(new Double(currentTickValue)) ? this.locationToSymbolMap.get(new Double(currentTickValue)) : (formatter != null ? formatter.format(currentTickValue) : this.valueToString(currentTickValue));
                Rectangle2D bounds = TextUtilities.getTextBounds((String)tickLabel, (Graphics2D)g2, (FontMetrics)g2.getFontMetrics());
                double tickLabelLength = this.isVerticalTickLabels() ? bounds.getHeight() : bounds.getWidth();
                boolean tickLabelsOverlapping = false;
                if (i > 0) {
                    double avgTickLabelLength = (previousDrawnTickLabelLength + tickLabelLength) / 2.0;
                    if (Math.abs(xx - previousDrawnTickLabelPos) < avgTickLabelLength) {
                        tickLabelsOverlapping = true;
                    }
                }
                if (tickLabelsOverlapping) {
                    tickLabel = "";
                } else {
                    previousDrawnTickLabelPos = xx;
                    previousDrawnTickLabelLength = tickLabelLength;
                }
                TextAnchor anchor = null;
                TextAnchor rotationAnchor = null;
                double angle = 0.0;
                if (this.isVerticalTickLabels()) {
                    anchor = TextAnchor.CENTER_RIGHT;
                    rotationAnchor = TextAnchor.CENTER_RIGHT;
                    angle = edge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                } else if (edge == RectangleEdge.TOP) {
                    anchor = TextAnchor.BOTTOM_CENTER;
                    rotationAnchor = TextAnchor.BOTTOM_CENTER;
                } else {
                    anchor = TextAnchor.TOP_CENTER;
                    rotationAnchor = TextAnchor.TOP_CENTER;
                }
                NumberTick tick = new NumberTick((Number)new Double(currentTickValue), tickLabel, anchor, rotationAnchor, angle);
                ticks.add(tick);
            }
        }
        return ticks;
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge) {
        AxisState state = new AxisState(cursor);
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(g2, cursor, dataArea, edge);
        }
        double ol = this.getTickMarkOutsideLength();
        double il = this.getTickMarkInsideLength();
        List ticks = this.refreshTicks(g2, state, dataArea, edge);
        state.setTicks(ticks);
        g2.setFont(this.getTickLabelFont());
        for (ValueTick tick : ticks) {
            if (this.isTickLabelsVisible()) {
                g2.setPaint(this.getTickLabelPaint());
                float[] anchorPoint = this.calculateAnchorPoint(tick, cursor, dataArea, edge);
                TextUtilities.drawRotatedString((String)tick.getText(), (Graphics2D)g2, (float)anchorPoint[0], (float)anchorPoint[1], (TextAnchor)tick.getTextAnchor(), (double)tick.getAngle(), (TextAnchor)tick.getRotationAnchor());
            }
            if (!this.isTickMarksVisible()) continue;
            float xx = (float)this.valueToJava2D(tick.getValue(), dataArea, edge);
            Line2D.Double mark = null;
            g2.setStroke(this.getTickMarkStroke());
            g2.setPaint(this.getTickMarkPaint());
            if (edge == RectangleEdge.LEFT) {
                mark = new Line2D.Double(cursor - ol, xx, cursor + il, xx);
            } else if (edge == RectangleEdge.RIGHT) {
                mark = new Line2D.Double(cursor + ol, xx, cursor - il, xx);
            } else if (edge == RectangleEdge.TOP) {
                mark = new Line2D.Double(xx, cursor - ol, xx, cursor + il);
            } else if (edge == RectangleEdge.BOTTOM) {
                mark = new Line2D.Double(xx, cursor + ol, xx, cursor - il);
            }
            g2.draw(mark);
        }
        double used = 0.0;
        if (this.isTickLabelsVisible()) {
            if (edge == RectangleEdge.LEFT) {
                state.cursorLeft(used += this.findMaximumTickLabelWidth(ticks, g2, plotArea, this.isVerticalTickLabels()));
            } else if (edge == RectangleEdge.RIGHT) {
                used = this.findMaximumTickLabelWidth(ticks, g2, plotArea, this.isVerticalTickLabels());
                state.cursorRight(used);
            } else if (edge == RectangleEdge.TOP) {
                used = this.findMaximumTickLabelHeight(ticks, g2, plotArea, this.isVerticalTickLabels());
                state.cursorUp(used);
            } else if (edge == RectangleEdge.BOTTOM) {
                used = this.findMaximumTickLabelHeight(ticks, g2, plotArea, this.isVerticalTickLabels());
                state.cursorDown(used);
            }
        }
        return state;
    }

    protected double calculateLowestVisibleTickValue() {
        double lowerbound = this.getRange().getLowerBound();
        for (int i = 0; i < this.symbolLocations.length; ++i) {
            if (!(this.symbolLocations[i] > lowerbound)) continue;
            return this.symbolLocations[i];
        }
        return 0.0;
    }

    protected double calculateHighestVisibleTickValue() {
        double upperbound = this.getRange().getUpperBound();
        for (int i = this.symbolLocations.length - 1; i >= 0; --i) {
            if (!(this.symbolLocations[i] < upperbound)) continue;
            return this.symbolLocations[i];
        }
        return 0.0;
    }
}

