/*
 * Decompiled with CFR 0.152.
 */
package jplot3dp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import jplot3dp.ColorDialog;
import jplot3dp.Utils;

class JColor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Color color;

    public JColor(int i, int j) {
        Dimension dimension = new Dimension(i, j);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        this.setMinimumSize(dimension);
        this.color = Color.RED;
        this.setAlignmentX(0.0f);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseevent) {
                ColorDialog colordialog = new ColorDialog(null, JColor.this.color);
                colordialog.setVisible(true);
                if (!colordialog.cancelled) {
                    int k = JColor.this.color.getAlpha();
                    JColor.this.color = Utils.changeAlpha(colordialog.getColor(), k);
                    JColor.this.repaint();
                }
            }
        });
    }

    public void setColor(Color color1) {
        this.color = color1;
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle rectangle = this.getBounds();
        for (int i = 0; i < rectangle.width; i += 5) {
            for (int j = 0; j < rectangle.height; j += 5) {
                if ((i + j) % 10 == 0) {
                    g.setColor(Color.WHITE);
                } else {
                    g.setColor(Color.BLACK);
                }
                g.fillRect(i, j, 5, 5);
            }
        }
        g.setColor(this.color);
        g.fill3DRect(0, 0, rectangle.width, rectangle.height, true);
    }
}

