/*
 * Decompiled with CFR 0.152.
 */
package jplot3d;

import graph.RTextLine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jplot.Translate;
import jplot3d.LineAccumulator;
import jplot3d.NumUtil;
import jplot3d.Projector;
import jplot3d.SurfaceColor;
import jplot3d.SurfaceModel;
import jplot3d.SurfaceModelCanvas;
import jplot3d.SurfaceVertex;
import jplot3d.draw.DrawContour;
import jplot3d.draw.DrawDensity;
import jplot3d.draw.DrawEmpty;
import jplot3d.draw.DrawH2D;
import jplot3d.draw.DrawP2D;
import jplot3d.draw.DrawP3D;
import jplot3d.draw.DrawSurface;
import jplot3d.draw.DrawWireframe;
import org.freehep.graphics2d.VectorGraphics;

public class JSurface
extends JComponent {
    private static final long serialVersionUID = 1L;
    public SurfaceModel model;
    public Projector projector;
    public SurfaceVertex[][] vertex;
    public boolean data_available;
    public boolean interrupted;
    public boolean critical;
    public boolean printing;
    private int prevwidth;
    private int prevheight;
    private int printwidth;
    private int printheight;
    public SurfaceVertex cop;
    private JPopupMenu menu;
    public JMenuItem item1;
    public JMenuItem item2;
    private float scalingFrame = 1.0f;
    private boolean first_frame = true;
    public int curve = 0;
    public VectorGraphics graphics;
    public SurfaceModel.PlotType plot_type;
    public int calc_divisions;
    public boolean plotfunc1;
    public boolean plotfunc2;
    public boolean plotboth;
    public boolean isBoxed;
    public boolean isMesh;
    public boolean isScaleBox;
    public boolean isDisplayXY;
    public boolean isDisplayZ;
    public boolean isDisplayGrids;
    public float xmin;
    public float xmax;
    public float ymin;
    public float ymax;
    public float zmin;
    public float zmax;
    private final int TOP = 0;
    private final int CENTER = 1;
    private final int UPPER = 1;
    private final int COINCIDE = 0;
    private final int LOWER = -1;
    private SurfaceColor colors;
    private JSurfaceChangesListener surfaceChangesListener;
    private JSurface lastFocused;
    private Rectangle comp_init;
    private boolean is_data_available;
    private boolean dragged;
    private int click_x;
    private int click_y;
    private int factor_x;
    private int factor_y;
    private int t_x;
    private int t_y;
    private int t_z;
    public float color_factor;
    public Point projection;
    public Color line_color;
    private final int[] poly_x = new int[9];
    private final int[] poly_y = new int[9];
    private final SurfaceVertex[] upperpart = new SurfaceVertex[8];
    private final SurfaceVertex[] lowerpart = new SurfaceVertex[8];
    private final SurfaceVertex[] values1 = new SurfaceVertex[4];
    private final SurfaceVertex[] values2 = new SurfaceVertex[4];
    private int contour_center_x = 0;
    private int contour_center_y = 0;
    private int contour_space_x = 0;
    private int legend_width = 0;
    private int legend_space = 0;
    private int legend_length = 0;
    private String[] legend_label = null;
    private float contour_width_x = 0.0f;
    private float contour_width_y = 0.0f;
    private Color[] contour_color = null;
    private String[] ylabels = null;
    private int[] xpoints = new int[8];
    private int[] ypoints = new int[8];
    private int[] contour_x = new int[8];
    private int[] contour_y = new int[8];
    private int contour_n = 0;
    public int contour_lines = 10;
    private float[] delta = new float[4];
    private float[] intersection = new float[4];
    public float contour_stepz;
    public SurfaceVertex[] contour_vertex = new SurfaceVertex[4];
    public LineAccumulator accumulator = new LineAccumulator();

    public JSurface() {
        this(new SurfaceModelCanvas());
    }

    public JSurface(SurfaceModel model) {
        this.menu = new JPopupMenu();
        this.item1 = new JMenuItem("Edit");
        this.item2 = new JMenuItem("Refresh");
        this.menu.add(this.item1);
        this.menu.add(this.item2);
        this.surfaceChangesListener = new JSurfaceChangesListener();
        JSurfaceMouseListener my = new JSurfaceMouseListener();
        this.addMouseListener(my);
        this.addMouseMotionListener(my);
        this.addMouseWheelListener(my);
        this.addMouseListener(new PopupListener());
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JSurface.this.lastFocused = JSurface.this;
            }
        });
        this.setModel(model);
    }

    public JSurface getFocusedComponent() {
        return this.lastFocused;
    }

    void setModel(SurfaceModel model) {
        if (this.model != null) {
            model.removePropertyChangeListener(this.surfaceChangesListener);
        }
        if (this.model != null) {
            model.removeChangeListener(this.surfaceChangesListener);
        }
        if (model == null) {
            model = new SurfaceModelCanvas();
        }
        this.model = model;
        this.interrupted = false;
        this.data_available = false;
        this.printing = false;
        this.prevheight = -1;
        this.prevwidth = -1;
        this.projector = model.getProjector();
        this.cop = new SurfaceVertex(this.projector.getDistance() * this.projector.getSinRotationAngle(), this.projector.getDistance() * this.projector.getCosRotationAngle(), this.projector.getDistance() * this.projector.getSinElevationAngle());
        this.cop.setProjector(this.projector);
        this.vertex = new SurfaceVertex[2][];
        model.addPropertyChangeListener(this.surfaceChangesListener);
        model.addChangeListener(this.surfaceChangesListener);
        this.init();
        this.first_frame = true;
    }

    private String format(float f) {
        return String.format("%.3G", Float.valueOf(f));
    }

    private void init() {
        this.colors = this.model.getColorModel();
        this.setRanges(this.model.getXMin(), this.model.getXMax(), this.model.getYMin(), this.model.getYMax());
        this.data_available = this.model.isDataAvailable();
        if (this.data_available) {
            this.setValuesArray(this.model.getSurfaceVertex());
        }
        this.plot_type = this.model.getPlotType();
        this.isBoxed = this.model.isBoxed();
        this.isMesh = this.model.isMesh();
        this.isScaleBox = this.model.isScaleBox();
        this.isDisplayXY = this.model.isDisplayXY();
        this.isDisplayZ = this.model.isDisplayZ();
        this.isDisplayGrids = this.model.isDisplayGrids();
        this.calc_divisions = this.model.getCalcDivisions();
        this.plotfunc1 = this.model.isPlotFunction1();
        this.plotfunc2 = this.model.isPlotFunction2();
        this.plotboth = this.plotfunc1 && this.plotfunc2;
    }

    public void destroyImage() {
        this.repaint();
    }

    public void setRanges(float xmin, float xmax, float ymin, float ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public float[] getRanges() {
        float[] ranges = new float[]{this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax};
        return ranges;
    }

    public void setDataAvailability(boolean avail) {
        this.data_available = avail;
        this.is_data_available = avail;
    }

    public void setValuesArray(SurfaceVertex[][] vertex) {
        this.vertex = vertex;
    }

    public SurfaceVertex[][] getValuesArray() {
        if (!this.data_available) {
            return null;
        }
        return this.vertex;
    }

    public void doExportPNG(File file) throws IOException {
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle cm = this.getBounds();
        double h = cm.getHeight();
        double w = cm.getWidth();
        if (w <= 0.0 || h <= 0.0) {
            return;
        }
        if (this.first_frame) {
            this.comp_init = this.getBounds();
            this.first_frame = false;
            this.model.setInitScaling(this.projector.get2DScaling());
        }
        double dd1 = Math.sqrt(w * w + h * h);
        double w1 = this.comp_init.getWidth();
        double h1 = this.comp_init.getHeight();
        double dd2 = Math.sqrt(w1 * w1 + h1 * h1);
        this.scalingFrame = (float)(dd1 / dd2);
        this.model.setFrameScale(this.scalingFrame);
        this.projector.set2DScaling(this.model.getInitScaling() * this.scalingFrame);
        if (this.getBounds().width != this.prevwidth || this.getBounds().height != this.prevheight) {
            this.projector.setProjectionArea(new Rectangle(0, 0, this.getBounds().width, this.getBounds().height));
            this.prevwidth = this.getBounds().width;
            this.prevheight = this.getBounds().height;
        }
        VectorGraphics vg = VectorGraphics.create((Graphics)g);
        this.printing = g instanceof PrintGraphics;
        if (this.printing) {
            this.printing(vg);
        }
        if (this.data_available && !this.interrupted) {
            this.draw((Graphics)vg);
        } else {
            vg.setColor(this.colors.getBackgroundColor());
            vg.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
            if (this.is3D()) {
                this.drawBoxGridsTicksLabels(vg, true);
            }
        }
        this.interrupted = false;
    }

    private boolean is3D() {
        return this.plot_type == SurfaceModel.PlotType.WIREFRAME || this.plot_type == SurfaceModel.PlotType.SURFACE || this.plot_type == SurfaceModel.PlotType.BARS;
    }

    private void printing(VectorGraphics graphics) {
        Dimension pagedimension = ((PrintGraphics)graphics).getPrintJob().getPageDimension();
        this.printwidth = pagedimension.width;
        this.printheight = this.prevheight * this.printwidth / this.prevwidth;
        if (this.printheight > pagedimension.height) {
            this.printheight = pagedimension.height;
            this.printwidth = this.prevwidth * this.printheight / this.prevheight;
        }
        float savedscalingfactor = this.projector.get2DScaling();
        this.projector.setProjectionArea(new Rectangle(0, 0, this.printwidth, this.printheight));
        this.projector.set2DScaling(savedscalingfactor * (float)this.printwidth / (float)this.prevwidth);
        graphics.clipRect(0, 0, this.printwidth, this.printheight);
        if (!this.data_available) {
            this.drawBoxGridsTicksLabels(graphics, true);
        }
        graphics.drawRect(0, 0, this.printwidth - 1, this.printheight - 1);
        this.projector.set2DScaling(savedscalingfactor);
        this.projector.setProjectionArea(new Rectangle(0, 0, this.getBounds().width, this.getBounds().height));
    }

    @Override
    public void update(Graphics g) {
        this.paintComponent(g);
    }

    private void export(VectorGraphics g) {
        if (this.data_available && !this.interrupted) {
            this.draw((Graphics)g);
        } else {
            System.out.println("empty plot");
            g.setColor(this.colors.getBackgroundColor());
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
            if (this.is3D()) {
                this.drawBoxGridsTicksLabels(g, true);
            }
        }
    }

    private synchronized void draw(Graphics graphics) {
        this.graphics = VectorGraphics.create((Graphics)graphics);
        SurfaceVertex.invalidate();
        if (this.model.isEmpty()) {
            DrawEmpty.run(this);
            this.cleanUpMemory();
            return;
        }
        if (this.model.isP2D()) {
            DrawP2D.run(this);
            this.cleanUpMemory();
            return;
        }
        if (this.model.isP3D()) {
            DrawP3D.run(this);
            this.cleanUpMemory();
            return;
        }
        if (this.model.isH2F2()) {
            if (this.plot_type == SurfaceModel.PlotType.BARS) {
                DrawH2D.run(this);
                DrawSurface.run(this);
                this.plotfunc1 = true;
                this.plotfunc2 = false;
            } else {
                DrawSurface.run(this);
                this.plotfunc1 = true;
                this.plotfunc2 = true;
            }
            this.cleanUpMemory();
            return;
        }
        switch (this.plot_type) {
            case CONTOUR: {
                DrawContour.run(this);
                break;
            }
            case DENSITY: {
                DrawDensity.run(this);
                break;
            }
            case WIREFRAME: {
                DrawWireframe.run(this);
                break;
            }
            case SURFACE: {
                DrawSurface.run(this);
                break;
            }
            case BARS: {
                DrawH2D.run(this);
            }
        }
        this.cleanUpMemory();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(550, 550);
    }

    public final void drawBoundingBox() {
        Point startingpoint = this.projector.project(this.factor_x * 10, this.factor_y * 10, 10.0f);
        this.graphics.setColor(this.colors.getLineBoxColor());
        Point projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
        this.graphics.drawLine(startingpoint.x, startingpoint.y, projection.x, projection.y);
        projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
        this.graphics.drawLine(startingpoint.x, startingpoint.y, projection.x, projection.y);
        projection = this.projector.project(this.factor_x * 10, this.factor_y * 10, -10.0f);
        this.graphics.drawLine(startingpoint.x, startingpoint.y, projection.x, projection.y);
    }

    private final void drawBase(VectorGraphics g, int[] x, int[] y) {
        Point projection = this.projector.project(-10.0f, -10.0f, -10.0f);
        x[0] = projection.x;
        y[0] = projection.y;
        projection = this.projector.project(-10.0f, 10.0f, -10.0f);
        x[1] = projection.x;
        y[1] = projection.y;
        projection = this.projector.project(10.0f, 10.0f, -10.0f);
        x[2] = projection.x;
        y[2] = projection.y;
        projection = this.projector.project(10.0f, -10.0f, -10.0f);
        x[3] = projection.x;
        y[3] = projection.y;
        x[4] = x[0];
        y[4] = y[0];
        g.setColor(this.colors.getBoxColor());
        g.fillPolygon(x, y, 4);
        g.setColor(this.colors.getLineBoxColor());
        g.drawPolygon(x, y, 5);
        float wline = this.model.getPenWidth() * this.model.getFrameScale();
        g.setStroke((Stroke)new BasicStroke(wline));
    }

    public final void drawBoxGridsTicksLabels(VectorGraphics g2d, boolean draw_axes) {
        Stroke old = g2d.getStroke();
        float wline = this.model.getPenWidth() * this.model.getFrameScale();
        g2d.setStroke((Stroke)new BasicStroke(wline));
        boolean x_left = false;
        boolean y_left = false;
        int[] x = new int[5];
        int[] y = new int[5];
        if (this.projector == null) {
            return;
        }
        Font fontAxis = this.model.getAxisFont();
        Color fontColorAxes = this.model.getAxesFontColor();
        double labelOffsetX = this.model.getLabelOffsetX();
        Font fontLabel = this.model.getLabelFont();
        String Xlabel = this.model.getXlabel();
        String Ylabel = this.model.getYlabel();
        String Zlabel = this.model.getZlabel();
        Color fontColorLabel = this.model.getLabelColor();
        double labelOffsetY = this.model.getLabelOffsetY();
        double labelOffsetZ = this.model.getLabelOffsetZ();
        Color frameColor = this.model.getColorModel().getBackgroundColor();
        g2d.setFont(this.scaleFont(fontAxis));
        if (draw_axes) {
            this.drawBase(g2d, x, y);
            Point projection = this.projector.project(0.0f, 0.0f, -10.0f);
            x[0] = projection.x;
            y[0] = projection.y;
            projection = this.projector.project(10.5f, 0.0f, -10.0f);
            g2d.drawLine(x[0], y[0], projection.x, projection.y);
            if (projection.x < x[0]) {
                this.outString(g2d, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "x", 2, 0, fontAxis, fontColorAxes, 0);
            } else {
                this.outString(g2d, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "x", 0, 0, fontAxis, fontColorAxes, 0);
            }
            projection = this.projector.project(0.0f, 11.5f, -10.0f);
            g2d.drawLine(x[0], y[0], projection.x, projection.y);
            if (projection.x < x[0]) {
                this.outString(g2d, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "y", 2, 0, fontAxis, fontColorAxes, 0);
            } else {
                this.outString(g2d, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "y", 0, 0, fontAxis, fontColorAxes, 0);
            }
            projection = this.projector.project(0.0f, 0.0f, 10.5f);
            g2d.drawLine(x[0], y[0], projection.x, projection.y);
            this.outString(g2d, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "z", 1, 1, fontAxis, fontColorAxes, 0);
        } else {
            this.factor_y = 1;
            this.factor_x = 1;
            Point projection = this.projector.project(0.0f, 0.0f, -10.0f);
            x[0] = projection.x;
            projection = this.projector.project(10.5f, 0.0f, -10.0f);
            y_left = projection.x > x[0];
            int i = projection.y;
            projection = this.projector.project(-10.5f, 0.0f, -10.0f);
            if (projection.y > i) {
                this.factor_x = -1;
                y_left = projection.x > x[0];
            }
            projection = this.projector.project(0.0f, 10.5f, -10.0f);
            x_left = projection.x > x[0];
            i = projection.y;
            projection = this.projector.project(0.0f, -10.5f, -10.0f);
            if (projection.y > i) {
                this.factor_y = -1;
                x_left = projection.x > x[0];
            }
            this.setAxesScale();
            this.drawBase(g2d, x, y);
            if (this.isBoxed) {
                projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, -10.0f);
                x[0] = projection.x;
                y[0] = projection.y;
                projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, 10.0f);
                x[1] = projection.x;
                y[1] = projection.y;
                projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
                x[2] = projection.x;
                y[2] = projection.y;
                projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0f);
                x[3] = projection.x;
                y[3] = projection.y;
                x[4] = x[0];
                y[4] = y[0];
                g2d.setColor(this.colors.getBoxColor());
                g2d.fillPolygon(x, y, 4);
                g2d.setColor(this.colors.getLineBoxColor());
                g2d.drawPolygon(x, y, 5);
                projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
                x[2] = projection.x;
                y[2] = projection.y;
                projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0f);
                x[3] = projection.x;
                y[3] = projection.y;
                x[4] = x[0];
                y[4] = y[0];
                g2d.setColor(this.colors.getBoxColor());
                g2d.fillPolygon(x, y, 4);
                g2d.setColor(this.colors.getLineBoxColor());
                g2d.drawPolygon(x, y, 5);
            } else if (this.isDisplayZ) {
                projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0f);
                x[0] = projection.x;
                y[0] = projection.y;
                projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
                g2d.drawLine(x[0], y[0], projection.x, projection.y);
                projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0f);
                x[0] = projection.x;
                y[0] = projection.y;
                projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
                g2d.drawLine(x[0], y[0], projection.x, projection.y);
            }
            for (i = -9; i <= 9; ++i) {
                Point tickpos;
                if (this.isDisplayXY || this.isDisplayGrids) {
                    if (!this.isDisplayGrids || i % (this.t_y / 2) == 0 || this.isDisplayXY) {
                        projection = this.isDisplayGrids && i % this.t_y == 0 ? this.projector.project(-this.factor_x * 10, i, -10.0f) : (i % this.t_y != 0 ? this.projector.project((float)this.factor_x * 9.8f, i, -10.0f) : this.projector.project((float)this.factor_x * 9.5f, i, -10.0f));
                        tickpos = this.projector.project(this.factor_x * 10, i, -10.0f);
                        g2d.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                        if (i % this.t_y == 0 && this.isDisplayXY) {
                            tickpos = this.projector.project((float)this.factor_x * 10.5f, i, -10.0f);
                            if (y_left) {
                                this.outFloat(g2d, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.ymax - this.ymin) + (double)this.ymin), 0, 0, 0);
                            } else {
                                this.outFloat(g2d, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.ymax - this.ymin) + (double)this.ymin), 2, 0, 0);
                            }
                        }
                    }
                    if (!this.isDisplayGrids || i % (this.t_x / 2) == 0 || this.isDisplayXY) {
                        projection = this.isDisplayGrids && i % this.t_x == 0 ? this.projector.project(i, -this.factor_y * 10, -10.0f) : (i % this.t_x != 0 ? this.projector.project(i, (float)this.factor_y * 9.8f, -10.0f) : this.projector.project(i, (float)this.factor_y * 9.5f, -10.0f));
                        tickpos = this.projector.project(i, this.factor_y * 10, -10.0f);
                        g2d.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                        if (i % this.t_x == 0 && this.isDisplayXY) {
                            tickpos = this.projector.project(i, (float)this.factor_y * 10.5f, -10.0f);
                            if (x_left) {
                                this.outFloat(g2d, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.xmax - this.xmin) + (double)this.xmin), 0, 0, 0);
                            } else {
                                this.outFloat(g2d, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.xmax - this.xmin) + (double)this.xmin), 2, 0, 0);
                            }
                        }
                    }
                }
                if (this.isDisplayXY) {
                    tickpos = this.projector.project(0.0f, this.factor_y * 14, -10.0f);
                    this.outString(g2d, (int)((double)tickpos.x * labelOffsetX), (int)((double)tickpos.y * labelOffsetX), Xlabel, 1, 0, fontLabel, fontColorLabel, 0);
                    tickpos = this.projector.project(this.factor_x * 14, 0.0f, -10.0f);
                    this.outString(g2d, (int)((double)tickpos.x * labelOffsetY), (int)((double)tickpos.y * labelOffsetY), Ylabel, 1, 0, fontLabel, fontColorLabel, 0);
                }
                if (this.isDisplayZ) {
                    tickpos = this.projector.project((float)(-this.factor_x) * 11.0f, (float)this.factor_y * 11.0f, 10.0f);
                    this.outString(g2d, (int)((double)((float)tickpos.x * 1.0f) / labelOffsetZ), (int)((double)((float)tickpos.y * 1.0f) / labelOffsetZ), Zlabel, 1, 0, fontLabel, fontColorLabel, 0);
                }
                if (!this.isDisplayZ && (!this.isDisplayGrids || !this.isBoxed) || this.isDisplayGrids && i % (this.t_z / 2) != 0 && !this.isDisplayZ) continue;
                if (this.isBoxed && this.isDisplayGrids && i % this.t_z == 0) {
                    projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, i);
                    tickpos = this.projector.project(-this.factor_x * 10, this.factor_y * 10, i);
                } else {
                    projection = i % this.t_z == 0 ? this.projector.project(-this.factor_x * 10, (float)this.factor_y * 9.5f, i) : this.projector.project(-this.factor_x * 10, (float)this.factor_y * 9.8f, i);
                    tickpos = this.projector.project(-this.factor_x * 10, this.factor_y * 10, i);
                }
                g2d.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                if (this.isDisplayZ) {
                    tickpos = this.projector.project(-this.factor_x * 10, (float)this.factor_y * 10.5f, i);
                    if (i % this.t_z == 0) {
                        if (x_left) {
                            this.outFloat(g2d, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.zmax - this.zmin) + (double)this.zmin), 0, 1, 0);
                        } else {
                            this.outFloat(g2d, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.zmax - this.zmin) + (double)this.zmin), 2, 1, 0);
                        }
                    }
                }
                if (this.isDisplayGrids && this.isBoxed && i % this.t_z == 0) {
                    projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, i);
                    tickpos = this.projector.project(this.factor_x * 10, -this.factor_y * 10, i);
                } else {
                    projection = i % this.t_z == 0 ? this.projector.project((float)this.factor_x * 9.5f, -this.factor_y * 10, i) : this.projector.project((float)this.factor_x * 9.8f, -this.factor_y * 10, i);
                    tickpos = this.projector.project(this.factor_x * 10, -this.factor_y * 10, i);
                }
                g2d.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                if (this.isDisplayZ) {
                    tickpos = this.projector.project((float)this.factor_x * 10.5f, -this.factor_y * 10, i);
                    if (i % this.t_z == 0) {
                        if (y_left) {
                            this.outFloat(g2d, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.zmax - this.zmin) + (double)this.zmin), 0, 1, 0);
                        } else {
                            this.outFloat(g2d, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.zmax - this.zmin) + (double)this.zmin), 2, 1, 0);
                        }
                    }
                }
                if (!this.isDisplayGrids || !this.isBoxed) continue;
                if (i % this.t_y == 0) {
                    projection = this.projector.project(-this.factor_x * 10, i, -10.0f);
                    tickpos = this.projector.project(-this.factor_x * 10, i, 10.0f);
                    g2d.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                }
                if (i % this.t_x != 0) continue;
                projection = this.projector.project(i, -this.factor_y * 10, -10.0f);
                tickpos = this.projector.project(i, -this.factor_y * 10, 10.0f);
                g2d.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
            }
        }
        float wwline = this.model.getPenWidth() * this.model.getFrameScale();
        g2d.setStroke((Stroke)new BasicStroke(wwline));
    }

    private final void setAxesScale() {
        float divisor;
        int longest;
        if (!this.isScaleBox) {
            this.projector.setScaling(1.0f);
            this.t_z = 4;
            this.t_y = 4;
            this.t_x = 4;
            return;
        }
        float scale_x = this.xmax - this.xmin;
        float scale_y = this.ymax - this.ymin;
        float scale_z = this.zmax - this.zmin;
        if (scale_x < scale_y) {
            if (scale_y < scale_z) {
                longest = 3;
                divisor = scale_z;
            } else {
                longest = 2;
                divisor = scale_y;
            }
        } else if (scale_x < scale_z) {
            longest = 3;
            divisor = scale_z;
        } else {
            longest = 1;
            divisor = scale_x;
        }
        scale_y /= divisor;
        scale_z /= divisor;
        if ((scale_x /= divisor) < 0.2f || scale_y < 0.2f && scale_z < 0.2f) {
            switch (longest) {
                case 1: {
                    if (scale_y < scale_z) {
                        scale_y /= scale_z;
                        scale_z = 1.0f;
                        break;
                    }
                    scale_z /= scale_y;
                    scale_y = 1.0f;
                    break;
                }
                case 2: {
                    if (scale_x < scale_z) {
                        scale_x /= scale_z;
                        scale_z = 1.0f;
                        break;
                    }
                    scale_z /= scale_x;
                    scale_x = 1.0f;
                    break;
                }
                case 3: {
                    if (scale_y < scale_x) {
                        scale_y /= scale_x;
                        scale_x = 1.0f;
                        break;
                    }
                    scale_x /= scale_y;
                    scale_y = 1.0f;
                }
            }
        }
        if (scale_x < 0.2f) {
            scale_x = 1.0f;
        }
        this.projector.setXScaling(scale_x);
        if (scale_y < 0.2f) {
            scale_y = 1.0f;
        }
        this.projector.setYScaling(scale_y);
        if (scale_z < 0.2f) {
            scale_z = 1.0f;
        }
        this.projector.setZScaling(scale_z);
        this.t_x = scale_x < 0.5f ? 8 : 4;
        this.t_y = scale_y < 0.5f ? 8 : 4;
        this.t_z = scale_z < 0.5f ? 8 : 4;
    }

    private final void outString(VectorGraphics g2d, int x, int y, String s, int x_align, int y_align, Font f, Color c, int angle) {
        Font ff = this.scaleFont(g2d.getFont());
        switch (y_align) {
            case 0: {
                y += g2d.getFontMetrics(ff).getAscent();
                break;
            }
            case 1: {
                y += g2d.getFontMetrics(ff).getAscent() / 2;
            }
        }
        RTextLine text = new RTextLine();
        text.setFont(this.scaleFont(f));
        text.setColor(c);
        String stext = Translate.decode(s);
        text.setText(stext);
        text.setRotation(angle);
        double rotation = (double)angle * Math.PI / 180.0;
        if (angle != 0) {
            g2d.rotate(rotation, (double)x, (double)y);
        }
        switch (x_align) {
            case 0: {
                text.draw(g2d, x, y);
                break;
            }
            case 2: {
                text.draw(g2d, x - g2d.getFontMetrics(g2d.getFont()).stringWidth(stext), y);
                break;
            }
            case 1: {
                text.draw(g2d, x - g2d.getFontMetrics(g2d.getFont()).stringWidth(stext) / 2, y);
            }
        }
        if (angle != 0) {
            g2d.rotate(-rotation, (double)x, (double)y);
        }
    }

    protected Font scaleFont(Font fo) {
        int fontSize = Math.round((float)fo.getSize() * this.model.getFrameScale());
        return new Font(fo.getName(), fo.getStyle(), fontSize);
    }

    private final void outFloat(VectorGraphics g2d, int x, int y, float f, int x_align, int y_align, int angle) {
        String s = Float.toString(f);
        s = NumUtil.RemoveZero(s);
        this.outString(g2d, x, y, s, x_align, y_align, this.model.getAxisFont(), this.model.getAxesFontColor(), angle);
    }

    private final void plotPlane(SurfaceVertex[] vertex, int verticescount) {
        if (verticescount < 3) {
            return;
        }
        int count = 0;
        float z = 0.0f;
        boolean low1 = vertex[0].z < this.zmin;
        boolean valid1 = !low1 && vertex[0].z <= this.zmax;
        int index = 1;
        for (int loop = 0; loop < verticescount; ++loop) {
            boolean valid2;
            boolean low2 = vertex[index].z < this.zmin;
            boolean bl = valid2 = !low2 && vertex[index].z <= this.zmax;
            if (valid1 || valid2 || low1 ^ low2) {
                float new_y;
                float new_x;
                float ratio;
                float result;
                if (!valid1) {
                    result = low1 ? this.zmin : this.zmax;
                    ratio = (result - vertex[index].z) / (vertex[loop].z - vertex[index].z);
                    new_x = ratio * (vertex[loop].x - vertex[index].x) + vertex[index].x;
                    new_y = ratio * (vertex[loop].y - vertex[index].y) + vertex[index].y;
                    this.projection = low1 ? this.projector.project(new_x, new_y, -10.0f) : this.projector.project(new_x, new_y, 10.0f);
                    this.poly_x[count] = this.projection.x;
                    this.poly_y[count] = this.projection.y;
                    ++count;
                    z += result;
                }
                if (valid2) {
                    this.projection = vertex[index].projection(this.projector);
                    this.poly_x[count] = this.projection.x;
                    this.poly_y[count] = this.projection.y;
                    ++count;
                    z += vertex[index].z;
                } else {
                    result = low2 ? this.zmin : this.zmax;
                    ratio = (result - vertex[loop].z) / (vertex[index].z - vertex[loop].z);
                    new_x = ratio * (vertex[index].x - vertex[loop].x) + vertex[loop].x;
                    new_y = ratio * (vertex[index].y - vertex[loop].y) + vertex[loop].y;
                    this.projection = low2 ? this.projector.project(new_x, new_y, -10.0f) : this.projector.project(new_x, new_y, 10.0f);
                    this.poly_x[count] = this.projection.x;
                    this.poly_y[count] = this.projection.y;
                    ++count;
                    z += result;
                }
            }
            if (++index == verticescount) {
                index = 0;
            }
            valid1 = valid2;
            low1 = low2;
        }
        if (count > 0) {
            z = (z / (float)count - this.zmin) * this.color_factor;
            this.graphics.setColor(this.colors.getPolygonColor(this.curve, z));
            this.graphics.fillPolygon(this.poly_x, this.poly_y, count);
            this.graphics.setColor(this.colors.getLineColor(1, z));
            if (this.isMesh) {
                this.poly_x[count] = this.poly_x[0];
                this.poly_y[count] = this.poly_y[0];
                this.graphics.drawPolygon(this.poly_x, this.poly_y, ++count);
            }
        }
    }

    private final void splitPlotPlane(SurfaceVertex[] values1, SurfaceVertex[] values2) {
        int trackposition = 0;
        int uppercount = 0;
        int lowercount = 0;
        boolean coincide = true;
        boolean upper_first = false;
        int i = 0;
        int j = 0;
        for (int counter = 0; counter <= 4; ++counter) {
            float zi;
            float xi;
            float yi;
            float factor;
            if (values1[i].z < values2[i].z) {
                coincide = false;
                if (trackposition == 0) {
                    trackposition = 1;
                    this.upperpart[uppercount++] = values2[i];
                } else if (trackposition != 1) {
                    factor = (values1[i].z - values2[i].z) / (values1[i].z - values2[i].z + values2[j].z - values1[j].z);
                    if (values1[i].x == values1[j].x) {
                        yi = factor * (values1[j].y - values1[i].y) + values1[i].y;
                        xi = values1[i].x;
                    } else {
                        xi = factor * (values1[j].x - values1[i].x) + values1[i].x;
                        yi = values1[i].y;
                    }
                    zi = factor * (values2[j].z - values2[i].z) + values2[i].z;
                    int n = uppercount++;
                    int n2 = lowercount++;
                    SurfaceVertex surfaceVertex = new SurfaceVertex(xi, yi, zi);
                    this.lowerpart[n2] = surfaceVertex;
                    this.upperpart[n] = surfaceVertex;
                    this.upperpart[uppercount++] = values2[i];
                    trackposition = 1;
                } else {
                    this.upperpart[uppercount++] = values2[i];
                }
            } else if (values1[i].z > values2[i].z) {
                coincide = false;
                if (trackposition == 0) {
                    trackposition = -1;
                    this.lowerpart[lowercount++] = values2[i];
                } else if (trackposition != -1) {
                    factor = (values1[i].z - values2[i].z) / (values1[i].z - values2[i].z + values2[j].z - values1[j].z);
                    if (values1[i].x == values1[j].x) {
                        yi = factor * (values1[j].y - values1[i].y) + values1[i].y;
                        xi = values1[i].x;
                    } else {
                        xi = factor * (values1[j].x - values1[i].x) + values1[i].x;
                        yi = values1[i].y;
                    }
                    zi = factor * (values2[j].z - values2[i].z) + values2[i].z;
                    int n = lowercount++;
                    int n3 = uppercount++;
                    SurfaceVertex surfaceVertex = new SurfaceVertex(xi, yi, zi);
                    this.upperpart[n3] = surfaceVertex;
                    this.lowerpart[n] = surfaceVertex;
                    this.lowerpart[lowercount++] = values2[i];
                    trackposition = -1;
                } else {
                    this.lowerpart[lowercount++] = values2[i];
                }
            } else {
                this.upperpart[uppercount++] = values2[i];
                this.lowerpart[lowercount++] = values2[i];
                trackposition = 0;
            }
            j = i;
            i = (i + 1) % 4;
        }
        if (coincide) {
            this.plotPlane(values1, 4);
        } else {
            if (this.critical) {
                upper_first = false;
            } else if (values1[1].x == values1[2].x) {
                upper_first = (values1[2].z - values1[3].z) * (this.cop.x - values1[3].x) / (values1[2].x - values1[3].x) + values1[3].z + (values1[2].z - values1[1].z) * (this.cop.y - values1[1].y) / (values1[2].y - values1[1].y) + values1[1].z - values1[2].z > this.cop.z;
            } else {
                boolean bl = upper_first = (values1[2].z - values1[1].z) * (this.cop.x - values1[1].x) / (values1[2].x - values1[1].x) + values1[1].z + (values1[2].z - values1[3].z) * (this.cop.y - values1[3].y) / (values1[2].y - values1[3].y) + values1[3].z - values1[2].z > this.cop.z;
            }
            if (lowercount < 3) {
                if (upper_first) {
                    this.curve = 2;
                    this.plotPlane(this.upperpart, uppercount);
                    this.curve = 1;
                    this.plotPlane(values1, 4);
                } else {
                    this.curve = 1;
                    this.plotPlane(values1, 4);
                    this.curve = 2;
                    this.plotPlane(this.upperpart, uppercount);
                }
            } else if (uppercount < 3) {
                if (upper_first) {
                    this.curve = 1;
                    this.plotPlane(values1, 4);
                    this.curve = 2;
                    this.plotPlane(this.lowerpart, lowercount);
                } else {
                    this.curve = 2;
                    this.plotPlane(this.lowerpart, lowercount);
                    this.curve = 1;
                    this.plotPlane(values1, 4);
                }
            } else if (upper_first) {
                this.curve = 2;
                this.plotPlane(this.upperpart, uppercount);
                this.curve = 1;
                this.plotPlane(values1, 4);
                this.curve = 2;
                this.plotPlane(this.lowerpart, lowercount);
            } else {
                this.curve = 2;
                this.plotPlane(this.lowerpart, lowercount);
                this.curve = 1;
                this.plotPlane(values1, 4);
                this.curve = 2;
                this.plotPlane(this.upperpart, uppercount);
            }
        }
    }

    private final boolean plottable(SurfaceVertex[] values) {
        return !values[0].isInvalid() && !values[1].isInvalid() && !values[2].isInvalid() && !values[3].isInvalid();
    }

    public final void plotArea(int start_lx, int start_ly, int end_lx, int end_ly, int sx, int sy) {
        if (this.vertex == null) {
            return;
        }
        sx *= this.calc_divisions + 1;
        end_lx *= this.calc_divisions + 1;
        int lx = start_lx *= this.calc_divisions + 1;
        for (int ly = start_ly; ly != end_ly; ly += sy) {
            if (this.plotfunc1) {
                this.values1[1] = this.vertex[0][lx + ly];
                this.values1[2] = this.vertex[0][lx + ly + sy];
            }
            if (this.plotfunc2) {
                this.values2[1] = this.vertex[1][lx + ly];
                this.values2[2] = this.vertex[1][lx + ly + sy];
            }
            while (lx != end_lx) {
                Thread.yield();
                if (this.plotfunc1) {
                    this.values1[0] = this.values1[1];
                    this.values1[1] = this.vertex[0][lx + sx + ly];
                    this.values1[3] = this.values1[2];
                    this.values1[2] = this.vertex[0][lx + sx + ly + sy];
                }
                if (this.plotfunc2) {
                    this.values2[0] = this.values2[1];
                    this.values2[1] = this.vertex[1][lx + sx + ly];
                    this.values2[3] = this.values2[2];
                    this.values2[2] = this.vertex[1][lx + sx + ly + sy];
                }
                if (!this.plotboth) {
                    if (this.plotfunc1) {
                        this.curve = 1;
                        if (this.plottable(this.values1)) {
                            this.plotPlane(this.values1, 4);
                        }
                    } else {
                        this.curve = 2;
                        if (this.plottable(this.values2)) {
                            this.plotPlane(this.values2, 4);
                        }
                    }
                } else if (this.plottable(this.values1)) {
                    if (this.plottable(this.values2)) {
                        this.splitPlotPlane(this.values1, this.values2);
                    } else {
                        this.curve = 1;
                        this.plotPlane(this.values1, 4);
                    }
                } else if (this.plottable(this.values2)) {
                    this.curve = 2;
                    this.plotPlane(this.values2, 4);
                }
                lx += sx;
            }
            lx = start_lx;
        }
    }

    public final int contourConvertX(float x) {
        return Math.round(x * this.contour_width_x + (float)this.contour_center_x);
    }

    public final int contourConvertY(float y) {
        return Math.round(-y * this.contour_width_y + (float)this.contour_center_y);
    }

    public final void drawBoundingRect() {
        this.graphics.setColor(this.colors.getLineBoxColor());
        int x1 = this.contourConvertX(-10.0f);
        int y1 = this.contourConvertY(10.0f);
        int x2 = this.contourConvertX(10.0f);
        int y2 = this.contourConvertY(-10.0f);
        this.graphics.drawRect(x1, y1, x2 - x1, y2 - y1);
        Font fontLabel = this.model.getLabelFont();
        Color fontColorLabel = this.model.getLabelColor();
        Font fontAxis = this.model.getAxisFont();
        Color fontColorAxes = this.model.getAxesFontColor();
        String Xlabel = this.model.getXlabel();
        String Ylabel = this.model.getYlabel();
        this.ylabels = NumUtil.ZeroRemover(this.ylabels);
        this.legend_label = NumUtil.ZeroRemover(this.legend_label);
        if (this.isDisplayXY || this.isDisplayGrids) {
            if (this.isDisplayXY) {
                x1 = this.contourConvertX(-10.5f);
                y1 = this.contourConvertY(10.5f);
                x2 = this.contourConvertX(10.5f);
                y2 = this.contourConvertY(-10.5f);
                this.graphics.drawRect(x1, y1, x2 - x1, y2 - y1);
            }
            int labelindex = 0;
            for (int i = -10; i <= 10; ++i) {
                if (!this.isDisplayGrids || i % (this.t_y / 2) == 0 || this.isDisplayXY) {
                    int yc = this.contourConvertY(i);
                    if (this.isDisplayGrids && i % this.t_y == 0) {
                        this.graphics.drawLine(this.contourConvertX(-10.0f), yc, this.contourConvertX(10.0f), yc);
                    }
                    if (this.isDisplayXY) {
                        if (i % this.t_y != 0) {
                            this.graphics.drawLine(this.contourConvertX(10.3f), yc, x2, yc);
                            this.graphics.drawLine(this.contourConvertX(-10.3f), yc, x1, yc);
                        } else {
                            this.graphics.drawLine(this.contourConvertX(10.0f), yc, x2, yc);
                            this.graphics.drawLine(this.contourConvertX(-10.0f), yc, x1, yc);
                        }
                    }
                    if (i % this.t_y == 0 && this.isDisplayXY) {
                        this.outString(this.graphics, this.contourConvertX(10.9f), yc, this.ylabels[labelindex++], 0, 1, fontAxis, fontColorAxes, 0);
                    }
                }
                if (!this.isDisplayGrids || i % (this.t_x / 2) == 0 || this.isDisplayXY) {
                    int xc = this.contourConvertX(i);
                    if (this.isDisplayGrids && i % this.t_x == 0) {
                        this.graphics.drawLine(xc, this.contourConvertY(-10.0f), xc, this.contourConvertY(10.0f));
                    }
                    if (this.isDisplayXY) {
                        if (i % this.t_x != 0) {
                            this.graphics.drawLine(xc, this.contourConvertY(-10.3f), xc, y2);
                            this.graphics.drawLine(xc, this.contourConvertY(10.3f), xc, y1);
                        } else {
                            this.graphics.drawLine(xc, this.contourConvertY(-10.0f), xc, y2);
                            this.graphics.drawLine(xc, this.contourConvertY(10.0f), xc, y1);
                        }
                    }
                    if (i % this.t_x == 0 && this.isDisplayXY) {
                        this.outFloat(this.graphics, xc, this.contourConvertY(-10.7f), (float)((double)(i + 10) / 20.0 * (double)(this.xmax - this.xmin) + (double)this.xmin), 1, 0, 0);
                    }
                }
                if (!this.isDisplayXY) continue;
                this.outString(this.graphics, (x1 + x2) / 2, this.contourConvertY(-10.9f - (float)this.model.getLabelOffsetX()), Xlabel, 1, 0, fontLabel, fontColorLabel, 0);
                this.outString(this.graphics, this.contourConvertX(-10.0f - (float)this.model.getLabelOffsetY()), this.contourConvertY(-1.0f), Ylabel, 0, 1, fontLabel, fontColorLabel, -90);
            }
        }
        if (this.isDisplayZ) {
            int lasty = y2;
            int height = y2 - y1;
            int divisions = this.contour_lines;
            x1 = (x2 += this.contour_space_x) - (this.legend_space + this.legend_width + this.legend_length);
            this.graphics.setColor(this.colors.getTextColor());
            this.outString(this.graphics, x2 -= this.legend_length, y2, this.legend_label[0], 0, 1, fontAxis, fontColorAxes, 0);
            int ntot = 5;
            if (divisions < 10) {
                ntot = 1;
            }
            if (divisions > 9 && divisions < 21) {
                ntot = 2;
            }
            if (divisions > 20 && divisions < 31) {
                ntot = 3;
            }
            if (divisions > 30 && divisions < 41) {
                ntot = 4;
            }
            if (divisions > 40 && divisions < 51) {
                ntot = 5;
            }
            if (divisions > 50) {
                ntot = 5;
            }
            for (int i = 1; i <= divisions + 1; ++i) {
                int y = y2 - i * height / (divisions + 1);
                this.graphics.setColor(this.contour_color[i - 1]);
                this.graphics.fillRect(x1, y, this.legend_width, lasty - y);
                this.graphics.setColor(this.colors.getLineColor());
                this.graphics.drawRect(x1, y, this.legend_width, lasty - y);
                if (i % ntot == 0) {
                    this.outString(this.graphics, x2, y, this.legend_label[i], 0, 1, fontAxis, fontColorAxes, 0);
                }
                lasty = y;
            }
        }
    }

    private final void cleanUpMemory() {
        this.legend_label = null;
        this.contour_color = null;
        this.ylabels = null;
        this.accumulator.clearAccumulator();
    }

    public final void computePlotArea() {
        this.setAxesScale();
        this.contour_lines = this.model.getContourLines();
        float ratio = this.projector.getYScaling() / this.projector.getXScaling();
        float width = 0.0f;
        float height = 0.0f;
        if (this.printing) {
            width = this.printwidth;
            height = this.printheight;
        } else {
            width = this.getBounds().width;
            height = this.getBounds().height;
        }
        int fontsize = 0;
        fontsize = width < height ? (int)(width / 48.0f) : (int)(height / 48.0f);
        this.graphics.setFont(new Font("Helvetica", 0, fontsize));
        FontMetrics fm = this.graphics.getFontMetrics();
        width *= 0.9f;
        height *= 0.9f;
        int spacex = 0;
        int spacey = 0;
        if (this.isDisplayXY) {
            int i;
            int labelscount = 0;
            int index = 0;
            int maxwidth = 0;
            for (i = -10; i < 10; ++i) {
                if (i % this.t_y != 0) continue;
                ++labelscount;
            }
            this.ylabels = new String[labelscount];
            for (i = -10; i < 10; ++i) {
                int strwidth;
                if (i % this.t_y != 0) continue;
                this.ylabels[index] = this.format((float)((double)(i + 10) / 20.0 * (double)(this.ymax - this.ymin) + (double)this.ymin));
                if ((strwidth = fm.stringWidth(this.ylabels[index++])) <= maxwidth) continue;
                maxwidth = strwidth;
            }
            spacex += maxwidth;
            spacey += fm.getMaxAscent();
        }
        if (this.isDisplayZ) {
            this.legend_width = (int)((double)width * 0.05);
            spacex += this.legend_width * 2;
            this.legend_space = fontsize;
            int counts = this.contour_lines;
            this.legend_length = 0;
            this.legend_label = new String[counts += 2];
            for (int i = 0; i < counts; ++i) {
                float label = (float)((double)i / (double)(counts - 1) * (double)(this.zmax - this.zmin) + (double)this.zmin);
                this.legend_label[i] = this.format(label);
                int labelwidth = fm.stringWidth(this.legend_label[i]);
                if (labelwidth <= this.legend_length) continue;
                this.legend_length = labelwidth;
            }
            spacex += this.legend_length + this.legend_space;
        }
        height -= (float)spacey;
        this.contour_width_x = width -= (float)spacex;
        this.contour_width_y = width * ratio;
        if (this.contour_width_y > height) {
            this.contour_width_y = height;
            this.contour_width_x = height / ratio;
        }
        float scaling_factor = 10.0f;
        if (this.isDisplayXY) {
            scaling_factor = 10.7f;
        }
        this.contour_width_x = this.contour_width_x / scaling_factor / 2.0f;
        this.contour_width_y = this.contour_width_y / scaling_factor / 2.0f;
        this.contour_center_x = 0;
        this.contour_center_y = 0;
        int x1 = this.contourConvertX(-scaling_factor);
        int y1 = this.contourConvertY(scaling_factor);
        int x2 = this.contourConvertX(scaling_factor) + spacex;
        int y2 = this.contourConvertY(-scaling_factor) + spacey;
        this.contour_center_x = (this.getBounds().width - (x1 + x2)) / 2;
        this.contour_center_y = (this.getBounds().height - (y1 + y2)) / 2;
        this.contour_space_x = spacex;
        this.contour_color = new Color[this.contour_lines + 1];
        for (int i = 0; i <= this.contour_lines; ++i) {
            float level = (float)i / (float)this.contour_lines;
            this.contour_color[i] = this.colors.getPolygonColor(this.curve, level);
        }
    }

    public final void createContour() {
        float z = this.zmin;
        int xmin = this.xpoints[0] = this.contourConvertX(this.contour_vertex[0].x);
        int xmax = this.xpoints[4] = this.contourConvertX(this.contour_vertex[2].x);
        this.ypoints[0] = this.contourConvertY(this.contour_vertex[0].y);
        this.xpoints[2] = this.contourConvertX(this.contour_vertex[1].x);
        this.ypoints[4] = this.contourConvertY(this.contour_vertex[2].y);
        this.xpoints[6] = this.contourConvertX(this.contour_vertex[3].x);
        this.ypoints[2] = this.ypoints[3] = this.contourConvertY(this.contour_vertex[1].y);
        this.ypoints[6] = this.ypoints[7] = this.contourConvertY(this.contour_vertex[3].y);
        this.xpoints[7] = -1;
        this.xpoints[5] = -1;
        this.xpoints[3] = -1;
        this.xpoints[1] = -1;
        for (int counter = 0; counter <= this.contour_lines + 1; ++counter) {
            block7: for (int edge = 0; edge < 4; ++edge) {
                int index = (edge << 1) + 1;
                int nextedge = edge + 1 & 3;
                if (z > this.contour_vertex[edge].z) {
                    this.xpoints[index - 1] = -2;
                    if (z > this.contour_vertex[nextedge].z) {
                        this.xpoints[index + 1 & 7] = -2;
                        this.xpoints[index] = -2;
                    }
                } else if (z > this.contour_vertex[nextedge].z) {
                    this.xpoints[index + 1 & 7] = -2;
                }
                if (this.xpoints[index] == -2) continue;
                if (this.xpoints[index] != -1) {
                    int n = edge;
                    this.intersection[n] = this.intersection[n] + this.delta[edge];
                    if (index == 1 || index == 5) {
                        this.ypoints[index] = this.contourConvertY(this.intersection[edge]);
                        continue;
                    }
                    this.xpoints[index] = this.contourConvertX(this.intersection[edge]);
                    continue;
                }
                if (!(z > this.contour_vertex[edge].z) && !(z > this.contour_vertex[nextedge].z)) continue;
                switch (index) {
                    case 1: {
                        this.delta[edge] = (this.contour_vertex[nextedge].y - this.contour_vertex[edge].y) * this.contour_stepz / (this.contour_vertex[nextedge].z - this.contour_vertex[edge].z);
                        this.intersection[edge] = (this.contour_vertex[nextedge].y * (z - this.contour_vertex[edge].z) + this.contour_vertex[edge].y * (this.contour_vertex[nextedge].z - z)) / (this.contour_vertex[nextedge].z - this.contour_vertex[edge].z);
                        this.xpoints[index] = xmin;
                        this.ypoints[index] = this.contourConvertY(this.intersection[edge]);
                        continue block7;
                    }
                    case 3: {
                        this.delta[edge] = (this.contour_vertex[nextedge].x - this.contour_vertex[edge].x) * this.contour_stepz / (this.contour_vertex[nextedge].z - this.contour_vertex[edge].z);
                        this.intersection[edge] = (this.contour_vertex[nextedge].x * (z - this.contour_vertex[edge].z) + this.contour_vertex[edge].x * (this.contour_vertex[nextedge].z - z)) / (this.contour_vertex[nextedge].z - this.contour_vertex[edge].z);
                        this.xpoints[index] = this.contourConvertX(this.intersection[edge]);
                        continue block7;
                    }
                    case 5: {
                        this.delta[edge] = (this.contour_vertex[edge].y - this.contour_vertex[nextedge].y) * this.contour_stepz / (this.contour_vertex[edge].z - this.contour_vertex[nextedge].z);
                        this.intersection[edge] = (this.contour_vertex[edge].y * (z - this.contour_vertex[nextedge].z) + this.contour_vertex[nextedge].y * (this.contour_vertex[edge].z - z)) / (this.contour_vertex[edge].z - this.contour_vertex[nextedge].z);
                        this.xpoints[index] = xmax;
                        this.ypoints[index] = this.contourConvertY(this.intersection[edge]);
                        continue block7;
                    }
                    case 7: {
                        this.delta[edge] = (this.contour_vertex[edge].x - this.contour_vertex[nextedge].x) * this.contour_stepz / (this.contour_vertex[edge].z - this.contour_vertex[nextedge].z);
                        this.intersection[edge] = (this.contour_vertex[edge].x * (z - this.contour_vertex[nextedge].z) + this.contour_vertex[nextedge].x * (this.contour_vertex[edge].z - z)) / (this.contour_vertex[edge].z - this.contour_vertex[nextedge].z);
                        this.xpoints[index] = this.contourConvertX(this.intersection[edge]);
                    }
                }
            }
            this.contour_n = 0;
            for (int index = 0; index < 8; ++index) {
                if (this.xpoints[index] < 0) continue;
                this.contour_x[this.contour_n] = this.xpoints[index];
                this.contour_y[this.contour_n] = this.ypoints[index];
                ++this.contour_n;
            }
            if (counter > this.contour_lines) {
                if (this.printing) {
                    this.graphics.setColor(Color.white);
                } else {
                    this.graphics.setColor(this.colors.getBackgroundColor());
                }
            } else {
                this.graphics.setColor(this.contour_color[counter]);
            }
            if (this.ok(this.contour_x, this.contour_n) && this.ok(this.contour_y, this.contour_n)) {
                this.graphics.fillPolygon(this.contour_x, this.contour_y, this.contour_n);
            }
            if (this.isMesh) {
                int x = -1;
                int y = -1;
                for (int index = 1; index < 8; index += 2) {
                    if (this.xpoints[index] < 0) continue;
                    if (x != -1) {
                        this.accumulator.addLine(x, y, this.xpoints[index], this.ypoints[index]);
                    }
                    x = this.xpoints[index];
                    y = this.ypoints[index];
                }
                if (this.xpoints[1] > 0 && x != -1) {
                    this.accumulator.addLine(x, y, this.xpoints[1], this.ypoints[1]);
                }
            }
            if (this.contour_n < 3) break;
            z += this.contour_stepz;
        }
    }

    private boolean ok(int[] f, int x) {
        for (int i = 0; i < x; ++i) {
            if (f[i] > 0) continue;
            return false;
        }
        return true;
    }

    public Projector getProjector() {
        return this.projector;
    }

    public SurfaceColor getSurfaceColor() {
        return this.colors;
    }

    public SurfaceModel getSurfaceModel() {
        return this.model;
    }

    public VectorGraphics getVectorGraphics() {
        return this.graphics;
    }

    class JSurfaceChangesListener
    implements PropertyChangeListener,
    ChangeListener {
        JSurfaceChangesListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSurface.this.destroyImage();
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            JSurface.this.init();
            JSurface.this.destroyImage();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JSurface.this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class JSurfaceMouseListener
    extends MouseAdapter
    implements MouseMotionListener,
    MouseWheelListener {
        int i = 0;

        JSurfaceMouseListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            float new_value = 0.0f;
            float old_value = JSurface.this.projector.get2DScaling();
            new_value = old_value * (1.0f - (float)(e.getScrollAmount() * e.getWheelRotation()) / 10.0f);
            if (new_value > 60.0f) {
                new_value = 60.0f;
            }
            if (new_value < 2.0f) {
                new_value = 2.0f;
            }
            if (new_value != old_value) {
                JSurface.this.projector.set2DScaling(new_value);
                JSurface.this.model.setInitScaling(new_value);
                JSurface.this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            JSurface.this.click_x = x;
            JSurface.this.click_y = y;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (!JSurface.this.is3D()) {
                return;
            }
            if (JSurface.this.model.isExpectDelay() && JSurface.this.dragged) {
                JSurface.this.destroyImage();
                JSurface.this.data_available = JSurface.this.is_data_available;
                JSurface.this.repaint();
                JSurface.this.dragged = false;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            float new_value = 0.0f;
            if (!JSurface.this.is3D()) {
                return;
            }
            if (e.isControlDown()) {
                JSurface.this.projector.set2D_xTranslation(JSurface.this.projector.get2D_xTranslation() + (x - JSurface.this.click_x));
                JSurface.this.projector.set2D_yTranslation(JSurface.this.projector.get2D_yTranslation() + (y - JSurface.this.click_y));
            } else if (e.isShiftDown()) {
                new_value = JSurface.this.projector.get2DScaling() + (float)(y - JSurface.this.click_y) * 0.5f;
                if (new_value > 60.0f) {
                    new_value = 60.0f;
                }
                if (new_value < 2.0f) {
                    new_value = 2.0f;
                }
                JSurface.this.projector.set2DScaling(new_value);
            } else {
                for (new_value = JSurface.this.projector.getRotationAngle() + (float)(x - JSurface.this.click_x); new_value > 360.0f; new_value -= 360.0f) {
                }
                while (new_value < 0.0f) {
                    new_value += 360.0f;
                }
                JSurface.this.projector.setRotationAngle(new_value);
                new_value = JSurface.this.projector.getElevationAngle() + (float)(y - JSurface.this.click_y);
                if (JSurface.this.plot_type == SurfaceModel.PlotType.BARS) {
                    if (new_value > 90.0f) {
                        new_value = 90.0f;
                    } else if (new_value < 0.0f) {
                        new_value = 0.0f;
                    }
                }
                JSurface.this.projector.setElevationAngle(new_value);
            }
            if (!JSurface.this.model.isExpectDelay()) {
                JSurface.this.repaint();
            } else {
                if (!JSurface.this.dragged) {
                    JSurface.this.is_data_available = JSurface.this.data_available;
                    JSurface.this.dragged = true;
                }
                JSurface.this.data_available = false;
                JSurface.this.repaint();
            }
            JSurface.this.click_x = x;
            JSurface.this.click_y = y;
        }
    }
}

