/*
 * Decompiled with CFR 0.152.
 */
package jplot.panels;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jplot.GraphSettings;
import jplot.LinePars;
import jplot.MyUtils;
import jplot.SmallScrollPane;
import jplot.panels.PanelSeeOption;

public class PanelDash
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox cb_lw;
    private String[] ten = new String[]{"10", "9", "8", "7", "6", "5", "4", "3", "2", "1"};
    private SmallScrollPane ssp;
    private LinePars lp;
    private DashSwatches swatches;
    boolean actionNeeded;

    public PanelDash(LinePars l) {
        this.lp = l;
        this.actionNeeded = false;
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Lines"));
        JPanel p = new JPanel(new FlowLayout());
        this.swatches = new DashSwatches();
        p.add(this.swatches);
        this.add((Component)p, "Center");
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(MyUtils.getLabel("pen width"));
        p.add(Box.createHorizontalStrut(4));
        this.ssp = new SmallScrollPane(this.ten);
        this.ssp.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PanelDash.this.actionNeeded) {
                    PanelDash.this.lp.setPenWidth(Float.parseFloat(PanelDash.this.ten[PanelDash.this.ssp.getSelectedIndex()]));
                }
            }
        });
        p.add(this.ssp);
        this.add((Component)p, "South");
    }

    public void refresh(LinePars l) {
        this.lp = l;
        this.actionNeeded = true;
        this.ssp.setSelectedIndex(this.ten.length - (int)this.lp.getPenWidth());
        this.swatches.setSelectedSwatch(this.lp.getDashIndex());
    }

    class DashSwatches
    extends PanelSeeOption {
        private static final long serialVersionUID = 1L;
        protected float[] dash;
        protected float penWidth;

        DashSwatches() {
            this.setSelectedSwatch(PanelDash.this.lp.getDashIndex());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        int index = DashSwatches.this.getIndex(e.getX(), e.getY());
                        DashSwatches.this.setSelectedSwatch(index);
                        PanelDash.this.lp.setDashLength(GraphSettings.dashLengths[index], index);
                    }
                }
            });
        }

        @Override
        protected void initValues() {
            this.dash = new float[1];
            this.dash[0] = 0.0f;
            this.penWidth = 1.0f;
            this.soptionSize = new Dimension(40, 14);
            this.numSOption = new Dimension(2, 4);
        }

        @Override
        protected void paintIt(Graphics2D g2, int column, int row, int x, int y) {
            this.dash[0] = GraphSettings.dashLengths[row * this.numSOption.width + column];
            if (this.dash[0] < 0.0f) {
                return;
            }
            g2.setColor(Color.black);
            if (this.dash[0] == 0.0f) {
                g2.setStroke(new BasicStroke(this.penWidth));
            } else {
                g2.setStroke(new BasicStroke(this.penWidth, 2, 0, 10.0f, this.dash, 0.0f));
            }
            g2.drawLine(x + 2, y + this.soptionSize.height / 2, x + this.soptionSize.width - 2, y + this.soptionSize.height / 2);
            g2.setStroke(new BasicStroke());
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            int i = this.getIndex(e.getX(), e.getY());
            if (i >= 0 && i < this.Ns) {
                return "dash type " + new Integer(i).toString();
            }
            return "no line";
        }
    }
}

