/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Vector;

public class XMLWrite {
    private String indent = "   ";
    private String shift = "";
    private StringBuffer sb;
    private String ls = System.getProperty("line.separator");
    private Vector keys = new Vector();
    private Vector v;

    public XMLWrite() {
        this.sb = new StringBuffer(300);
        this.v = new Vector();
    }

    public XMLWrite(String indent) {
        this();
        this.indent = indent;
    }

    public XMLWrite(String indent, String ls) {
        this(indent);
        this.ls = ls;
    }

    private void addSetting(String key, boolean close, boolean newline) {
        this.sb.append(this.shift).append("<").append(key);
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            this.sb.append(" ").append((String)e.nextElement()).append("=\"").append((String)e.nextElement()).append("\"");
        }
        if (close) {
            this.sb.append("/>");
        } else {
            this.sb.append(">");
        }
        if (newline) {
            this.sb.append(this.ls);
        }
        this.v.setSize(0);
    }

    private void addSetting(String key, boolean close) {
        this.addSetting(key, close, true);
    }

    public void set(String key) {
        this.addSetting(key, true);
    }

    public void open(String key) {
        this.addSetting(key, false);
        this.keys.add(key);
        this.open();
    }

    public void close() {
        int len = this.shift.length() - this.indent.length();
        this.shift = len > 0 ? this.shift.substring(0, len) : "";
        if (this.keys.size() > 0) {
            String key = (String)this.keys.remove(this.keys.size() - 1);
            this.sb.append(this.shift).append("</").append(key).append(">");
        }
        this.sb.append(this.ls);
    }

    public void set(String key, Color c) {
        this.sb.append(this.shift).append("<").append(key);
        this.sb.append(" red=\"").append(c.getRed());
        this.sb.append("\" green=\"").append(c.getGreen());
        this.sb.append("\" blue=\"").append(c.getBlue()).append("\"/>").append(this.ls);
    }

    public void set(String key, Font f) {
        this.sb.append(this.shift).append("<").append(key);
        this.sb.append(" name=\"").append(f.getName());
        this.sb.append("\" style=\"").append(f.getStyle());
        this.sb.append("\" size=\"").append(f.getSize()).append("\"/>").append(this.ls);
    }

    public void set(String key, BasicStroke f) {
        this.sb.append(this.shift).append("<").append(key);
        float[] d = f.getDashArray();
        float dash = 1.0f;
        if (d != null && d.length > 0) {
            dash = d[0];
        }
        this.sb.append(" dashArray=\"").append(Float.toString(dash));
        this.sb.append("\" lineJoin=\"").append(f.getLineJoin());
        this.sb.append("\" miterLimit=\"").append(f.getMiterLimit());
        this.sb.append("\" dashPhase=\"").append(f.getDashPhase());
        this.sb.append("\" endCap=\"").append(f.getEndCap());
        this.sb.append("\" thikness=\"").append(f.getLineWidth()).append("\"/>").append(this.ls);
    }

    public String getSettings() {
        return this.sb.toString();
    }

    public void setSeparator(String s) {
        this.ls = s;
    }

    public void setShift(String ii) {
        this.shift = ii;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public void open() {
        this.shift = this.shift + this.indent;
    }

    public void clear() {
        this.sb.delete(0, this.sb.length());
        this.v.removeAllElements();
    }

    public void addSettings(String s) {
        this.sb.append(s);
    }

    public void add(String attr, String val) {
        this.v.add(attr);
        this.v.add(val);
    }

    public void addData(String data) {
        this.sb.append(this.shift).append(data).append(this.ls);
    }

    public void setData(String key, String data) {
        this.addSetting(key, false, false);
        this.sb.append(data);
        this.sb.append("</").append(key).append(">").append(this.ls);
    }

    public void setData(String key, double double_data) {
        String data = Double.toString(double_data);
        this.addSetting(key, false, false);
        this.sb.append(data);
        this.sb.append("</").append(key).append(">").append(this.ls);
    }

    public void setData(String key, int integer_data) {
        String data = Integer.toString(integer_data);
        this.addSetting(key, false, false);
        this.sb.append(data);
        this.sb.append("</").append(key).append(">").append(this.ls);
    }
}

