/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.RandomAccessFile;

public class PrintFilePainter
implements Printable {
    private RandomAccessFile raf;
    private String fileName = "none";
    private Font fnt = new Font("Monospaced", 0, 11);
    private Color color = Color.black;
    private int rememberedPageIndex = -1;
    private long rememberedFilePointer = -1L;
    private boolean rememberedEOF = false;
    private int size = 13;

    public PrintFilePainter(String file) {
        this.fileName = file;
        try {
            this.raf = new RandomAccessFile(file, "r");
        }
        catch (Exception e) {
            this.rememberedEOF = true;
        }
    }

    public void setFont(Font f) {
        this.fnt = f;
        this.size = this.fnt.getSize() + 2;
    }

    public void setForeground(Color c) {
        this.color = c;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        try {
            System.out.println("pageIndex = " + pageIndex);
            System.out.println("rememberedPageIndex = " + this.rememberedPageIndex);
            if (pageIndex != this.rememberedPageIndex) {
                this.rememberedPageIndex = pageIndex;
                if (this.rememberedEOF) {
                    return 1;
                }
                this.rememberedFilePointer = this.raf.getFilePointer();
            } else {
                this.raf.seek(this.rememberedFilePointer);
            }
            g.setColor(this.color);
            g.setFont(this.fnt);
            int x = (int)pf.getImageableX();
            int y = (int)pf.getImageableY();
            y += 32;
            while ((double)(y + this.size) < pf.getImageableY() + pf.getImageableHeight()) {
                String line = this.raf.readLine();
                if (line == null) {
                    this.rememberedEOF = true;
                    break;
                }
                g.drawString(line, x, y);
                y += this.size;
            }
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }
}

