/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.io.Serializable;

public class PlotPoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected double x;
    protected double y;
    protected double left = 0.0;
    protected double right = 0.0;
    protected double upper = 0.0;
    protected double lower = 0.0;
    protected double left_sys = 0.0;
    protected double right_sys = 0.0;
    protected double upper_sys = 0.0;
    protected double lower_sys = 0.0;
    protected boolean lift;

    public PlotPoint() {
        this.lift = false;
    }

    public PlotPoint(double x, double y) {
        this.setPoint(x, y);
        this.lift = false;
    }

    public PlotPoint(double x, double y, double upper, double lower) {
        this.setPoint(x, y, upper, lower);
        this.lift = false;
    }

    public PlotPoint(double x, double y, double left, double right, double upper, double lower) {
        this.setPoint(x, y, left, right, upper, lower);
        this.lift = false;
    }

    public PlotPoint(double x, double y, double left, double right, double upper, double lower, double left_sys, double right_sys, double upper_sys, double lower_sys) {
        this.setPoint(x, y, left, right, upper, lower, left_sys, right_sys, upper_sys, lower_sys);
        this.lift = false;
    }

    public PlotPoint(double x, double y, boolean liftNow) {
        this.setPoint(x, y);
        this.lift = liftNow;
    }

    public PlotPoint(PlotPoint pp) {
        this.setPoint(pp);
        this.lift = false;
    }

    public void setPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setPoint(double x, double y, double upper, double lower) {
        this.x = x;
        this.y = y;
        this.upper = upper;
        this.lower = lower;
    }

    public void setPoint(double x, double y, double left, double right, double upper, double lower) {
        this.x = x;
        this.y = y;
        this.left = left;
        this.right = right;
        this.upper = upper;
        this.lower = lower;
    }

    public void setPoint(double x, double y, double left, double right, double upper, double lower, double left_sys, double right_sys, double upper_sys, double lower_sys) {
        this.x = x;
        this.y = y;
        this.left = left;
        this.right = right;
        this.upper = upper;
        this.lower = lower;
        this.left_sys = left_sys;
        this.right_sys = right_sys;
        this.upper_sys = upper_sys;
        this.lower_sys = lower_sys;
    }

    public void setPoint(PlotPoint pp) {
        this.x = pp.getX();
        this.y = pp.getY();
        this.left = pp.getXleft();
        this.right = pp.getXright();
        this.upper = pp.getYupper();
        this.lower = pp.getYlower();
        this.left_sys = pp.getXleftSys();
        this.right_sys = pp.getXrightSys();
        this.upper_sys = pp.getYupperSys();
        this.lower_sys = pp.getYlowerSys();
    }

    public PlotPoint getPoint() {
        return new PlotPoint(this.x, this.y, this.left, this.right, this.upper, this.lower, this.left_sys, this.right_sys, this.upper_sys, this.lower_sys);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getXleft() {
        return this.left;
    }

    public double getXright() {
        return this.right;
    }

    public double getXleftSys() {
        return this.left_sys;
    }

    public double getXrightSys() {
        return this.right_sys;
    }

    public double getYupper() {
        return this.upper;
    }

    public double getYlower() {
        return this.lower;
    }

    public double getYupperSys() {
        return this.upper_sys;
    }

    public double getYlowerSys() {
        return this.lower_sys;
    }

    public void setLiftPen(boolean b) {
        this.lift = b;
    }

    public boolean liftPen() {
        return this.lift;
    }

    public void print() {
        System.out.println("--- print-out of PlotPoint ---");
        String s1 = Double.toString(this.getX());
        String s2 = Double.toString(this.getY());
        String s3 = Double.toString(this.getYupper());
        String s4 = Double.toString(this.getYlower());
        String s5 = Double.toString(this.getXleft());
        String s6 = Double.toString(this.getXright());
        System.out.println("    X=" + s1 + "   Y=" + s2 + "   errLeft=" + s5 + "  errRight=" + s6 + "   errUpper=" + s3 + "  errLower=" + s4);
    }
}

