/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import graph.RTextLine;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jhplot.JHPlot;
import jhplot.shapes.Arrow;
import jhplot.shapes.Circle;
import jhplot.shapes.HShape;
import jhplot.shapes.Picture;
import jhplot.shapes.Text;
import jplot.DataArray;
import jplot.GPoints;
import jplot.GraphLabel;
import jplot.GraphSettings;
import jplot.JPlot;
import jplot.LinePars;
import jplot.PlotPoint;
import jplot.Translate;
import jplot.Utils;
import jplot.panels.PanelPlot;
import org.freehep.graphics2d.VectorGraphics;

public abstract class GraphGeneral
extends JPanel
implements Printable {
    private static final long serialVersionUID = 1L;
    Vector data;
    protected final int X = 0;
    protected final int Y = 1;
    protected final int Na = 2;
    protected double[] axisLength = new double[2];
    protected double leftMargin;
    protected double rightMargin;
    protected double bottomMargin;
    protected double topMargin;
    protected JPopupMenu menu;
    public JMenuItem m_edit;
    public JMenuItem m_default;
    public JMenuItem m_refresh;
    protected final int numDigits = 3;
    protected String[][] ticLabel = new String[2][];
    protected double[][] ticNumber = new double[2][];
    protected double[] ticLength = new double[2];
    protected double[] subticLength = new double[2];
    protected int[] subticNumber = new int[2];
    protected double[] MinAxis = new double[2];
    protected double[] MaxAxis = new double[2];
    protected int[] AxisExponent = new int[2];
    protected double[] diff = new double[2];
    protected double[] inv = new double[2];
    protected int[] numberOfTics = new int[2];
    protected double[] sep = new double[2];
    public float scalingFrame = 1.0f;
    public float scalingFrameY = 1.0f;
    public float scalingFrameX = 1.0f;
    private boolean firstDraw;
    protected VectorGraphics currentG = null;
    protected boolean legendActive = false;
    protected boolean somethingActive = false;
    protected final float xSepIni = 10.0f;
    protected final float ySepIni = 4.0f;
    protected float xSep;
    protected float ySep;
    private int _startX = 0;
    private int _startY = 0;
    private int _lastX = 0;
    private int _lastY = 0;
    private boolean _isDragging = false;
    protected GraphSettings gs;
    protected Vector<Font> iniFonts;
    protected int numberLabels;
    protected static boolean zoomModeX = false;
    protected static boolean zoomModeY = false;
    protected static int currentZoomX;
    protected static int currentZoomY;
    protected static int startZoomX;
    protected static int startZoomY;
    protected static double defXmin;
    protected static double defXmax;
    protected static double defYmin;
    protected static double defYmax;
    protected static boolean zoomFirst;
    protected static boolean defAutoX;
    protected static boolean defAutoY;
    protected double ldy;
    protected double keyLen;
    protected final double keyLenIni;
    protected double legendWidth;
    protected double legendHeight;
    protected Dimension panelSize;
    protected Dimension panelSizeOriginal;
    protected Dimension panelSizeForPrinter;
    protected int width;
    protected int height;
    protected Vector<String>[] ticsAxis;
    private final Color boxColor = Color.gray;
    private static final double LNTEN;
    protected Line2D.Double line = new Line2D.Double();
    protected Rectangle2D.Double rect = new Rectangle2D.Double();
    protected Polygon polyg = new Polygon();
    protected int x1;
    protected int y1;
    protected int boxWidth;
    protected int boxHeight;
    protected int xStart;
    protected int yStart;
    private boolean initializing;
    protected double piperSep;
    protected double normalSep;
    protected double triangleBottom;
    protected double triangleSide;
    protected double triangleHeight;
    protected double borderWidth;
    protected double arc;
    protected double tan;
    protected double sin;
    protected double cos;
    protected int al = 10;
    protected int aw = 5;
    protected int haw = 2;
    protected double hhaw = 0.5;
    protected int[] xValues = new int[3];
    protected int[] yValues = new int[3];
    protected double mPosX;
    protected double mPosY;
    private JPlot jplot;

    public GraphGeneral(JPlot jp, final GraphSettings gs) {
        this.jplot = jp;
        this.initializing = true;
        this.setLayout(new FlowLayout(2));
        this.addMouseListener(new GraphMouseListener());
        this.addMouseMotionListener(new DragListener());
        this.gs = gs;
        zoomFirst = true;
        this.numberLabels = 0;
        this.iniFonts = new Vector();
        this.xSep = 10.0f;
        this.ySep = 4.0f;
        this.ticsAxis = new Vector[2];
        this.menu = new JPopupMenu();
        this.m_edit = new JMenuItem("Edit settings");
        this.m_refresh = new JMenuItem("Refresh canvas");
        this.m_refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphGeneral.this.jplot.updateGraphIfShowing();
            }
        });
        this.m_default = new JMenuItem("Default axis range");
        this.m_default.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!zoomFirst) {
                    gs.setAutoRange(0, defAutoX);
                    gs.setAutoRange(1, defAutoY);
                    gs.setRange(0, defXmin, defXmax);
                    gs.setRange(1, defYmin, defYmax);
                    GraphGeneral.this.jplot.updateGraphIfShowing();
                }
            }
        });
        this.menu.add(this.m_edit);
        this.menu.add(this.m_refresh);
        this.menu.add(this.m_default);
        this.panelSize = gs.getPanelSize();
        this.panelSizeOriginal = new Dimension(this.panelSize);
        this.firstDraw = true;
        this.height = this.panelSize.height;
        this.width = this.panelSize.width;
        this.leftMargin = gs.getLeftMargin();
        this.rightMargin = gs.getRightMargin();
        this.bottomMargin = gs.getBottomMargin();
        this.topMargin = gs.getTopMargin();
        this.keyLen = this.keyLenIni = 25.0;
        zoomModeX = false;
        zoomModeY = false;
    }

    public GraphGeneral(GraphSettings gs) {
        this(null, gs);
    }

    protected Font scaleFont(Font fo) {
        int fontSize = Math.round((float)fo.getSize() * this.scalingFrame);
        return new Font(fo.getName(), fo.getStyle(), fontSize);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public void clear() {
        this.getGraphics().dispose();
        this.ticLength = null;
        this.ticNumber = null;
        this.ticLabel = null;
        this.diff = null;
        this.inv = null;
        this.numberOfTics = null;
        this.sep = null;
        this.ticLength = null;
        this.axisLength = null;
        this.gs = null;
        this.jplot = null;
        this.data = null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public static double log10(double x) {
        return Math.log(x) / LNTEN;
    }

    public static int getNumDigits(double num) {
        int numDigits;
        if (num == 0.0) {
            return 0;
        }
        for (numDigits = 0; numDigits <= 15 && Math.abs(Math.floor(num) / num - 1.0) > 1.0E-10; ++numDigits) {
            num *= 10.0;
        }
        return numDigits;
    }

    public static String formatNumber(double num, int n) {
        int maxFloat = 6;
        if (num != 0.0) {
            int exp = (int)Math.floor(GraphGeneral.log10(num));
            int x = Math.abs(exp) + n;
            BigDecimal bd = new BigDecimal(num);
            if (x > maxFloat) {
                bd = exp > 0 ? bd.movePointLeft(exp) : bd.movePointRight(Math.abs(exp));
            } else {
                n = exp < 0 ? x : x - Math.abs(exp);
            }
            bd = bd.setScale(n, 6);
            int nn = GraphGeneral.getNumDigits(bd.doubleValue());
            if (nn < n) {
                bd = bd.setScale(nn);
            }
            String res = bd.toString();
            if (x > maxFloat) {
                res = res + "e" + exp;
            }
            return res;
        }
        return "0";
    }

    abstract void makeTicLabels();

    protected void updateMargins() {
        double xlHeight = 0.0;
        double ylWidth = 0.0;
        double tHeight = 0.0;
        Enumeration<GraphLabel> e = this.gs.getLabels().elements();
        while (e.hasMoreElements()) {
            GraphLabel gl = e.nextElement();
            if (gl.equals(0)) {
                xlHeight = gl.getHeight() + (double)this.ySep;
            } else if (gl.equals(1)) {
                ylWidth = gl.getWidth() + (double)this.xSep;
            } else if (gl.equals(2)) {
                tHeight = gl.getHeight() + (double)this.ySep;
            }
            if (!gl.equals(3)) continue;
            xlHeight = gl.getHeight() - 3.0;
        }
        double maxYLabel = 0.0;
        this.borderWidth = this.gs.getBoxOffset() * this.scalingFrame;
        this.leftMargin = this.gs.getLeftMargin() + this.borderWidth;
        this.bottomMargin = this.gs.getBottomMargin() + xlHeight + this.borderWidth;
        this.rightMargin = this.gs.getRightMargin() + this.borderWidth;
        this.topMargin = this.gs.getTopMargin() + tHeight + this.borderWidth;
        if (this.gs.drawTicLabels(0)) {
            this.bottomMargin += (double)(this.ySep * 2.0f);
        }
        this.axisLength[0] = (double)this.width - this.leftMargin - this.rightMargin;
        this.axisLength[1] = (double)this.height - this.topMargin - this.bottomMargin;
        double r = this.axisLength[1] / this.axisLength[0];
        if (this.gs.useAxesRatio()) {
            if (r > this.gs.getAxesRatio()) {
                this.axisLength[1] = this.gs.getAxesRatio() * this.axisLength[0];
                this.topMargin = (double)this.height - this.bottomMargin - this.axisLength[1];
            } else if (r < this.gs.getAxesRatio()) {
                this.axisLength[0] = this.gs.getAxesRatio() * this.axisLength[1];
                this.rightMargin = (double)this.width - this.leftMargin - this.axisLength[0];
            }
        } else {
            this.gs.setAxesRatio(r);
        }
        if (this.gs.getGraphType() == 1) {
            if (!this.gs.useLegendPosition()) {
                this.gs.setLegendPosition(this.borderWidth, this.borderWidth + 3.0);
            }
            this.tan = 2.0 * this.axisLength[1] / this.axisLength[0];
            this.arc = Math.atan(this.tan);
            this.sin = Math.sin(this.arc);
            this.cos = Math.cos(this.arc);
            this.normalSep = this.piperSep * this.sin;
            this.triangleBottom = (this.axisLength[0] - this.piperSep) / 2.0;
            this.triangleHeight = (this.axisLength[1] - this.normalSep) / 2.0;
            this.triangleSide = this.triangleHeight / this.sin;
            this.sep[0] = this.triangleBottom / (double)(this.numberOfTics[0] - 1);
            this.sep[1] = this.triangleHeight / (double)(this.numberOfTics[1] - 1);
            if (tHeight > 0.0) {
                tHeight += 10.0;
            }
        } else {
            if (!this.gs.useLegendPosition()) {
                this.gs.setLegendPosition(this.leftMargin + this.ticLength[1] + 7.0, this.topMargin + 7.0);
            }
            this.sep[0] = this.axisLength[0] / (double)(this.numberOfTics[0] - 1);
            this.sep[1] = this.axisLength[1] / (double)(this.numberOfTics[1] - 1);
        }
        this.ticLength[0] = this.gs.getTicLength(0) * (double)this.width;
        this.ticLength[1] = this.gs.getTicLength(1) * (double)this.width;
        this.subticLength[0] = this.gs.getSubTicLength(0) * (double)this.width;
        this.subticLength[1] = this.gs.getSubTicLength(1) * (double)this.width;
        this.subticNumber[0] = this.gs.getSubTicNumber(0);
        this.subticNumber[1] = this.gs.getSubTicNumber(1);
        this.MinAxis[0] = this.gs.getMinValue(0);
        this.MinAxis[1] = this.gs.getMinValue(1);
        this.MaxAxis[0] = this.gs.getMaxValue(0);
        this.MaxAxis[1] = this.gs.getMaxValue(1);
        this.setDefaultLabelPositions(maxYLabel);
    }

    private void setDefaultLabelPositions(double m) {
        int numOfOtherLabels = 0;
        if (this.gs.getGraphType() == 1) {
            m *= 0.7;
        }
        Enumeration<GraphLabel> e = this.gs.getLabels().elements();
        while (e.hasMoreElements()) {
            double xx;
            GraphLabel gl = e.nextElement();
            if (gl.usePosition()) continue;
            double x = 0.0;
            double y = 0.0;
            if (gl.equals(0)) {
                x = this.leftMargin + this.axisLength[0] / 2.0;
                y = this.topMargin + this.axisLength[1] + (this.bottomMargin - this.borderWidth) / 2.0 + (double)this.ySep;
            } else if (gl.equals(1)) {
                x = this.borderWidth + (this.leftMargin - this.borderWidth - m) / 3.0;
                y = this.topMargin + this.axisLength[1] / 2.0;
            } else if (gl.equals(2)) {
                x = this.leftMargin + this.axisLength[0] / 2.0;
                y = this.topMargin / 2.0;
            } else if (gl.equals(10)) {
                x = this.leftMargin + 10.0 + gl.getWidth() / 2.0;
                y = this.topMargin + this.axisLength[1] - (double)(14.0f * (float)(1 + numOfOtherLabels));
                ++numOfOtherLabels;
            } else if (gl.equals(3)) {
                x = this.leftMargin + this.triangleBottom / 2.0;
                y = this.topMargin + this.axisLength[1] + (this.bottomMargin - this.borderWidth) / 2.0 + (double)this.ySep;
            } else if (gl.equals(4)) {
                x = this.leftMargin + this.axisLength[0] - this.triangleBottom / 2.0;
                y = this.topMargin + this.axisLength[1] + (this.bottomMargin - this.borderWidth) / 2.0 + (double)this.ySep;
            } else if (gl.equals(5)) {
                gl.setRotation(-this.arc);
                xx = m + this.sin * ((double)this.xSep + gl.getTextHeight());
                x = this.leftMargin + this.triangleBottom / 4.0 - xx;
                y = this.topMargin + this.axisLength[1] - this.triangleHeight / 2.0 - xx / this.tan;
            } else if (gl.equals(6)) {
                gl.setRotation(this.arc);
                xx = m + this.cos * ((double)this.xSep + gl.getTextHeight());
                x = this.leftMargin + this.axisLength[0] - this.triangleBottom / 4.0 + xx;
                y = this.topMargin + this.axisLength[1] - this.triangleHeight / 2.0 - xx / this.tan;
            } else if (gl.equals(7)) {
                gl.setRotation(-this.arc);
                xx = m + this.sin * ((double)this.xSep + gl.getTextHeight());
                x = this.leftMargin + this.axisLength[0] / 2.0 - this.triangleBottom / 4.0 - xx;
                y = this.topMargin + this.triangleHeight / 2.0 - xx / this.tan;
            } else if (gl.equals(8)) {
                gl.setRotation(this.arc);
                xx = m + this.cos * ((double)this.xSep + gl.getTextHeight());
                x = this.leftMargin + this.axisLength[0] / 2.0 + this.triangleBottom / 4.0 + xx;
                y = this.topMargin + this.triangleHeight / 2.0 - xx / this.tan;
            } else if (gl.equals(9)) {
                x = this.toX(gl.getXPos());
                y = this.toY(gl.getYPos());
                gl.setUsePosition(true);
            }
            gl.setLocation(x - gl.getWidth() / 2.0, y - gl.getHeight() / 2.0);
            gl.setRotation(gl.getRotation());
        }
    }

    protected void plotPrimitives(VectorGraphics g2) {
        Enumeration<HShape> e = this.gs.getPrimitives().elements();
        while (e.hasMoreElements()) {
            int ws;
            HShape gl = e.nextElement();
            Stroke old1 = g2.getStroke();
            Color old2 = g2.getColor();
            Composite originalComposite = g2.getComposite();
            Font old3 = g2.getFont();
            g2.setComposite((Composite)this.makeComposite(gl.getTransparency().floatValue()));
            g2.setStroke(gl.getStroke());
            g2.setColor(gl.getColor());
            double[] pos = gl.getPosition();
            int x1 = (int)this.toX(pos[0]);
            int y1 = (int)this.toY(pos[1]);
            int x2 = (int)this.toX(pos[2]);
            int y2 = (int)this.toY(pos[3]);
            if (gl.getPositionCoordinate() == 1) {
                double w = this.panelSize.width;
                double h = this.panelSize.height;
                x1 = (int)(w * pos[0]);
                y1 = (int)(h * (1.0 - pos[1]));
                x2 = (int)(w * pos[2]);
                y2 = (int)(h * (1.0 - pos[3]));
            }
            if (gl.getWhoAm() == 1) {
                AffineTransform old = g2.getTransform();
                g2.rotate(-1.0 * gl.getRotation(), (double)x1, (double)y1);
                g2.drawLine(x1, y1, x2, y2);
                g2.setTransform(old);
            }
            if (gl.getWhoAm() == 4) {
                AffineTransform old = g2.getTransform();
                g2.rotate(-1.0 * gl.getRotation(), (double)x1, (double)y1);
                g2.drawImage(((Picture)gl).getPicture(), x1, y1, null);
                g2.setTransform(old);
            }
            if (gl.getWhoAm() == 5) {
                double dd = ((Circle)gl).getRadius();
                int ddx = (int)this.toX(pos[0] + 2.0 * dd);
                ws = ddx - x1;
                if (!gl.getFill()) {
                    g2.draw((Shape)new Ellipse2D.Double(x1 - ws / 2, y1 - ws / 2, ws, ws));
                }
                if (gl.getFill()) {
                    g2.fill((Shape)new Ellipse2D.Double(x1 - ws / 2, y1 - ws / 2, ws, ws));
                }
            }
            if (gl.getWhoAm() == 6) {
                int wsMajor = (int)this.toX(pos[0] + pos[2]);
                int wsMinor = (int)this.toY(pos[1] + pos[3]);
                int major = wsMajor - x1;
                int minor = y1 - wsMinor;
                AffineTransform old = g2.getTransform();
                g2.rotate(-1.0 * gl.getRotation(), (double)x1, (double)y1);
                if (!gl.getFill()) {
                    g2.draw((Shape)new Ellipse2D.Double(x1 - major, y1 - minor, major * 2, minor * 2));
                }
                if (gl.getFill()) {
                    g2.fill((Shape)new Ellipse2D.Double(x1 - major, y1 - minor, major * 2, minor * 2));
                }
                g2.setTransform(old);
            }
            if (gl.getWhoAm() == 8) {
                // empty if block
            }
            if (gl.getWhoAm() == 7) {
                int ddx = (int)this.toX(pos[0] + pos[2]);
                int ddy = (int)this.toY(pos[1] + pos[3]);
                AffineTransform old = g2.getTransform();
                g2.rotate(-1.0 * gl.getRotation(), (double)x1, (double)y1);
                ws = ddx - x1;
                int hs = y1 - ddy;
                if (!gl.getFill()) {
                    g2.drawRect(x1 - ws / 2, y1 - hs / 2, ws, hs);
                }
                if (gl.getFill()) {
                    g2.fillRect(x1 - ws / 2, y1 - hs / 2, ws, hs);
                }
                g2.setTransform(old);
            }
            if (gl.getWhoAm() == 3) {
                Text aa = (Text)gl;
                RTextLine text = new RTextLine();
                float x = x1;
                float y = y1;
                text.setFont(this.scaleFont(aa.getFont()));
                text.setColor(aa.getColor());
                String stext = Translate.decode(aa.getText());
                text.setText(stext);
                double rotation = aa.getRotation();
                rotation = aa.getRotation() * 360.0 / (Math.PI * 2);
                g2.rotate(aa.getRotation(), (double)x, (double)y);
                text.setRotation((int)rotation);
                text.draw(g2, (int)x, (int)y);
                g2.rotate(-aa.getRotation(), (double)x, (double)y);
            }
            if (gl.getWhoAm() == 2) {
                Arrow aa = (Arrow)gl;
                int[] x = new int[]{x1, x2};
                int[] y = new int[]{y1, y2};
                this.al = (int)aa.getEndLength();
                this.aw = (int)aa.getEndWidth();
                if (aa.getType() == 1) {
                    this.drawPolylineArrow((Graphics)g2, x, y, this.al, this.aw);
                }
                if (aa.getType() == 2) {
                    this.drawArrow2(g2, x1, y1, x2, y2);
                }
                if (aa.getType() == 3) {
                    this.drawArrow((Graphics)g2, x1, y1, x2, y2);
                }
            }
            g2.setStroke(old1);
            g2.setColor(old2);
            g2.setFont(old3);
            g2.setComposite(originalComposite);
        }
    }

    private AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    abstract boolean setMinMax(int var1, Vector var2);

    protected void plotLabels(VectorGraphics g2) {
        Enumeration<GraphLabel> e = this.gs.getLabels().elements();
        while (e.hasMoreElements()) {
            GraphLabel gl = e.nextElement();
            if (gl.hide() || gl.getText().equals("")) continue;
            if (gl.getID() != 12) {
                float xtmp = (float)gl.getXPos();
                float ytmp = (float)gl.getYPos() - (float)gl.getTextDescent();
                RTextLine text = new RTextLine();
                float x = xtmp;
                float y = ytmp;
                text.setFont(gl.getFont());
                text.setColor(gl.getColor());
                String stext = Translate.decode(gl.getText());
                text.setText(stext);
                double rotation = gl.getRotation();
                rotation = gl.getRotation() * 360.0 / (Math.PI * 2);
                g2.rotate(gl.getRotation(), (double)x, (double)y);
                text.setRotation((int)rotation);
                if (gl.getID() != 13) {
                    text.draw(g2, (int)x, (int)y);
                }
                if (gl.getID() == 13) {
                    this.drawKey(g2, gl, x, y);
                    text.draw(g2, (int)x, (int)y);
                }
                g2.rotate(-gl.getRotation(), (double)x, (double)y);
                continue;
            }
            String[] ss = gl.getMultiText();
            int hh = (int)gl.getTextHeight();
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i] == null) continue;
                RTextLine text = new RTextLine();
                float x = (float)gl.getXPos();
                float y = (float)gl.getYPos();
                text.setFont(gl.getFont());
                text.setColor(gl.getColor());
                String stext = Translate.decode(ss[i]);
                text.setText(stext);
                text.draw(g2, (int)x, (int)y + hh * i);
            }
        }
    }

    protected void getLegendBox(Vector data) {
        String s = "";
        int k = 0;
        Enumeration e = data.elements();
        while (e.hasMoreElements()) {
            DataArray da = (DataArray)e.nextElement();
            if (!da.drawLegend()) continue;
            if (da.getName().length() > s.length()) {
                s = da.getName();
            }
            ++k;
        }
        FontMetrics fm = this.getFontMetrics(this.scaleFont(this.gs.getLegendFont()));
        s = Translate.shrink(s);
        this.legendWidth = (double)fm.stringWidth(s) + this.keyLen + (double)this.xSep;
        this.ldy = (double)fm.getHeight() * this.gs.getLegendSpacing() * (double)this.scalingFrameY * (double)this.scalingFrame;
        this.legendHeight = this.ldy * (double)(k - 1) + (double)((float)(fm.getHeight() + 2) * this.scalingFrameY);
    }

    protected void drawLegend(VectorGraphics g2, DataArray da, int i) {
        float y = (float)(this.gs.getLegendPosition(1) + this.ldy * (double)(i + 1) * (double)this.scalingFrameY);
        float x = (float)this.gs.getLegendPosition(0);
        float yy = y - (float)this.ldy / 4.0f;
        if (da.drawLine()) {
            g2.drawLine((double)x, (double)yy, (double)x + this.keyLen, (double)yy);
        }
        if (da.drawSymbol()) {
            GPoints.drawPointType(da.getSymbol(), (Graphics2D)g2, (double)x + this.keyLen / 2.0, yy, da.getSymbolSize() * this.scalingFrame);
        }
        RTextLine text = new RTextLine();
        text.setFont(this.scaleFont(this.gs.getLegendFont()));
        text.setColor(da.getColor());
        String stext = Translate.decode(da.getName());
        text.setText(stext);
        text.draw(g2, (int)((double)x + this.keyLen + (double)this.xSep), (int)y);
    }

    public abstract double toX(double var1);

    public abstract double toY(double var1);

    public abstract double toUserX(int var1);

    public abstract double toUserY(int var1);

    abstract void fillGraphArea(VectorGraphics var1);

    public void show(Vector data) {
        this.data = data;
        this.gs.setNoData(false);
        if (data == null) {
            this.gs.setNoData(true);
        }
        if (data.size() < 1) {
            this.gs.setNoData(true);
        }
        if (this.gs.getNoData()) {
            this.gs.setAutoRange(0, false);
            this.gs.setAutoRange(1, false);
        }
        if (this.gs.drawLegend() && !this.gs.getNoData()) {
            this.getLegendBox(data);
        }
        for (int k = 0; k < 2; ++k) {
            if (this.setMinMax(k, data)) continue;
            Utils.bummer(null, "Invalid data, no way to show a decent graph");
            return;
        }
        this.makeTicLabels();
        this.updateMargins();
        this.repaint();
    }

    public void resetLabelPositions(double w0, double h0, double w1, double h1) {
        if (this.gs.useLegendPosition()) {
            this.gs.setLegendPosition(w1 * this.gs.getLegendPosition(0) / w0, h1 * this.gs.getLegendPosition(1) / h0);
        }
        Enumeration<GraphLabel> e = this.gs.getLabels().elements();
        while (e.hasMoreElements()) {
            GraphLabel gl = e.nextElement();
            if (gl.usePosition()) {
                gl.setLocation(w1 * gl.getX() / w0, h1 * gl.getY() / h0);
            }
            if (gl.equals(5)) {
                gl.setRotation(-this.arc);
                continue;
            }
            if (!gl.equals(6)) continue;
            gl.setRotation(this.arc);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        this.currentG = VectorGraphics.create((Graphics)g);
        this.panelSize = this.getSize();
        if (this.firstDraw) {
            this.panelSizeOriginal = new Dimension(this.panelSize);
            this.firstDraw = false;
        }
        double s1 = Math.sqrt(this.panelSizeOriginal.height * this.panelSizeOriginal.height + this.panelSizeOriginal.width * this.panelSizeOriginal.width);
        double s2 = Math.sqrt(this.panelSize.height * this.panelSize.height + this.panelSize.width * this.panelSize.width);
        if (this.gs.getAttResizable()) {
            this.scalingFrame = (float)(s2 / s1);
            this.scalingFrameY = (float)((double)this.panelSize.height / (double)this.panelSizeOriginal.height);
            this.scalingFrameX = (float)((double)this.panelSize.width / (double)this.panelSizeOriginal.width);
        } else {
            this.scalingFrame = 1.0f;
            this.scalingFrameY = 1.0f;
            this.scalingFrameX = 1.0f;
        }
        this.xSep = 10.0f * this.scalingFrameX;
        this.ySep = 4.0f * this.scalingFrameY;
        this.keyLen = this.keyLenIni * (double)this.scalingFrameX;
        this.drawAllGraphics(this.panelSize, this.currentG);
        if (this.numberLabels != this.gs.getLabels().size()) {
            this.numberLabels = this.gs.getLabels().size();
            this.iniFonts.clear();
            Enumeration<GraphLabel> e = this.gs.getLabels().elements();
            while (e.hasMoreElements()) {
                GraphLabel gl = e.nextElement();
                this.iniFonts.addElement(gl.getFont());
            }
        } else {
            int k = 0;
            Enumeration<GraphLabel> e = this.gs.getLabels().elements();
            while (e.hasMoreElements()) {
                GraphLabel gl = e.nextElement();
                gl.setFont(this.scaleFont(this.iniFonts.elementAt(k)));
                ++k;
            }
        }
        if (this._isDragging) {
            int ww1 = this._lastX - this._startX;
            int hh1 = this._lastY - this._startY;
            this.currentG.setPaint((Paint)new Color(180, 180, 220));
            this.currentG.drawRect(this._startX, this._startY, ww1, hh1);
            this.currentG.setPaint((Paint)new Color(177, 234, 220, 125));
            this.currentG.fillRect(this._startX, this._startY, ww1, hh1);
        }
    }

    void drawAllGraphics(Dimension size, VectorGraphics g2) {
        if ((double)this.width != size.getWidth() || (double)this.height != size.getHeight()) {
            double w = this.width;
            double h = this.height;
            this.width = size.width;
            this.height = size.height;
            this.updateMargins();
            this.resetLabelPositions(w, h, size.width, size.height);
        }
        if (this.gs.getAntiAlias()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g2.setColor(this.gs.getBackgroundColor());
        g2.fillRect(0, 0, this.width, this.height);
        if (this.gs.drawBox()) {
            g2.setColor(Color.red);
            g2.setColor(this.gs.getBoxFillColor());
            g2.fillRect(this.borderWidth, this.borderWidth, (double)this.width - 2.0 * this.borderWidth, (double)this.height - 2.0 * this.borderWidth);
            g2.setColor(this.gs.getBoxColor());
            g2.drawRect(this.borderWidth, this.borderWidth, (double)this.width - 2.0 * this.borderWidth, (double)this.height - 2.0 * this.borderWidth);
        }
        this.fillGraphArea(g2);
        this.updateGraph();
    }

    protected VectorGraphics createGraphics() {
        if (this.currentG == null) {
            return null;
        }
        VectorGraphics g2 = this.currentG;
        if (this.gs.getAntiAlias()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g2.setColor(this.gs.getBackgroundColor());
        g2.fillRect(0, 0, this.width, this.height);
        if (this.gs.drawBox()) {
            g2.setColor(this.gs.getBoxFillColor());
            g2.fillRect(this.borderWidth, this.borderWidth, (double)this.width - 2.0 * this.borderWidth, (double)this.height - 2.0 * this.borderWidth);
            g2.setColor(this.gs.getBoxColor());
            g2.drawRect(this.borderWidth, this.borderWidth, (double)this.width - 2.0 * this.borderWidth, (double)this.height - 2.0 * this.borderWidth);
        }
        this.fillGraphArea(g2);
        return g2;
    }

    abstract void updateGraph();

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        g.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        if (pageIndex >= 1) {
            return 1;
        }
        ++this.width;
        this.paintComponent(g);
        System.gc();
        return 0;
    }

    public void drawPolylineArrow(Graphics g, int[] xPoints, int[] yPoints, int headLength, int headwidth) {
        Object tempX1 = Array.get(xPoints, xPoints.length - 2);
        Object tempX2 = Array.get(xPoints, xPoints.length - 1);
        Integer fooX1 = (Integer)tempX1;
        int x1 = fooX1;
        Integer fooX2 = (Integer)tempX2;
        int x2 = fooX2;
        Object tempY1 = Array.get(yPoints, yPoints.length - 2);
        Object tempY2 = Array.get(yPoints, yPoints.length - 1);
        Integer fooY1 = (Integer)tempY1;
        int y1 = fooY1;
        Integer fooY2 = (Integer)tempY2;
        int y2 = fooY2;
        int deltaX = x2 - x1;
        int deltaY = y2 - y1;
        double theta = Math.atan((double)deltaY / (double)deltaX);
        double theta1 = (double)deltaX < 0.0 ? theta + Math.PI : theta;
        int lengthdeltaX = -((int)(Math.cos(theta1) * (double)headLength));
        int lengthdeltaY = -((int)(Math.sin(theta1) * (double)headLength));
        int widthdeltaX = (int)(Math.sin(theta1) * (double)headwidth);
        int widthdeltaY = (int)(Math.cos(theta1) * (double)headwidth);
        g.drawPolyline(xPoints, yPoints, xPoints.length);
        g.drawLine(x2, y2, x2 + lengthdeltaX + widthdeltaX, y2 + lengthdeltaY - widthdeltaY);
        g.drawLine(x2, y2, x2 + lengthdeltaX - widthdeltaX, y2 + lengthdeltaY + widthdeltaY);
    }

    public void drawArrow(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
        this.calcValues(x1, y1, x2, y2);
        g.fillPolygon(this.xValues, this.yValues, 3);
    }

    public void calcValues(int x1, int y1, int x2, int y2) {
        if (x1 == x2) {
            if (y2 < y1) {
                this.arrowCoords(x2, y2, x2 - this.haw, y2 + this.al, x2 + this.haw, y2 + this.al);
            } else {
                this.arrowCoords(x2, y2, x2 - this.haw, y2 - this.al, x2 + this.haw, y2 - this.al);
            }
            return;
        }
        if (y1 == y2) {
            if (x2 > x1) {
                this.arrowCoords(x2, y2, x2 - this.al, y2 - this.haw, x2 - this.al, y2 + this.haw);
            } else {
                this.arrowCoords(x2, y2, x2 + this.al, y2 - this.haw, x2 + this.al, y2 + this.haw);
            }
            return;
        }
        this.calcValuesQuad(x1, y1, x2, y2);
    }

    public void calcValuesQuad(int x1, int y1, int x2, int y2) {
        double arrowAng = Math.toDegrees(Math.atan((double)this.haw / (double)this.al));
        double dist = Math.sqrt(this.al * this.al + this.aw);
        double lineAng = Math.toDegrees(Math.atan((double)Math.abs(x1 - x2) / (double)Math.abs(y1 - y2)));
        if (x1 > x2) {
            if (y1 > y2) {
                lineAng = 180.0 - lineAng;
            }
        } else {
            lineAng = y1 > y2 ? 180.0 + lineAng : 360.0 - lineAng;
        }
        this.xValues[0] = x2;
        this.yValues[0] = y2;
        this.calcCoords(1, x2, y2, dist, lineAng - arrowAng);
        this.calcCoords(2, x2, y2, dist, lineAng + arrowAng);
    }

    public void calcCoords(int index, int x, int y, double dist, double dirn) {
        while (dirn < 0.0) {
            dirn = 360.0 + dirn;
        }
        while (dirn > 360.0) {
            dirn -= 360.0;
        }
        if (dirn <= 90.0) {
            this.xValues[index] = x + (int)(Math.sin(Math.toRadians(dirn)) * dist);
            this.yValues[index] = y - (int)(Math.cos(Math.toRadians(dirn)) * dist);
            return;
        }
        if (dirn <= 180.0) {
            this.xValues[index] = x + (int)(Math.cos(Math.toRadians(dirn - 90.0)) * dist);
            this.yValues[index] = y + (int)(Math.sin(Math.toRadians(dirn - 90.0)) * dist);
            return;
        }
        if (dirn <= 90.0) {
            this.xValues[index] = x - (int)(Math.sin(Math.toRadians(dirn - 180.0)) * dist);
            this.yValues[index] = y + (int)(Math.cos(Math.toRadians(dirn - 180.0)) * dist);
        } else {
            this.xValues[index] = x - (int)(Math.cos(Math.toRadians(dirn - 270.0)) * dist);
            this.yValues[index] = y - (int)(Math.sin(Math.toRadians(dirn - 270.0)) * dist);
        }
    }

    public void arrowCoords(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.xValues[0] = x1;
        this.yValues[0] = y1;
        this.xValues[1] = x2;
        this.yValues[1] = y2;
        this.xValues[2] = x3;
        this.yValues[2] = y3;
    }

    public void drawArrow2(VectorGraphics g, int x1, int y1, int x2, int y2) {
        g.drawPolygon(this.getArrow(x1, y1, x2, y2, this.al, this.aw, this.hhaw));
    }

    private Polygon getArrow(int x1, int y1, int x2, int y2, int headsize, int difference, double factor) {
        int[] crosslinebase = this.getArrowHeadLine(x1, y1, x2, y2, headsize);
        int[] headbase = this.getArrowHeadLine(x1, y1, x2, y2, headsize - difference);
        int[] crossline = this.getArrowHeadCrossLine(crosslinebase[0], crosslinebase[1], x2, y2, factor);
        Polygon head = new Polygon();
        head.addPoint(headbase[0], headbase[1]);
        head.addPoint(crossline[0], crossline[1]);
        head.addPoint(x2, y2);
        head.addPoint(crossline[2], crossline[3]);
        head.addPoint(headbase[0], headbase[1]);
        head.addPoint(x1, y1);
        return head;
    }

    private int[] getArrowHeadLine(int xsource, int ysource, int xdest, int ydest, int distance) {
        int[] arrowhead = new int[2];
        int headsize = distance;
        double stretchfactor = 0.0;
        stretchfactor = 1.0 - (double)headsize / Math.sqrt((xdest - xsource) * (xdest - xsource) + (ydest - ysource) * (ydest - ysource));
        arrowhead[0] = (int)(stretchfactor * (double)(xdest - xsource)) + xsource;
        arrowhead[1] = (int)(stretchfactor * (double)(ydest - ysource)) + ysource;
        return arrowhead;
    }

    private int[] getArrowHeadCrossLine(int x1, int x2, int b1, int b2, double factor) {
        int[] crossline = new int[4];
        int x_dest = (int)((double)(b1 - x1) * factor + (double)x1);
        int y_dest = (int)((double)(b2 - x2) * factor + (double)x2);
        crossline[0] = x1 + x2 - y_dest;
        crossline[1] = x2 + x_dest - x1;
        crossline[2] = crossline[0] + (x1 - crossline[0]) * 2;
        crossline[3] = crossline[1] + (x2 - crossline[1]) * 2;
        return crossline;
    }

    protected void drawKey(VectorGraphics g2, GraphLabel gl, float x, float y) {
        Color old1 = g2.getColor();
        Stroke old2 = g2.getStroke();
        g2.setStroke((Stroke)new BasicStroke(gl.getKeyLineWidth()));
        g2.setColor(gl.getKeyColor());
        FontMetrics fM = g2.getFontMetrics();
        float hh = (float)(0.7 * gl.getTextHeight() * (double)this.scalingFrame);
        float ww = (float)fM.stringWidth("w") * this.scalingFrame;
        float ypos = y - (float)(0.5 * gl.getTextHeight() * (double)this.scalingFrame) + (float)gl.getTextDescent();
        float lsize = 0.5f * gl.getKeySize() * ww;
        if (gl.getKeyType() > -1 && gl.getKeyType() < 20) {
            GPoints.drawPointType(gl.getKeyType(), (Graphics2D)g2, x, (double)ypos + 0.25 * (double)lsize, lsize);
            return;
        }
        if (gl.getKeyType() == 20) {
            g2.fillRect((double)x - 0.5 * (double)lsize, (double)(ypos - 1.5f * (float)gl.getTextDescent()), (double)lsize, (double)hh);
            return;
        }
        if (gl.getKeyType() == 21) {
            g2.drawRect((double)x - 0.5 * (double)lsize, (double)(ypos - 1.5f * (float)gl.getTextDescent()), (double)lsize, (double)hh);
            return;
        }
        if (gl.getKeyType() == 30) {
            g2.drawLine((double)(x -= 0.5f * lsize), (double)ypos, (double)(x + lsize), (double)ypos);
            return;
        }
        if (gl.getKeyType() == 31) {
            int dash = (int)((double)lsize / 7.0);
            this.drawDashedLine(g2, (int)(x -= 0.5f * lsize), (int)ypos, (int)(x + lsize), (int)ypos, 2 * dash, dash);
            return;
        }
        if (gl.getKeyType() == 32) {
            int dash = (int)((double)lsize / 10.0);
            this.drawDashedLine(g2, (int)(x -= 0.5f * lsize), (int)ypos, (int)(x + lsize), (int)ypos, dash, 3 * dash);
            return;
        }
        g2.setColor(old1);
        g2.setStroke(old2);
    }

    public void drawDashedLine(VectorGraphics g, int x1, int y1, int x2, int y2, double dashlength, double spacelength) {
        if (x1 == x2 && y1 == y2) {
            g.drawLine(x1, y1, x2, y2);
            return;
        }
        double linelength = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        double yincrement = (double)(y2 - y1) / (linelength / (dashlength + spacelength));
        double xincdashspace = (double)(x2 - x1) / (linelength / (dashlength + spacelength));
        double yincdashspace = (double)(y2 - y1) / (linelength / (dashlength + spacelength));
        double xincdash = (double)(x2 - x1) / (linelength / dashlength);
        double yincdash = (double)(y2 - y1) / (linelength / dashlength);
        int counter = 0;
        for (double i = 0.0; i < linelength - dashlength; i += dashlength + spacelength) {
            g.drawLine((int)((double)x1 + xincdashspace * (double)counter), (int)((double)y1 + yincdashspace * (double)counter), (int)((double)x1 + xincdashspace * (double)counter + xincdash), (int)((double)y1 + yincdashspace * (double)counter + yincdash));
            ++counter;
        }
        if ((dashlength + spacelength) * (double)counter <= linelength) {
            g.drawLine((int)((double)x1 + xincdashspace * (double)counter), (int)((double)y1 + yincdashspace * (double)counter), x2, y2);
        }
    }

    static {
        zoomFirst = true;
        LNTEN = Math.log(10.0);
    }

    public class DragListener
    implements MouseMotionListener {
        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if ((e.getModifiers() & 8) != 0) {
                if (GraphGeneral.this._isDragging) {
                    GraphGeneral.this._lastX = x;
                    GraphGeneral.this._lastY = y;
                    GraphGeneral.this.repaint();
                }
            } else {
                GraphGeneral.this._isDragging = false;
            }
            if (!((e.getModifiers() & 8) == 0 || (double)x > GraphGeneral.this.leftMargin - 1.0 && (double)GraphGeneral.this.width - GraphGeneral.this.rightMargin + 1.0 > (double)x && (double)y > GraphGeneral.this.topMargin - 1.0 && (double)y < (double)GraphGeneral.this.height - GraphGeneral.this.bottomMargin + 1.0 || !zoomModeX && !zoomModeY)) {
                currentZoomX = x;
                currentZoomY = y;
                int beginX = Math.min(startZoomX, currentZoomX);
                int beginY = Math.min(startZoomY, currentZoomY);
                int wX = Math.abs(currentZoomX - startZoomX);
                int hY = Math.abs(currentZoomY - startZoomY);
                Graphics g = GraphGeneral.this.getGraphics();
                Color old = g.getColor();
                g.setColor(Color.red);
                if ((double)y > (double)GraphGeneral.this.height - GraphGeneral.this.bottomMargin + 1.0 && (double)x > GraphGeneral.this.leftMargin - 1.0 && (double)GraphGeneral.this.width - GraphGeneral.this.rightMargin + 1.0 > (double)x) {
                    int ypos = GraphGeneral.this.height - (int)GraphGeneral.this.bottomMargin - 4;
                    g.drawLine(beginX, ypos, beginX + wX, ypos);
                    zoomModeX = true;
                    zoomModeY = false;
                }
                if ((double)x < GraphGeneral.this.leftMargin - 1.0 && (double)y > GraphGeneral.this.topMargin - 1.0 && (double)y < (double)GraphGeneral.this.height - GraphGeneral.this.bottomMargin + 1.0) {
                    int xpos = (int)GraphGeneral.this.leftMargin + 4;
                    g.drawLine(xpos, beginY, xpos, beginY + hY);
                    zoomModeX = false;
                    zoomModeY = true;
                }
                g.setColor(old);
            }
            if (GraphGeneral.this.somethingActive) {
                Graphics g = GraphGeneral.this.getGraphics();
                g.setXORMode(GraphGeneral.this.boxColor);
                g.drawRect(GraphGeneral.this.x1, GraphGeneral.this.y1, GraphGeneral.this.boxWidth, GraphGeneral.this.boxHeight);
                GraphGeneral.this.x1 += x - GraphGeneral.this.xStart;
                GraphGeneral.this.y1 += y - GraphGeneral.this.yStart;
                g.drawRect(GraphGeneral.this.x1, GraphGeneral.this.y1, GraphGeneral.this.boxWidth, GraphGeneral.this.boxHeight);
                g.setPaintMode();
                GraphGeneral.this.xStart = x;
                GraphGeneral.this.yStart = y;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            GraphGeneral.this._isDragging = false;
        }
    }

    public class GraphMouseListener
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent e) {
            GraphGeneral.this.xStart = e.getX();
            GraphGeneral.this.yStart = e.getY();
            if ((e.getModifiers() & 8) != 0 && e.getClickCount() == 1) {
                GraphGeneral.this.height = GraphGeneral.this.panelSize.height;
                GraphGeneral.this.width = GraphGeneral.this.panelSize.width;
                if ((double)GraphGeneral.this.xStart > GraphGeneral.this.leftMargin - 1.0 && (double)GraphGeneral.this.width - GraphGeneral.this.rightMargin + 1.0 > (double)GraphGeneral.this.xStart && (double)GraphGeneral.this.yStart > GraphGeneral.this.topMargin - 1.0 && (double)GraphGeneral.this.yStart < (double)GraphGeneral.this.height - GraphGeneral.this.bottomMargin + 1.0) {
                    double Xndc = (double)GraphGeneral.this.xStart / (double)GraphGeneral.this.width;
                    double Yndc = 1.0 - (double)GraphGeneral.this.yStart / (double)GraphGeneral.this.height;
                    JHPlot.showMouse("Mouse at", GraphGeneral.this.toUserX(GraphGeneral.this.xStart), GraphGeneral.this.toUserY(GraphGeneral.this.yStart), Xndc, Yndc, GraphGeneral.this.xStart, GraphGeneral.this.yStart);
                    GraphGeneral.this._startX = GraphGeneral.this.xStart;
                    GraphGeneral.this._startY = GraphGeneral.this.yStart;
                    GraphGeneral.this._lastX = GraphGeneral.this.xStart;
                    GraphGeneral.this._lastY = GraphGeneral.this.yStart;
                    GraphGeneral.this._isDragging = true;
                }
            }
            if (e.getClickCount() == 2 && GraphGeneral.this.jplot != null) {
                int a = e.getX() + 20;
                int b = e.getY() + 20;
                double xx = GraphGeneral.this.gs.getLegendPosition(0);
                double yy = GraphGeneral.this.gs.getLegendPosition(1);
                if (GraphGeneral.this.gs.drawLegend() && (double)GraphGeneral.this.xStart > xx && (double)GraphGeneral.this.xStart < xx + GraphGeneral.this.legendWidth && (double)GraphGeneral.this.yStart > yy && (double)GraphGeneral.this.yStart < yy + GraphGeneral.this.legendHeight) {
                    ((GraphGeneral)GraphGeneral.this).jplot.legendPanel.show(((GraphGeneral)GraphGeneral.this).jplot.frame, a, b);
                } else {
                    boolean found = false;
                    Enumeration<GraphLabel> el = GraphGeneral.this.gs.getLabels().elements();
                    while (el.hasMoreElements()) {
                        GraphLabel gl = el.nextElement();
                        if (!gl.contains(GraphGeneral.this.xStart, GraphGeneral.this.yStart)) continue;
                        ((GraphGeneral)GraphGeneral.this).jplot.labelPanel.show(((GraphGeneral)GraphGeneral.this).jplot.frame, a, b);
                        found = true;
                        break;
                    }
                    if (!found) {
                        Enumeration e2 = GraphGeneral.this.data.elements();
                        while (e2.hasMoreElements()) {
                            DataArray da = (DataArray)e2.nextElement();
                            Enumeration e3 = da.getData().elements();
                            while (e3.hasMoreElements()) {
                                PlotPoint p = (PlotPoint)e3.nextElement();
                                xx = GraphGeneral.this.toX(p.getX());
                                yy = GraphGeneral.this.toY(p.getY());
                                if (!((double)GraphGeneral.this.xStart > xx - 3.0) || !((double)GraphGeneral.this.xStart < xx + 3.0) || !((double)GraphGeneral.this.yStart > yy - 3.0) || !((double)GraphGeneral.this.yStart < yy + 3.0)) continue;
                                LinePars lp = ((GraphGeneral)GraphGeneral.this).jplot.styleChooser.show(a, b, da);
                                if (lp != null) {
                                    GraphGeneral.this.gs.setDataChanged(lp.dataChanged());
                                    PanelPlot pp = ((GraphGeneral)GraphGeneral.this).jplot.plotPanels.get(da.getFileIndex());
                                    pp.updateStyle(da.getColumnIndex(), lp);
                                }
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            break;
                        }
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        public boolean startDrag(boolean active, int x, int y, int w, int h) {
            if (!active) {
                active = true;
                GraphGeneral.this.x1 = x;
                GraphGeneral.this.y1 = y;
                GraphGeneral.this.boxWidth = w;
                GraphGeneral.this.boxHeight = h;
                Graphics g = GraphGeneral.this.getGraphics();
                g.drawRect(GraphGeneral.this.x1, GraphGeneral.this.y1, GraphGeneral.this.boxWidth, GraphGeneral.this.boxHeight);
            } else {
                active = false;
            }
            return active;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            GraphGeneral.this.xStart = e.getX();
            GraphGeneral.this.yStart = e.getY();
            zoomModeX = false;
            zoomModeY = false;
            if (!((e.getModifiers() & 8) == 0 || (double)GraphGeneral.this.xStart > GraphGeneral.this.leftMargin - 1.0 && (double)GraphGeneral.this.xStart < GraphGeneral.this.leftMargin - 1.0 + GraphGeneral.this.axisLength[0] && (double)GraphGeneral.this.yStart > GraphGeneral.this.topMargin - 1.0 && (double)GraphGeneral.this.yStart < GraphGeneral.this.topMargin + GraphGeneral.this.axisLength[1])) {
                zoomModeX = true;
                zoomModeY = true;
                startZoomX = GraphGeneral.this.xStart;
                startZoomY = GraphGeneral.this.yStart;
            }
            if ((e.getModifiers() & 0x10) != 0) {
                double xx = GraphGeneral.this.gs.getLegendPosition(0);
                double yy = GraphGeneral.this.gs.getLegendPosition(1);
                if (GraphGeneral.this.gs.drawLegend() && (double)GraphGeneral.this.xStart > xx && (double)GraphGeneral.this.xStart < xx + GraphGeneral.this.legendWidth && (double)GraphGeneral.this.yStart > yy && (double)GraphGeneral.this.yStart < yy + GraphGeneral.this.legendHeight) {
                    GraphGeneral.this.somethingActive = GraphGeneral.this.legendActive = this.startDrag(GraphGeneral.this.legendActive, (int)xx, (int)yy, (int)GraphGeneral.this.legendWidth, (int)GraphGeneral.this.legendHeight);
                } else {
                    Enumeration<GraphLabel> el = GraphGeneral.this.gs.getLabels().elements();
                    while (el.hasMoreElements()) {
                        GraphLabel gl = el.nextElement();
                        if (!gl.contains(GraphGeneral.this.xStart, GraphGeneral.this.yStart)) continue;
                        gl.setActive(this.startDrag(gl.isActive(), (int)gl.getX(), (int)gl.getY(), (int)gl.getWidth(), (int)gl.getHeight()));
                        GraphGeneral.this.somethingActive = gl.isActive();
                        break;
                    }
                }
            }
            if ((e.getModifiers() & 4) != 0) {
                GraphGeneral.this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if ((e.getModifiers() & 8) != 0 && GraphGeneral.this._isDragging) {
                GraphGeneral.this._lastX = e.getX();
                GraphGeneral.this._lastY = e.getY();
                GraphGeneral.this._lastX = e.getX();
                GraphGeneral.this._lastY = e.getY();
                GraphGeneral.this._isDragging = false;
                double ss = Math.sqrt((GraphGeneral.this._lastX - GraphGeneral.this._startX) * (GraphGeneral.this._lastX - GraphGeneral.this._startX) + (GraphGeneral.this._lastY - GraphGeneral.this._startY) * (GraphGeneral.this._lastY - GraphGeneral.this._startY));
                if (ss > 4.0) {
                    GraphGeneral.this.repaint();
                    if (zoomFirst) {
                        defAutoX = GraphGeneral.this.gs.autoRange(0);
                        defAutoY = GraphGeneral.this.gs.autoRange(1);
                        defXmin = GraphGeneral.this.gs.getMinValue(0);
                        defYmin = GraphGeneral.this.gs.getMinValue(1);
                        defXmax = GraphGeneral.this.gs.getMaxValue(0);
                        defYmax = GraphGeneral.this.gs.getMaxValue(1);
                        zoomFirst = false;
                    }
                    GraphGeneral.this.gs.setAutoRange(0, false);
                    GraphGeneral.this.gs.setAutoRange(1, false);
                    double newXmin = GraphGeneral.this.toUserX(GraphGeneral.this._startX);
                    double newXmax = GraphGeneral.this.toUserX(GraphGeneral.this._lastX);
                    double newYmin = GraphGeneral.this.toUserY(GraphGeneral.this._startY);
                    double newYmax = GraphGeneral.this.toUserY(GraphGeneral.this._lastY);
                    if (newXmax > newXmin) {
                        GraphGeneral.this.gs.setRange(0, newXmin, newXmax);
                    }
                    if (newXmax < newXmin) {
                        GraphGeneral.this.gs.setRange(0, newXmax, newXmin);
                    }
                    if (newYmax > newYmin) {
                        GraphGeneral.this.gs.setRange(1, newYmin, newYmax);
                    }
                    if (newYmax < newYmin) {
                        GraphGeneral.this.gs.setRange(1, newYmax, newYmin);
                    }
                    GraphGeneral.this.jplot.updateGraphIfShowing();
                }
            }
            GraphGeneral.this._isDragging = false;
            if (zoomModeX || zoomModeY) {
                int beginX = Math.min(startZoomX, currentZoomX);
                int beginY = Math.min(startZoomY, currentZoomY);
                int wX = Math.abs(currentZoomX - startZoomX);
                int hY = Math.abs(currentZoomY - startZoomY);
                if (zoomFirst) {
                    defAutoX = GraphGeneral.this.gs.autoRange(0);
                    defAutoY = GraphGeneral.this.gs.autoRange(1);
                    defXmin = GraphGeneral.this.gs.getMinValue(0);
                    defYmin = GraphGeneral.this.gs.getMinValue(1);
                    defXmax = GraphGeneral.this.gs.getMaxValue(0);
                    defYmax = GraphGeneral.this.gs.getMaxValue(1);
                    zoomFirst = false;
                }
                GraphGeneral.this.gs.setAutoRange(0, false);
                GraphGeneral.this.gs.setAutoRange(1, false);
                if (zoomModeX) {
                    double newXmin = GraphGeneral.this.toUserX(beginX);
                    double newXmax = GraphGeneral.this.toUserX(beginX + wX);
                    GraphGeneral.this.gs.setRange(0, newXmin, newXmax);
                    GraphGeneral.this.jplot.updateGraphIfShowing();
                }
                if (zoomModeY) {
                    double newYmin = GraphGeneral.this.toUserY(beginY + hY);
                    double newYmax = GraphGeneral.this.toUserY(beginY);
                    GraphGeneral.this.gs.setRange(1, newYmin, newYmax);
                    GraphGeneral.this.jplot.updateGraphIfShowing();
                }
                currentZoomX = startZoomX;
                currentZoomY = startZoomY;
                zoomModeX = false;
                zoomModeY = false;
            }
            if (!GraphGeneral.this.somethingActive) {
                return;
            }
            if (GraphGeneral.this.legendActive) {
                GraphGeneral.this.legendActive = false;
                GraphGeneral.this.gs.setLegendPosition((double)GraphGeneral.this.x1, (double)GraphGeneral.this.y1);
                GraphGeneral.this.gs.setUseLegendPosition(true);
                GraphGeneral.this.gs.setDataChanged(true);
                GraphGeneral.this.repaint();
            } else {
                Enumeration<GraphLabel> el = GraphGeneral.this.gs.getLabels().elements();
                while (el.hasMoreElements()) {
                    GraphLabel gl = el.nextElement();
                    if (!gl.isActive()) continue;
                    gl.setActive(false);
                    if (GraphGeneral.this.x1 != (int)gl.getX() || GraphGeneral.this.y1 != (int)gl.getY()) {
                        GraphGeneral.this.gs.setDataChanged(true);
                        gl.setLocation(GraphGeneral.this.x1, GraphGeneral.this.y1);
                        gl.setUsePosition(true);
                        GraphGeneral.this.repaint();
                        double Xndc = (double)GraphGeneral.this.x1 / (double)GraphGeneral.this.width;
                        double Yndc = 1.0 - (double)GraphGeneral.this.y1 / (double)GraphGeneral.this.height;
                        JHPlot.showMouse("Label position", GraphGeneral.this.toUserX(GraphGeneral.this.x1), GraphGeneral.this.toUserY(GraphGeneral.this.y1), Xndc, Yndc, GraphGeneral.this.x1, GraphGeneral.this.y1);
                        break;
                    }
                    GraphGeneral.this.repaint();
                    break;
                }
            }
            GraphGeneral.this.somethingActive = false;
        }
    }
}

