/*
 * Decompiled with CFR 0.152.
 */
package jhplot.v3d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jhplot.v3d.Canvas3d;
import jhplot.v3d.Model3d;
import jhplot.v3d.Util;

public class Editor3d
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane;
    private JButton closeButton;
    private Canvas3d win;
    private Model3d md;
    private JButton jb1;
    private JButton jb2;
    private JButton jb3;
    private JButton jb4;
    private JButton jb5;
    private JButton jb6;
    private JButton jb7;
    private JButton jb8;
    private JButton jb9;
    private JButton jb10;

    public Editor3d(Canvas3d win, Model3d md) {
        this.win = win;
        this.md = md;
        this.setDefaultCloseOperation(2);
        this.setTitle("");
        this.setModal(true);
        this.setResizable(true);
        Dimension size = new Dimension(80, 400);
        JPanel topPanel = new JPanel();
        JPanel lowerPanel = new JPanel();
        lowerPanel.setPreferredSize(new Dimension(80, 40));
        this.closeButton = new JButton();
        this.closeButton.setText("Exit");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor3d.this.setVisible(false);
                Editor3d.this.dispose();
            }
        });
        lowerPanel.add((Component)this.closeButton, null);
        topPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)topPanel, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        topPanel.setLayout(new GridLayout(10, 0));
        this.jb1 = new JButton("Home");
        this.jb2 = new JButton("XRot");
        this.jb3 = new JButton("YRot");
        this.jb4 = new JButton("ZRot");
        this.jb5 = new JButton("Left");
        this.jb6 = new JButton("Right");
        this.jb7 = new JButton("Up");
        this.jb8 = new JButton("Down");
        this.jb9 = new JButton("ZoomIn");
        this.jb10 = new JButton("ZoomOut");
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        this.jb3.addActionListener(this);
        this.jb4.addActionListener(this);
        this.jb5.addActionListener(this);
        this.jb6.addActionListener(this);
        this.jb7.addActionListener(this);
        this.jb8.addActionListener(this);
        this.jb9.addActionListener(this);
        this.jb10.addActionListener(this);
        topPanel.add(this.jb1);
        topPanel.add(this.jb2);
        topPanel.add(this.jb3);
        topPanel.add(this.jb4);
        topPanel.add(this.jb5);
        topPanel.add(this.jb6);
        topPanel.add(this.jb7);
        topPanel.add(this.jb8);
        topPanel.add(this.jb9);
        topPanel.add(this.jb10);
        Util.rightWithin(win, this);
        this.setSize(size);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.md == null) {
            return;
        }
        String s = e.getActionCommand();
        if (s.equals("Home")) {
            this.md.rot.copy(this.win.orot);
            this.md.trans.copy(this.win.otrans);
            if (this.md.persp) {
                this.md.minScale = this.win.ominScale;
                this.md.maxScale = this.win.omaxScale;
                this.md.computeMatrix();
            } else {
                this.md.scale.copy(this.win.oscale);
            }
        } else if (s.equals("ZRot")) {
            this.md.incRot(10.0f, 0.0f, 0.0f);
        } else if (s.equals("XRot")) {
            this.md.incRot(0.0f, 10.0f, 0.0f);
        } else if (s.equals("YRot")) {
            this.md.incRot(0.0f, 0.0f, 10.0f);
        } else if (s.equals("Right")) {
            this.md.incTrans(this.md.bb.getWidth() / 10.0f, 0.0f, 0.0f);
        } else if (s.equals("Left")) {
            this.md.incTrans(-this.md.bb.getWidth() / 10.0f, 0.0f, 0.0f);
        } else if (s.equals("Down")) {
            this.md.incTrans(0.0f, -this.md.bb.getHeight() / 10.0f, 0.0f);
        } else if (s.equals("Up")) {
            this.md.incTrans(0.0f, this.md.bb.getHeight() / 10.0f, 0.0f);
        } else if (s.equals("ZoomOut")) {
            if (this.md.persp) {
                this.md.minScale /= 1.1f;
                this.md.maxScale /= 1.1f;
                this.md.computeMatrix();
            } else {
                float f = 0.9090909f;
                this.md.incScale(f, f, f);
            }
        } else if (s.equals("ZoomIn")) {
            if (this.md.persp) {
                this.md.minScale *= 1.1f;
                this.md.maxScale *= 1.1f;
                this.md.computeMatrix();
            } else {
                float f = 1.1f;
                this.md.incScale(f, f, f);
            }
        }
        this.win.repaint();
    }
}

