/*
 * Decompiled with CFR 0.152.
 */
package jhplot.v3d;

import jhplot.v3d.Matrix3d;
import jhplot.v3d.Model3d;
import jhplot.v3d.Prism;
import jhplot.v3d.Vector3d;

public class Cylinder
extends Prism {
    Cylinder(Model3d md, float r, int nv, Vector3d d) {
        super(md, Cylinder.computeBase(r, nv, d), nv, d);
    }

    public Cylinder(Model3d md, float r, int nv, float d) {
        this(md, r, nv, new Vector3d(0.0f, 0.0f, d));
    }

    static Vector3d[] computeBase(float r, int nv, Vector3d d) {
        Vector3d[] v = new Vector3d[nv];
        v[0] = new Vector3d(r, 0.0f, 0.0f);
        for (int i = 1; i < nv; ++i) {
            Matrix3d m = new Matrix3d();
            m.zrot(360.0f / (float)nv * (float)i);
            v[i] = new Vector3d(v[0]);
            m.transform(v[i], v[i]);
        }
        return v;
    }
}

