/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import jhplot.F1D;
import jhplot.P1D;
import jhplot.gui.HelpBrowser;

public class StatShape {
    private double[] x;
    private double[] y;
    private double[] w;
    private double a;
    private double b;
    private double a0;
    private double b0;
    private double newa;
    private double newa0;
    private double newb;
    private double newb0;
    private int n;
    private int choice;
    private double wm_x;
    private double wm_y;
    private double W = 0.0;
    private int Q = 0;
    private double Fmax;
    private double[] wm;
    private double[][] points;
    private double[][] NewPoints;
    private double[][] R;
    private double[][] dist;
    private double minorLength;
    private double majorLength;
    private double minorLength_meth2;
    private double majorLength_meth2;
    private double majorLength1;
    private double majorLength2;
    private double minorLength1;
    private double minorLength2;
    private double nq_minorLength;
    private double nq_majorLength;
    private double nq_minorLength_meth2;
    private double nq_majorLength_meth2;
    private double GlobalMajorLength;
    private double GlobalMinorLength;
    private double nq_majorLength1;
    private double nq_majorLength2;
    private double nq_minorLength1;
    private double nq_minorLength2;
    private double[][] wwm;
    private double[][] wwm1;
    private double[][] wwm_a;
    private double[][] wwm1_a;
    private double[] Wp;
    private double[] covariance;
    double chisq2;

    public StatShape(double[] x, double[] y, double[] w, int n) {
        int i;
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        for (i = 0; i < n; ++i) {
            minX = Math.min(minX, x[i]);
            maxX = Math.max(maxX, x[i]);
            minY = Math.min(minY, y[i]);
            maxY = Math.max(maxY, y[i]);
        }
        if (maxY - minY > maxX - minX) {
            for (i = 0; i < n; ++i) {
                double s = y[i];
                y[i] = x[i];
                x[i] = s;
            }
        }
        this.n = n;
        this.x = x;
        this.y = y;
        this.w = w;
    }

    public P1D getData() {
        P1D p1 = new P1D("data");
        for (int i = 0; i < this.n; ++i) {
            p1.add(this.x[i], this.y[i]);
        }
        return p1;
    }

    public double getChi2() {
        return this.chisq2;
    }

    public double[] getCovariance() {
        return this.covariance;
    }

    public void process(int choice) {
        double dy;
        double dx;
        double wi;
        int i;
        this.wm_x = 0.0;
        this.wm_y = 0.0;
        double wm_dx2 = 0.0;
        double wm_dxdy = 0.0;
        if (choice == 1) {
            for (i = 0; i < this.n; ++i) {
                wi = 1.0;
                if (!(wi > 0.0)) continue;
                this.W += wi;
                ++this.Q;
                this.wm_x += (this.x[i] - this.wm_x) * (wi / (double)this.Q);
                this.wm_y += (this.y[i] - this.wm_y) * (wi / (double)this.Q);
            }
            for (i = 0; i < this.n; ++i) {
                wi = 1.0;
                if (!(wi > 0.0)) continue;
                dx = this.x[i] - this.wm_x;
                dy = this.y[i] - this.wm_y;
                wm_dx2 += dx * dx / (double)this.n;
                wm_dxdy += dx * dy / (double)this.n;
            }
        }
        if (choice == 0) {
            for (i = 0; i < this.n; ++i) {
                wi = this.w[i];
                if (!(wi > 0.0)) continue;
                this.W += wi;
                this.wm_x += (this.x[i] - this.wm_x) * (wi / this.W);
                this.wm_y += (this.y[i] - this.wm_y) * (wi / this.W);
            }
            for (i = 0; i < this.n; ++i) {
                wi = this.w[i];
                if (!(wi > 0.0)) continue;
                dx = this.x[i] - this.wm_x;
                dy = this.y[i] - this.wm_y;
                wm_dx2 += dx * dx * wi / this.W;
                wm_dxdy += dx * dy * wi / this.W;
            }
        }
        this.W = 0.0;
        for (i = 0; i < this.n; ++i) {
            this.W += this.w[i];
        }
        double d2 = 0.0;
        this.b = wm_dxdy / wm_dx2;
        this.a = this.wm_y - this.wm_x * this.b;
        this.b0 = -1.0 / this.b;
        this.a0 = this.wm_y - this.b0 * this.wm_x;
        double rotang = Math.atan(this.b) + 0.7853981633974483;
        double rotangp = Math.atan(this.b0) + 0.7853981633974483;
        this.newb = Math.tan(rotang);
        this.newb0 = Math.tan(rotangp);
        this.newa = this.wm_y - this.newb * this.wm_x;
        this.newa0 = this.wm_y - this.newb0 * this.wm_x;
        double cov_00 = 1.0 / this.W * (1.0 + this.wm_x * this.wm_x / wm_dx2);
        double cov_11 = 1.0 / (this.W * wm_dx2);
        double cov_01 = -this.wm_x / (this.W * wm_dx2);
        this.covariance = new double[3];
        this.covariance[0] = cov_00;
        this.covariance[1] = cov_11;
        this.covariance[2] = cov_01;
        for (i = 0; i < this.n; ++i) {
            double wi2 = this.w[i];
            if (!(wi2 > 0.0)) continue;
            double dx2 = this.x[i] - this.wm_x;
            double dy2 = this.y[i] - this.wm_y;
            double d = dy2 - this.b * dx2;
            d2 += wi2 * d * d;
        }
        this.chisq2 = d2;
        this.processQuadrant();
    }

    public double[] getFitParameters() {
        double[] p = new double[]{this.a, this.b};
        return p;
    }

    public F1D getFitFunction() {
        F1D f1 = new F1D("a+b*x", "a+b*x", -10.0, 10.0, false);
        f1.setPar("a", this.a);
        f1.setPar("b", this.b);
        f1.parse();
        return f1;
    }

    public F1D getFitFunctionPerp() {
        F1D f1 = new F1D("a+b*x", "a+b*x", -10.0, 10.0, false);
        f1.setPar("a", this.a0);
        f1.setPar("b", this.b0);
        f1.parse();
        return f1;
    }

    public double[] getFitParametersPerp() {
        double[] p = new double[]{this.a0, this.b0};
        return p;
    }

    public double[] getFitParametersRotate() {
        double[] p = new double[]{this.newa, this.newb, this.newa0, this.newb0};
        return p;
    }

    public F1D[] getFitFunctionQuadrants() {
        F1D f1 = new F1D("a+b*x", -10.0, 10.0, false);
        f1.setPar("a", this.newa);
        f1.setPar("b", this.newb);
        f1.parse();
        F1D f2 = new F1D("a+b*x", -10.0, 10.0, false);
        f2.setPar("a", this.newa0);
        f2.setPar("b", this.newb0);
        f2.parse();
        F1D[] ff = new F1D[]{f1, f2};
        return ff;
    }

    public double[] getMeans() {
        double[] p = new double[]{this.wm_x, this.wm_y};
        return p;
    }

    public double[] getCenters(int k) {
        double[] p = new double[]{this.wwm_a[k][0], this.wwm_a[k][1]};
        return p;
    }

    private boolean processQuadrant() {
        double wi;
        int j;
        int i;
        this.dist = new double[2][this.n];
        this.points = new double[2][this.n];
        this.NewPoints = new double[2][this.n];
        this.R = new double[2][2];
        for (i = 0; i < this.n; ++i) {
            this.points[0][i] = this.x[i];
            this.points[1][i] = this.y[i];
        }
        double theta = Math.atan(this.b);
        this.R[0][0] = Math.cos(theta);
        this.R[0][1] = Math.sin(theta);
        this.R[1][0] = -Math.sin(theta);
        this.R[1][1] = Math.cos(theta);
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < this.n; ++j) {
                this.NewPoints[0][j] = this.points[0][j] - this.wm_x;
                this.NewPoints[1][j] = this.points[1][j] - this.wm_y;
                this.dist[i][j] = this.R[i][0] * this.NewPoints[0][j] + this.R[i][1] * this.NewPoints[1][j];
            }
        }
        this.wwm = new double[4][2];
        this.Wp = new double[4];
        this.wwm1 = new double[4][2];
        this.wwm_a = new double[4][2];
        this.wwm1_a = new double[4][2];
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 2; ++j) {
                this.wwm[i][j] = 0.0;
                this.wwm1[i][j] = 0.0;
                this.wwm_a[i][j] = 0.0;
                this.wwm1_a[i][j] = 0.0;
            }
        }
        for (i = 0; i < 4; ++i) {
            this.Wp[i] = 0.0;
        }
        double[] aa = this.getFitParametersPerp();
        for (i = 0; i < this.n; ++i) {
            wi = this.w[i];
            if (!(wi > 0.0)) continue;
            if (this.y[i] > this.a + this.b * this.x[i]) {
                this.Wp[0] = this.Wp[0] + wi;
                double[] dArray = this.wwm_a[0];
                dArray[0] = dArray[0] + (this.x[i] - this.wwm_a[0][0]) * (wi / this.Wp[0]);
                double[] dArray2 = this.wwm_a[0];
                dArray2[1] = dArray2[1] + (this.y[i] - this.wwm_a[0][1]) * (wi / this.Wp[0]);
                double[] dArray3 = this.wwm1_a[0];
                dArray3[0] = dArray3[0] + (this.dist[0][i] - this.wwm1_a[0][0]) * (wi / this.Wp[0]);
                double[] dArray4 = this.wwm1_a[0];
                dArray4[1] = dArray4[1] + (this.dist[1][i] - this.wwm1_a[0][1]) * (wi / this.Wp[0]);
            }
            if (this.y[i] < this.a + this.b * this.x[i]) {
                this.Wp[1] = this.Wp[1] + wi;
                double[] dArray = this.wwm_a[1];
                dArray[0] = dArray[0] + (this.x[i] - this.wwm_a[1][0]) * (wi / this.Wp[1]);
                double[] dArray5 = this.wwm_a[1];
                dArray5[1] = dArray5[1] + (this.y[i] - this.wwm_a[1][1]) * (wi / this.Wp[1]);
                double[] dArray6 = this.wwm1_a[1];
                dArray6[0] = dArray6[0] + (this.dist[0][i] - this.wwm1_a[1][0]) * (wi / this.Wp[1]);
                double[] dArray7 = this.wwm1_a[1];
                dArray7[1] = dArray7[1] + (this.dist[1][i] - this.wwm1_a[1][1]) * (wi / this.Wp[1]);
            }
            if (this.y[i] > this.a0 + this.b0 * this.x[i]) {
                this.Wp[2] = this.Wp[2] + wi;
                double[] dArray = this.wwm_a[2];
                dArray[0] = dArray[0] + (this.x[i] - this.wwm_a[2][0]) * (wi / this.Wp[2]);
                double[] dArray8 = this.wwm_a[2];
                dArray8[1] = dArray8[1] + (this.y[i] - this.wwm_a[2][1]) * (wi / this.Wp[2]);
                double[] dArray9 = this.wwm1_a[2];
                dArray9[0] = dArray9[0] + (this.dist[0][i] - this.wwm1_a[2][0]) * (wi / this.Wp[2]);
                double[] dArray10 = this.wwm1_a[2];
                dArray10[1] = dArray10[1] + (this.dist[1][i] - this.wwm1_a[2][1]) * (wi / this.Wp[2]);
            }
            if (!(this.y[i] < this.a0 + this.b0 * this.x[i])) continue;
            this.Wp[3] = this.Wp[3] + wi;
            double[] dArray = this.wwm_a[3];
            dArray[0] = dArray[0] + (this.x[i] - this.wwm_a[3][0]) * (wi / this.Wp[3]);
            double[] dArray11 = this.wwm_a[3];
            dArray11[1] = dArray11[1] + (this.y[i] - this.wwm_a[3][1]) * (wi / this.Wp[3]);
            double[] dArray12 = this.wwm1_a[3];
            dArray12[0] = dArray12[0] + (this.dist[0][i] - this.wwm1_a[3][0]) * (wi / this.Wp[3]);
            double[] dArray13 = this.wwm1_a[3];
            dArray13[1] = dArray13[1] + (this.dist[1][i] - this.wwm1_a[3][1]) * (wi / this.Wp[3]);
        }
        for (i = 0; i < 4; ++i) {
            this.Wp[i] = 0.0;
        }
        for (i = 0; i < this.n; ++i) {
            wi = this.w[i];
            if (!(wi > 0.0)) continue;
            if (this.y[i] > this.newa + this.newb * this.x[i] && this.y[i] > this.newa0 + this.newb0 * this.x[i]) {
                this.Wp[0] = this.Wp[0] + wi;
                double[] dArray = this.wwm[0];
                dArray[0] = dArray[0] + (this.x[i] - this.wwm[0][0]) * (wi / this.Wp[0]);
                double[] dArray14 = this.wwm[0];
                dArray14[1] = dArray14[1] + (this.y[i] - this.wwm[0][1]) * (wi / this.Wp[0]);
                double[] dArray15 = this.wwm1[0];
                dArray15[0] = dArray15[0] + (this.dist[0][i] - this.wwm1[0][0]) * (wi / this.Wp[0]);
                double[] dArray16 = this.wwm1[0];
                dArray16[1] = dArray16[1] + (this.dist[1][i] - this.wwm1[0][1]) * (wi / this.Wp[0]);
            }
            if (this.y[i] > this.newa + this.newb * this.x[i] && this.y[i] < this.newa0 + this.newb0 * this.x[i]) {
                this.Wp[1] = this.Wp[1] + wi;
                double[] dArray = this.wwm[1];
                dArray[0] = dArray[0] + (this.x[i] - this.wwm[1][0]) * (wi / this.Wp[1]);
                double[] dArray17 = this.wwm[1];
                dArray17[1] = dArray17[1] + (this.y[i] - this.wwm[1][1]) * (wi / this.Wp[1]);
                double[] dArray18 = this.wwm1[1];
                dArray18[0] = dArray18[0] + (this.dist[0][i] - this.wwm1[1][0]) * (wi / this.Wp[1]);
                double[] dArray19 = this.wwm1[1];
                dArray19[1] = dArray19[1] + (this.dist[1][i] - this.wwm1[1][1]) * (wi / this.Wp[1]);
            }
            if (this.y[i] < this.newa + this.newb * this.x[i] && this.y[i] < this.newa0 + this.newb0 * this.x[i]) {
                this.Wp[2] = this.Wp[2] + wi;
                double[] dArray = this.wwm[2];
                dArray[0] = dArray[0] + (this.x[i] - this.wwm[2][0]) * (wi / this.Wp[2]);
                double[] dArray20 = this.wwm[2];
                dArray20[1] = dArray20[1] + (this.y[i] - this.wwm[2][1]) * (wi / this.Wp[2]);
                double[] dArray21 = this.wwm1[2];
                dArray21[0] = dArray21[0] + (this.dist[0][i] - this.wwm1[2][0]) * (wi / this.Wp[2]);
                double[] dArray22 = this.wwm1[2];
                dArray22[1] = dArray22[1] + (this.dist[1][i] - this.wwm1[2][1]) * (wi / this.Wp[2]);
            }
            if (!(this.y[i] < this.newa + this.newb * this.x[i]) || !(this.y[i] > this.newa0 + this.newb0 * this.x[i])) continue;
            this.Wp[3] = this.Wp[3] + wi;
            double[] dArray = this.wwm[3];
            dArray[0] = dArray[0] + (this.x[i] - this.wwm[3][0]) * (wi / this.Wp[3]);
            double[] dArray23 = this.wwm[3];
            dArray23[1] = dArray23[1] + (this.y[i] - this.wwm[3][1]) * (wi / this.Wp[3]);
            double[] dArray24 = this.wwm1[3];
            dArray24[0] = dArray24[0] + (this.dist[0][i] - this.wwm1[3][0]) * (wi / this.Wp[3]);
            double[] dArray25 = this.wwm1[3];
            dArray25[1] = dArray25[1] + (this.dist[1][i] - this.wwm1[3][1]) * (wi / this.Wp[3]);
        }
        double wmax = 0.0;
        for (i = 0; i < this.n; ++i) {
            if (!(this.w[i] > wmax)) continue;
            wmax = this.w[i];
        }
        this.Fmax = wmax / this.W;
        double a1 = Math.sqrt((this.wwm[0][0] - this.wwm[2][0]) * (this.wwm[0][0] - this.wwm[2][0]) + (this.wwm[0][1] - this.wwm[2][1]) * (this.wwm[0][1] - this.wwm[2][1]));
        double a2 = Math.sqrt((this.wwm[1][0] - this.wwm[3][0]) * (this.wwm[1][0] - this.wwm[3][0]) + (this.wwm[1][1] - this.wwm[3][1]) * (this.wwm[1][1] - this.wwm[3][1]));
        double a7 = Math.sqrt((this.wwm1[0][1] - this.wwm1[2][1]) * (this.wwm1[0][1] - this.wwm1[2][1]));
        double a8 = Math.sqrt((this.wwm1[1][0] - this.wwm1[3][0]) * (this.wwm1[1][0] - this.wwm1[3][0]));
        double a3 = Math.sqrt((this.wm_x - this.wwm[0][0]) * (this.wm_x - this.wwm[0][0]) + (this.wm_y - this.wwm[0][1]) * (this.wm_y - this.wwm[0][1]));
        double a4 = Math.sqrt((this.wm_x - this.wwm[1][0]) * (this.wm_x - this.wwm[1][0]) + (this.wm_y - this.wwm[1][1]) * (this.wm_y - this.wwm[1][1]));
        double a5 = Math.sqrt((this.wm_x - this.wwm[2][0]) * (this.wm_x - this.wwm[2][0]) + (this.wm_y - this.wwm[2][1]) * (this.wm_y - this.wwm[2][1]));
        double a6 = Math.sqrt((this.wm_x - this.wwm[3][0]) * (this.wm_x - this.wwm[3][0]) + (this.wm_y - this.wwm[3][1]) * (this.wm_y - this.wwm[3][1]));
        double a9 = Math.sqrt((this.wwm_a[0][0] - this.wwm_a[1][0]) * (this.wwm_a[0][0] - this.wwm_a[1][0]) + (this.wwm_a[0][1] - this.wwm_a[1][1]) * (this.wwm_a[0][1] - this.wwm_a[1][1]));
        double a10 = Math.sqrt((this.wwm_a[2][0] - this.wwm_a[3][0]) * (this.wwm_a[2][0] - this.wwm_a[3][0]) + (this.wwm_a[2][1] - this.wwm_a[3][1]) * (this.wwm_a[2][1] - this.wwm_a[3][1]));
        double a11 = Math.sqrt((this.wwm1_a[0][1] - this.wwm1_a[1][1]) * (this.wwm1_a[0][1] - this.wwm1_a[1][1]));
        double a12 = Math.sqrt((this.wwm1_a[2][0] - this.wwm1_a[3][0]) * (this.wwm1_a[2][0] - this.wwm1_a[3][0]));
        double a13 = Math.sqrt((this.wm_x - this.wwm_a[0][0]) * (this.wm_x - this.wwm_a[0][0]) + (this.wm_y - this.wwm_a[0][1]) * (this.wm_y - this.wwm_a[0][1]));
        double a14 = Math.sqrt((this.wm_x - this.wwm_a[1][0]) * (this.wm_x - this.wwm_a[1][0]) + (this.wm_y - this.wwm_a[1][1]) * (this.wm_y - this.wwm_a[1][1]));
        double a15 = Math.sqrt((this.wm_x - this.wwm_a[2][0]) * (this.wm_x - this.wwm_a[2][0]) + (this.wm_y - this.wwm_a[2][1]) * (this.wm_y - this.wwm_a[2][1]));
        double a16 = Math.sqrt((this.wm_x - this.wwm_a[3][0]) * (this.wm_x - this.wwm_a[3][0]) + (this.wm_y - this.wwm_a[3][1]) * (this.wm_y - this.wwm_a[3][1]));
        this.minorLength = a1;
        this.majorLength = a2;
        if (a1 > a2) {
            this.minorLength = a2;
            this.majorLength = a1;
        }
        this.minorLength_meth2 = a7;
        this.majorLength_meth2 = a8;
        if (a7 > a8) {
            this.minorLength_meth2 = a8;
            this.majorLength_meth2 = a7;
        }
        this.majorLength1 = a4;
        this.majorLength2 = a6;
        if (a4 > a6) {
            this.majorLength1 = a6;
            this.majorLength2 = a4;
        }
        this.minorLength1 = a3;
        this.minorLength2 = a5;
        if (a3 > a5) {
            this.minorLength1 = a5;
            this.minorLength2 = a3;
        }
        this.nq_minorLength = a9;
        this.nq_majorLength = a10;
        if (a9 > a10) {
            this.nq_minorLength = a10;
            this.nq_majorLength = a9;
        }
        this.nq_minorLength_meth2 = a11;
        this.nq_majorLength_meth2 = a12;
        if (a11 > a12) {
            this.nq_minorLength_meth2 = a12;
            this.nq_majorLength_meth2 = a11;
        }
        this.nq_majorLength1 = a15;
        this.nq_majorLength2 = a16;
        if (a15 > a16) {
            this.nq_majorLength1 = a16;
            this.nq_majorLength2 = a15;
        }
        this.nq_minorLength1 = a13;
        this.nq_minorLength2 = a14;
        if (a13 > a14) {
            this.nq_minorLength1 = a14;
            this.nq_minorLength2 = a13;
        }
        double minx = this.dist[0][0];
        double maxx = this.dist[0][0];
        double miny = this.dist[0][0];
        double maxy = this.dist[0][0];
        int l = 0;
        int q = 0;
        int r = 0;
        int s = 0;
        for (i = 1; i < this.n; ++i) {
            if (this.dist[0][i] > maxx) {
                maxx = this.dist[0][i];
                l = i;
            }
            if (this.dist[0][i] < minx) {
                minx = this.dist[0][i];
                q = i;
            }
            if (this.dist[1][i] > maxy) {
                maxy = this.dist[1][i];
                r = i;
            }
            if (!(this.dist[1][i] < miny)) continue;
            miny = this.dist[1][i];
            s = i;
        }
        this.GlobalMajorLength = this.dist[0][l] - this.dist[0][q];
        this.GlobalMinorLength = this.dist[1][r] - this.dist[1][s];
        return true;
    }

    public double[] getSummary() {
        double[] p = new double[]{this.majorLength, this.minorLength, 1.0 - this.minorLength / this.majorLength, this.majorLength1, this.majorLength2, 1.0 - this.majorLength1 / this.majorLength2, this.minorLength1, this.minorLength2, 1.0 - this.minorLength1 / this.minorLength2, this.GlobalMajorLength, this.GlobalMinorLength, this.majorLength_meth2, this.minorLength_meth2, 1.0 - this.minorLength_meth2 / this.majorLength_meth2, this.nq_majorLength, this.nq_minorLength, 1.0 - this.nq_minorLength / this.nq_majorLength, this.nq_majorLength_meth2, this.nq_minorLength_meth2, 1.0 - this.nq_minorLength_meth2 / this.nq_majorLength_meth2, 1.0 - this.nq_majorLength1 / this.nq_majorLength2, 1.0 - this.nq_minorLength1 / this.nq_minorLength2, this.Fmax};
        return p;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

